import { HttpHandlerOptions as __HttpHandlerOptions } from "@smithy/types";
import { CloudFrontClient } from "./CloudFrontClient";
import {
  AssociateAliasCommandInput,
  AssociateAliasCommandOutput,
} from "./commands/AssociateAliasCommand";
import {
  AssociateDistributionTenantWebACLCommandInput,
  AssociateDistributionTenantWebACLCommandOutput,
} from "./commands/AssociateDistributionTenantWebACLCommand";
import {
  AssociateDistributionWebACLCommandInput,
  AssociateDistributionWebACLCommandOutput,
} from "./commands/AssociateDistributionWebACLCommand";
import {
  CopyDistributionCommandInput,
  CopyDistributionCommandOutput,
} from "./commands/CopyDistributionCommand";
import {
  CreateAnycastIpListCommandInput,
  CreateAnycastIpListCommandOutput,
} from "./commands/CreateAnycastIpListCommand";
import {
  CreateCachePolicyCommandInput,
  CreateCachePolicyCommandOutput,
} from "./commands/CreateCachePolicyCommand";
import {
  CreateCloudFrontOriginAccessIdentityCommandInput,
  CreateCloudFrontOriginAccessIdentityCommandOutput,
} from "./commands/CreateCloudFrontOriginAccessIdentityCommand";
import {
  CreateConnectionGroupCommandInput,
  CreateConnectionGroupCommandOutput,
} from "./commands/CreateConnectionGroupCommand";
import {
  CreateContinuousDeploymentPolicyCommandInput,
  CreateContinuousDeploymentPolicyCommandOutput,
} from "./commands/CreateContinuousDeploymentPolicyCommand";
import {
  CreateDistributionCommandInput,
  CreateDistributionCommandOutput,
} from "./commands/CreateDistributionCommand";
import {
  CreateDistributionTenantCommandInput,
  CreateDistributionTenantCommandOutput,
} from "./commands/CreateDistributionTenantCommand";
import {
  CreateDistributionWithTagsCommandInput,
  CreateDistributionWithTagsCommandOutput,
} from "./commands/CreateDistributionWithTagsCommand";
import {
  CreateFieldLevelEncryptionConfigCommandInput,
  CreateFieldLevelEncryptionConfigCommandOutput,
} from "./commands/CreateFieldLevelEncryptionConfigCommand";
import {
  CreateFieldLevelEncryptionProfileCommandInput,
  CreateFieldLevelEncryptionProfileCommandOutput,
} from "./commands/CreateFieldLevelEncryptionProfileCommand";
import {
  CreateFunctionCommandInput,
  CreateFunctionCommandOutput,
} from "./commands/CreateFunctionCommand";
import {
  CreateInvalidationCommandInput,
  CreateInvalidationCommandOutput,
} from "./commands/CreateInvalidationCommand";
import {
  CreateInvalidationForDistributionTenantCommandInput,
  CreateInvalidationForDistributionTenantCommandOutput,
} from "./commands/CreateInvalidationForDistributionTenantCommand";
import {
  CreateKeyGroupCommandInput,
  CreateKeyGroupCommandOutput,
} from "./commands/CreateKeyGroupCommand";
import {
  CreateKeyValueStoreCommandInput,
  CreateKeyValueStoreCommandOutput,
} from "./commands/CreateKeyValueStoreCommand";
import {
  CreateMonitoringSubscriptionCommandInput,
  CreateMonitoringSubscriptionCommandOutput,
} from "./commands/CreateMonitoringSubscriptionCommand";
import {
  CreateOriginAccessControlCommandInput,
  CreateOriginAccessControlCommandOutput,
} from "./commands/CreateOriginAccessControlCommand";
import {
  CreateOriginRequestPolicyCommandInput,
  CreateOriginRequestPolicyCommandOutput,
} from "./commands/CreateOriginRequestPolicyCommand";
import {
  CreatePublicKeyCommandInput,
  CreatePublicKeyCommandOutput,
} from "./commands/CreatePublicKeyCommand";
import {
  CreateRealtimeLogConfigCommandInput,
  CreateRealtimeLogConfigCommandOutput,
} from "./commands/CreateRealtimeLogConfigCommand";
import {
  CreateResponseHeadersPolicyCommandInput,
  CreateResponseHeadersPolicyCommandOutput,
} from "./commands/CreateResponseHeadersPolicyCommand";
import {
  CreateStreamingDistributionCommandInput,
  CreateStreamingDistributionCommandOutput,
} from "./commands/CreateStreamingDistributionCommand";
import {
  CreateStreamingDistributionWithTagsCommandInput,
  CreateStreamingDistributionWithTagsCommandOutput,
} from "./commands/CreateStreamingDistributionWithTagsCommand";
import {
  CreateVpcOriginCommandInput,
  CreateVpcOriginCommandOutput,
} from "./commands/CreateVpcOriginCommand";
import {
  DeleteAnycastIpListCommandInput,
  DeleteAnycastIpListCommandOutput,
} from "./commands/DeleteAnycastIpListCommand";
import {
  DeleteCachePolicyCommandInput,
  DeleteCachePolicyCommandOutput,
} from "./commands/DeleteCachePolicyCommand";
import {
  DeleteCloudFrontOriginAccessIdentityCommandInput,
  DeleteCloudFrontOriginAccessIdentityCommandOutput,
} from "./commands/DeleteCloudFrontOriginAccessIdentityCommand";
import {
  DeleteConnectionGroupCommandInput,
  DeleteConnectionGroupCommandOutput,
} from "./commands/DeleteConnectionGroupCommand";
import {
  DeleteContinuousDeploymentPolicyCommandInput,
  DeleteContinuousDeploymentPolicyCommandOutput,
} from "./commands/DeleteContinuousDeploymentPolicyCommand";
import {
  DeleteDistributionCommandInput,
  DeleteDistributionCommandOutput,
} from "./commands/DeleteDistributionCommand";
import {
  DeleteDistributionTenantCommandInput,
  DeleteDistributionTenantCommandOutput,
} from "./commands/DeleteDistributionTenantCommand";
import {
  DeleteFieldLevelEncryptionConfigCommandInput,
  DeleteFieldLevelEncryptionConfigCommandOutput,
} from "./commands/DeleteFieldLevelEncryptionConfigCommand";
import {
  DeleteFieldLevelEncryptionProfileCommandInput,
  DeleteFieldLevelEncryptionProfileCommandOutput,
} from "./commands/DeleteFieldLevelEncryptionProfileCommand";
import {
  DeleteFunctionCommandInput,
  DeleteFunctionCommandOutput,
} from "./commands/DeleteFunctionCommand";
import {
  DeleteKeyGroupCommandInput,
  DeleteKeyGroupCommandOutput,
} from "./commands/DeleteKeyGroupCommand";
import {
  DeleteKeyValueStoreCommandInput,
  DeleteKeyValueStoreCommandOutput,
} from "./commands/DeleteKeyValueStoreCommand";
import {
  DeleteMonitoringSubscriptionCommandInput,
  DeleteMonitoringSubscriptionCommandOutput,
} from "./commands/DeleteMonitoringSubscriptionCommand";
import {
  DeleteOriginAccessControlCommandInput,
  DeleteOriginAccessControlCommandOutput,
} from "./commands/DeleteOriginAccessControlCommand";
import {
  DeleteOriginRequestPolicyCommandInput,
  DeleteOriginRequestPolicyCommandOutput,
} from "./commands/DeleteOriginRequestPolicyCommand";
import {
  DeletePublicKeyCommandInput,
  DeletePublicKeyCommandOutput,
} from "./commands/DeletePublicKeyCommand";
import {
  DeleteRealtimeLogConfigCommandInput,
  DeleteRealtimeLogConfigCommandOutput,
} from "./commands/DeleteRealtimeLogConfigCommand";
import {
  DeleteResourcePolicyCommandInput,
  DeleteResourcePolicyCommandOutput,
} from "./commands/DeleteResourcePolicyCommand";
import {
  DeleteResponseHeadersPolicyCommandInput,
  DeleteResponseHeadersPolicyCommandOutput,
} from "./commands/DeleteResponseHeadersPolicyCommand";
import {
  DeleteStreamingDistributionCommandInput,
  DeleteStreamingDistributionCommandOutput,
} from "./commands/DeleteStreamingDistributionCommand";
import {
  DeleteVpcOriginCommandInput,
  DeleteVpcOriginCommandOutput,
} from "./commands/DeleteVpcOriginCommand";
import {
  DescribeFunctionCommandInput,
  DescribeFunctionCommandOutput,
} from "./commands/DescribeFunctionCommand";
import {
  DescribeKeyValueStoreCommandInput,
  DescribeKeyValueStoreCommandOutput,
} from "./commands/DescribeKeyValueStoreCommand";
import {
  DisassociateDistributionTenantWebACLCommandInput,
  DisassociateDistributionTenantWebACLCommandOutput,
} from "./commands/DisassociateDistributionTenantWebACLCommand";
import {
  DisassociateDistributionWebACLCommandInput,
  DisassociateDistributionWebACLCommandOutput,
} from "./commands/DisassociateDistributionWebACLCommand";
import {
  GetAnycastIpListCommandInput,
  GetAnycastIpListCommandOutput,
} from "./commands/GetAnycastIpListCommand";
import {
  GetCachePolicyCommandInput,
  GetCachePolicyCommandOutput,
} from "./commands/GetCachePolicyCommand";
import {
  GetCachePolicyConfigCommandInput,
  GetCachePolicyConfigCommandOutput,
} from "./commands/GetCachePolicyConfigCommand";
import {
  GetCloudFrontOriginAccessIdentityCommandInput,
  GetCloudFrontOriginAccessIdentityCommandOutput,
} from "./commands/GetCloudFrontOriginAccessIdentityCommand";
import {
  GetCloudFrontOriginAccessIdentityConfigCommandInput,
  GetCloudFrontOriginAccessIdentityConfigCommandOutput,
} from "./commands/GetCloudFrontOriginAccessIdentityConfigCommand";
import {
  GetConnectionGroupByRoutingEndpointCommandInput,
  GetConnectionGroupByRoutingEndpointCommandOutput,
} from "./commands/GetConnectionGroupByRoutingEndpointCommand";
import {
  GetConnectionGroupCommandInput,
  GetConnectionGroupCommandOutput,
} from "./commands/GetConnectionGroupCommand";
import {
  GetContinuousDeploymentPolicyCommandInput,
  GetContinuousDeploymentPolicyCommandOutput,
} from "./commands/GetContinuousDeploymentPolicyCommand";
import {
  GetContinuousDeploymentPolicyConfigCommandInput,
  GetContinuousDeploymentPolicyConfigCommandOutput,
} from "./commands/GetContinuousDeploymentPolicyConfigCommand";
import {
  GetDistributionCommandInput,
  GetDistributionCommandOutput,
} from "./commands/GetDistributionCommand";
import {
  GetDistributionConfigCommandInput,
  GetDistributionConfigCommandOutput,
} from "./commands/GetDistributionConfigCommand";
import {
  GetDistributionTenantByDomainCommandInput,
  GetDistributionTenantByDomainCommandOutput,
} from "./commands/GetDistributionTenantByDomainCommand";
import {
  GetDistributionTenantCommandInput,
  GetDistributionTenantCommandOutput,
} from "./commands/GetDistributionTenantCommand";
import {
  GetFieldLevelEncryptionCommandInput,
  GetFieldLevelEncryptionCommandOutput,
} from "./commands/GetFieldLevelEncryptionCommand";
import {
  GetFieldLevelEncryptionConfigCommandInput,
  GetFieldLevelEncryptionConfigCommandOutput,
} from "./commands/GetFieldLevelEncryptionConfigCommand";
import {
  GetFieldLevelEncryptionProfileCommandInput,
  GetFieldLevelEncryptionProfileCommandOutput,
} from "./commands/GetFieldLevelEncryptionProfileCommand";
import {
  GetFieldLevelEncryptionProfileConfigCommandInput,
  GetFieldLevelEncryptionProfileConfigCommandOutput,
} from "./commands/GetFieldLevelEncryptionProfileConfigCommand";
import {
  GetFunctionCommandInput,
  GetFunctionCommandOutput,
} from "./commands/GetFunctionCommand";
import {
  GetInvalidationCommandInput,
  GetInvalidationCommandOutput,
} from "./commands/GetInvalidationCommand";
import {
  GetInvalidationForDistributionTenantCommandInput,
  GetInvalidationForDistributionTenantCommandOutput,
} from "./commands/GetInvalidationForDistributionTenantCommand";
import {
  GetKeyGroupCommandInput,
  GetKeyGroupCommandOutput,
} from "./commands/GetKeyGroupCommand";
import {
  GetKeyGroupConfigCommandInput,
  GetKeyGroupConfigCommandOutput,
} from "./commands/GetKeyGroupConfigCommand";
import {
  GetManagedCertificateDetailsCommandInput,
  GetManagedCertificateDetailsCommandOutput,
} from "./commands/GetManagedCertificateDetailsCommand";
import {
  GetMonitoringSubscriptionCommandInput,
  GetMonitoringSubscriptionCommandOutput,
} from "./commands/GetMonitoringSubscriptionCommand";
import {
  GetOriginAccessControlCommandInput,
  GetOriginAccessControlCommandOutput,
} from "./commands/GetOriginAccessControlCommand";
import {
  GetOriginAccessControlConfigCommandInput,
  GetOriginAccessControlConfigCommandOutput,
} from "./commands/GetOriginAccessControlConfigCommand";
import {
  GetOriginRequestPolicyCommandInput,
  GetOriginRequestPolicyCommandOutput,
} from "./commands/GetOriginRequestPolicyCommand";
import {
  GetOriginRequestPolicyConfigCommandInput,
  GetOriginRequestPolicyConfigCommandOutput,
} from "./commands/GetOriginRequestPolicyConfigCommand";
import {
  GetPublicKeyCommandInput,
  GetPublicKeyCommandOutput,
} from "./commands/GetPublicKeyCommand";
import {
  GetPublicKeyConfigCommandInput,
  GetPublicKeyConfigCommandOutput,
} from "./commands/GetPublicKeyConfigCommand";
import {
  GetRealtimeLogConfigCommandInput,
  GetRealtimeLogConfigCommandOutput,
} from "./commands/GetRealtimeLogConfigCommand";
import {
  GetResourcePolicyCommandInput,
  GetResourcePolicyCommandOutput,
} from "./commands/GetResourcePolicyCommand";
import {
  GetResponseHeadersPolicyCommandInput,
  GetResponseHeadersPolicyCommandOutput,
} from "./commands/GetResponseHeadersPolicyCommand";
import {
  GetResponseHeadersPolicyConfigCommandInput,
  GetResponseHeadersPolicyConfigCommandOutput,
} from "./commands/GetResponseHeadersPolicyConfigCommand";
import {
  GetStreamingDistributionCommandInput,
  GetStreamingDistributionCommandOutput,
} from "./commands/GetStreamingDistributionCommand";
import {
  GetStreamingDistributionConfigCommandInput,
  GetStreamingDistributionConfigCommandOutput,
} from "./commands/GetStreamingDistributionConfigCommand";
import {
  GetVpcOriginCommandInput,
  GetVpcOriginCommandOutput,
} from "./commands/GetVpcOriginCommand";
import {
  ListAnycastIpListsCommandInput,
  ListAnycastIpListsCommandOutput,
} from "./commands/ListAnycastIpListsCommand";
import {
  ListCachePoliciesCommandInput,
  ListCachePoliciesCommandOutput,
} from "./commands/ListCachePoliciesCommand";
import {
  ListCloudFrontOriginAccessIdentitiesCommandInput,
  ListCloudFrontOriginAccessIdentitiesCommandOutput,
} from "./commands/ListCloudFrontOriginAccessIdentitiesCommand";
import {
  ListConflictingAliasesCommandInput,
  ListConflictingAliasesCommandOutput,
} from "./commands/ListConflictingAliasesCommand";
import {
  ListConnectionGroupsCommandInput,
  ListConnectionGroupsCommandOutput,
} from "./commands/ListConnectionGroupsCommand";
import {
  ListContinuousDeploymentPoliciesCommandInput,
  ListContinuousDeploymentPoliciesCommandOutput,
} from "./commands/ListContinuousDeploymentPoliciesCommand";
import {
  ListDistributionsByAnycastIpListIdCommandInput,
  ListDistributionsByAnycastIpListIdCommandOutput,
} from "./commands/ListDistributionsByAnycastIpListIdCommand";
import {
  ListDistributionsByCachePolicyIdCommandInput,
  ListDistributionsByCachePolicyIdCommandOutput,
} from "./commands/ListDistributionsByCachePolicyIdCommand";
import {
  ListDistributionsByConnectionModeCommandInput,
  ListDistributionsByConnectionModeCommandOutput,
} from "./commands/ListDistributionsByConnectionModeCommand";
import {
  ListDistributionsByKeyGroupCommandInput,
  ListDistributionsByKeyGroupCommandOutput,
} from "./commands/ListDistributionsByKeyGroupCommand";
import {
  ListDistributionsByOriginRequestPolicyIdCommandInput,
  ListDistributionsByOriginRequestPolicyIdCommandOutput,
} from "./commands/ListDistributionsByOriginRequestPolicyIdCommand";
import {
  ListDistributionsByOwnedResourceCommandInput,
  ListDistributionsByOwnedResourceCommandOutput,
} from "./commands/ListDistributionsByOwnedResourceCommand";
import {
  ListDistributionsByRealtimeLogConfigCommandInput,
  ListDistributionsByRealtimeLogConfigCommandOutput,
} from "./commands/ListDistributionsByRealtimeLogConfigCommand";
import {
  ListDistributionsByResponseHeadersPolicyIdCommandInput,
  ListDistributionsByResponseHeadersPolicyIdCommandOutput,
} from "./commands/ListDistributionsByResponseHeadersPolicyIdCommand";
import {
  ListDistributionsByVpcOriginIdCommandInput,
  ListDistributionsByVpcOriginIdCommandOutput,
} from "./commands/ListDistributionsByVpcOriginIdCommand";
import {
  ListDistributionsByWebACLIdCommandInput,
  ListDistributionsByWebACLIdCommandOutput,
} from "./commands/ListDistributionsByWebACLIdCommand";
import {
  ListDistributionsCommandInput,
  ListDistributionsCommandOutput,
} from "./commands/ListDistributionsCommand";
import {
  ListDistributionTenantsByCustomizationCommandInput,
  ListDistributionTenantsByCustomizationCommandOutput,
} from "./commands/ListDistributionTenantsByCustomizationCommand";
import {
  ListDistributionTenantsCommandInput,
  ListDistributionTenantsCommandOutput,
} from "./commands/ListDistributionTenantsCommand";
import {
  ListDomainConflictsCommandInput,
  ListDomainConflictsCommandOutput,
} from "./commands/ListDomainConflictsCommand";
import {
  ListFieldLevelEncryptionConfigsCommandInput,
  ListFieldLevelEncryptionConfigsCommandOutput,
} from "./commands/ListFieldLevelEncryptionConfigsCommand";
import {
  ListFieldLevelEncryptionProfilesCommandInput,
  ListFieldLevelEncryptionProfilesCommandOutput,
} from "./commands/ListFieldLevelEncryptionProfilesCommand";
import {
  ListFunctionsCommandInput,
  ListFunctionsCommandOutput,
} from "./commands/ListFunctionsCommand";
import {
  ListInvalidationsCommandInput,
  ListInvalidationsCommandOutput,
} from "./commands/ListInvalidationsCommand";
import {
  ListInvalidationsForDistributionTenantCommandInput,
  ListInvalidationsForDistributionTenantCommandOutput,
} from "./commands/ListInvalidationsForDistributionTenantCommand";
import {
  ListKeyGroupsCommandInput,
  ListKeyGroupsCommandOutput,
} from "./commands/ListKeyGroupsCommand";
import {
  ListKeyValueStoresCommandInput,
  ListKeyValueStoresCommandOutput,
} from "./commands/ListKeyValueStoresCommand";
import {
  ListOriginAccessControlsCommandInput,
  ListOriginAccessControlsCommandOutput,
} from "./commands/ListOriginAccessControlsCommand";
import {
  ListOriginRequestPoliciesCommandInput,
  ListOriginRequestPoliciesCommandOutput,
} from "./commands/ListOriginRequestPoliciesCommand";
import {
  ListPublicKeysCommandInput,
  ListPublicKeysCommandOutput,
} from "./commands/ListPublicKeysCommand";
import {
  ListRealtimeLogConfigsCommandInput,
  ListRealtimeLogConfigsCommandOutput,
} from "./commands/ListRealtimeLogConfigsCommand";
import {
  ListResponseHeadersPoliciesCommandInput,
  ListResponseHeadersPoliciesCommandOutput,
} from "./commands/ListResponseHeadersPoliciesCommand";
import {
  ListStreamingDistributionsCommandInput,
  ListStreamingDistributionsCommandOutput,
} from "./commands/ListStreamingDistributionsCommand";
import {
  ListTagsForResourceCommandInput,
  ListTagsForResourceCommandOutput,
} from "./commands/ListTagsForResourceCommand";
import {
  ListVpcOriginsCommandInput,
  ListVpcOriginsCommandOutput,
} from "./commands/ListVpcOriginsCommand";
import {
  PublishFunctionCommandInput,
  PublishFunctionCommandOutput,
} from "./commands/PublishFunctionCommand";
import {
  PutResourcePolicyCommandInput,
  PutResourcePolicyCommandOutput,
} from "./commands/PutResourcePolicyCommand";
import {
  TagResourceCommandInput,
  TagResourceCommandOutput,
} from "./commands/TagResourceCommand";
import {
  TestFunctionCommandInput,
  TestFunctionCommandOutput,
} from "./commands/TestFunctionCommand";
import {
  UntagResourceCommandInput,
  UntagResourceCommandOutput,
} from "./commands/UntagResourceCommand";
import {
  UpdateAnycastIpListCommandInput,
  UpdateAnycastIpListCommandOutput,
} from "./commands/UpdateAnycastIpListCommand";
import {
  UpdateCachePolicyCommandInput,
  UpdateCachePolicyCommandOutput,
} from "./commands/UpdateCachePolicyCommand";
import {
  UpdateCloudFrontOriginAccessIdentityCommandInput,
  UpdateCloudFrontOriginAccessIdentityCommandOutput,
} from "./commands/UpdateCloudFrontOriginAccessIdentityCommand";
import {
  UpdateConnectionGroupCommandInput,
  UpdateConnectionGroupCommandOutput,
} from "./commands/UpdateConnectionGroupCommand";
import {
  UpdateContinuousDeploymentPolicyCommandInput,
  UpdateContinuousDeploymentPolicyCommandOutput,
} from "./commands/UpdateContinuousDeploymentPolicyCommand";
import {
  UpdateDistributionCommandInput,
  UpdateDistributionCommandOutput,
} from "./commands/UpdateDistributionCommand";
import {
  UpdateDistributionTenantCommandInput,
  UpdateDistributionTenantCommandOutput,
} from "./commands/UpdateDistributionTenantCommand";
import {
  UpdateDistributionWithStagingConfigCommandInput,
  UpdateDistributionWithStagingConfigCommandOutput,
} from "./commands/UpdateDistributionWithStagingConfigCommand";
import {
  UpdateDomainAssociationCommandInput,
  UpdateDomainAssociationCommandOutput,
} from "./commands/UpdateDomainAssociationCommand";
import {
  UpdateFieldLevelEncryptionConfigCommandInput,
  UpdateFieldLevelEncryptionConfigCommandOutput,
} from "./commands/UpdateFieldLevelEncryptionConfigCommand";
import {
  UpdateFieldLevelEncryptionProfileCommandInput,
  UpdateFieldLevelEncryptionProfileCommandOutput,
} from "./commands/UpdateFieldLevelEncryptionProfileCommand";
import {
  UpdateFunctionCommandInput,
  UpdateFunctionCommandOutput,
} from "./commands/UpdateFunctionCommand";
import {
  UpdateKeyGroupCommandInput,
  UpdateKeyGroupCommandOutput,
} from "./commands/UpdateKeyGroupCommand";
import {
  UpdateKeyValueStoreCommandInput,
  UpdateKeyValueStoreCommandOutput,
} from "./commands/UpdateKeyValueStoreCommand";
import {
  UpdateOriginAccessControlCommandInput,
  UpdateOriginAccessControlCommandOutput,
} from "./commands/UpdateOriginAccessControlCommand";
import {
  UpdateOriginRequestPolicyCommandInput,
  UpdateOriginRequestPolicyCommandOutput,
} from "./commands/UpdateOriginRequestPolicyCommand";
import {
  UpdatePublicKeyCommandInput,
  UpdatePublicKeyCommandOutput,
} from "./commands/UpdatePublicKeyCommand";
import {
  UpdateRealtimeLogConfigCommandInput,
  UpdateRealtimeLogConfigCommandOutput,
} from "./commands/UpdateRealtimeLogConfigCommand";
import {
  UpdateResponseHeadersPolicyCommandInput,
  UpdateResponseHeadersPolicyCommandOutput,
} from "./commands/UpdateResponseHeadersPolicyCommand";
import {
  UpdateStreamingDistributionCommandInput,
  UpdateStreamingDistributionCommandOutput,
} from "./commands/UpdateStreamingDistributionCommand";
import {
  UpdateVpcOriginCommandInput,
  UpdateVpcOriginCommandOutput,
} from "./commands/UpdateVpcOriginCommand";
import {
  VerifyDnsConfigurationCommandInput,
  VerifyDnsConfigurationCommandOutput,
} from "./commands/VerifyDnsConfigurationCommand";
export interface CloudFront {
  associateAlias(
    args: AssociateAliasCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AssociateAliasCommandOutput>;
  associateAlias(
    args: AssociateAliasCommandInput,
    cb: (err: any, data?: AssociateAliasCommandOutput) => void
  ): void;
  associateAlias(
    args: AssociateAliasCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AssociateAliasCommandOutput) => void
  ): void;
  associateDistributionTenantWebACL(
    args: AssociateDistributionTenantWebACLCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AssociateDistributionTenantWebACLCommandOutput>;
  associateDistributionTenantWebACL(
    args: AssociateDistributionTenantWebACLCommandInput,
    cb: (
      err: any,
      data?: AssociateDistributionTenantWebACLCommandOutput
    ) => void
  ): void;
  associateDistributionTenantWebACL(
    args: AssociateDistributionTenantWebACLCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: AssociateDistributionTenantWebACLCommandOutput
    ) => void
  ): void;
  associateDistributionWebACL(
    args: AssociateDistributionWebACLCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AssociateDistributionWebACLCommandOutput>;
  associateDistributionWebACL(
    args: AssociateDistributionWebACLCommandInput,
    cb: (err: any, data?: AssociateDistributionWebACLCommandOutput) => void
  ): void;
  associateDistributionWebACL(
    args: AssociateDistributionWebACLCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AssociateDistributionWebACLCommandOutput) => void
  ): void;
  copyDistribution(
    args: CopyDistributionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CopyDistributionCommandOutput>;
  copyDistribution(
    args: CopyDistributionCommandInput,
    cb: (err: any, data?: CopyDistributionCommandOutput) => void
  ): void;
  copyDistribution(
    args: CopyDistributionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CopyDistributionCommandOutput) => void
  ): void;
  createAnycastIpList(
    args: CreateAnycastIpListCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateAnycastIpListCommandOutput>;
  createAnycastIpList(
    args: CreateAnycastIpListCommandInput,
    cb: (err: any, data?: CreateAnycastIpListCommandOutput) => void
  ): void;
  createAnycastIpList(
    args: CreateAnycastIpListCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateAnycastIpListCommandOutput) => void
  ): void;
  createCachePolicy(
    args: CreateCachePolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateCachePolicyCommandOutput>;
  createCachePolicy(
    args: CreateCachePolicyCommandInput,
    cb: (err: any, data?: CreateCachePolicyCommandOutput) => void
  ): void;
  createCachePolicy(
    args: CreateCachePolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateCachePolicyCommandOutput) => void
  ): void;
  createCloudFrontOriginAccessIdentity(
    args: CreateCloudFrontOriginAccessIdentityCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateCloudFrontOriginAccessIdentityCommandOutput>;
  createCloudFrontOriginAccessIdentity(
    args: CreateCloudFrontOriginAccessIdentityCommandInput,
    cb: (
      err: any,
      data?: CreateCloudFrontOriginAccessIdentityCommandOutput
    ) => void
  ): void;
  createCloudFrontOriginAccessIdentity(
    args: CreateCloudFrontOriginAccessIdentityCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: CreateCloudFrontOriginAccessIdentityCommandOutput
    ) => void
  ): void;
  createConnectionGroup(
    args: CreateConnectionGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateConnectionGroupCommandOutput>;
  createConnectionGroup(
    args: CreateConnectionGroupCommandInput,
    cb: (err: any, data?: CreateConnectionGroupCommandOutput) => void
  ): void;
  createConnectionGroup(
    args: CreateConnectionGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateConnectionGroupCommandOutput) => void
  ): void;
  createContinuousDeploymentPolicy(
    args: CreateContinuousDeploymentPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateContinuousDeploymentPolicyCommandOutput>;
  createContinuousDeploymentPolicy(
    args: CreateContinuousDeploymentPolicyCommandInput,
    cb: (err: any, data?: CreateContinuousDeploymentPolicyCommandOutput) => void
  ): void;
  createContinuousDeploymentPolicy(
    args: CreateContinuousDeploymentPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateContinuousDeploymentPolicyCommandOutput) => void
  ): void;
  createDistribution(
    args: CreateDistributionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDistributionCommandOutput>;
  createDistribution(
    args: CreateDistributionCommandInput,
    cb: (err: any, data?: CreateDistributionCommandOutput) => void
  ): void;
  createDistribution(
    args: CreateDistributionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDistributionCommandOutput) => void
  ): void;
  createDistributionTenant(
    args: CreateDistributionTenantCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDistributionTenantCommandOutput>;
  createDistributionTenant(
    args: CreateDistributionTenantCommandInput,
    cb: (err: any, data?: CreateDistributionTenantCommandOutput) => void
  ): void;
  createDistributionTenant(
    args: CreateDistributionTenantCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDistributionTenantCommandOutput) => void
  ): void;
  createDistributionWithTags(
    args: CreateDistributionWithTagsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDistributionWithTagsCommandOutput>;
  createDistributionWithTags(
    args: CreateDistributionWithTagsCommandInput,
    cb: (err: any, data?: CreateDistributionWithTagsCommandOutput) => void
  ): void;
  createDistributionWithTags(
    args: CreateDistributionWithTagsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDistributionWithTagsCommandOutput) => void
  ): void;
  createFieldLevelEncryptionConfig(
    args: CreateFieldLevelEncryptionConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateFieldLevelEncryptionConfigCommandOutput>;
  createFieldLevelEncryptionConfig(
    args: CreateFieldLevelEncryptionConfigCommandInput,
    cb: (err: any, data?: CreateFieldLevelEncryptionConfigCommandOutput) => void
  ): void;
  createFieldLevelEncryptionConfig(
    args: CreateFieldLevelEncryptionConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateFieldLevelEncryptionConfigCommandOutput) => void
  ): void;
  createFieldLevelEncryptionProfile(
    args: CreateFieldLevelEncryptionProfileCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateFieldLevelEncryptionProfileCommandOutput>;
  createFieldLevelEncryptionProfile(
    args: CreateFieldLevelEncryptionProfileCommandInput,
    cb: (
      err: any,
      data?: CreateFieldLevelEncryptionProfileCommandOutput
    ) => void
  ): void;
  createFieldLevelEncryptionProfile(
    args: CreateFieldLevelEncryptionProfileCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: CreateFieldLevelEncryptionProfileCommandOutput
    ) => void
  ): void;
  createFunction(
    args: CreateFunctionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateFunctionCommandOutput>;
  createFunction(
    args: CreateFunctionCommandInput,
    cb: (err: any, data?: CreateFunctionCommandOutput) => void
  ): void;
  createFunction(
    args: CreateFunctionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateFunctionCommandOutput) => void
  ): void;
  createInvalidation(
    args: CreateInvalidationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateInvalidationCommandOutput>;
  createInvalidation(
    args: CreateInvalidationCommandInput,
    cb: (err: any, data?: CreateInvalidationCommandOutput) => void
  ): void;
  createInvalidation(
    args: CreateInvalidationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateInvalidationCommandOutput) => void
  ): void;
  createInvalidationForDistributionTenant(
    args: CreateInvalidationForDistributionTenantCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateInvalidationForDistributionTenantCommandOutput>;
  createInvalidationForDistributionTenant(
    args: CreateInvalidationForDistributionTenantCommandInput,
    cb: (
      err: any,
      data?: CreateInvalidationForDistributionTenantCommandOutput
    ) => void
  ): void;
  createInvalidationForDistributionTenant(
    args: CreateInvalidationForDistributionTenantCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: CreateInvalidationForDistributionTenantCommandOutput
    ) => void
  ): void;
  createKeyGroup(
    args: CreateKeyGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateKeyGroupCommandOutput>;
  createKeyGroup(
    args: CreateKeyGroupCommandInput,
    cb: (err: any, data?: CreateKeyGroupCommandOutput) => void
  ): void;
  createKeyGroup(
    args: CreateKeyGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateKeyGroupCommandOutput) => void
  ): void;
  createKeyValueStore(
    args: CreateKeyValueStoreCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateKeyValueStoreCommandOutput>;
  createKeyValueStore(
    args: CreateKeyValueStoreCommandInput,
    cb: (err: any, data?: CreateKeyValueStoreCommandOutput) => void
  ): void;
  createKeyValueStore(
    args: CreateKeyValueStoreCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateKeyValueStoreCommandOutput) => void
  ): void;
  createMonitoringSubscription(
    args: CreateMonitoringSubscriptionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateMonitoringSubscriptionCommandOutput>;
  createMonitoringSubscription(
    args: CreateMonitoringSubscriptionCommandInput,
    cb: (err: any, data?: CreateMonitoringSubscriptionCommandOutput) => void
  ): void;
  createMonitoringSubscription(
    args: CreateMonitoringSubscriptionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateMonitoringSubscriptionCommandOutput) => void
  ): void;
  createOriginAccessControl(
    args: CreateOriginAccessControlCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateOriginAccessControlCommandOutput>;
  createOriginAccessControl(
    args: CreateOriginAccessControlCommandInput,
    cb: (err: any, data?: CreateOriginAccessControlCommandOutput) => void
  ): void;
  createOriginAccessControl(
    args: CreateOriginAccessControlCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateOriginAccessControlCommandOutput) => void
  ): void;
  createOriginRequestPolicy(
    args: CreateOriginRequestPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateOriginRequestPolicyCommandOutput>;
  createOriginRequestPolicy(
    args: CreateOriginRequestPolicyCommandInput,
    cb: (err: any, data?: CreateOriginRequestPolicyCommandOutput) => void
  ): void;
  createOriginRequestPolicy(
    args: CreateOriginRequestPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateOriginRequestPolicyCommandOutput) => void
  ): void;
  createPublicKey(
    args: CreatePublicKeyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreatePublicKeyCommandOutput>;
  createPublicKey(
    args: CreatePublicKeyCommandInput,
    cb: (err: any, data?: CreatePublicKeyCommandOutput) => void
  ): void;
  createPublicKey(
    args: CreatePublicKeyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreatePublicKeyCommandOutput) => void
  ): void;
  createRealtimeLogConfig(
    args: CreateRealtimeLogConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateRealtimeLogConfigCommandOutput>;
  createRealtimeLogConfig(
    args: CreateRealtimeLogConfigCommandInput,
    cb: (err: any, data?: CreateRealtimeLogConfigCommandOutput) => void
  ): void;
  createRealtimeLogConfig(
    args: CreateRealtimeLogConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateRealtimeLogConfigCommandOutput) => void
  ): void;
  createResponseHeadersPolicy(
    args: CreateResponseHeadersPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateResponseHeadersPolicyCommandOutput>;
  createResponseHeadersPolicy(
    args: CreateResponseHeadersPolicyCommandInput,
    cb: (err: any, data?: CreateResponseHeadersPolicyCommandOutput) => void
  ): void;
  createResponseHeadersPolicy(
    args: CreateResponseHeadersPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateResponseHeadersPolicyCommandOutput) => void
  ): void;
  createStreamingDistribution(
    args: CreateStreamingDistributionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateStreamingDistributionCommandOutput>;
  createStreamingDistribution(
    args: CreateStreamingDistributionCommandInput,
    cb: (err: any, data?: CreateStreamingDistributionCommandOutput) => void
  ): void;
  createStreamingDistribution(
    args: CreateStreamingDistributionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateStreamingDistributionCommandOutput) => void
  ): void;
  createStreamingDistributionWithTags(
    args: CreateStreamingDistributionWithTagsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateStreamingDistributionWithTagsCommandOutput>;
  createStreamingDistributionWithTags(
    args: CreateStreamingDistributionWithTagsCommandInput,
    cb: (
      err: any,
      data?: CreateStreamingDistributionWithTagsCommandOutput
    ) => void
  ): void;
  createStreamingDistributionWithTags(
    args: CreateStreamingDistributionWithTagsCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: CreateStreamingDistributionWithTagsCommandOutput
    ) => void
  ): void;
  createVpcOrigin(
    args: CreateVpcOriginCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateVpcOriginCommandOutput>;
  createVpcOrigin(
    args: CreateVpcOriginCommandInput,
    cb: (err: any, data?: CreateVpcOriginCommandOutput) => void
  ): void;
  createVpcOrigin(
    args: CreateVpcOriginCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateVpcOriginCommandOutput) => void
  ): void;
  deleteAnycastIpList(
    args: DeleteAnycastIpListCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteAnycastIpListCommandOutput>;
  deleteAnycastIpList(
    args: DeleteAnycastIpListCommandInput,
    cb: (err: any, data?: DeleteAnycastIpListCommandOutput) => void
  ): void;
  deleteAnycastIpList(
    args: DeleteAnycastIpListCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteAnycastIpListCommandOutput) => void
  ): void;
  deleteCachePolicy(
    args: DeleteCachePolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteCachePolicyCommandOutput>;
  deleteCachePolicy(
    args: DeleteCachePolicyCommandInput,
    cb: (err: any, data?: DeleteCachePolicyCommandOutput) => void
  ): void;
  deleteCachePolicy(
    args: DeleteCachePolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteCachePolicyCommandOutput) => void
  ): void;
  deleteCloudFrontOriginAccessIdentity(
    args: DeleteCloudFrontOriginAccessIdentityCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteCloudFrontOriginAccessIdentityCommandOutput>;
  deleteCloudFrontOriginAccessIdentity(
    args: DeleteCloudFrontOriginAccessIdentityCommandInput,
    cb: (
      err: any,
      data?: DeleteCloudFrontOriginAccessIdentityCommandOutput
    ) => void
  ): void;
  deleteCloudFrontOriginAccessIdentity(
    args: DeleteCloudFrontOriginAccessIdentityCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: DeleteCloudFrontOriginAccessIdentityCommandOutput
    ) => void
  ): void;
  deleteConnectionGroup(
    args: DeleteConnectionGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteConnectionGroupCommandOutput>;
  deleteConnectionGroup(
    args: DeleteConnectionGroupCommandInput,
    cb: (err: any, data?: DeleteConnectionGroupCommandOutput) => void
  ): void;
  deleteConnectionGroup(
    args: DeleteConnectionGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteConnectionGroupCommandOutput) => void
  ): void;
  deleteContinuousDeploymentPolicy(
    args: DeleteContinuousDeploymentPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteContinuousDeploymentPolicyCommandOutput>;
  deleteContinuousDeploymentPolicy(
    args: DeleteContinuousDeploymentPolicyCommandInput,
    cb: (err: any, data?: DeleteContinuousDeploymentPolicyCommandOutput) => void
  ): void;
  deleteContinuousDeploymentPolicy(
    args: DeleteContinuousDeploymentPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteContinuousDeploymentPolicyCommandOutput) => void
  ): void;
  deleteDistribution(
    args: DeleteDistributionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDistributionCommandOutput>;
  deleteDistribution(
    args: DeleteDistributionCommandInput,
    cb: (err: any, data?: DeleteDistributionCommandOutput) => void
  ): void;
  deleteDistribution(
    args: DeleteDistributionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDistributionCommandOutput) => void
  ): void;
  deleteDistributionTenant(
    args: DeleteDistributionTenantCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDistributionTenantCommandOutput>;
  deleteDistributionTenant(
    args: DeleteDistributionTenantCommandInput,
    cb: (err: any, data?: DeleteDistributionTenantCommandOutput) => void
  ): void;
  deleteDistributionTenant(
    args: DeleteDistributionTenantCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDistributionTenantCommandOutput) => void
  ): void;
  deleteFieldLevelEncryptionConfig(
    args: DeleteFieldLevelEncryptionConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteFieldLevelEncryptionConfigCommandOutput>;
  deleteFieldLevelEncryptionConfig(
    args: DeleteFieldLevelEncryptionConfigCommandInput,
    cb: (err: any, data?: DeleteFieldLevelEncryptionConfigCommandOutput) => void
  ): void;
  deleteFieldLevelEncryptionConfig(
    args: DeleteFieldLevelEncryptionConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteFieldLevelEncryptionConfigCommandOutput) => void
  ): void;
  deleteFieldLevelEncryptionProfile(
    args: DeleteFieldLevelEncryptionProfileCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteFieldLevelEncryptionProfileCommandOutput>;
  deleteFieldLevelEncryptionProfile(
    args: DeleteFieldLevelEncryptionProfileCommandInput,
    cb: (
      err: any,
      data?: DeleteFieldLevelEncryptionProfileCommandOutput
    ) => void
  ): void;
  deleteFieldLevelEncryptionProfile(
    args: DeleteFieldLevelEncryptionProfileCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: DeleteFieldLevelEncryptionProfileCommandOutput
    ) => void
  ): void;
  deleteFunction(
    args: DeleteFunctionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteFunctionCommandOutput>;
  deleteFunction(
    args: DeleteFunctionCommandInput,
    cb: (err: any, data?: DeleteFunctionCommandOutput) => void
  ): void;
  deleteFunction(
    args: DeleteFunctionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteFunctionCommandOutput) => void
  ): void;
  deleteKeyGroup(
    args: DeleteKeyGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteKeyGroupCommandOutput>;
  deleteKeyGroup(
    args: DeleteKeyGroupCommandInput,
    cb: (err: any, data?: DeleteKeyGroupCommandOutput) => void
  ): void;
  deleteKeyGroup(
    args: DeleteKeyGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteKeyGroupCommandOutput) => void
  ): void;
  deleteKeyValueStore(
    args: DeleteKeyValueStoreCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteKeyValueStoreCommandOutput>;
  deleteKeyValueStore(
    args: DeleteKeyValueStoreCommandInput,
    cb: (err: any, data?: DeleteKeyValueStoreCommandOutput) => void
  ): void;
  deleteKeyValueStore(
    args: DeleteKeyValueStoreCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteKeyValueStoreCommandOutput) => void
  ): void;
  deleteMonitoringSubscription(
    args: DeleteMonitoringSubscriptionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteMonitoringSubscriptionCommandOutput>;
  deleteMonitoringSubscription(
    args: DeleteMonitoringSubscriptionCommandInput,
    cb: (err: any, data?: DeleteMonitoringSubscriptionCommandOutput) => void
  ): void;
  deleteMonitoringSubscription(
    args: DeleteMonitoringSubscriptionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteMonitoringSubscriptionCommandOutput) => void
  ): void;
  deleteOriginAccessControl(
    args: DeleteOriginAccessControlCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteOriginAccessControlCommandOutput>;
  deleteOriginAccessControl(
    args: DeleteOriginAccessControlCommandInput,
    cb: (err: any, data?: DeleteOriginAccessControlCommandOutput) => void
  ): void;
  deleteOriginAccessControl(
    args: DeleteOriginAccessControlCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteOriginAccessControlCommandOutput) => void
  ): void;
  deleteOriginRequestPolicy(
    args: DeleteOriginRequestPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteOriginRequestPolicyCommandOutput>;
  deleteOriginRequestPolicy(
    args: DeleteOriginRequestPolicyCommandInput,
    cb: (err: any, data?: DeleteOriginRequestPolicyCommandOutput) => void
  ): void;
  deleteOriginRequestPolicy(
    args: DeleteOriginRequestPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteOriginRequestPolicyCommandOutput) => void
  ): void;
  deletePublicKey(
    args: DeletePublicKeyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeletePublicKeyCommandOutput>;
  deletePublicKey(
    args: DeletePublicKeyCommandInput,
    cb: (err: any, data?: DeletePublicKeyCommandOutput) => void
  ): void;
  deletePublicKey(
    args: DeletePublicKeyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeletePublicKeyCommandOutput) => void
  ): void;
  deleteRealtimeLogConfig(): Promise<DeleteRealtimeLogConfigCommandOutput>;
  deleteRealtimeLogConfig(
    args: DeleteRealtimeLogConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteRealtimeLogConfigCommandOutput>;
  deleteRealtimeLogConfig(
    args: DeleteRealtimeLogConfigCommandInput,
    cb: (err: any, data?: DeleteRealtimeLogConfigCommandOutput) => void
  ): void;
  deleteRealtimeLogConfig(
    args: DeleteRealtimeLogConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteRealtimeLogConfigCommandOutput) => void
  ): void;
  deleteResourcePolicy(
    args: DeleteResourcePolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteResourcePolicyCommandOutput>;
  deleteResourcePolicy(
    args: DeleteResourcePolicyCommandInput,
    cb: (err: any, data?: DeleteResourcePolicyCommandOutput) => void
  ): void;
  deleteResourcePolicy(
    args: DeleteResourcePolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteResourcePolicyCommandOutput) => void
  ): void;
  deleteResponseHeadersPolicy(
    args: DeleteResponseHeadersPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteResponseHeadersPolicyCommandOutput>;
  deleteResponseHeadersPolicy(
    args: DeleteResponseHeadersPolicyCommandInput,
    cb: (err: any, data?: DeleteResponseHeadersPolicyCommandOutput) => void
  ): void;
  deleteResponseHeadersPolicy(
    args: DeleteResponseHeadersPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteResponseHeadersPolicyCommandOutput) => void
  ): void;
  deleteStreamingDistribution(
    args: DeleteStreamingDistributionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteStreamingDistributionCommandOutput>;
  deleteStreamingDistribution(
    args: DeleteStreamingDistributionCommandInput,
    cb: (err: any, data?: DeleteStreamingDistributionCommandOutput) => void
  ): void;
  deleteStreamingDistribution(
    args: DeleteStreamingDistributionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteStreamingDistributionCommandOutput) => void
  ): void;
  deleteVpcOrigin(
    args: DeleteVpcOriginCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteVpcOriginCommandOutput>;
  deleteVpcOrigin(
    args: DeleteVpcOriginCommandInput,
    cb: (err: any, data?: DeleteVpcOriginCommandOutput) => void
  ): void;
  deleteVpcOrigin(
    args: DeleteVpcOriginCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteVpcOriginCommandOutput) => void
  ): void;
  describeFunction(
    args: DescribeFunctionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeFunctionCommandOutput>;
  describeFunction(
    args: DescribeFunctionCommandInput,
    cb: (err: any, data?: DescribeFunctionCommandOutput) => void
  ): void;
  describeFunction(
    args: DescribeFunctionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeFunctionCommandOutput) => void
  ): void;
  describeKeyValueStore(
    args: DescribeKeyValueStoreCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeKeyValueStoreCommandOutput>;
  describeKeyValueStore(
    args: DescribeKeyValueStoreCommandInput,
    cb: (err: any, data?: DescribeKeyValueStoreCommandOutput) => void
  ): void;
  describeKeyValueStore(
    args: DescribeKeyValueStoreCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeKeyValueStoreCommandOutput) => void
  ): void;
  disassociateDistributionTenantWebACL(
    args: DisassociateDistributionTenantWebACLCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DisassociateDistributionTenantWebACLCommandOutput>;
  disassociateDistributionTenantWebACL(
    args: DisassociateDistributionTenantWebACLCommandInput,
    cb: (
      err: any,
      data?: DisassociateDistributionTenantWebACLCommandOutput
    ) => void
  ): void;
  disassociateDistributionTenantWebACL(
    args: DisassociateDistributionTenantWebACLCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: DisassociateDistributionTenantWebACLCommandOutput
    ) => void
  ): void;
  disassociateDistributionWebACL(
    args: DisassociateDistributionWebACLCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DisassociateDistributionWebACLCommandOutput>;
  disassociateDistributionWebACL(
    args: DisassociateDistributionWebACLCommandInput,
    cb: (err: any, data?: DisassociateDistributionWebACLCommandOutput) => void
  ): void;
  disassociateDistributionWebACL(
    args: DisassociateDistributionWebACLCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DisassociateDistributionWebACLCommandOutput) => void
  ): void;
  getAnycastIpList(
    args: GetAnycastIpListCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetAnycastIpListCommandOutput>;
  getAnycastIpList(
    args: GetAnycastIpListCommandInput,
    cb: (err: any, data?: GetAnycastIpListCommandOutput) => void
  ): void;
  getAnycastIpList(
    args: GetAnycastIpListCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetAnycastIpListCommandOutput) => void
  ): void;
  getCachePolicy(
    args: GetCachePolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetCachePolicyCommandOutput>;
  getCachePolicy(
    args: GetCachePolicyCommandInput,
    cb: (err: any, data?: GetCachePolicyCommandOutput) => void
  ): void;
  getCachePolicy(
    args: GetCachePolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetCachePolicyCommandOutput) => void
  ): void;
  getCachePolicyConfig(
    args: GetCachePolicyConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetCachePolicyConfigCommandOutput>;
  getCachePolicyConfig(
    args: GetCachePolicyConfigCommandInput,
    cb: (err: any, data?: GetCachePolicyConfigCommandOutput) => void
  ): void;
  getCachePolicyConfig(
    args: GetCachePolicyConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetCachePolicyConfigCommandOutput) => void
  ): void;
  getCloudFrontOriginAccessIdentity(
    args: GetCloudFrontOriginAccessIdentityCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetCloudFrontOriginAccessIdentityCommandOutput>;
  getCloudFrontOriginAccessIdentity(
    args: GetCloudFrontOriginAccessIdentityCommandInput,
    cb: (
      err: any,
      data?: GetCloudFrontOriginAccessIdentityCommandOutput
    ) => void
  ): void;
  getCloudFrontOriginAccessIdentity(
    args: GetCloudFrontOriginAccessIdentityCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: GetCloudFrontOriginAccessIdentityCommandOutput
    ) => void
  ): void;
  getCloudFrontOriginAccessIdentityConfig(
    args: GetCloudFrontOriginAccessIdentityConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetCloudFrontOriginAccessIdentityConfigCommandOutput>;
  getCloudFrontOriginAccessIdentityConfig(
    args: GetCloudFrontOriginAccessIdentityConfigCommandInput,
    cb: (
      err: any,
      data?: GetCloudFrontOriginAccessIdentityConfigCommandOutput
    ) => void
  ): void;
  getCloudFrontOriginAccessIdentityConfig(
    args: GetCloudFrontOriginAccessIdentityConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: GetCloudFrontOriginAccessIdentityConfigCommandOutput
    ) => void
  ): void;
  getConnectionGroup(
    args: GetConnectionGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetConnectionGroupCommandOutput>;
  getConnectionGroup(
    args: GetConnectionGroupCommandInput,
    cb: (err: any, data?: GetConnectionGroupCommandOutput) => void
  ): void;
  getConnectionGroup(
    args: GetConnectionGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetConnectionGroupCommandOutput) => void
  ): void;
  getConnectionGroupByRoutingEndpoint(
    args: GetConnectionGroupByRoutingEndpointCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetConnectionGroupByRoutingEndpointCommandOutput>;
  getConnectionGroupByRoutingEndpoint(
    args: GetConnectionGroupByRoutingEndpointCommandInput,
    cb: (
      err: any,
      data?: GetConnectionGroupByRoutingEndpointCommandOutput
    ) => void
  ): void;
  getConnectionGroupByRoutingEndpoint(
    args: GetConnectionGroupByRoutingEndpointCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: GetConnectionGroupByRoutingEndpointCommandOutput
    ) => void
  ): void;
  getContinuousDeploymentPolicy(
    args: GetContinuousDeploymentPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetContinuousDeploymentPolicyCommandOutput>;
  getContinuousDeploymentPolicy(
    args: GetContinuousDeploymentPolicyCommandInput,
    cb: (err: any, data?: GetContinuousDeploymentPolicyCommandOutput) => void
  ): void;
  getContinuousDeploymentPolicy(
    args: GetContinuousDeploymentPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetContinuousDeploymentPolicyCommandOutput) => void
  ): void;
  getContinuousDeploymentPolicyConfig(
    args: GetContinuousDeploymentPolicyConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetContinuousDeploymentPolicyConfigCommandOutput>;
  getContinuousDeploymentPolicyConfig(
    args: GetContinuousDeploymentPolicyConfigCommandInput,
    cb: (
      err: any,
      data?: GetContinuousDeploymentPolicyConfigCommandOutput
    ) => void
  ): void;
  getContinuousDeploymentPolicyConfig(
    args: GetContinuousDeploymentPolicyConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: GetContinuousDeploymentPolicyConfigCommandOutput
    ) => void
  ): void;
  getDistribution(
    args: GetDistributionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetDistributionCommandOutput>;
  getDistribution(
    args: GetDistributionCommandInput,
    cb: (err: any, data?: GetDistributionCommandOutput) => void
  ): void;
  getDistribution(
    args: GetDistributionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetDistributionCommandOutput) => void
  ): void;
  getDistributionConfig(
    args: GetDistributionConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetDistributionConfigCommandOutput>;
  getDistributionConfig(
    args: GetDistributionConfigCommandInput,
    cb: (err: any, data?: GetDistributionConfigCommandOutput) => void
  ): void;
  getDistributionConfig(
    args: GetDistributionConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetDistributionConfigCommandOutput) => void
  ): void;
  getDistributionTenant(
    args: GetDistributionTenantCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetDistributionTenantCommandOutput>;
  getDistributionTenant(
    args: GetDistributionTenantCommandInput,
    cb: (err: any, data?: GetDistributionTenantCommandOutput) => void
  ): void;
  getDistributionTenant(
    args: GetDistributionTenantCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetDistributionTenantCommandOutput) => void
  ): void;
  getDistributionTenantByDomain(
    args: GetDistributionTenantByDomainCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetDistributionTenantByDomainCommandOutput>;
  getDistributionTenantByDomain(
    args: GetDistributionTenantByDomainCommandInput,
    cb: (err: any, data?: GetDistributionTenantByDomainCommandOutput) => void
  ): void;
  getDistributionTenantByDomain(
    args: GetDistributionTenantByDomainCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetDistributionTenantByDomainCommandOutput) => void
  ): void;
  getFieldLevelEncryption(
    args: GetFieldLevelEncryptionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetFieldLevelEncryptionCommandOutput>;
  getFieldLevelEncryption(
    args: GetFieldLevelEncryptionCommandInput,
    cb: (err: any, data?: GetFieldLevelEncryptionCommandOutput) => void
  ): void;
  getFieldLevelEncryption(
    args: GetFieldLevelEncryptionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetFieldLevelEncryptionCommandOutput) => void
  ): void;
  getFieldLevelEncryptionConfig(
    args: GetFieldLevelEncryptionConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetFieldLevelEncryptionConfigCommandOutput>;
  getFieldLevelEncryptionConfig(
    args: GetFieldLevelEncryptionConfigCommandInput,
    cb: (err: any, data?: GetFieldLevelEncryptionConfigCommandOutput) => void
  ): void;
  getFieldLevelEncryptionConfig(
    args: GetFieldLevelEncryptionConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetFieldLevelEncryptionConfigCommandOutput) => void
  ): void;
  getFieldLevelEncryptionProfile(
    args: GetFieldLevelEncryptionProfileCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetFieldLevelEncryptionProfileCommandOutput>;
  getFieldLevelEncryptionProfile(
    args: GetFieldLevelEncryptionProfileCommandInput,
    cb: (err: any, data?: GetFieldLevelEncryptionProfileCommandOutput) => void
  ): void;
  getFieldLevelEncryptionProfile(
    args: GetFieldLevelEncryptionProfileCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetFieldLevelEncryptionProfileCommandOutput) => void
  ): void;
  getFieldLevelEncryptionProfileConfig(
    args: GetFieldLevelEncryptionProfileConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetFieldLevelEncryptionProfileConfigCommandOutput>;
  getFieldLevelEncryptionProfileConfig(
    args: GetFieldLevelEncryptionProfileConfigCommandInput,
    cb: (
      err: any,
      data?: GetFieldLevelEncryptionProfileConfigCommandOutput
    ) => void
  ): void;
  getFieldLevelEncryptionProfileConfig(
    args: GetFieldLevelEncryptionProfileConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: GetFieldLevelEncryptionProfileConfigCommandOutput
    ) => void
  ): void;
  getFunction(
    args: GetFunctionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetFunctionCommandOutput>;
  getFunction(
    args: GetFunctionCommandInput,
    cb: (err: any, data?: GetFunctionCommandOutput) => void
  ): void;
  getFunction(
    args: GetFunctionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetFunctionCommandOutput) => void
  ): void;
  getInvalidation(
    args: GetInvalidationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetInvalidationCommandOutput>;
  getInvalidation(
    args: GetInvalidationCommandInput,
    cb: (err: any, data?: GetInvalidationCommandOutput) => void
  ): void;
  getInvalidation(
    args: GetInvalidationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetInvalidationCommandOutput) => void
  ): void;
  getInvalidationForDistributionTenant(
    args: GetInvalidationForDistributionTenantCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetInvalidationForDistributionTenantCommandOutput>;
  getInvalidationForDistributionTenant(
    args: GetInvalidationForDistributionTenantCommandInput,
    cb: (
      err: any,
      data?: GetInvalidationForDistributionTenantCommandOutput
    ) => void
  ): void;
  getInvalidationForDistributionTenant(
    args: GetInvalidationForDistributionTenantCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: GetInvalidationForDistributionTenantCommandOutput
    ) => void
  ): void;
  getKeyGroup(
    args: GetKeyGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetKeyGroupCommandOutput>;
  getKeyGroup(
    args: GetKeyGroupCommandInput,
    cb: (err: any, data?: GetKeyGroupCommandOutput) => void
  ): void;
  getKeyGroup(
    args: GetKeyGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetKeyGroupCommandOutput) => void
  ): void;
  getKeyGroupConfig(
    args: GetKeyGroupConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetKeyGroupConfigCommandOutput>;
  getKeyGroupConfig(
    args: GetKeyGroupConfigCommandInput,
    cb: (err: any, data?: GetKeyGroupConfigCommandOutput) => void
  ): void;
  getKeyGroupConfig(
    args: GetKeyGroupConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetKeyGroupConfigCommandOutput) => void
  ): void;
  getManagedCertificateDetails(
    args: GetManagedCertificateDetailsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetManagedCertificateDetailsCommandOutput>;
  getManagedCertificateDetails(
    args: GetManagedCertificateDetailsCommandInput,
    cb: (err: any, data?: GetManagedCertificateDetailsCommandOutput) => void
  ): void;
  getManagedCertificateDetails(
    args: GetManagedCertificateDetailsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetManagedCertificateDetailsCommandOutput) => void
  ): void;
  getMonitoringSubscription(
    args: GetMonitoringSubscriptionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetMonitoringSubscriptionCommandOutput>;
  getMonitoringSubscription(
    args: GetMonitoringSubscriptionCommandInput,
    cb: (err: any, data?: GetMonitoringSubscriptionCommandOutput) => void
  ): void;
  getMonitoringSubscription(
    args: GetMonitoringSubscriptionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetMonitoringSubscriptionCommandOutput) => void
  ): void;
  getOriginAccessControl(
    args: GetOriginAccessControlCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetOriginAccessControlCommandOutput>;
  getOriginAccessControl(
    args: GetOriginAccessControlCommandInput,
    cb: (err: any, data?: GetOriginAccessControlCommandOutput) => void
  ): void;
  getOriginAccessControl(
    args: GetOriginAccessControlCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetOriginAccessControlCommandOutput) => void
  ): void;
  getOriginAccessControlConfig(
    args: GetOriginAccessControlConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetOriginAccessControlConfigCommandOutput>;
  getOriginAccessControlConfig(
    args: GetOriginAccessControlConfigCommandInput,
    cb: (err: any, data?: GetOriginAccessControlConfigCommandOutput) => void
  ): void;
  getOriginAccessControlConfig(
    args: GetOriginAccessControlConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetOriginAccessControlConfigCommandOutput) => void
  ): void;
  getOriginRequestPolicy(
    args: GetOriginRequestPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetOriginRequestPolicyCommandOutput>;
  getOriginRequestPolicy(
    args: GetOriginRequestPolicyCommandInput,
    cb: (err: any, data?: GetOriginRequestPolicyCommandOutput) => void
  ): void;
  getOriginRequestPolicy(
    args: GetOriginRequestPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetOriginRequestPolicyCommandOutput) => void
  ): void;
  getOriginRequestPolicyConfig(
    args: GetOriginRequestPolicyConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetOriginRequestPolicyConfigCommandOutput>;
  getOriginRequestPolicyConfig(
    args: GetOriginRequestPolicyConfigCommandInput,
    cb: (err: any, data?: GetOriginRequestPolicyConfigCommandOutput) => void
  ): void;
  getOriginRequestPolicyConfig(
    args: GetOriginRequestPolicyConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetOriginRequestPolicyConfigCommandOutput) => void
  ): void;
  getPublicKey(
    args: GetPublicKeyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetPublicKeyCommandOutput>;
  getPublicKey(
    args: GetPublicKeyCommandInput,
    cb: (err: any, data?: GetPublicKeyCommandOutput) => void
  ): void;
  getPublicKey(
    args: GetPublicKeyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetPublicKeyCommandOutput) => void
  ): void;
  getPublicKeyConfig(
    args: GetPublicKeyConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetPublicKeyConfigCommandOutput>;
  getPublicKeyConfig(
    args: GetPublicKeyConfigCommandInput,
    cb: (err: any, data?: GetPublicKeyConfigCommandOutput) => void
  ): void;
  getPublicKeyConfig(
    args: GetPublicKeyConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetPublicKeyConfigCommandOutput) => void
  ): void;
  getRealtimeLogConfig(): Promise<GetRealtimeLogConfigCommandOutput>;
  getRealtimeLogConfig(
    args: GetRealtimeLogConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetRealtimeLogConfigCommandOutput>;
  getRealtimeLogConfig(
    args: GetRealtimeLogConfigCommandInput,
    cb: (err: any, data?: GetRealtimeLogConfigCommandOutput) => void
  ): void;
  getRealtimeLogConfig(
    args: GetRealtimeLogConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetRealtimeLogConfigCommandOutput) => void
  ): void;
  getResourcePolicy(
    args: GetResourcePolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetResourcePolicyCommandOutput>;
  getResourcePolicy(
    args: GetResourcePolicyCommandInput,
    cb: (err: any, data?: GetResourcePolicyCommandOutput) => void
  ): void;
  getResourcePolicy(
    args: GetResourcePolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetResourcePolicyCommandOutput) => void
  ): void;
  getResponseHeadersPolicy(
    args: GetResponseHeadersPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetResponseHeadersPolicyCommandOutput>;
  getResponseHeadersPolicy(
    args: GetResponseHeadersPolicyCommandInput,
    cb: (err: any, data?: GetResponseHeadersPolicyCommandOutput) => void
  ): void;
  getResponseHeadersPolicy(
    args: GetResponseHeadersPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetResponseHeadersPolicyCommandOutput) => void
  ): void;
  getResponseHeadersPolicyConfig(
    args: GetResponseHeadersPolicyConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetResponseHeadersPolicyConfigCommandOutput>;
  getResponseHeadersPolicyConfig(
    args: GetResponseHeadersPolicyConfigCommandInput,
    cb: (err: any, data?: GetResponseHeadersPolicyConfigCommandOutput) => void
  ): void;
  getResponseHeadersPolicyConfig(
    args: GetResponseHeadersPolicyConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetResponseHeadersPolicyConfigCommandOutput) => void
  ): void;
  getStreamingDistribution(
    args: GetStreamingDistributionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetStreamingDistributionCommandOutput>;
  getStreamingDistribution(
    args: GetStreamingDistributionCommandInput,
    cb: (err: any, data?: GetStreamingDistributionCommandOutput) => void
  ): void;
  getStreamingDistribution(
    args: GetStreamingDistributionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetStreamingDistributionCommandOutput) => void
  ): void;
  getStreamingDistributionConfig(
    args: GetStreamingDistributionConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetStreamingDistributionConfigCommandOutput>;
  getStreamingDistributionConfig(
    args: GetStreamingDistributionConfigCommandInput,
    cb: (err: any, data?: GetStreamingDistributionConfigCommandOutput) => void
  ): void;
  getStreamingDistributionConfig(
    args: GetStreamingDistributionConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetStreamingDistributionConfigCommandOutput) => void
  ): void;
  getVpcOrigin(
    args: GetVpcOriginCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<GetVpcOriginCommandOutput>;
  getVpcOrigin(
    args: GetVpcOriginCommandInput,
    cb: (err: any, data?: GetVpcOriginCommandOutput) => void
  ): void;
  getVpcOrigin(
    args: GetVpcOriginCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: GetVpcOriginCommandOutput) => void
  ): void;
  listAnycastIpLists(): Promise<ListAnycastIpListsCommandOutput>;
  listAnycastIpLists(
    args: ListAnycastIpListsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListAnycastIpListsCommandOutput>;
  listAnycastIpLists(
    args: ListAnycastIpListsCommandInput,
    cb: (err: any, data?: ListAnycastIpListsCommandOutput) => void
  ): void;
  listAnycastIpLists(
    args: ListAnycastIpListsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListAnycastIpListsCommandOutput) => void
  ): void;
  listCachePolicies(): Promise<ListCachePoliciesCommandOutput>;
  listCachePolicies(
    args: ListCachePoliciesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListCachePoliciesCommandOutput>;
  listCachePolicies(
    args: ListCachePoliciesCommandInput,
    cb: (err: any, data?: ListCachePoliciesCommandOutput) => void
  ): void;
  listCachePolicies(
    args: ListCachePoliciesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListCachePoliciesCommandOutput) => void
  ): void;
  listCloudFrontOriginAccessIdentities(): Promise<ListCloudFrontOriginAccessIdentitiesCommandOutput>;
  listCloudFrontOriginAccessIdentities(
    args: ListCloudFrontOriginAccessIdentitiesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListCloudFrontOriginAccessIdentitiesCommandOutput>;
  listCloudFrontOriginAccessIdentities(
    args: ListCloudFrontOriginAccessIdentitiesCommandInput,
    cb: (
      err: any,
      data?: ListCloudFrontOriginAccessIdentitiesCommandOutput
    ) => void
  ): void;
  listCloudFrontOriginAccessIdentities(
    args: ListCloudFrontOriginAccessIdentitiesCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: ListCloudFrontOriginAccessIdentitiesCommandOutput
    ) => void
  ): void;
  listConflictingAliases(
    args: ListConflictingAliasesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListConflictingAliasesCommandOutput>;
  listConflictingAliases(
    args: ListConflictingAliasesCommandInput,
    cb: (err: any, data?: ListConflictingAliasesCommandOutput) => void
  ): void;
  listConflictingAliases(
    args: ListConflictingAliasesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListConflictingAliasesCommandOutput) => void
  ): void;
  listConnectionGroups(): Promise<ListConnectionGroupsCommandOutput>;
  listConnectionGroups(
    args: ListConnectionGroupsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListConnectionGroupsCommandOutput>;
  listConnectionGroups(
    args: ListConnectionGroupsCommandInput,
    cb: (err: any, data?: ListConnectionGroupsCommandOutput) => void
  ): void;
  listConnectionGroups(
    args: ListConnectionGroupsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListConnectionGroupsCommandOutput) => void
  ): void;
  listContinuousDeploymentPolicies(): Promise<ListContinuousDeploymentPoliciesCommandOutput>;
  listContinuousDeploymentPolicies(
    args: ListContinuousDeploymentPoliciesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListContinuousDeploymentPoliciesCommandOutput>;
  listContinuousDeploymentPolicies(
    args: ListContinuousDeploymentPoliciesCommandInput,
    cb: (err: any, data?: ListContinuousDeploymentPoliciesCommandOutput) => void
  ): void;
  listContinuousDeploymentPolicies(
    args: ListContinuousDeploymentPoliciesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListContinuousDeploymentPoliciesCommandOutput) => void
  ): void;
  listDistributions(): Promise<ListDistributionsCommandOutput>;
  listDistributions(
    args: ListDistributionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDistributionsCommandOutput>;
  listDistributions(
    args: ListDistributionsCommandInput,
    cb: (err: any, data?: ListDistributionsCommandOutput) => void
  ): void;
  listDistributions(
    args: ListDistributionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListDistributionsCommandOutput) => void
  ): void;
  listDistributionsByAnycastIpListId(
    args: ListDistributionsByAnycastIpListIdCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDistributionsByAnycastIpListIdCommandOutput>;
  listDistributionsByAnycastIpListId(
    args: ListDistributionsByAnycastIpListIdCommandInput,
    cb: (
      err: any,
      data?: ListDistributionsByAnycastIpListIdCommandOutput
    ) => void
  ): void;
  listDistributionsByAnycastIpListId(
    args: ListDistributionsByAnycastIpListIdCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: ListDistributionsByAnycastIpListIdCommandOutput
    ) => void
  ): void;
  listDistributionsByCachePolicyId(
    args: ListDistributionsByCachePolicyIdCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDistributionsByCachePolicyIdCommandOutput>;
  listDistributionsByCachePolicyId(
    args: ListDistributionsByCachePolicyIdCommandInput,
    cb: (err: any, data?: ListDistributionsByCachePolicyIdCommandOutput) => void
  ): void;
  listDistributionsByCachePolicyId(
    args: ListDistributionsByCachePolicyIdCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListDistributionsByCachePolicyIdCommandOutput) => void
  ): void;
  listDistributionsByConnectionMode(
    args: ListDistributionsByConnectionModeCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDistributionsByConnectionModeCommandOutput>;
  listDistributionsByConnectionMode(
    args: ListDistributionsByConnectionModeCommandInput,
    cb: (
      err: any,
      data?: ListDistributionsByConnectionModeCommandOutput
    ) => void
  ): void;
  listDistributionsByConnectionMode(
    args: ListDistributionsByConnectionModeCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: ListDistributionsByConnectionModeCommandOutput
    ) => void
  ): void;
  listDistributionsByKeyGroup(
    args: ListDistributionsByKeyGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDistributionsByKeyGroupCommandOutput>;
  listDistributionsByKeyGroup(
    args: ListDistributionsByKeyGroupCommandInput,
    cb: (err: any, data?: ListDistributionsByKeyGroupCommandOutput) => void
  ): void;
  listDistributionsByKeyGroup(
    args: ListDistributionsByKeyGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListDistributionsByKeyGroupCommandOutput) => void
  ): void;
  listDistributionsByOriginRequestPolicyId(
    args: ListDistributionsByOriginRequestPolicyIdCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDistributionsByOriginRequestPolicyIdCommandOutput>;
  listDistributionsByOriginRequestPolicyId(
    args: ListDistributionsByOriginRequestPolicyIdCommandInput,
    cb: (
      err: any,
      data?: ListDistributionsByOriginRequestPolicyIdCommandOutput
    ) => void
  ): void;
  listDistributionsByOriginRequestPolicyId(
    args: ListDistributionsByOriginRequestPolicyIdCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: ListDistributionsByOriginRequestPolicyIdCommandOutput
    ) => void
  ): void;
  listDistributionsByOwnedResource(
    args: ListDistributionsByOwnedResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDistributionsByOwnedResourceCommandOutput>;
  listDistributionsByOwnedResource(
    args: ListDistributionsByOwnedResourceCommandInput,
    cb: (err: any, data?: ListDistributionsByOwnedResourceCommandOutput) => void
  ): void;
  listDistributionsByOwnedResource(
    args: ListDistributionsByOwnedResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListDistributionsByOwnedResourceCommandOutput) => void
  ): void;
  listDistributionsByRealtimeLogConfig(): Promise<ListDistributionsByRealtimeLogConfigCommandOutput>;
  listDistributionsByRealtimeLogConfig(
    args: ListDistributionsByRealtimeLogConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDistributionsByRealtimeLogConfigCommandOutput>;
  listDistributionsByRealtimeLogConfig(
    args: ListDistributionsByRealtimeLogConfigCommandInput,
    cb: (
      err: any,
      data?: ListDistributionsByRealtimeLogConfigCommandOutput
    ) => void
  ): void;
  listDistributionsByRealtimeLogConfig(
    args: ListDistributionsByRealtimeLogConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: ListDistributionsByRealtimeLogConfigCommandOutput
    ) => void
  ): void;
  listDistributionsByResponseHeadersPolicyId(
    args: ListDistributionsByResponseHeadersPolicyIdCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDistributionsByResponseHeadersPolicyIdCommandOutput>;
  listDistributionsByResponseHeadersPolicyId(
    args: ListDistributionsByResponseHeadersPolicyIdCommandInput,
    cb: (
      err: any,
      data?: ListDistributionsByResponseHeadersPolicyIdCommandOutput
    ) => void
  ): void;
  listDistributionsByResponseHeadersPolicyId(
    args: ListDistributionsByResponseHeadersPolicyIdCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: ListDistributionsByResponseHeadersPolicyIdCommandOutput
    ) => void
  ): void;
  listDistributionsByVpcOriginId(
    args: ListDistributionsByVpcOriginIdCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDistributionsByVpcOriginIdCommandOutput>;
  listDistributionsByVpcOriginId(
    args: ListDistributionsByVpcOriginIdCommandInput,
    cb: (err: any, data?: ListDistributionsByVpcOriginIdCommandOutput) => void
  ): void;
  listDistributionsByVpcOriginId(
    args: ListDistributionsByVpcOriginIdCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListDistributionsByVpcOriginIdCommandOutput) => void
  ): void;
  listDistributionsByWebACLId(
    args: ListDistributionsByWebACLIdCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDistributionsByWebACLIdCommandOutput>;
  listDistributionsByWebACLId(
    args: ListDistributionsByWebACLIdCommandInput,
    cb: (err: any, data?: ListDistributionsByWebACLIdCommandOutput) => void
  ): void;
  listDistributionsByWebACLId(
    args: ListDistributionsByWebACLIdCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListDistributionsByWebACLIdCommandOutput) => void
  ): void;
  listDistributionTenants(): Promise<ListDistributionTenantsCommandOutput>;
  listDistributionTenants(
    args: ListDistributionTenantsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDistributionTenantsCommandOutput>;
  listDistributionTenants(
    args: ListDistributionTenantsCommandInput,
    cb: (err: any, data?: ListDistributionTenantsCommandOutput) => void
  ): void;
  listDistributionTenants(
    args: ListDistributionTenantsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListDistributionTenantsCommandOutput) => void
  ): void;
  listDistributionTenantsByCustomization(): Promise<ListDistributionTenantsByCustomizationCommandOutput>;
  listDistributionTenantsByCustomization(
    args: ListDistributionTenantsByCustomizationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDistributionTenantsByCustomizationCommandOutput>;
  listDistributionTenantsByCustomization(
    args: ListDistributionTenantsByCustomizationCommandInput,
    cb: (
      err: any,
      data?: ListDistributionTenantsByCustomizationCommandOutput
    ) => void
  ): void;
  listDistributionTenantsByCustomization(
    args: ListDistributionTenantsByCustomizationCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: ListDistributionTenantsByCustomizationCommandOutput
    ) => void
  ): void;
  listDomainConflicts(
    args: ListDomainConflictsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListDomainConflictsCommandOutput>;
  listDomainConflicts(
    args: ListDomainConflictsCommandInput,
    cb: (err: any, data?: ListDomainConflictsCommandOutput) => void
  ): void;
  listDomainConflicts(
    args: ListDomainConflictsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListDomainConflictsCommandOutput) => void
  ): void;
  listFieldLevelEncryptionConfigs(): Promise<ListFieldLevelEncryptionConfigsCommandOutput>;
  listFieldLevelEncryptionConfigs(
    args: ListFieldLevelEncryptionConfigsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListFieldLevelEncryptionConfigsCommandOutput>;
  listFieldLevelEncryptionConfigs(
    args: ListFieldLevelEncryptionConfigsCommandInput,
    cb: (err: any, data?: ListFieldLevelEncryptionConfigsCommandOutput) => void
  ): void;
  listFieldLevelEncryptionConfigs(
    args: ListFieldLevelEncryptionConfigsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListFieldLevelEncryptionConfigsCommandOutput) => void
  ): void;
  listFieldLevelEncryptionProfiles(): Promise<ListFieldLevelEncryptionProfilesCommandOutput>;
  listFieldLevelEncryptionProfiles(
    args: ListFieldLevelEncryptionProfilesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListFieldLevelEncryptionProfilesCommandOutput>;
  listFieldLevelEncryptionProfiles(
    args: ListFieldLevelEncryptionProfilesCommandInput,
    cb: (err: any, data?: ListFieldLevelEncryptionProfilesCommandOutput) => void
  ): void;
  listFieldLevelEncryptionProfiles(
    args: ListFieldLevelEncryptionProfilesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListFieldLevelEncryptionProfilesCommandOutput) => void
  ): void;
  listFunctions(): Promise<ListFunctionsCommandOutput>;
  listFunctions(
    args: ListFunctionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListFunctionsCommandOutput>;
  listFunctions(
    args: ListFunctionsCommandInput,
    cb: (err: any, data?: ListFunctionsCommandOutput) => void
  ): void;
  listFunctions(
    args: ListFunctionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListFunctionsCommandOutput) => void
  ): void;
  listInvalidations(
    args: ListInvalidationsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListInvalidationsCommandOutput>;
  listInvalidations(
    args: ListInvalidationsCommandInput,
    cb: (err: any, data?: ListInvalidationsCommandOutput) => void
  ): void;
  listInvalidations(
    args: ListInvalidationsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListInvalidationsCommandOutput) => void
  ): void;
  listInvalidationsForDistributionTenant(
    args: ListInvalidationsForDistributionTenantCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListInvalidationsForDistributionTenantCommandOutput>;
  listInvalidationsForDistributionTenant(
    args: ListInvalidationsForDistributionTenantCommandInput,
    cb: (
      err: any,
      data?: ListInvalidationsForDistributionTenantCommandOutput
    ) => void
  ): void;
  listInvalidationsForDistributionTenant(
    args: ListInvalidationsForDistributionTenantCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: ListInvalidationsForDistributionTenantCommandOutput
    ) => void
  ): void;
  listKeyGroups(): Promise<ListKeyGroupsCommandOutput>;
  listKeyGroups(
    args: ListKeyGroupsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListKeyGroupsCommandOutput>;
  listKeyGroups(
    args: ListKeyGroupsCommandInput,
    cb: (err: any, data?: ListKeyGroupsCommandOutput) => void
  ): void;
  listKeyGroups(
    args: ListKeyGroupsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListKeyGroupsCommandOutput) => void
  ): void;
  listKeyValueStores(): Promise<ListKeyValueStoresCommandOutput>;
  listKeyValueStores(
    args: ListKeyValueStoresCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListKeyValueStoresCommandOutput>;
  listKeyValueStores(
    args: ListKeyValueStoresCommandInput,
    cb: (err: any, data?: ListKeyValueStoresCommandOutput) => void
  ): void;
  listKeyValueStores(
    args: ListKeyValueStoresCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListKeyValueStoresCommandOutput) => void
  ): void;
  listOriginAccessControls(): Promise<ListOriginAccessControlsCommandOutput>;
  listOriginAccessControls(
    args: ListOriginAccessControlsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListOriginAccessControlsCommandOutput>;
  listOriginAccessControls(
    args: ListOriginAccessControlsCommandInput,
    cb: (err: any, data?: ListOriginAccessControlsCommandOutput) => void
  ): void;
  listOriginAccessControls(
    args: ListOriginAccessControlsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListOriginAccessControlsCommandOutput) => void
  ): void;
  listOriginRequestPolicies(): Promise<ListOriginRequestPoliciesCommandOutput>;
  listOriginRequestPolicies(
    args: ListOriginRequestPoliciesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListOriginRequestPoliciesCommandOutput>;
  listOriginRequestPolicies(
    args: ListOriginRequestPoliciesCommandInput,
    cb: (err: any, data?: ListOriginRequestPoliciesCommandOutput) => void
  ): void;
  listOriginRequestPolicies(
    args: ListOriginRequestPoliciesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListOriginRequestPoliciesCommandOutput) => void
  ): void;
  listPublicKeys(): Promise<ListPublicKeysCommandOutput>;
  listPublicKeys(
    args: ListPublicKeysCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListPublicKeysCommandOutput>;
  listPublicKeys(
    args: ListPublicKeysCommandInput,
    cb: (err: any, data?: ListPublicKeysCommandOutput) => void
  ): void;
  listPublicKeys(
    args: ListPublicKeysCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListPublicKeysCommandOutput) => void
  ): void;
  listRealtimeLogConfigs(): Promise<ListRealtimeLogConfigsCommandOutput>;
  listRealtimeLogConfigs(
    args: ListRealtimeLogConfigsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListRealtimeLogConfigsCommandOutput>;
  listRealtimeLogConfigs(
    args: ListRealtimeLogConfigsCommandInput,
    cb: (err: any, data?: ListRealtimeLogConfigsCommandOutput) => void
  ): void;
  listRealtimeLogConfigs(
    args: ListRealtimeLogConfigsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListRealtimeLogConfigsCommandOutput) => void
  ): void;
  listResponseHeadersPolicies(): Promise<ListResponseHeadersPoliciesCommandOutput>;
  listResponseHeadersPolicies(
    args: ListResponseHeadersPoliciesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListResponseHeadersPoliciesCommandOutput>;
  listResponseHeadersPolicies(
    args: ListResponseHeadersPoliciesCommandInput,
    cb: (err: any, data?: ListResponseHeadersPoliciesCommandOutput) => void
  ): void;
  listResponseHeadersPolicies(
    args: ListResponseHeadersPoliciesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListResponseHeadersPoliciesCommandOutput) => void
  ): void;
  listStreamingDistributions(): Promise<ListStreamingDistributionsCommandOutput>;
  listStreamingDistributions(
    args: ListStreamingDistributionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListStreamingDistributionsCommandOutput>;
  listStreamingDistributions(
    args: ListStreamingDistributionsCommandInput,
    cb: (err: any, data?: ListStreamingDistributionsCommandOutput) => void
  ): void;
  listStreamingDistributions(
    args: ListStreamingDistributionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListStreamingDistributionsCommandOutput) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListTagsForResourceCommandOutput>;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  listVpcOrigins(): Promise<ListVpcOriginsCommandOutput>;
  listVpcOrigins(
    args: ListVpcOriginsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListVpcOriginsCommandOutput>;
  listVpcOrigins(
    args: ListVpcOriginsCommandInput,
    cb: (err: any, data?: ListVpcOriginsCommandOutput) => void
  ): void;
  listVpcOrigins(
    args: ListVpcOriginsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListVpcOriginsCommandOutput) => void
  ): void;
  publishFunction(
    args: PublishFunctionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<PublishFunctionCommandOutput>;
  publishFunction(
    args: PublishFunctionCommandInput,
    cb: (err: any, data?: PublishFunctionCommandOutput) => void
  ): void;
  publishFunction(
    args: PublishFunctionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: PublishFunctionCommandOutput) => void
  ): void;
  putResourcePolicy(
    args: PutResourcePolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<PutResourcePolicyCommandOutput>;
  putResourcePolicy(
    args: PutResourcePolicyCommandInput,
    cb: (err: any, data?: PutResourcePolicyCommandOutput) => void
  ): void;
  putResourcePolicy(
    args: PutResourcePolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: PutResourcePolicyCommandOutput) => void
  ): void;
  tagResource(
    args: TagResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<TagResourceCommandOutput>;
  tagResource(
    args: TagResourceCommandInput,
    cb: (err: any, data?: TagResourceCommandOutput) => void
  ): void;
  tagResource(
    args: TagResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: TagResourceCommandOutput) => void
  ): void;
  testFunction(
    args: TestFunctionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<TestFunctionCommandOutput>;
  testFunction(
    args: TestFunctionCommandInput,
    cb: (err: any, data?: TestFunctionCommandOutput) => void
  ): void;
  testFunction(
    args: TestFunctionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: TestFunctionCommandOutput) => void
  ): void;
  untagResource(
    args: UntagResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UntagResourceCommandOutput>;
  untagResource(
    args: UntagResourceCommandInput,
    cb: (err: any, data?: UntagResourceCommandOutput) => void
  ): void;
  untagResource(
    args: UntagResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UntagResourceCommandOutput) => void
  ): void;
  updateAnycastIpList(
    args: UpdateAnycastIpListCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateAnycastIpListCommandOutput>;
  updateAnycastIpList(
    args: UpdateAnycastIpListCommandInput,
    cb: (err: any, data?: UpdateAnycastIpListCommandOutput) => void
  ): void;
  updateAnycastIpList(
    args: UpdateAnycastIpListCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateAnycastIpListCommandOutput) => void
  ): void;
  updateCachePolicy(
    args: UpdateCachePolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateCachePolicyCommandOutput>;
  updateCachePolicy(
    args: UpdateCachePolicyCommandInput,
    cb: (err: any, data?: UpdateCachePolicyCommandOutput) => void
  ): void;
  updateCachePolicy(
    args: UpdateCachePolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateCachePolicyCommandOutput) => void
  ): void;
  updateCloudFrontOriginAccessIdentity(
    args: UpdateCloudFrontOriginAccessIdentityCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateCloudFrontOriginAccessIdentityCommandOutput>;
  updateCloudFrontOriginAccessIdentity(
    args: UpdateCloudFrontOriginAccessIdentityCommandInput,
    cb: (
      err: any,
      data?: UpdateCloudFrontOriginAccessIdentityCommandOutput
    ) => void
  ): void;
  updateCloudFrontOriginAccessIdentity(
    args: UpdateCloudFrontOriginAccessIdentityCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: UpdateCloudFrontOriginAccessIdentityCommandOutput
    ) => void
  ): void;
  updateConnectionGroup(
    args: UpdateConnectionGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateConnectionGroupCommandOutput>;
  updateConnectionGroup(
    args: UpdateConnectionGroupCommandInput,
    cb: (err: any, data?: UpdateConnectionGroupCommandOutput) => void
  ): void;
  updateConnectionGroup(
    args: UpdateConnectionGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateConnectionGroupCommandOutput) => void
  ): void;
  updateContinuousDeploymentPolicy(
    args: UpdateContinuousDeploymentPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateContinuousDeploymentPolicyCommandOutput>;
  updateContinuousDeploymentPolicy(
    args: UpdateContinuousDeploymentPolicyCommandInput,
    cb: (err: any, data?: UpdateContinuousDeploymentPolicyCommandOutput) => void
  ): void;
  updateContinuousDeploymentPolicy(
    args: UpdateContinuousDeploymentPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateContinuousDeploymentPolicyCommandOutput) => void
  ): void;
  updateDistribution(
    args: UpdateDistributionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateDistributionCommandOutput>;
  updateDistribution(
    args: UpdateDistributionCommandInput,
    cb: (err: any, data?: UpdateDistributionCommandOutput) => void
  ): void;
  updateDistribution(
    args: UpdateDistributionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateDistributionCommandOutput) => void
  ): void;
  updateDistributionTenant(
    args: UpdateDistributionTenantCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateDistributionTenantCommandOutput>;
  updateDistributionTenant(
    args: UpdateDistributionTenantCommandInput,
    cb: (err: any, data?: UpdateDistributionTenantCommandOutput) => void
  ): void;
  updateDistributionTenant(
    args: UpdateDistributionTenantCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateDistributionTenantCommandOutput) => void
  ): void;
  updateDistributionWithStagingConfig(
    args: UpdateDistributionWithStagingConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateDistributionWithStagingConfigCommandOutput>;
  updateDistributionWithStagingConfig(
    args: UpdateDistributionWithStagingConfigCommandInput,
    cb: (
      err: any,
      data?: UpdateDistributionWithStagingConfigCommandOutput
    ) => void
  ): void;
  updateDistributionWithStagingConfig(
    args: UpdateDistributionWithStagingConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: UpdateDistributionWithStagingConfigCommandOutput
    ) => void
  ): void;
  updateDomainAssociation(
    args: UpdateDomainAssociationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateDomainAssociationCommandOutput>;
  updateDomainAssociation(
    args: UpdateDomainAssociationCommandInput,
    cb: (err: any, data?: UpdateDomainAssociationCommandOutput) => void
  ): void;
  updateDomainAssociation(
    args: UpdateDomainAssociationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateDomainAssociationCommandOutput) => void
  ): void;
  updateFieldLevelEncryptionConfig(
    args: UpdateFieldLevelEncryptionConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateFieldLevelEncryptionConfigCommandOutput>;
  updateFieldLevelEncryptionConfig(
    args: UpdateFieldLevelEncryptionConfigCommandInput,
    cb: (err: any, data?: UpdateFieldLevelEncryptionConfigCommandOutput) => void
  ): void;
  updateFieldLevelEncryptionConfig(
    args: UpdateFieldLevelEncryptionConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateFieldLevelEncryptionConfigCommandOutput) => void
  ): void;
  updateFieldLevelEncryptionProfile(
    args: UpdateFieldLevelEncryptionProfileCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateFieldLevelEncryptionProfileCommandOutput>;
  updateFieldLevelEncryptionProfile(
    args: UpdateFieldLevelEncryptionProfileCommandInput,
    cb: (
      err: any,
      data?: UpdateFieldLevelEncryptionProfileCommandOutput
    ) => void
  ): void;
  updateFieldLevelEncryptionProfile(
    args: UpdateFieldLevelEncryptionProfileCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: UpdateFieldLevelEncryptionProfileCommandOutput
    ) => void
  ): void;
  updateFunction(
    args: UpdateFunctionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateFunctionCommandOutput>;
  updateFunction(
    args: UpdateFunctionCommandInput,
    cb: (err: any, data?: UpdateFunctionCommandOutput) => void
  ): void;
  updateFunction(
    args: UpdateFunctionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateFunctionCommandOutput) => void
  ): void;
  updateKeyGroup(
    args: UpdateKeyGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateKeyGroupCommandOutput>;
  updateKeyGroup(
    args: UpdateKeyGroupCommandInput,
    cb: (err: any, data?: UpdateKeyGroupCommandOutput) => void
  ): void;
  updateKeyGroup(
    args: UpdateKeyGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateKeyGroupCommandOutput) => void
  ): void;
  updateKeyValueStore(
    args: UpdateKeyValueStoreCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateKeyValueStoreCommandOutput>;
  updateKeyValueStore(
    args: UpdateKeyValueStoreCommandInput,
    cb: (err: any, data?: UpdateKeyValueStoreCommandOutput) => void
  ): void;
  updateKeyValueStore(
    args: UpdateKeyValueStoreCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateKeyValueStoreCommandOutput) => void
  ): void;
  updateOriginAccessControl(
    args: UpdateOriginAccessControlCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateOriginAccessControlCommandOutput>;
  updateOriginAccessControl(
    args: UpdateOriginAccessControlCommandInput,
    cb: (err: any, data?: UpdateOriginAccessControlCommandOutput) => void
  ): void;
  updateOriginAccessControl(
    args: UpdateOriginAccessControlCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateOriginAccessControlCommandOutput) => void
  ): void;
  updateOriginRequestPolicy(
    args: UpdateOriginRequestPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateOriginRequestPolicyCommandOutput>;
  updateOriginRequestPolicy(
    args: UpdateOriginRequestPolicyCommandInput,
    cb: (err: any, data?: UpdateOriginRequestPolicyCommandOutput) => void
  ): void;
  updateOriginRequestPolicy(
    args: UpdateOriginRequestPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateOriginRequestPolicyCommandOutput) => void
  ): void;
  updatePublicKey(
    args: UpdatePublicKeyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdatePublicKeyCommandOutput>;
  updatePublicKey(
    args: UpdatePublicKeyCommandInput,
    cb: (err: any, data?: UpdatePublicKeyCommandOutput) => void
  ): void;
  updatePublicKey(
    args: UpdatePublicKeyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdatePublicKeyCommandOutput) => void
  ): void;
  updateRealtimeLogConfig(): Promise<UpdateRealtimeLogConfigCommandOutput>;
  updateRealtimeLogConfig(
    args: UpdateRealtimeLogConfigCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateRealtimeLogConfigCommandOutput>;
  updateRealtimeLogConfig(
    args: UpdateRealtimeLogConfigCommandInput,
    cb: (err: any, data?: UpdateRealtimeLogConfigCommandOutput) => void
  ): void;
  updateRealtimeLogConfig(
    args: UpdateRealtimeLogConfigCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateRealtimeLogConfigCommandOutput) => void
  ): void;
  updateResponseHeadersPolicy(
    args: UpdateResponseHeadersPolicyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateResponseHeadersPolicyCommandOutput>;
  updateResponseHeadersPolicy(
    args: UpdateResponseHeadersPolicyCommandInput,
    cb: (err: any, data?: UpdateResponseHeadersPolicyCommandOutput) => void
  ): void;
  updateResponseHeadersPolicy(
    args: UpdateResponseHeadersPolicyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateResponseHeadersPolicyCommandOutput) => void
  ): void;
  updateStreamingDistribution(
    args: UpdateStreamingDistributionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateStreamingDistributionCommandOutput>;
  updateStreamingDistribution(
    args: UpdateStreamingDistributionCommandInput,
    cb: (err: any, data?: UpdateStreamingDistributionCommandOutput) => void
  ): void;
  updateStreamingDistribution(
    args: UpdateStreamingDistributionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateStreamingDistributionCommandOutput) => void
  ): void;
  updateVpcOrigin(
    args: UpdateVpcOriginCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<UpdateVpcOriginCommandOutput>;
  updateVpcOrigin(
    args: UpdateVpcOriginCommandInput,
    cb: (err: any, data?: UpdateVpcOriginCommandOutput) => void
  ): void;
  updateVpcOrigin(
    args: UpdateVpcOriginCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: UpdateVpcOriginCommandOutput) => void
  ): void;
  verifyDnsConfiguration(
    args: VerifyDnsConfigurationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<VerifyDnsConfigurationCommandOutput>;
  verifyDnsConfiguration(
    args: VerifyDnsConfigurationCommandInput,
    cb: (err: any, data?: VerifyDnsConfigurationCommandOutput) => void
  ): void;
  verifyDnsConfiguration(
    args: VerifyDnsConfigurationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: VerifyDnsConfigurationCommandOutput) => void
  ): void;
}
export declare class CloudFront
  extends CloudFrontClient
  implements CloudFront {}
