/**
 * ./src/commands/update.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { Command } from '@oclif/core';
import Distro from '../classes/distro.js';
/**
 *
 */
export default class Update extends Command {
    static description: string;
    static examples: string[];
    static flags: {
        help: import("@oclif/core/interfaces").BooleanFlag<void>;
        verbose: import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    distro: Distro;
    /**
     *
     */
    choosePkg(): Promise<string>;
    chooseUpdate(): Promise<void>;
    /**
     *
     * @param url
     * @param outputFilename
     * @returns
     */
    downloadWithCurl(url: string, outputFilename: string): Promise<void>;
    /**
     *
     */
    getFromSource(): void;
    /**
     *
     */
    getLatestAppImage(): Promise<void>;
    /**
     *
     */
    getLatestAppImageUrl(): Promise<null | string>;
    /**
     * download da LAN
     */
    getPkgFromLan(): Promise<void>;
    /**
     *
     */
    getPkgFromPackageManager(): Promise<void>;
    /**
     * run
     */
    run(): Promise<void>;
    /**
     * show
     */
    show(url: string): Promise<void>;
}
