/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.PrintWriter;
import net.sf.mpxj.fasttrack.AbstractColumn;
import net.sf.mpxj.fasttrack.FastTrackUtility;

class StringColumn
extends AbstractColumn {
    StringColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 0;
    }

    @Override
    protected int readData(byte[] buffer, int offset) {
        int index;
        int structureFlags = FastTrackUtility.getInt(buffer, offset += 6);
        offset += 4;
        offset = structureFlags == 0 ? (offset += 10) : FastTrackUtility.skipToNextMatchingShort(buffer, offset, 15);
        int numberOfItems = FastTrackUtility.getInt(buffer, offset);
        FastTrackUtility.validateSize(numberOfItems);
        this.m_data = new String[numberOfItems];
        offset += 4;
        offset += 4;
        int[] blockOffsets = new int[this.m_data.length + 1];
        for (index = 0; index < blockOffsets.length; ++index) {
            int offsetInBlock;
            blockOffsets[index] = offsetInBlock = FastTrackUtility.getInt(buffer, offset);
            offset += 4;
        }
        offset += 4;
        for (index = 0; index < this.m_data.length; ++index) {
            int itemNameLength = blockOffsets[index + 1] - blockOffsets[index];
            FastTrackUtility.validateSize(itemNameLength);
            this.m_data[index] = FastTrackUtility.getString(buffer, offset, itemNameLength);
            offset += itemNameLength;
        }
        return offset;
    }

    @Override
    protected void dumpData(PrintWriter pw) {
        pw.println("  [Data");
        for (Object item : this.m_data) {
            pw.println("    " + item);
        }
        pw.println("  ]");
    }
}

