/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import java.io.IOException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.secret.DBSSecretObject;
import org.jkiss.dbeaver.model.secret.DBSSecretValue;
import org.jkiss.utils.CommonUtils;

public class LocalSecretController
implements DBSSecretController {
    public static final LocalSecretController INSTANCE = new LocalSecretController();
    private final DBPPreferenceStore preferences = ModelPreferences.getPreferences();

    @Override
    @Nullable
    public String getPrivateSecretValue(@NotNull String secretId) {
        String value = this.preferences.getString(LocalSecretController.makeKey(secretId));
        if (CommonUtils.isEmpty((String)value)) {
            return null;
        }
        return value;
    }

    @Override
    public void setPrivateSecretValue(@NotNull String secretId, @Nullable String secretValue) throws DBException {
        String key = LocalSecretController.makeKey(secretId);
        if (secretValue != null) {
            this.preferences.setValue(key, secretValue);
        } else {
            this.preferences.setToDefault(key);
        }
    }

    @Override
    @NotNull
    public List<DBSSecretValue> discoverCurrentUserSecrets(@NotNull DBSSecretObject secretObject) throws DBException {
        throw new DBCFeatureNotSupportedException("Secrets discovery not supported");
    }

    @Override
    public void flushChanges() throws DBException {
        try {
            this.preferences.save();
        }
        catch (IOException e) {
            throw new DBException("Error flushing secure preferences", e);
        }
    }

    @NotNull
    private static String makeKey(@NotNull String secretId) {
        return "secrets/" + secretId;
    }
}

