/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObjectLocalized;
import org.jkiss.dbeaver.model.DBPObjectWithDescription;
import org.jkiss.dbeaver.model.DBPPersistedObject;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public abstract class DBNNode
implements DBPNamedObject,
DBPNamedObjectLocalized,
DBPObjectWithDescription,
DBPPersistedObject,
DBPAdaptable {
    static final Log log = Log.getLog(DBNNode.class);
    protected final DBNNode parentNode;

    protected DBNNode() {
        this.parentNode = null;
    }

    protected DBNNode(DBNNode parentNode) {
        this.parentNode = parentNode;
    }

    public boolean isDisposed() {
        return false;
    }

    protected void dispose(boolean reflect) {
    }

    public DBNModel getModel() {
        return this.parentNode == null ? null : this.parentNode.getModel();
    }

    @Nullable
    public DBNNode getParentNode() {
        return this.parentNode;
    }

    public boolean isLocked() {
        return this.getParentNode() != null && this.getParentNode().isLocked();
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    public boolean isManageable() {
        return false;
    }

    @NotNull
    public String getNodeId() {
        return this.getName();
    }

    @Override
    @NotNull
    public String getName() {
        return this.getNodeDisplayName();
    }

    @NotNull
    public abstract String getNodeDisplayName();

    @Override
    @NotNull
    public String getLocalizedName(@NotNull String locale) {
        return this.getName();
    }

    @NotNull
    public abstract String getNodeType();

    @NotNull
    public String getNodeTypeLabel() {
        return this.getNodeType();
    }

    @Nullable
    public String getNodeBriefInfo() {
        return null;
    }

    @Nullable
    public abstract String getNodeDescription();

    @Nullable
    public abstract DBPImage getNodeIcon();

    @Override
    @Nullable
    public String getDescription() {
        return this.getNodeDescription();
    }

    @NotNull
    public DBPImage getNodeIconDefault() {
        DBPImage image = this.getNodeIcon();
        if (image == null) {
            if (this.hasChildren(false)) {
                return DBIcon.TREE_FOLDER;
            }
            return DBIcon.TREE_PAGE;
        }
        return image;
    }

    @NotNull
    public String getNodeFullName() {
        StringBuilder pathName = new StringBuilder();
        pathName.append(this.getNodeDisplayName());
        DBNNode parent = this.getParentNode();
        while (parent != null && !(parent instanceof DBNDataSource)) {
            String parentName;
            if (!(parent instanceof DBNDatabaseFolder) && !CommonUtils.isEmpty((String)(parentName = parent.getNodeDisplayName()))) {
                pathName.insert(0, '.').insert(0, parentName);
            }
            parent = parent.getParentNode();
        }
        return pathName.toString();
    }

    @NotNull
    public String getNodeTargetName() {
        return this.getNodeDisplayName();
    }

    public boolean hasChildren(boolean navigableOnly) {
        return navigableOnly ? this.allowsNavigableChildren() : this.allowsChildren();
    }

    protected abstract boolean allowsChildren();

    protected boolean allowsNavigableChildren() {
        return this.allowsChildren();
    }

    @Nullable
    public abstract DBNNode[] getChildren(@NotNull DBRProgressMonitor var1) throws DBException;

    void clearNode(boolean reflect) {
    }

    public boolean supportsRename() {
        return false;
    }

    public void rename(@NotNull DBRProgressMonitor monitor, @NotNull String newName) throws DBException {
        throw new DBException("Rename is not supported");
    }

    public boolean supportsDrop(@Nullable DBNNode otherNode) {
        return false;
    }

    public void dropNodes(@NotNull DBRProgressMonitor monitor, @NotNull Collection<DBNNode> nodes) throws DBException {
        throw new DBException("Drop is not supported");
    }

    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        if (this.getParentNode() != null) {
            return this.getParentNode().refreshNode(monitor, source);
        }
        return null;
    }

    public boolean allowsOpen() {
        return true;
    }

    public boolean isChildOf(DBNNode node) {
        DBNNode parent = this.getParentNode();
        while (parent != null) {
            if (parent == node) {
                return true;
            }
            parent = parent.getParentNode();
        }
        return false;
    }

    public boolean isFiltered() {
        return false;
    }

    @Deprecated
    @NotNull
    public abstract String getNodeItemPath();

    @NotNull
    public final String getNodeUri() {
        StringBuilder pathBuilder = new StringBuilder();
        DBNNode currentNode = this;
        while (currentNode != null && !(currentNode instanceof DBNRoot)) {
            if (!pathBuilder.isEmpty()) {
                pathBuilder.insert(0, '/');
            }
            String nodeId = DBNUtils.encodeNodePath(currentNode.getNodeId());
            pathBuilder.insert(0, nodeId);
            if (currentNode instanceof DBNLocalFolder) {
                DBNLocalFolder folder = (DBNLocalFolder)currentNode;
                currentNode = folder.getLogicalParent();
                continue;
            }
            currentNode = currentNode.getParentNode();
        }
        return NodePathType.node.getPrefix() + String.valueOf(pathBuilder);
    }

    @Override
    public <T> T getAdapter(@NotNull Class<T> adapter) {
        return null;
    }

    @Nullable
    public DBPProject getOwnerProjectOrNull() {
        DBNNode node = this.getParentNode();
        while (node != null) {
            if (node instanceof DBNProject) {
                return ((DBNProject)node).getProject();
            }
            node = node.getParentNode();
        }
        return null;
    }

    @NotNull
    public DBPProject getOwnerProject() {
        DBPProject project = this.getOwnerProjectOrNull();
        if (project == null) {
            throw new IllegalStateException("Node doesn't have owner project");
        }
        return project;
    }

    @Nullable
    public Throwable getLastLoadError() {
        return null;
    }

    static void sortNodes(@NotNull List<? extends DBNNode> nodes) {
        nodes.sort((o1, o2) -> {
            boolean isFolder1 = o1 instanceof DBNLocalFolder;
            boolean isFolder2 = o2 instanceof DBNLocalFolder;
            if (isFolder1 && !isFolder2) {
                return -1;
            }
            if (!isFolder1 && isFolder2) {
                return 1;
            }
            String odn1 = o1.getNodeDisplayName();
            String odn2 = o2.getNodeDisplayName();
            return CommonUtils.notEmpty((String)odn1).compareToIgnoreCase(CommonUtils.notEmpty((String)odn2));
        });
    }

    protected void fireNodeEvent(DBNEvent event) {
        this.getModel().fireNodeEvent(event);
    }

    public static Class<? extends DBSObject> getFolderChildrenClass(DBXTreeFolder meta) {
        String itemsType = CommonUtils.toString((Object)meta.getType());
        if (CommonUtils.isEmpty((String)itemsType)) {
            return null;
        }
        Class<DBSObject> aClass = meta.getSource().getObjectClass(itemsType, DBSObject.class);
        if (aClass == null) {
            log.error("Items class '" + itemsType + "' not found");
            return null;
        }
        if (!DBSObject.class.isAssignableFrom(aClass)) {
            log.error("Class '" + aClass.getName() + "' doesn't extend DBSObject");
            return null;
        }
        return aClass;
    }

    public static boolean nodeHasStructureContainers(@NotNull DBNNode node, @NotNull DBXTreeNode meta) {
        List<DBXTreeNode> children = meta.getChildren(node);
        if (!CommonUtils.isEmpty(children)) {
            for (DBXTreeNode child : children) {
                Class<? extends DBSObject> childrenClass;
                if (!(child instanceof DBXTreeFolder) || (childrenClass = DBNNode.getFolderChildrenClass((DBXTreeFolder)child)) == null || !DBSObjectContainer.class.isAssignableFrom(childrenClass)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String toString() {
        return this.getNodeUri();
    }

    public static enum NodePathType {
        resource,
        dbvfs,
        folder,
        database,
        ext,
        other,
        node;


        public String getPrefix() {
            return this.name() + "://";
        }
    }
}

