/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.conditions.ViolatedAndSatisfiedConditionEvents;
import com.tngtech.archunit.thirdparty.com.google.common.base.MoreObjects;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class JoinCondition<T>
extends ArchCondition<T> {
    private final Collection<ArchCondition<T>> conditions;

    JoinCondition(String infix, Collection<ArchCondition<T>> conditions) {
        super(JoinCondition.joinDescriptionsOf(infix, conditions), new Object[0]);
        this.conditions = conditions;
    }

    private static <T> String joinDescriptionsOf(String infix, Collection<ArchCondition<T>> conditions) {
        return conditions.stream().map(ArchCondition::getDescription).collect(Collectors.joining(" " + infix + " "));
    }

    @Override
    public void init(Collection<T> allObjectsToTest) {
        for (ArchCondition<T> condition : this.conditions) {
            condition.init(allObjectsToTest);
        }
    }

    @Override
    public void finish(ConditionEvents events) {
        for (ArchCondition<T> condition : this.conditions) {
            condition.finish(events);
        }
    }

    List<ConditionWithEvents<T>> evaluateConditions(T item) {
        return this.conditions.stream().map(condition -> new ConditionWithEvents<Object>((ArchCondition<Object>)condition, item)).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.conditions + "}";
    }

    static class ConditionWithEvents<T> {
        private final ArchCondition<T> condition;
        private final ViolatedAndSatisfiedConditionEvents events;

        ConditionWithEvents(ArchCondition<T> condition, T item) {
            this(condition, ConditionWithEvents.check(condition, item));
        }

        ConditionWithEvents(ArchCondition<T> condition, ViolatedAndSatisfiedConditionEvents events) {
            this.condition = condition;
            this.events = events;
        }

        public ConditionEvents getEvents() {
            return this.events;
        }

        private static <T> ViolatedAndSatisfiedConditionEvents check(ArchCondition<T> condition, T item) {
            ViolatedAndSatisfiedConditionEvents events = new ViolatedAndSatisfiedConditionEvents();
            condition.check(item, events);
            return events;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("condition", this.condition).add("events", this.events).toString();
        }
    }

    static abstract class JoinConditionEvent<T>
    implements ConditionEvent {
        final T correspondingObject;
        final List<ConditionWithEvents<T>> evaluatedConditions;

        JoinConditionEvent(T correspondingObject, List<ConditionWithEvents<T>> evaluatedConditions) {
            this.correspondingObject = correspondingObject;
            this.evaluatedConditions = evaluatedConditions;
        }

        List<String> getUniqueLinesOfViolations() {
            TreeSet<String> result = new TreeSet<String>();
            for (ConditionWithEvents<T> evaluation : this.evaluatedConditions) {
                for (ConditionEvent event : ((ConditionWithEvents)evaluation).events.getViolating()) {
                    result.addAll(event.getDescriptionLines());
                }
            }
            return ImmutableList.copyOf(result);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("evaluatedConditions", this.evaluatedConditions).toString();
        }

        List<ConditionWithEvents<T>> invert(List<ConditionWithEvents<T>> evaluatedConditions) {
            return evaluatedConditions.stream().map(this::invert).collect(Collectors.toList());
        }

        private ConditionWithEvents<T> invert(ConditionWithEvents<T> evaluation) {
            ViolatedAndSatisfiedConditionEvents invertedEvents = new ViolatedAndSatisfiedConditionEvents();
            Stream.concat(((ConditionWithEvents)evaluation).events.getAllowed().stream(), ((ConditionWithEvents)evaluation).events.getViolating().stream()).forEach(event -> invertedEvents.add(event.invert()));
            return new ConditionWithEvents(((ConditionWithEvents)evaluation).condition, invertedEvents);
        }
    }
}

