/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.function.Supplier;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class LinkOpener
extends MouseAdapter
implements MouseMotionListener {
    private final Supplier<NodeModel> nodeSupplier;

    public LinkOpener(Supplier<NodeModel> nodeSupplier) {
        this.nodeSupplier = nodeSupplier;
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        int requiredCursor;
        JTextComponent textComponent = (JTextComponent)ev.getComponent();
        Document document = textComponent.getDocument();
        if (!(document instanceof HTMLDocument) || this.nodeSupplier.get() == null) {
            return;
        }
        String link = HtmlUtils.getURLOfExistingLink((HTMLDocument)document, textComponent.viewToModel(ev.getPoint()));
        boolean followLink = link != null;
        Controller currentController = Controller.getCurrentController();
        if (followLink) {
            currentController.getViewController().out(link);
            requiredCursor = 12;
        } else {
            requiredCursor = 0;
        }
        if (textComponent.getCursor().getType() != requiredCursor) {
            textComponent.setCursor(requiredCursor != 0 ? new Cursor(requiredCursor) : null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        if (Compat.isPlainEvent(ev)) {
            JTextComponent textComponent = (JTextComponent)ev.getComponent();
            Document document = textComponent.getDocument();
            if (!(document instanceof HTMLDocument) || this.nodeSupplier.get() == null) {
                return;
            }
            String linkURL = HtmlUtils.getURLOfExistingLink((HTMLDocument)document, textComponent.viewToModel(ev.getPoint()));
            if (linkURL != null) {
                try {
                    NodeModel node = this.nodeSupplier.get();
                    LinkController.getController().loadURI(node, LinkController.createHyperlink(linkURL));
                }
                catch (Exception e) {
                    LogUtils.warn(e);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }
}

