/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.formula;

import java.net.URL;
import java.util.Hashtable;
import java.util.Objects;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.text.IContentTransformer;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.ConditionalContentTransformer;
import org.freeplane.main.application.CommandLineOptions;
import org.freeplane.main.osgi.IModeControllerExtensionProvider;
import org.freeplane.plugin.formula.EvaluateAllAction;
import org.freeplane.plugin.formula.FormulaTextTransformer;
import org.freeplane.plugin.formula.FormulaUpdateChangeListener;
import org.freeplane.plugin.formula.dependencies.ActionFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String FORMULA_DISABLE_PLUGIN = "formula_disable_plugin";
    private static final String FORMULA_DISABLE_CACHING = "formula_disable_caching";
    private static final String MENU_BAR_PARENT_LOCATION = "/menu_bar/extras/first";
    static final String MENU_BAR_LOCATION = "/menu_bar/extras/first/formula";
    private static final String TOGGLE_PARSE_FORMULAS = "parse_formulas";

    public void start(BundleContext context) throws Exception {
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        props.put("mode", new String[]{"MindMap"});
        context.registerService(IModeControllerExtensionProvider.class.getName(), (Object)new FormulaPluginRegistration(), props);
    }

    public void stop(BundleContext context) throws Exception {
    }

    private final class FormulaPluginRegistration
    implements IModeControllerExtensionProvider {
        private static final String PREFERENCES_RESOURCE = "preferences.xml";

        private FormulaPluginRegistration() {
        }

        public void installExtension(ModeController modeController, CommandLineOptions options) {
            this.addPluginDefaults();
            this.addPreferencesToOptionPanel();
            boolean disablePluginProperty = ResourceController.getResourceController().getBooleanProperty(Activator.FORMULA_DISABLE_PLUGIN);
            EvaluateAllAction evaluateAllAction = new EvaluateAllAction();
            modeController.addAction((AFreeplaneAction)evaluateAllAction);
            ActionFactory.createActions(modeController);
            if (!disablePluginProperty) {
                TextController textController = TextController.getController((ModeController)modeController);
                textController.addTextTransformer((IContentTransformer)new ConditionalContentTransformer((IContentTransformer)new FormulaTextTransformer(1), Activator.TOGGLE_PARSE_FORMULAS));
                FormulaUpdateChangeListener listener = new FormulaUpdateChangeListener();
                MapController mapController = modeController.getMapController();
                mapController.addNodeChangeListener((INodeChangeListener)listener);
                mapController.addMapChangeListener((IMapChangeListener)listener);
                mapController.addMapLifeCycleListener((IMapLifeCycleListener)listener);
                boolean disableCacheProperty = ResourceController.getResourceController().getBooleanProperty(Activator.FORMULA_DISABLE_CACHING);
                if (disableCacheProperty) {
                    System.err.println("Formula cache disabled. This might severely impair performance when using formulas.");
                }
            } else {
                System.out.println("Formula plugin is disabled");
                evaluateAllAction.setEnabled(false);
            }
        }

        private void addPreferencesToOptionPanel() {
            URL preferences = this.getClass().getResource(PREFERENCES_RESOURCE);
            if (preferences == null) {
                throw new RuntimeException("cannot open preferences");
            }
            Controller controller = Controller.getCurrentController();
            MModeController modeController = (MModeController)controller.getModeController();
            modeController.getOptionPanelBuilder().load(preferences);
        }

        private void addPluginDefaults() {
            URL defaults = this.getClass().getResource("defaults.properties");
            Objects.requireNonNull(defaults);
            Controller.getCurrentController().getResourceController().addDefaults(defaults);
        }
    }
}

