/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.compiler;

import com.google.gson.Gson;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import groovy.lang.GroovyObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.tooling.ProjectConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.slf4j.Logger;

public final class GradleBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    public static final com.intellij.openapi.diagnostic.Logger LOG = com.intellij.openapi.diagnostic.Logger.getInstance(GradleBuildProcessParametersProvider.class);
    @NotNull
    private final Project myProject;
    private List<String> myGradleClasspath;

    public GradleBuildProcessParametersProvider(@NotNull Project project) {
        if (project == null) {
            GradleBuildProcessParametersProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public List<String> getClassPath() {
        ArrayList<String> result = new ArrayList<String>();
        if (!GradleSettings.getInstance((Project)this.myProject).getLinkedProjectsSettings().isEmpty()) {
            this.addGradleClassPath(result);
            GradleBuildProcessParametersProvider.addOtherClassPath(result);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            GradleBuildProcessParametersProvider.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private void addGradleClassPath(@NotNull List<String> classpath) {
        if (classpath == null) {
            GradleBuildProcessParametersProvider.$$$reportNull$$$0(2);
        }
        if (this.myGradleClasspath == null) {
            String gradleToolingApiImplDepJarPath;
            this.myGradleClasspath = new ArrayList<String>();
            String gradleToolingApiJarPath = PathUtil.getJarPathForClass(ProjectConnection.class);
            if (!StringUtil.isEmpty((String)gradleToolingApiJarPath)) {
                this.myGradleClasspath.add(gradleToolingApiJarPath);
            }
            if (!StringUtil.isEmpty((String)(gradleToolingApiImplDepJarPath = PathUtil.getJarPathForClass(Optional.class)))) {
                this.myGradleClasspath.add(gradleToolingApiImplDepJarPath);
            }
        }
        classpath.addAll(this.myGradleClasspath);
    }

    private static void addOtherClassPath(@NotNull List<String> classpath) {
        if (classpath == null) {
            GradleBuildProcessParametersProvider.$$$reportNull$$$0(3);
        }
        classpath.add(GradleBuildProcessParametersProvider.locateAntLibraries());
        classpath.add(PathUtil.getJarPathForClass(GroovyObject.class));
        classpath.add(PathUtil.getJarPathForClass(Gson.class));
        classpath.add(PathUtil.getJarPathForClass(Logger.class));
    }

    @NotNull
    private static String locateAntLibraries() {
        Path gradleJar = PathManager.getJarForClass(GradleConstants.class);
        if (gradleJar != null) {
            String string;
            Path pathToAnt = gradleJar.resolveSibling("ant").resolve("ant.jar");
            if (pathToAnt.toFile().isFile()) {
                String string2 = pathToAnt.toString();
                if (string2 == null) {
                    GradleBuildProcessParametersProvider.$$$reportNull$$$0(4);
                }
                return string2;
            }
            try {
                string = PathUtil.getJarPathForClass(Class.forName("org.apache.tools.ant.taskdefs.Ant"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (string == null) {
                GradleBuildProcessParametersProvider.$$$reportNull$$$0(5);
            }
            return string;
        }
        LOG.warn("Unable to locate ant.jar for build process classpath");
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/compiler/GradleBuildProcessParametersProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classpath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/compiler/GradleBuildProcessParametersProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "locateAntLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addGradleClassPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addOtherClassPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5 -> new IllegalStateException(string);
        };
    }
}

