/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.InlineSingleBlockHelper;
import org.jetbrains.java.decompiler.modules.decompiler.MergeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SynchronizedStatement;

public final class LabelHelper {
    public static void cleanUpEdges(RootStatement root) {
        LabelHelper.resetAllEdges(root);
        LabelHelper.removeNonImmediateEdges(root);
        LabelHelper.liftClosures(root);
        LabelHelper.lowContinueLabels(root, new LinkedHashSet<StatEdge>());
        LabelHelper.lowClosures(root);
    }

    public static void identifyLabels(RootStatement root) {
        LabelHelper.setExplicitEdges(root);
        LabelHelper.hideDefaultSwitchEdges(root);
        LabelHelper.processStatementLabel(root);
        LabelHelper.setRetEdgesUnlabeled(root);
    }

    private static void liftClosures(Statement stat) {
        block0: for (StatEdge edge : stat.getAllSuccessorEdges()) {
            if (StatEdge.EdgeType.CONTINUE.equals(edge.getType())) {
                if (edge.getDestination() == edge.closure) continue;
                edge.getDestination().addLabeledEdge(edge);
                continue;
            }
            if (!StatEdge.EdgeType.BREAK.equals(edge.getType())) continue;
            Statement dest = edge.getDestination();
            if (dest.type == Statement.StatementType.DUMMY_EXIT) continue;
            Statement parent = dest.getParent();
            ArrayList<Statement> lst = new ArrayList<Statement>();
            if (parent.type == Statement.StatementType.SEQUENCE) {
                lst.addAll(parent.getStats());
            } else if (parent.type == Statement.StatementType.SWITCH) {
                lst.addAll(((SwitchStatement)parent).getCaseStatements());
            }
            for (int i = 0; i < lst.size(); ++i) {
                if (lst.get(i) != dest) continue;
                ((Statement)lst.get(i - 1)).addLabeledEdge(edge);
                continue block0;
            }
        }
        for (Statement st : stat.getStats()) {
            LabelHelper.liftClosures(st);
        }
    }

    private static void removeNonImmediateEdges(Statement stat) {
        for (Statement st : stat.getStats()) {
            LabelHelper.removeNonImmediateEdges(st);
        }
        if (!stat.hasBasicSuccEdge()) {
            for (StatEdge edge : stat.getSuccessorEdges(StatEdge.EdgeType.CONTINUE.unite(StatEdge.EdgeType.BREAK))) {
                stat.removeSuccessor(edge);
            }
        }
    }

    public static void lowContinueLabels(Statement stat, HashSet<StatEdge> edges) {
        boolean ok;
        boolean bl = ok = stat.type != Statement.StatementType.DO;
        if (!ok) {
            DoStatement dostat = (DoStatement)stat;
            boolean bl2 = ok = dostat.getLoopType() == DoStatement.LoopType.DO || dostat.getLoopType() == DoStatement.LoopType.WHILE || dostat.getLoopType() == DoStatement.LoopType.FOR && dostat.getIncExprent() == null;
        }
        if (ok) {
            edges.addAll(stat.getPredecessorEdges(StatEdge.EdgeType.CONTINUE));
        }
        if (ok && stat.type == Statement.StatementType.DO) {
            for (StatEdge edge : edges) {
                if (!stat.containsStatementStrict(edge.getSource())) continue;
                edge.getDestination().removePredecessor(edge);
                edge.getSource().changeEdgeNode(StatEdge.EdgeDirection.FORWARD, edge, stat);
                stat.addPredecessor(edge);
                stat.addLabeledEdge(edge);
            }
        }
        for (Statement st : stat.getStats()) {
            if (st == stat.getFirst()) {
                LabelHelper.lowContinueLabels(st, edges);
                continue;
            }
            LabelHelper.lowContinueLabels(st, new LinkedHashSet<StatEdge>());
        }
    }

    public static void lowClosures(Statement stat) {
        for (StatEdge edge : new ArrayList<StatEdge>(stat.getLabelEdges())) {
            if (edge.getType() != StatEdge.EdgeType.BREAK) continue;
            for (Statement st : stat.getStats()) {
                if (!st.containsStatementStrict(edge.getSource()) || !MergeHelper.isDirectPath(st, edge.getDestination())) continue;
                st.addLabeledEdge(edge);
            }
        }
        for (Statement st : stat.getStats()) {
            LabelHelper.lowClosures(st);
        }
    }

    private static void resetAllEdges(Statement stat) {
        for (Statement st : stat.getStats()) {
            LabelHelper.resetAllEdges(st);
        }
        for (StatEdge edge : stat.getAllSuccessorEdges()) {
            edge.explicit = true;
            edge.labeled = true;
        }
    }

    private static void setRetEdgesUnlabeled(RootStatement root) {
        DummyExitStatement exit = root.getDummyExit();
        for (StatEdge edge : exit.getAllPredecessorEdges()) {
            List<Exprent> lst = edge.getSource().getExprents();
            if (edge.getType() != StatEdge.EdgeType.FINALLY_EXIT && (lst == null || lst.isEmpty() || lst.get((int)(lst.size() - 1)).type != 4)) continue;
            edge.labeled = false;
        }
    }

    private static HashMap<Statement, List<StatEdge>> setExplicitEdges(Statement stat) {
        HashMap<Statement, List<StatEdge>> mapEdges = new HashMap<Statement, List<StatEdge>>();
        if (stat.getExprents() != null) {
            return mapEdges;
        }
        switch (stat.type) {
            case TRY_CATCH: 
            case CATCH_ALL: {
                for (Statement st : stat.getStats()) {
                    HashMap<Statement, List<StatEdge>> mapEdges1 = LabelHelper.setExplicitEdges(st);
                    LabelHelper.processEdgesWithNext(st, mapEdges1, null);
                    if (stat.type != Statement.StatementType.TRY_CATCH && st != stat.getFirst() || mapEdges1 == null) continue;
                    for (Map.Entry<Statement, List<StatEdge>> entr : mapEdges1.entrySet()) {
                        if (mapEdges.containsKey(entr.getKey())) {
                            mapEdges.get(entr.getKey()).addAll((Collection<StatEdge>)entr.getValue());
                            continue;
                        }
                        mapEdges.put(entr.getKey(), entr.getValue());
                    }
                }
                break;
            }
            case DO: {
                mapEdges = LabelHelper.setExplicitEdges(stat.getFirst());
                LabelHelper.processEdgesWithNext(stat.getFirst(), mapEdges, stat);
                break;
            }
            case IF: {
                IfStatement ifstat = (IfStatement)stat;
                if (ifstat.getIfstat() == null) {
                    LabelHelper.processEdgesWithNext(ifstat.getFirst(), mapEdges, null);
                    break;
                }
                mapEdges = LabelHelper.setExplicitEdges(ifstat.getIfstat());
                LabelHelper.processEdgesWithNext(ifstat.getIfstat(), mapEdges, null);
                HashMap<Statement, List<StatEdge>> mapEdges1 = null;
                if (ifstat.getElsestat() != null) {
                    mapEdges1 = LabelHelper.setExplicitEdges(ifstat.getElsestat());
                    LabelHelper.processEdgesWithNext(ifstat.getElsestat(), mapEdges1, null);
                }
                if (mapEdges1 == null) break;
                for (Map.Entry<Statement, List<StatEdge>> entr : mapEdges1.entrySet()) {
                    if (mapEdges.containsKey(entr.getKey())) {
                        mapEdges.get(entr.getKey()).addAll((Collection<StatEdge>)entr.getValue());
                        continue;
                    }
                    mapEdges.put(entr.getKey(), entr.getValue());
                }
                break;
            }
            case ROOT: {
                mapEdges = LabelHelper.setExplicitEdges(stat.getFirst());
                LabelHelper.processEdgesWithNext(stat.getFirst(), mapEdges, ((RootStatement)stat).getDummyExit());
                break;
            }
            case SEQUENCE: {
                Statement st;
                int index;
                for (index = 0; index < stat.getStats().size() - 1; ++index) {
                    st = (Statement)stat.getStats().get(index);
                    LabelHelper.processEdgesWithNext(st, LabelHelper.setExplicitEdges(st), (Statement)stat.getStats().get(index + 1));
                }
                st = (Statement)stat.getStats().get(index);
                mapEdges = LabelHelper.setExplicitEdges(st);
                LabelHelper.processEdgesWithNext(st, mapEdges, null);
                break;
            }
            case SWITCH: {
                SwitchStatement swst = (SwitchStatement)stat;
                for (int i = 0; i < swst.getCaseStatements().size() - 1; ++i) {
                    Statement stt = swst.getCaseStatements().get(i);
                    Statement stnext = swst.getCaseStatements().get(i + 1);
                    if (stnext.getExprents() != null && stnext.getExprents().isEmpty()) {
                        stnext = stnext.getAllSuccessorEdges().get(0).getDestination();
                    }
                    LabelHelper.processEdgesWithNext(stt, LabelHelper.setExplicitEdges(stt), stnext);
                }
                int last = swst.getCaseStatements().size() - 1;
                if (last < 0) break;
                Statement stlast = swst.getCaseStatements().get(last);
                if (stlast.getExprents() != null && stlast.getExprents().isEmpty()) {
                    StatEdge edge = stlast.getAllSuccessorEdges().get(0);
                    mapEdges.put(edge.getDestination(), new ArrayList<StatEdge>(Collections.singletonList(edge)));
                    break;
                }
                mapEdges = LabelHelper.setExplicitEdges(stlast);
                LabelHelper.processEdgesWithNext(stlast, mapEdges, null);
                break;
            }
            case SYNCHRONIZED: {
                SynchronizedStatement synstat = (SynchronizedStatement)stat;
                LabelHelper.processEdgesWithNext(synstat.getFirst(), LabelHelper.setExplicitEdges(stat.getFirst()), synstat.getBody());
                mapEdges = LabelHelper.setExplicitEdges(synstat.getBody());
                LabelHelper.processEdgesWithNext(synstat.getBody(), mapEdges, null);
            }
        }
        return mapEdges;
    }

    /*
     * WARNING - void declaration
     */
    private static void processEdgesWithNext(Statement stat, HashMap<Statement, List<StatEdge>> mapEdges, Statement next) {
        StatEdge statedge = null;
        List<StatEdge> lstSuccs = stat.getAllSuccessorEdges();
        if (!lstSuccs.isEmpty()) {
            statedge = lstSuccs.get(0);
            if (statedge.getDestination() == next) {
                statedge.explicit = false;
                statedge = null;
            } else {
                next = statedge.getDestination();
            }
        }
        if (stat.type == Statement.StatementType.DO && ((DoStatement)stat).getLoopType() == DoStatement.LoopType.DO) {
            next = null;
        }
        if (next == null) {
            List<StatEdge> lstEdges;
            if (mapEdges.size() == 1 && (lstEdges = mapEdges.values().iterator().next()).size() > 1 && mapEdges.keySet().iterator().next().type != Statement.StatementType.DUMMY_EXIT) {
                StatEdge edge_example = lstEdges.get(0);
                Statement closure = stat.getParent();
                if (!closure.containsStatementStrict(edge_example.closure)) {
                    closure = edge_example.closure;
                }
                StatEdge statEdge = new StatEdge(edge_example.getType(), stat, edge_example.getDestination(), closure);
                stat.addSuccessor(statEdge);
                for (StatEdge edge : lstEdges) {
                    edge.explicit = false;
                }
                mapEdges.put(statEdge.getDestination(), new ArrayList<StatEdge>(Collections.singletonList(statEdge)));
            }
        } else {
            boolean implfound = false;
            for (Map.Entry<Statement, List<StatEdge>> entr : mapEdges.entrySet()) {
                if (entr.getKey() != next) continue;
                for (StatEdge edge : entr.getValue()) {
                    edge.explicit = false;
                }
                implfound = true;
                break;
            }
            if (stat.getAllSuccessorEdges().isEmpty() && !implfound) {
                List lstEdges = null;
                for (Map.Entry entry : mapEdges.entrySet()) {
                    if (((Statement)entry.getKey()).type == Statement.StatementType.DUMMY_EXIT || lstEdges != null && ((List)entry.getValue()).size() <= lstEdges.size()) continue;
                    lstEdges = (List)entry.getValue();
                }
                if (lstEdges != null && lstEdges.size() > 1) {
                    void var8_17;
                    StatEdge edge_example = (StatEdge)lstEdges.get(0);
                    Statement statement = stat.getParent();
                    if (!statement.containsStatementStrict(edge_example.closure)) {
                        Statement statement2 = edge_example.closure;
                    }
                    StatEdge newedge = new StatEdge(edge_example.getType(), stat, edge_example.getDestination(), (Statement)var8_17);
                    stat.addSuccessor(newedge);
                    for (StatEdge edge : lstEdges) {
                        edge.explicit = false;
                    }
                }
            }
            mapEdges.clear();
        }
        if (statedge != null) {
            mapEdges.put(statedge.getDestination(), new ArrayList<StatEdge>(Collections.singletonList(statedge)));
        }
    }

    private static void hideDefaultSwitchEdges(Statement stat) {
        Statement stlast;
        SwitchStatement swst;
        int last;
        if (stat.type == Statement.StatementType.SWITCH && (last = (swst = (SwitchStatement)stat).getCaseStatements().size() - 1) >= 0 && (stlast = swst.getCaseStatements().get(last)).getExprents() != null && stlast.getExprents().isEmpty() && !stlast.getAllSuccessorEdges().get((int)0).explicit) {
            List<StatEdge> lstEdges = swst.getCaseEdges().get(last);
            lstEdges.remove(swst.getDefaultEdge());
            if (lstEdges.isEmpty()) {
                swst.getCaseStatements().remove(last);
                swst.getCaseEdges().remove(last);
            }
        }
        for (Statement st : stat.getStats()) {
            LabelHelper.hideDefaultSwitchEdges(st);
        }
    }

    private static LabelSets processStatementLabel(Statement stat) {
        LabelSets sets = new LabelSets();
        if (stat.getExprents() == null) {
            boolean shieldType;
            for (Statement st : stat.getStats()) {
                LabelSets nested = LabelHelper.processStatementLabel(st);
                sets.breaks.addAll(nested.breaks);
                sets.continues.addAll(nested.continues);
            }
            boolean bl = shieldType = stat.type == Statement.StatementType.DO || stat.type == Statement.StatementType.SWITCH;
            if (shieldType) {
                for (StatEdge edge : stat.getLabelEdges()) {
                    if (!edge.explicit || (edge.getType() != StatEdge.EdgeType.BREAK || !sets.breaks.contains(edge.getSource())) && (edge.getType() != StatEdge.EdgeType.CONTINUE || !sets.continues.contains(edge.getSource()))) continue;
                    edge.labeled = false;
                }
            }
            switch (stat.type) {
                case DO: {
                    sets.continues.clear();
                }
                case SWITCH: {
                    sets.breaks.clear();
                }
            }
        }
        sets.breaks.add(stat);
        sets.continues.add(stat);
        return sets;
    }

    public static void replaceContinueWithBreak(Statement stat) {
        if (stat.type == Statement.StatementType.DO) {
            List<StatEdge> lst = stat.getPredecessorEdges(StatEdge.EdgeType.CONTINUE);
            for (StatEdge edge : lst) {
                Statement minclosure;
                if (!edge.explicit || (minclosure = LabelHelper.getMinContinueClosure(edge)) == edge.closure || InlineSingleBlockHelper.isBreakEdgeLabeled(edge.getSource(), minclosure)) continue;
                edge.getSource().changeEdgeType(StatEdge.EdgeDirection.FORWARD, edge, StatEdge.EdgeType.BREAK);
                edge.labeled = false;
                minclosure.addLabeledEdge(edge);
            }
        }
        for (Statement st : stat.getStats()) {
            LabelHelper.replaceContinueWithBreak(st);
        }
    }

    private static Statement getMinContinueClosure(StatEdge edge) {
        boolean found;
        Statement closure = edge.closure;
        block0: do {
            found = false;
            for (Statement st : closure.getStats()) {
                if (!st.containsStatementStrict(edge.getSource()) || !MergeHelper.isDirectPath(st, edge.getDestination())) continue;
                closure = st;
                found = true;
                continue block0;
            }
        } while (found);
        return closure;
    }

    private static class LabelSets {
        private final Set<Statement> breaks = new HashSet<Statement>();
        private final Set<Statement> continues = new HashSet<Statement>();

        private LabelSets() {
        }
    }
}

