/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonIrAttributesKt;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmCachedDeclarations;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmDefaultUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmDefaultParameterInjector;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@PhaseDescription(name="Interface", prerequisite={JvmDefaultParameterInjector.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u0010*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0014\u0010\u001e\u001a\u00020\u0010*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020 2\u0006\u0010!\u001a\u00020&H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "removedFunctions", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lkotlin/collections/HashMap;", "removedFunctionsWithoutRemapping", "", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "handleInterface", "createJvmDefaultCompatibilityDelegate", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "handleAnnotationClass", "createDefaultImpl", "forCompatibility", "", "bridgeToStatic", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "callTarget", "bridgeViaAccessorTo", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nInterfaceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterfaceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InterfaceLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,302:1\n808#2,11:303\n1878#2,3:314\n1634#2,3:319\n1878#2,3:323\n1634#2,3:328\n406#3,2:317\n408#3:322\n406#3,2:326\n408#3:331\n*S KotlinDebug\n*F\n+ 1 InterfaceLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InterfaceLowering\n*L\n190#1:303,11\n231#1:314,3\n235#1:319,3\n251#1:323,3\n255#1:328,3\n235#1:317,2\n235#1:322\n255#1:326,2\n255#1:331\n*E\n"})
public final class InterfaceLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final HashMap<IrSimpleFunctionSymbol, IrSimpleFunctionSymbol> removedFunctions;
    @NotNull
    private final Set<IrSimpleFunctionSymbol> removedFunctionsWithoutRemapping;

    public InterfaceLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.removedFunctions = new HashMap();
        this.removedFunctionsWithoutRemapping = new LinkedHashSet();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (!JvmIrUtilsKt.isJvmInterface(irClass)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[irClass.getKind().ordinal()]) {
            case 1: {
                this.handleInterface(irClass);
                break;
            }
            case 2: {
                this.handleAnnotationClass(irClass);
                break;
            }
            default: {
                return;
            }
        }
        CollectionsKt.removeAll((List)irClass.getDeclarations(), arg_0 -> InterfaceLowering.lower$lambda$0(this, arg_0));
        IrClass defaultImplsIrClass = this.context.getCachedDeclarations().getDefaultImplsClass(irClass);
        if (!((Collection)defaultImplsIrClass.getDeclarations()).isEmpty()) {
            irClass.getDeclarations().add(defaultImplsIrClass);
        }
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irClass), (IrElementTransformerVoid)this);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInterface(IrClass irClass) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable superImpl;
        JvmDefaultMode jvmDefaultMode = this.context.getConfig().getJvmDefaultMode();
        boolean isCompatibilityMode = jvmDefaultMode == JvmDefaultMode.ENABLE && !IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)irClass), (FqName)JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_WITHOUT_COMPATIBILITY_FQ_NAME()) || jvmDefaultMode == JvmDefaultMode.NO_COMPATIBILITY && IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)irClass), (FqName)JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME());
        for (IrSimpleFunction function2 : IrUtilsKt.getFunctions((IrClass)irClass)) {
            DescriptorVisibility visibility;
            DescriptorVisibility descriptorVisibility;
            IrSimpleFunction defaultImpl;
            if (function2.getModality() == Modality.ABSTRACT) continue;
            if (function2.isFakeOverride()) {
                String string = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                if (StringsKt.endsWith$default((String)string, (String)"$default", (boolean)false, (int)2, null)) continue;
                IrSimpleFunction implementation2 = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverrideOrFail((IrOverridableDeclaration)((IrOverridableDeclaration)function2));
                if (DescriptorVisibilities.isPrivate(implementation2.getVisibility()) || IrUtilsKt.isMethodOfAny((IrFunction)((IrFunction)implementation2))) continue;
                if (!JvmDefaultUtilsKt.isDefinitelyNotDefaultImplsMethod(function2, jvmDefaultMode, implementation2)) {
                    IrSimpleFunction irSimpleFunction;
                    IrSimpleFunction defaultImpl2 = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
                    superImpl = JvmIrUtilsKt.firstSuperMethodFromKotlin(function2, implementation2);
                    IrSimpleFunction it = irSimpleFunction = JvmCachedDeclarations.getDefaultImplsFunction$default(this.context.getCachedDeclarations(), (IrSimpleFunction)superImpl.getOwner(), false, 2, null);
                    boolean bl = false;
                    this.bridgeToStatic((IrFunction)defaultImpl2, it);
                    continue;
                }
                if (!isCompatibilityMode || !JvmDefaultUtilsKt.isCompiledToJvmDefault(implementation2, jvmDefaultMode)) continue;
                this.createJvmDefaultCompatibilityDelegate(function2);
                continue;
            }
            if (!JvmDefaultUtilsKt.isCompiledToJvmDefault(function2, jvmDefaultMode) && (DescriptorVisibilities.isPrivate(function2.getVisibility()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_METHOD_FOR_PROPERTY_OR_TYPEALIAS_ANNOTATIONS())) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_METHOD_FOR_PROPERTY_OR_TYPEALIAS_ANNOTATIONS()) && isCompatibilityMode && JvmDefaultUtilsKt.isCompiledToJvmDefault(function2, jvmDefaultMode)) {
                if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getINLINE_LAMBDA())) {
                    IrClass defaultImplsClass = this.context.getCachedDeclarations().getDefaultImplsClass(irClass);
                    defaultImplsClass.getDeclarations().add(function2);
                    this.removedFunctionsWithoutRemapping.add(function2.getSymbol());
                    function2.setParent((IrDeclarationParent)defaultImplsClass);
                    continue;
                }
                defaultImpl = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
                defaultImpl.setBody(IrInlineUtilsKt.moveBodyTo((IrFunction)((IrFunction)function2), (IrFunction)((IrFunction)defaultImpl)));
                ((Map)this.removedFunctions).put(function2.getSymbol(), defaultImpl.getSymbol());
                continue;
            }
            if (!JvmDefaultUtilsKt.isCompiledToJvmDefault(function2, jvmDefaultMode)) {
                defaultImpl = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
                defaultImpl.setBody(IrInlineUtilsKt.moveBodyTo((IrFunction)((IrFunction)function2), (IrFunction)((IrFunction)defaultImpl)));
                function2.setBody(null);
                continue;
            }
            if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER())) {
                IrFunction irFunction = CommonIrAttributesKt.getDefaultArgumentsOriginalFunction((IrFunction)((IrFunction)function2));
                Intrinsics.checkNotNull((Object)irFunction);
                descriptorVisibility = irFunction.getVisibility();
            } else {
                descriptorVisibility = visibility = function2.getVisibility();
            }
            if (!DescriptorVisibilities.isPrivate(visibility)) {
                if (!isCompatibilityMode) continue;
                this.createJvmDefaultCompatibilityDelegate(function2);
                continue;
            }
            if (this.context.getConfig().getTarget() != JvmTarget.JVM_1_8 || this.context.getState().getClassBuilderMode().generateBodies) continue;
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
            function2.setVisibility(descriptorVisibility2);
        }
        IrClass defaultImplsIrClass = this.context.getCachedDeclarations().getDefaultImplsClass(irClass);
        Iterable $this$filterIsInstance$iv = irClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        superImpl = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (IrField field : (List)destination$iv$iv) {
            if ((jvmDefaultMode.isEnabled() || !Intrinsics.areEqual((Object)field.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getGENERATED_PROPERTY_REFERENCE())) && !Intrinsics.areEqual((Object)field.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getGENERATED_ASSERTION_ENABLED_FIELD())) continue;
            irClass.getDeclarations().remove(field);
            defaultImplsIrClass.getDeclarations().add(0, field);
            field.setParent((IrDeclarationParent)defaultImplsIrClass);
        }
    }

    private final void createJvmDefaultCompatibilityDelegate(IrSimpleFunction function2) {
        IrSimpleFunction defaultImpl = this.createDefaultImpl(function2, true);
        this.bridgeViaAccessorTo((IrFunction)defaultImpl, function2);
    }

    private final void handleAnnotationClass(IrClass irClass) {
        Sequence annotationsMethods = SequencesKt.filter((Sequence)IrUtilsKt.getFunctions((IrClass)irClass), InterfaceLowering::handleAnnotationClass$lambda$2);
        if (SequencesKt.none((Sequence)annotationsMethods)) {
            return;
        }
        for (IrSimpleFunction function2 : annotationsMethods) {
            IrSimpleFunction defaultImpl = InterfaceLowering.createDefaultImpl$default(this, function2, false, 2, null);
            defaultImpl.setBody(IrInlineUtilsKt.moveBodyTo((IrFunction)((IrFunction)function2), (IrFunction)((IrFunction)defaultImpl)));
            ((Map)this.removedFunctions).put(function2.getSymbol(), defaultImpl.getSymbol());
        }
    }

    private final IrSimpleFunction createDefaultImpl(IrSimpleFunction function2, boolean forCompatibility) {
        IrSimpleFunction irSimpleFunction;
        IrSimpleFunction newFunction = irSimpleFunction = this.context.getCachedDeclarations().getDefaultImplsFunction(function2, forCompatibility);
        boolean bl = false;
        IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)newFunction)).getDeclarations().add(newFunction);
        return irSimpleFunction;
    }

    static /* synthetic */ IrSimpleFunction createDefaultImpl$default(InterfaceLowering interfaceLowering, IrSimpleFunction irSimpleFunction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return interfaceLowering.createDefaultImpl(irSimpleFunction, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void bridgeToStatic(IrFunction $this$bridgeToStatic, IrSimpleFunction callTarget) {
        void $this$mapTo$iv$iv;
        void $this$assignFrom$iv;
        void call;
        IrCallImpl irCallImpl;
        IrCallImpl irCallImpl2 = irCallImpl = BuildersKt.fromSymbolOwner$default((IrCallImpl.Companion)IrCallImpl.Companion, (int)$this$bridgeToStatic.getStartOffset(), (int)$this$bridgeToStatic.getEndOffset(), (IrType)$this$bridgeToStatic.getReturnType(), (IrSimpleFunctionSymbol)callTarget.getSymbol(), null, null, (int)48, null);
        IrFactory irFactory = this.context.getIrFactory();
        IrFunction irFunction = $this$bridgeToStatic;
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = callTarget.getTypeParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrTypeParameter cfr_ignored_0 = (IrTypeParameter)item$iv;
            int i = n;
            boolean bl2 = false;
            call.getTypeArguments().set(i, JvmIrUtilsKt.createPlaceholderAnyNType(this.context.getIrBuiltIns()));
        }
        $this$forEachIndexed$iv = (List)call.getArguments();
        Iterable other$iv = IrUtilsKt.getNonDispatchParameters((IrFunction)$this$bridgeToStatic);
        boolean $i$f$assignFrom = false;
        $this$assignFrom$iv.clear();
        Iterable iterable = other$iv;
        Collection destination$iv$iv = (Collection)$this$assignFrom$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter bl2 = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add((IrExpression)BuildersKt.IrGetValueImpl$default((int)$this$bridgeToStatic.getStartOffset(), (int)$this$bridgeToStatic.getEndOffset(), (IrValueSymbol)((IrValueSymbol)it.getSymbol()), null, (int)8, null));
        }
        Unit unit = Unit.INSTANCE;
        irFunction.setBody((IrBody)IrFactoryHelpersKt.createExpressionBody((IrFactory)irFactory, (IrExpression)((IrExpression)irCallImpl)));
    }

    /*
     * WARNING - void declaration
     */
    private final void bridgeViaAccessorTo(IrFunction $this$bridgeViaAccessorTo, IrSimpleFunction callTarget) {
        void $this$mapTo$iv$iv;
        void $this$assignFrom$iv;
        void call;
        IrCallImpl irCallImpl;
        IrCallImpl irCallImpl2 = irCallImpl = BuildersKt.fromSymbolOwner$default((IrCallImpl.Companion)IrCallImpl.Companion, (int)$this$bridgeViaAccessorTo.getStartOffset(), (int)$this$bridgeViaAccessorTo.getEndOffset(), (IrType)$this$bridgeViaAccessorTo.getReturnType(), (IrSimpleFunctionSymbol)callTarget.getSymbol(), null, (IrClassSymbol)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)callTarget)).getSymbol(), (int)16, null);
        IrFactory irFactory = this.context.getIrFactory();
        IrFunction irFunction = $this$bridgeViaAccessorTo;
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = CollectionsKt.drop((Iterable)$this$bridgeViaAccessorTo.getTypeParameters(), (int)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)callTarget)).getTypeParameters().size());
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void typeParameter;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv;
            int i = n;
            boolean bl2 = false;
            call.getTypeArguments().set(i, IrTypesKt.getDefaultType((IrTypeParameter)typeParameter));
        }
        $this$forEachIndexed$iv = (List)call.getArguments();
        Iterable other$iv = $this$bridgeViaAccessorTo.getParameters();
        boolean $i$f$assignFrom = false;
        $this$assignFrom$iv.clear();
        Iterable iterable = other$iv;
        Collection destination$iv$iv = (Collection)$this$assignFrom$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter bl2 = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add((IrExpression)BuildersKt.IrGetValueImpl$default((int)$this$bridgeViaAccessorTo.getStartOffset(), (int)$this$bridgeViaAccessorTo.getEndOffset(), (IrValueSymbol)((IrValueSymbol)it.getSymbol()), null, (int)8, null));
        }
        Unit unit = Unit.INSTANCE;
        irFunction.setBody((IrBody)IrFactoryHelpersKt.createExpressionBody((IrFactory)irFactory, (IrExpression)((IrExpression)irCallImpl)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2) {
        IrReturn irReturn;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Map map = this.removedFunctions;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)map.get(expression2.getReturnTargetSymbol());
        IrSimpleFunction newFunction = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
        InterfaceLowering interfaceLowering = this;
        if (newFunction != null) {
            void $this$visitReturn_u24lambda_u2410;
            IrReturn irReturn2 = expression2;
            InterfaceLowering interfaceLowering2 = interfaceLowering;
            boolean bl = false;
            interfaceLowering = interfaceLowering2;
            irReturn = (IrReturn)new IrReturnImpl($this$visitReturn_u24lambda_u2410.getStartOffset(), $this$visitReturn_u24lambda_u2410.getEndOffset(), $this$visitReturn_u24lambda_u2410.getType(), (IrReturnTargetSymbol)newFunction.getSymbol(), $this$visitReturn_u24lambda_u2410.getValue());
        } else {
            irReturn = expression2;
        }
        return super.visitReturn(irReturn);
    }

    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.removedFunctions.get(expression2.getSymbol());
        IrSimpleFunction newFunction = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
        return super.visitCall(newFunction != null ? JvmIrUtilsKt.createDelegatingCallWithPlaceholderTypeArguments(expression2, newFunction, this.context.getIrBuiltIns()) : expression2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrFunctionReference irFunctionReference;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Map map = this.removedFunctions;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)map.get(expression2.getSymbol());
        IrSimpleFunction newFunction = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
        InterfaceLowering interfaceLowering = this;
        if (newFunction != null) {
            void $this$visitFunctionReference_u24lambda_u2412;
            IrFunctionReferenceImpl irFunctionReferenceImpl;
            IrFunctionReference irFunctionReference2 = expression2;
            InterfaceLowering interfaceLowering2 = interfaceLowering;
            boolean bl = false;
            IrFunctionReferenceImpl $this$visitFunctionReference_u24lambda_u2412_u24lambda_u2411 = irFunctionReferenceImpl = BuildersKt.IrFunctionReferenceImpl((int)$this$visitFunctionReference_u24lambda_u2412.getStartOffset(), (int)$this$visitFunctionReference_u24lambda_u2412.getEndOffset(), (IrType)$this$visitFunctionReference_u24lambda_u2412.getType(), (IrFunctionSymbol)((IrFunctionSymbol)newFunction.getSymbol()), (int)newFunction.getTypeParameters().size(), (IrFunctionSymbol)expression2.getReflectionTarget(), (IrStatementOrigin)$this$visitFunctionReference_u24lambda_u2412.getOrigin());
            boolean bl2 = false;
            JvmIrUtilsKt.copyFromWithPlaceholderTypeArguments((IrMemberAccessExpression<IrFunctionSymbol>)((IrMemberAccessExpression)$this$visitFunctionReference_u24lambda_u2412_u24lambda_u2411), (IrMemberAccessExpression<IrFunctionSymbol>)((IrMemberAccessExpression)expression2), this.context.getIrBuiltIns());
            IrDeclarationsKt.copyAttributes$default((IrElement)((IrElement)$this$visitFunctionReference_u24lambda_u2412_u24lambda_u2411), (IrElement)((IrElement)expression2), (boolean)false, (int)2, null);
            interfaceLowering = interfaceLowering2;
            irFunctionReference = (IrFunctionReference)irFunctionReferenceImpl;
        } else {
            irFunctionReference = expression2;
        }
        return super.visitFunctionReference(irFunctionReference);
    }

    private static final boolean lower$lambda$0(InterfaceLowering this$0, IrDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof IrFunction && (((Map)this$0.removedFunctions).containsKey(((IrFunction)it).getSymbol()) || CollectionsKt.contains((Iterable)this$0.removedFunctionsWithoutRemapping, (Object)((IrFunction)it).getSymbol()));
    }

    private static final boolean handleAnnotationClass$lambda$2(IrSimpleFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_METHOD_FOR_PROPERTY_OR_TYPEALIAS_ANNOTATIONS());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

