/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Objects;
import org.assertj.core.configuration.Configuration;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.configuration.PreferredAssumptionException;

public class AssumptionExceptionFactory {
    private static PreferredAssumptionException preferredAssumptionException = Configuration.PREFERRED_ASSUMPTION_EXCEPTION;

    static RuntimeException assumptionNotMet(AssertionError assertionError) throws ReflectiveOperationException {
        Class<?> assumptionExceptionClass = preferredAssumptionException.getAssumptionExceptionClass();
        return AssumptionExceptionFactory.buildAssumptionException(assumptionExceptionClass, assertionError);
    }

    public static PreferredAssumptionException getPreferredAssumptionException() {
        return preferredAssumptionException;
    }

    static void setPreferredAssumptionException(PreferredAssumptionException preferredAssumptionException) {
        ConfigurationProvider.loadRegisteredConfiguration();
        Objects.requireNonNull(preferredAssumptionException, "preferredAssumptionException must not be null");
        AssumptionExceptionFactory.preferredAssumptionException = preferredAssumptionException;
    }

    private static RuntimeException buildAssumptionException(Class<?> assumptionExceptionClass, AssertionError assertionError) throws ReflectiveOperationException {
        return (RuntimeException)assumptionExceptionClass.getConstructor(String.class, Throwable.class).newInstance("assumption was not met due to: " + ((Throwable)((Object)assertionError)).getMessage(), assertionError);
    }
}

