/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.shared;

import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.XSourcePosition;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/debugger/impl/shared/XDebuggerUtilImplShared;", "", "<init>", "()V", "createNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "createOpenFileDescriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "XSourcePositionNavigatable", "intellij.platform.debugger.impl.shared"})
@ApiStatus.Internal
public final class XDebuggerUtilImplShared {
    @NotNull
    public static final XDebuggerUtilImplShared INSTANCE = new XDebuggerUtilImplShared();

    private XDebuggerUtilImplShared() {
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final Navigatable createNavigatable(@NotNull Project project, @NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return new XSourcePositionNavigatable(project, position);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final OpenFileDescriptor createOpenFileDescriptor(@NotNull Project project, @NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return position.getOffset() != -1 ? new OpenFileDescriptor(project, position.getFile(), position.getOffset()) : new OpenFileDescriptor(project, position.getFile(), position.getLine(), 0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/debugger/impl/shared/XDebuggerUtilImplShared$XSourcePositionNavigatable;", "Lcom/intellij/pom/Navigatable;", "myProject", "Lcom/intellij/openapi/project/Project;", "myPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/XSourcePosition;)V", "navigate", "", "requestFocus", "", "canNavigate", "canNavigateToSource", "intellij.platform.debugger.impl.shared"})
    private static final class XSourcePositionNavigatable
    implements Navigatable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final XSourcePosition myPosition;

        public XSourcePositionNavigatable(@NotNull Project myProject, @NotNull XSourcePosition myPosition) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            Intrinsics.checkNotNullParameter((Object)myPosition, (String)"myPosition");
            this.myProject = myProject;
            this.myPosition = myPosition;
        }

        public void navigate(boolean requestFocus) {
            XDebuggerUtilImplShared.createOpenFileDescriptor(this.myProject, this.myPosition).navigate(requestFocus);
        }

        public boolean canNavigate() {
            return this.myPosition.getFile().isValid();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }
    }
}

