/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;

public class BasicPanelUI
extends PanelUI {
    private static PanelUI panelUI;

    public static ComponentUI createUI(JComponent jComponent) {
        if (panelUI == null) {
            panelUI = new BasicPanelUI();
        }
        return panelUI;
    }

    @Override
    public void installUI(JComponent jComponent) {
        JPanel jPanel = (JPanel)jComponent;
        super.installUI(jPanel);
        this.installDefaults(jPanel);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        JPanel jPanel = (JPanel)jComponent;
        this.uninstallDefaults(jPanel);
        super.uninstallUI(jComponent);
    }

    protected void installDefaults(JPanel jPanel) {
        LookAndFeel.installColorsAndFont(jPanel, "Panel.background", "Panel.foreground", "Panel.font");
        LookAndFeel.installBorder(jPanel, "Panel.border");
        LookAndFeel.installProperty(jPanel, "opaque", Boolean.TRUE);
    }

    protected void uninstallDefaults(JPanel jPanel) {
        LookAndFeel.uninstallBorder(jPanel);
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        super.getBaseline(jComponent, n, n2);
        Border border = jComponent.getBorder();
        if (border instanceof AbstractBorder) {
            return ((AbstractBorder)border).getBaseline(jComponent, n, n2);
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        Border border = jComponent.getBorder();
        if (border instanceof AbstractBorder) {
            return ((AbstractBorder)border).getBaselineResizeBehavior(jComponent);
        }
        return Component.BaselineResizeBehavior.OTHER;
    }
}

