/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.access;

import java.util.Collections;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.authenticators.access.DenyAccessAuthenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class DenyAccessAuthenticatorFactory
implements AuthenticatorFactory {
    private static final DenyAccessAuthenticator SINGLETON = new DenyAccessAuthenticator();
    public static final String PROVIDER_ID = "deny-access-authenticator";
    public static final String ERROR_MESSAGE = "denyErrorMessage";
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getId() {
        return PROVIDER_ID;
    }

    public Authenticator create(KeycloakSession session) {
        return SINGLETON;
    }

    public String getDisplayType() {
        return "Deny access";
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Access will be always denied. Useful for example in the conditional flows to be used after satisfying the previous conditions";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        ProviderConfigProperty errorMessage = new ProviderConfigProperty();
        errorMessage.setType("String");
        errorMessage.setName(ERROR_MESSAGE);
        errorMessage.setLabel("Error message");
        errorMessage.setHelpText("Error message which will be shown to the user. You can directly define particular message or property, which will be used for mapping the error message f.e `deny-access-role1`. If the field is blank, default property 'access-denied' is used.");
        return Collections.singletonList(errorMessage);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

