/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.OAuthErrorException;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oid4vc.issuance.OID4VCAuthorizationDetailsResponse;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerWellKnownProvider;
import org.keycloak.protocol.oid4vc.issuance.credentialoffer.CredentialOfferStorage;
import org.keycloak.protocol.oid4vc.model.AuthorizationDetail;
import org.keycloak.protocol.oid4vc.model.ClaimsDescription;
import org.keycloak.protocol.oid4vc.model.CredentialsOffer;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;
import org.keycloak.protocol.oid4vc.utils.ClaimsPathPointer;
import org.keycloak.protocol.oidc.rar.AuthorizationDetailsProcessor;
import org.keycloak.protocol.oidc.rar.AuthorizationDetailsResponse;
import org.keycloak.util.JsonSerialization;

public class OID4VCAuthorizationDetailsProcessor
implements AuthorizationDetailsProcessor {
    private static final Logger logger = Logger.getLogger(OID4VCAuthorizationDetailsProcessor.class);
    private final KeycloakSession session;

    public OID4VCAuthorizationDetailsProcessor(KeycloakSession session) {
        this.session = session;
    }

    public boolean isSupported() {
        return this.session.getContext().getRealm().isVerifiableCredentialsEnabled();
    }

    public List<AuthorizationDetailsResponse> process(UserSessionModel userSession, ClientSessionContext clientSessionCtx, String authorizationDetailsParameter) {
        if (authorizationDetailsParameter == null) {
            return null;
        }
        List<AuthorizationDetail> authDetails = this.parseAuthorizationDetails(authorizationDetailsParameter);
        Map<String, SupportedCredentialConfiguration> supportedCredentials = OID4VCIssuerWellKnownProvider.getSupportedCredentials(this.session);
        ArrayList<AuthorizationDetailsResponse> authDetailsResponse = new ArrayList<AuthorizationDetailsResponse>();
        List<String> authorizationServers = OID4VCIssuerWellKnownProvider.getAuthorizationServers(this.session);
        String issuerIdentifier = OID4VCIssuerWellKnownProvider.getIssuer(this.session.getContext());
        for (AuthorizationDetail detail : authDetails) {
            this.validateAuthorizationDetail(detail, supportedCredentials, authorizationServers, issuerIdentifier);
            AuthorizationDetailsResponse responseDetail = this.buildAuthorizationDetailResponse(detail, userSession, clientSessionCtx);
            authDetailsResponse.add(responseDetail);
        }
        if (authDetailsResponse.isEmpty()) {
            throw this.getInvalidRequestException("no valid authorization details found");
        }
        this.createOfferStateForAuthorizationCodeFlow(userSession, clientSessionCtx, authDetailsResponse);
        return authDetailsResponse;
    }

    private void createOfferStateForAuthorizationCodeFlow(UserSessionModel userSession, ClientSessionContext clientSessionCtx, List<AuthorizationDetailsResponse> authDetailsResponse) {
        UserModel user;
        AuthenticatedClientSessionModel clientSession = clientSessionCtx.getClientSession();
        ClientModel client = clientSession != null ? clientSession.getClient() : null;
        UserModel userModel = user = userSession != null ? userSession.getUser() : null;
        if (client == null || user == null) {
            return;
        }
        String vcIssuanceFlow = clientSession.getNote("VC-Issuance-Flow");
        if (vcIssuanceFlow != null && vcIssuanceFlow.equals("urn:ietf:params:oauth:grant-type:pre-authorized_code")) {
            logger.debugf("Skipping offer state creation for pre-authorized code flow (offer state already exists and will be updated)", new Object[0]);
            return;
        }
        CredentialOfferStorage offerStorage = (CredentialOfferStorage)this.session.getProvider(CredentialOfferStorage.class);
        for (AuthorizationDetailsResponse authDetail : authDetailsResponse) {
            OID4VCAuthorizationDetailsResponse oid4vcDetail;
            if (!(authDetail instanceof OID4VCAuthorizationDetailsResponse) || (oid4vcDetail = (OID4VCAuthorizationDetailsResponse)authDetail).getCredentialIdentifiers() == null || oid4vcDetail.getCredentialIdentifiers().isEmpty()) continue;
            for (String credentialId : oid4vcDetail.getCredentialIdentifiers()) {
                CredentialOfferStorage.CredentialOfferState existingState = offerStorage.findOfferStateByCredentialId(this.session, credentialId);
                if (existingState == null) {
                    CredentialsOffer credOffer = new CredentialsOffer().setCredentialIssuer(OID4VCIssuerWellKnownProvider.getIssuer(this.session.getContext())).setCredentialConfigurationIds(List.of(oid4vcDetail.getCredentialConfigurationId()));
                    int expiration = Time.currentTime() + 3600;
                    CredentialOfferStorage.CredentialOfferState offerState = new CredentialOfferStorage.CredentialOfferState(credOffer, client.getClientId(), user.getId(), expiration);
                    offerState.setAuthorizationDetails(oid4vcDetail);
                    offerStorage.putOfferState(this.session, offerState);
                    logger.debugf("Created credential offer state for authorization code flow: [cid=%s, uid=%s, credConfigId=%s, credId=%s]", new Object[]{client.getClientId(), offerState.getUserId(), oid4vcDetail.getCredentialConfigurationId(), credentialId});
                    continue;
                }
                existingState.setAuthorizationDetails(oid4vcDetail);
                offerStorage.replaceOfferState(this.session, existingState);
                logger.debugf("Updated existing credential offer state for authorization code flow: [cid=%s, uid=%s, credConfigId=%s, credId=%s]", new Object[]{client.getClientId(), existingState.getUserId(), oid4vcDetail.getCredentialConfigurationId(), credentialId});
            }
        }
    }

    private List<AuthorizationDetail> parseAuthorizationDetails(String authorizationDetailsParam) {
        try {
            return (List)JsonSerialization.readValue((String)authorizationDetailsParam, (TypeReference)new TypeReference<List<AuthorizationDetail>>(){});
        }
        catch (Exception e) {
            logger.warnf((Throwable)e, "Invalid authorization_details format: %s", (Object)authorizationDetailsParam);
            throw this.getInvalidRequestException("format: " + authorizationDetailsParam);
        }
    }

    private RuntimeException getInvalidRequestException(String errorDescription) {
        return new RuntimeException("Invalid authorization_details: " + errorDescription);
    }

    private void validateAuthorizationDetail(AuthorizationDetail detail, Map<String, SupportedCredentialConfiguration> supportedCredentials, List<String> authorizationServers, String issuerIdentifier) {
        List<String> locations;
        String type = detail.getType();
        String credentialConfigurationId = detail.getCredentialConfigurationId();
        List<ClaimsDescription> claims = detail.getClaims();
        if (!"openid_credential".equals(type)) {
            logger.warnf("Invalid authorization_details type: %s", (Object)type);
            throw this.getInvalidRequestException("type: " + type + ", expected=openid_credential");
        }
        if (!(authorizationServers == null || authorizationServers.isEmpty() || (locations = detail.getLocations()) != null && locations.size() == 1 && issuerIdentifier.equals(locations.get(0)))) {
            logger.warnf("Invalid locations field in authorization_details: %s, expected: %s", locations, (Object)issuerIdentifier);
            throw this.getInvalidRequestException("locations=" + String.valueOf(locations) + ", expected=" + issuerIdentifier);
        }
        if (credentialConfigurationId == null) {
            logger.warnf("Missing credential_configuration_id in authorization_details", new Object[0]);
            throw this.getInvalidRequestException("credential_configuration_id is required");
        }
        SupportedCredentialConfiguration config = supportedCredentials.get(credentialConfigurationId);
        if (config == null) {
            logger.warnf("Unsupported credential_configuration_id: %s", (Object)credentialConfigurationId);
            throw this.getInvalidRequestException("Invalid credential configuration: unsupported credential_configuration_id=" + credentialConfigurationId);
        }
        if (claims != null && !claims.isEmpty()) {
            this.validateClaims(claims, config);
        }
    }

    private void validateClaims(List<ClaimsDescription> claims, SupportedCredentialConfiguration config) {
        List exposedClaims = null;
        if (config.getCredentialMetadata() != null && config.getCredentialMetadata().getClaims() != null && !config.getCredentialMetadata().getClaims().isEmpty()) {
            exposedClaims = config.getCredentialMetadata().getClaims();
        }
        if (exposedClaims == null || exposedClaims.isEmpty()) {
            throw this.getInvalidRequestException("Credential configuration does not expose any claims metadata");
        }
        Set exposedClaimPaths = exposedClaims.stream().filter(claim -> claim.getPath() != null && !claim.getPath().isEmpty()).map(claim -> claim.getPath().toString()).collect(Collectors.toSet());
        for (ClaimsDescription requestedClaim : claims) {
            if (requestedClaim.getPath() == null || requestedClaim.getPath().isEmpty()) {
                throw this.getInvalidRequestException("Invalid claims description: path is required");
            }
            if (!ClaimsPathPointer.isValidPath(requestedClaim.getPath())) {
                throw this.getInvalidRequestException("Invalid claims path pointer: " + String.valueOf(requestedClaim.getPath()) + ". Path must contain only strings, non-negative integers, and null values.");
            }
            String requestedPath = requestedClaim.getPath().toString();
            if (exposedClaimPaths.contains(requestedPath)) continue;
            throw this.getInvalidRequestException("Unsupported claim: " + requestedPath + ". This claim is not supported by the credential configuration.");
        }
        if (!ClaimsPathPointer.validateClaimsDescriptions(claims)) {
            throw this.getInvalidRequestException("Invalid claims descriptions: conflicting or contradictory claims found");
        }
    }

    private AuthorizationDetailsResponse buildAuthorizationDetailResponse(AuthorizationDetail detail, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        String credentialConfigurationId = detail.getCredentialConfigurationId();
        List previousResponses = (List)clientSessionCtx.getAttribute("authorization_details_response", List.class);
        List<String> credentialIdentifiers = null;
        if (previousResponses != null) {
            for (AuthorizationDetailsResponse prev : previousResponses) {
                if (!(prev instanceof OID4VCAuthorizationDetailsResponse)) continue;
                OID4VCAuthorizationDetailsResponse oid4vcResponse = (OID4VCAuthorizationDetailsResponse)prev;
                credentialIdentifiers = oid4vcResponse.getCredentialIdentifiers();
                break;
            }
        }
        if (credentialIdentifiers == null) {
            credentialIdentifiers = new ArrayList<String>();
            credentialIdentifiers.add(UUID.randomUUID().toString());
        }
        OID4VCAuthorizationDetailsResponse responseDetail = new OID4VCAuthorizationDetailsResponse();
        responseDetail.setType("openid_credential");
        responseDetail.setCredentialConfigurationId(credentialConfigurationId);
        responseDetail.setCredentialIdentifiers(credentialIdentifiers);
        if (detail.getClaims() != null) {
            String claimsKey = "AUTHORIZATION_DETAILS_CLAIMS_" + credentialConfigurationId;
            try {
                userSession.setNote(claimsKey, JsonSerialization.writeValueAsString(detail.getClaims()));
            }
            catch (Exception e) {
                logger.warnf((Throwable)e, "Failed to store claims in user session for credential configuration %s", (Object)credentialConfigurationId);
            }
            responseDetail.setClaims(detail.getClaims());
        }
        return responseDetail;
    }

    private List<AuthorizationDetailsResponse> generateAuthorizationDetailsFromCredentialOffer(AuthenticatedClientSessionModel clientSession) {
        logger.debug((Object)"Processing authorization_details from credential offer");
        Map<String, SupportedCredentialConfiguration> supportedCredentials = OID4VCIssuerWellKnownProvider.getSupportedCredentials(this.session);
        if (supportedCredentials == null || supportedCredentials.isEmpty()) {
            logger.debug((Object)"No supported credentials found, cannot generate authorization_details from credential offer");
            return null;
        }
        List<String> credentialConfigurationIds = this.extractCredentialConfigurationIds(clientSession);
        if (credentialConfigurationIds == null || credentialConfigurationIds.isEmpty()) {
            logger.debug((Object)"No credential_configuration_ids found in credential offer, cannot generate authorization_details");
            return null;
        }
        ArrayList<AuthorizationDetailsResponse> authorizationDetailsList = new ArrayList<AuthorizationDetailsResponse>();
        for (String credentialConfigurationId : credentialConfigurationIds) {
            SupportedCredentialConfiguration config = supportedCredentials.get(credentialConfigurationId);
            if (config == null) {
                logger.warnf("Credential configuration '%s' not found in supported credentials, skipping", (Object)credentialConfigurationId);
                continue;
            }
            String credentialIdentifier = UUID.randomUUID().toString();
            logger.debugf("Generated credential identifier '%s' for configuration '%s'", (Object)credentialIdentifier, (Object)credentialConfigurationId);
            OID4VCAuthorizationDetailsResponse authDetail = new OID4VCAuthorizationDetailsResponse();
            authDetail.setType("openid_credential");
            authDetail.setCredentialConfigurationId(credentialConfigurationId);
            authDetail.setCredentialIdentifiers(List.of(credentialIdentifier));
            authorizationDetailsList.add(authDetail);
        }
        if (authorizationDetailsList.isEmpty()) {
            logger.debug((Object)"No valid credential configurations found, cannot generate authorization_details");
            return null;
        }
        return authorizationDetailsList;
    }

    private List<String> extractCredentialConfigurationIds(AuthenticatedClientSessionModel clientSession) {
        String credentialConfigIdsJson = clientSession.getNote("CREDENTIAL_CONFIGURATION_IDS");
        if (credentialConfigIdsJson != null) {
            logger.debugf("Found credential configuration IDs in predictable location", new Object[0]);
            try {
                List configIds = (List)JsonSerialization.readValue((String)credentialConfigIdsJson, List.class);
                logger.debugf("Successfully parsed credential configuration IDs: %s", (Object)configIds);
                return configIds;
            }
            catch (Exception e) {
                logger.warnf("Failed to parse credential configuration IDs from predictable location: %s", (Object)e.getMessage());
            }
        }
        logger.debugf("No credential_configuration_ids found in predictable location", new Object[0]);
        return null;
    }

    public List<AuthorizationDetailsResponse> handleMissingAuthorizationDetails(UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        AuthenticatedClientSessionModel clientSession = clientSessionCtx.getClientSession();
        return this.generateAuthorizationDetailsFromCredentialOffer(clientSession);
    }

    public List<AuthorizationDetailsResponse> processStoredAuthorizationDetails(UserSessionModel userSession, ClientSessionContext clientSessionCtx, String storedAuthDetails) throws OAuthErrorException {
        if (storedAuthDetails == null) {
            return null;
        }
        logger.debugf("Processing stored authorization_details from authorization request: %s", (Object)storedAuthDetails);
        try {
            return this.process(userSession, clientSessionCtx, storedAuthDetails);
        }
        catch (RuntimeException e) {
            logger.warnf((Throwable)e, "Error when processing stored authorization_details, cannot fulfill OID4VC requirement", new Object[0]);
            throw new OAuthErrorException("invalid_request", "authorization_details was used in authorization request but cannot be processed for token response: " + e.getMessage());
        }
    }

    public void close() {
    }
}

