/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachment;

public class DescribeTransitGatewayPeeringAttachmentsIterable
implements SdkIterable<DescribeTransitGatewayPeeringAttachmentsResponse> {
    private final Ec2Client client;
    private final DescribeTransitGatewayPeeringAttachmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTransitGatewayPeeringAttachmentsIterable(Ec2Client client, DescribeTransitGatewayPeeringAttachmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTransitGatewayPeeringAttachmentsResponseFetcher();
    }

    public Iterator<DescribeTransitGatewayPeeringAttachmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayPeeringAttachment> transitGatewayPeeringAttachments() {
        Function<DescribeTransitGatewayPeeringAttachmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayPeeringAttachments() != null) {
                return response.transitGatewayPeeringAttachments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTransitGatewayPeeringAttachmentsResponseFetcher
    implements SyncPageFetcher<DescribeTransitGatewayPeeringAttachmentsResponse> {
        private DescribeTransitGatewayPeeringAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayPeeringAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTransitGatewayPeeringAttachmentsResponse nextPage(DescribeTransitGatewayPeeringAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayPeeringAttachmentsIterable.this.client.describeTransitGatewayPeeringAttachments(DescribeTransitGatewayPeeringAttachmentsIterable.this.firstRequest);
            }
            return DescribeTransitGatewayPeeringAttachmentsIterable.this.client.describeTransitGatewayPeeringAttachments((DescribeTransitGatewayPeeringAttachmentsRequest)((Object)DescribeTransitGatewayPeeringAttachmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

