/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLDeleteMemoryAction;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLDeleteMemoryRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLDeleteMemoryAction
extends BaseRestHandler {
    private static final String ML_DELETE_MEMORY_ACTION = "ml_delete_memory_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLDeleteMemoryAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_DELETE_MEMORY_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, "/_plugins/_ml/memory_containers/{memory_container_id}/memories/{memory_type}/{memory_id}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            throw new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]);
        }
        MLDeleteMemoryRequest mlDeleteMemoryRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLDeleteMemoryAction.INSTANCE, (ActionRequest)mlDeleteMemoryRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLDeleteMemoryRequest getRequest(RestRequest request) {
        String memoryContainerId = RestActionUtils.getParameterId(request, "memory_container_id");
        String memoryTypeStr = RestActionUtils.getParameterId(request, "memory_type");
        MemoryType memoryType = MemoryType.fromString((String)memoryTypeStr);
        String memoryId = RestActionUtils.getParameterId(request, "memory_id");
        return MLDeleteMemoryRequest.builder().memoryContainerId(memoryContainerId).memoryType(memoryType).memoryId(memoryId).build();
    }
}

