/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.reindex;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RemoteSource
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RemoteSource> {
    @Nullable
    private final Time connectTimeout;
    @Nonnull
    private final Map<String, String> headers;
    @Nonnull
    private final String host;
    @Nullable
    private final String password;
    @Nullable
    private final Time socketTimeout;
    @Nullable
    private final String username;
    public static final JsonpDeserializer<RemoteSource> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoteSource::setupRemoteSourceDeserializer);

    private RemoteSource(Builder builder) {
        this.connectTimeout = builder.connectTimeout;
        this.headers = ApiTypeHelper.unmodifiable(builder.headers);
        this.host = ApiTypeHelper.requireNonNull(builder.host, this, "host");
        this.password = builder.password;
        this.socketTimeout = builder.socketTimeout;
        this.username = builder.username;
    }

    public static RemoteSource of(Function<Builder, ObjectBuilder<RemoteSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time connectTimeout() {
        return this.connectTimeout;
    }

    @Nonnull
    public final Map<String, String> headers() {
        return this.headers;
    }

    @Nonnull
    public final String host() {
        return this.host;
    }

    @Nullable
    public final String password() {
        return this.password;
    }

    @Nullable
    public final Time socketTimeout() {
        return this.socketTimeout;
    }

    @Nullable
    public final String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.connectTimeout != null) {
            generator.writeKey("connect_timeout");
            this.connectTimeout.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.headers)) {
            generator.writeKey("headers");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.headers.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("host");
        generator.write(this.host);
        if (this.password != null) {
            generator.writeKey("password");
            generator.write(this.password);
        }
        if (this.socketTimeout != null) {
            generator.writeKey("socket_timeout");
            this.socketTimeout.serialize(generator, mapper);
        }
        if (this.username != null) {
            generator.writeKey("username");
            generator.write(this.username);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRemoteSourceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::connectTimeout, Time._DESERIALIZER, "connect_timeout");
        op.add(Builder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "headers");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password");
        op.add(Builder::socketTimeout, Time._DESERIALIZER, "socket_timeout");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.connectTimeout);
        result = 31 * result + Objects.hashCode(this.headers);
        result = 31 * result + this.host.hashCode();
        result = 31 * result + Objects.hashCode(this.password);
        result = 31 * result + Objects.hashCode(this.socketTimeout);
        result = 31 * result + Objects.hashCode(this.username);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteSource other = (RemoteSource)o;
        return Objects.equals(this.connectTimeout, other.connectTimeout) && Objects.equals(this.headers, other.headers) && this.host.equals(other.host) && Objects.equals(this.password, other.password) && Objects.equals(this.socketTimeout, other.socketTimeout) && Objects.equals(this.username, other.username);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RemoteSource> {
        @Nullable
        private Time connectTimeout;
        @Nullable
        private Map<String, String> headers;
        private String host;
        @Nullable
        private String password;
        @Nullable
        private Time socketTimeout;
        @Nullable
        private String username;

        public Builder() {
        }

        private Builder(RemoteSource o) {
            this.connectTimeout = o.connectTimeout;
            this.headers = Builder._mapCopy(o.headers);
            this.host = o.host;
            this.password = o.password;
            this.socketTimeout = o.socketTimeout;
            this.username = o.username;
        }

        private Builder(Builder o) {
            this.connectTimeout = o.connectTimeout;
            this.headers = Builder._mapCopy(o.headers);
            this.host = o.host;
            this.password = o.password;
            this.socketTimeout = o.socketTimeout;
            this.username = o.username;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder connectTimeout(@Nullable Time value) {
            this.connectTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder connectTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.connectTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder headers(Map<String, String> map) {
            this.headers = Builder._mapPutAll(this.headers, map);
            return this;
        }

        @Nonnull
        public final Builder headers(String key, String value) {
            this.headers = Builder._mapPut(this.headers, key, value);
            return this;
        }

        @Nonnull
        public final Builder host(String value) {
            this.host = value;
            return this;
        }

        @Nonnull
        public final Builder password(@Nullable String value) {
            this.password = value;
            return this;
        }

        @Nonnull
        public final Builder socketTimeout(@Nullable Time value) {
            this.socketTimeout = value;
            return this;
        }

        @Nonnull
        public final Builder socketTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.socketTimeout(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        @Override
        @Nonnull
        public RemoteSource build() {
            this._checkSingleUse();
            return new RemoteSource(this);
        }
    }
}

