/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import java.util.Objects;
import lombok.NonNull;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.cache.CircuitBreakerManager;
import org.opensearch.neuralsearch.sparse.cache.ClusteredPostingCacheItem;
import org.opensearch.neuralsearch.sparse.cache.MemMonitoredCache;
import org.opensearch.neuralsearch.sparse.cache.MemoryUsageManager;
import org.opensearch.neuralsearch.sparse.cache.RamBytesRecorder;

public class ClusteredPostingCache
extends MemMonitoredCache<ClusteredPostingCacheItem> {
    private static volatile ClusteredPostingCache INSTANCE;

    protected ClusteredPostingCache() {
        MemoryUsageManager.getInstance().getMemoryUsageTracker().recordWithoutValidation(RamUsageEstimator.shallowSizeOf((Object)this.cacheMap), CircuitBreakerManager::addWithoutBreaking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusteredPostingCache getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ClusteredPostingCache> clazz = ClusteredPostingCache.class;
        synchronized (ClusteredPostingCache.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ClusteredPostingCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @NonNull
    public ClusteredPostingCacheItem getOrCreate(@NonNull CacheKey key) {
        Objects.requireNonNull(key, "key is marked non-null but is null");
        RamBytesRecorder globalRecorder = MemoryUsageManager.getInstance().getMemoryUsageTracker();
        return super.getOrCreate(key, k -> new ClusteredPostingCacheItem((CacheKey)k, globalRecorder));
    }
}

