/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdate;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexAutoScalingUpdateListCopier;
import software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingUpdateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTableReplicaAutoScalingRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, UpdateTableReplicaAutoScalingRequest> {
    private static final SdkField<List<GlobalSecondaryIndexAutoScalingUpdate>> GLOBAL_SECONDARY_INDEX_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalSecondaryIndexUpdates").getter(UpdateTableReplicaAutoScalingRequest.getter(UpdateTableReplicaAutoScalingRequest::globalSecondaryIndexUpdates)).setter(UpdateTableReplicaAutoScalingRequest.setter(Builder::globalSecondaryIndexUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalSecondaryIndexAutoScalingUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(UpdateTableReplicaAutoScalingRequest.getter(UpdateTableReplicaAutoScalingRequest::tableName)).setter(UpdateTableReplicaAutoScalingRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<AutoScalingSettingsUpdate> PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedWriteCapacityAutoScalingUpdate").getter(UpdateTableReplicaAutoScalingRequest.getter(UpdateTableReplicaAutoScalingRequest::provisionedWriteCapacityAutoScalingUpdate)).setter(UpdateTableReplicaAutoScalingRequest.setter(Builder::provisionedWriteCapacityAutoScalingUpdate)).constructor(AutoScalingSettingsUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedWriteCapacityAutoScalingUpdate").build()}).build();
    private static final SdkField<List<ReplicaAutoScalingUpdate>> REPLICA_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicaUpdates").getter(UpdateTableReplicaAutoScalingRequest.getter(UpdateTableReplicaAutoScalingRequest::replicaUpdates)).setter(UpdateTableReplicaAutoScalingRequest.setter(Builder::replicaUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaAutoScalingUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_SECONDARY_INDEX_UPDATES_FIELD, TABLE_NAME_FIELD, PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_UPDATE_FIELD, REPLICA_UPDATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTableReplicaAutoScalingRequest.memberNameToFieldInitializer();
    private final List<GlobalSecondaryIndexAutoScalingUpdate> globalSecondaryIndexUpdates;
    private final String tableName;
    private final AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingUpdate;
    private final List<ReplicaAutoScalingUpdate> replicaUpdates;

    private UpdateTableReplicaAutoScalingRequest(BuilderImpl builder) {
        super(builder);
        this.globalSecondaryIndexUpdates = builder.globalSecondaryIndexUpdates;
        this.tableName = builder.tableName;
        this.provisionedWriteCapacityAutoScalingUpdate = builder.provisionedWriteCapacityAutoScalingUpdate;
        this.replicaUpdates = builder.replicaUpdates;
    }

    public final boolean hasGlobalSecondaryIndexUpdates() {
        return this.globalSecondaryIndexUpdates != null && !(this.globalSecondaryIndexUpdates instanceof SdkAutoConstructList);
    }

    public final List<GlobalSecondaryIndexAutoScalingUpdate> globalSecondaryIndexUpdates() {
        return this.globalSecondaryIndexUpdates;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingUpdate() {
        return this.provisionedWriteCapacityAutoScalingUpdate;
    }

    public final boolean hasReplicaUpdates() {
        return this.replicaUpdates != null && !(this.replicaUpdates instanceof SdkAutoConstructList);
    }

    public final List<ReplicaAutoScalingUpdate> replicaUpdates() {
        return this.replicaUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalSecondaryIndexUpdates() ? this.globalSecondaryIndexUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedWriteCapacityAutoScalingUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicaUpdates() ? this.replicaUpdates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableReplicaAutoScalingRequest)) {
            return false;
        }
        UpdateTableReplicaAutoScalingRequest other = (UpdateTableReplicaAutoScalingRequest)((Object)obj);
        return this.hasGlobalSecondaryIndexUpdates() == other.hasGlobalSecondaryIndexUpdates() && Objects.equals(this.globalSecondaryIndexUpdates(), other.globalSecondaryIndexUpdates()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.provisionedWriteCapacityAutoScalingUpdate(), other.provisionedWriteCapacityAutoScalingUpdate()) && this.hasReplicaUpdates() == other.hasReplicaUpdates() && Objects.equals(this.replicaUpdates(), other.replicaUpdates());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTableReplicaAutoScalingRequest").add("GlobalSecondaryIndexUpdates", this.hasGlobalSecondaryIndexUpdates() ? this.globalSecondaryIndexUpdates() : null).add("TableName", (Object)this.tableName()).add("ProvisionedWriteCapacityAutoScalingUpdate", (Object)this.provisionedWriteCapacityAutoScalingUpdate()).add("ReplicaUpdates", this.hasReplicaUpdates() ? this.replicaUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalSecondaryIndexUpdates": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexUpdates()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "ProvisionedWriteCapacityAutoScalingUpdate": {
                return Optional.ofNullable(clazz.cast(this.provisionedWriteCapacityAutoScalingUpdate()));
            }
            case "ReplicaUpdates": {
                return Optional.ofNullable(clazz.cast(this.replicaUpdates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GlobalSecondaryIndexUpdates", GLOBAL_SECONDARY_INDEX_UPDATES_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("ProvisionedWriteCapacityAutoScalingUpdate", PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_UPDATE_FIELD);
        map.put("ReplicaUpdates", REPLICA_UPDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableReplicaAutoScalingRequest, T> g) {
        return obj -> g.apply((UpdateTableReplicaAutoScalingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private List<GlobalSecondaryIndexAutoScalingUpdate> globalSecondaryIndexUpdates = DefaultSdkAutoConstructList.getInstance();
        private String tableName;
        private AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingUpdate;
        private List<ReplicaAutoScalingUpdate> replicaUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableReplicaAutoScalingRequest model) {
            super(model);
            this.globalSecondaryIndexUpdates(model.globalSecondaryIndexUpdates);
            this.tableName(model.tableName);
            this.provisionedWriteCapacityAutoScalingUpdate(model.provisionedWriteCapacityAutoScalingUpdate);
            this.replicaUpdates(model.replicaUpdates);
        }

        public final List<GlobalSecondaryIndexAutoScalingUpdate.Builder> getGlobalSecondaryIndexUpdates() {
            List<GlobalSecondaryIndexAutoScalingUpdate.Builder> result = GlobalSecondaryIndexAutoScalingUpdateListCopier.copyToBuilder(this.globalSecondaryIndexUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexAutoScalingUpdate.BuilderImpl> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexAutoScalingUpdateListCopier.copyFromBuilder(globalSecondaryIndexUpdates);
        }

        @Override
        public final Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexAutoScalingUpdate> globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates = GlobalSecondaryIndexAutoScalingUpdateListCopier.copy(globalSecondaryIndexUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexAutoScalingUpdate ... globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates(Arrays.asList(globalSecondaryIndexUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexUpdates(Consumer<GlobalSecondaryIndexAutoScalingUpdate.Builder> ... globalSecondaryIndexUpdates) {
            this.globalSecondaryIndexUpdates(Stream.of(globalSecondaryIndexUpdates).map(c -> (GlobalSecondaryIndexAutoScalingUpdate)((GlobalSecondaryIndexAutoScalingUpdate.Builder)GlobalSecondaryIndexAutoScalingUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final AutoScalingSettingsUpdate.Builder getProvisionedWriteCapacityAutoScalingUpdate() {
            return this.provisionedWriteCapacityAutoScalingUpdate != null ? this.provisionedWriteCapacityAutoScalingUpdate.toBuilder() : null;
        }

        public final void setProvisionedWriteCapacityAutoScalingUpdate(AutoScalingSettingsUpdate.BuilderImpl provisionedWriteCapacityAutoScalingUpdate) {
            this.provisionedWriteCapacityAutoScalingUpdate = provisionedWriteCapacityAutoScalingUpdate != null ? provisionedWriteCapacityAutoScalingUpdate.build() : null;
        }

        @Override
        public final Builder provisionedWriteCapacityAutoScalingUpdate(AutoScalingSettingsUpdate provisionedWriteCapacityAutoScalingUpdate) {
            this.provisionedWriteCapacityAutoScalingUpdate = provisionedWriteCapacityAutoScalingUpdate;
            return this;
        }

        public final List<ReplicaAutoScalingUpdate.Builder> getReplicaUpdates() {
            List<ReplicaAutoScalingUpdate.Builder> result = ReplicaAutoScalingUpdateListCopier.copyToBuilder(this.replicaUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicaUpdates(Collection<ReplicaAutoScalingUpdate.BuilderImpl> replicaUpdates) {
            this.replicaUpdates = ReplicaAutoScalingUpdateListCopier.copyFromBuilder(replicaUpdates);
        }

        @Override
        public final Builder replicaUpdates(Collection<ReplicaAutoScalingUpdate> replicaUpdates) {
            this.replicaUpdates = ReplicaAutoScalingUpdateListCopier.copy(replicaUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaUpdates(ReplicaAutoScalingUpdate ... replicaUpdates) {
            this.replicaUpdates(Arrays.asList(replicaUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaUpdates(Consumer<ReplicaAutoScalingUpdate.Builder> ... replicaUpdates) {
            this.replicaUpdates(Stream.of(replicaUpdates).map(c -> (ReplicaAutoScalingUpdate)((ReplicaAutoScalingUpdate.Builder)ReplicaAutoScalingUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableReplicaAutoScalingRequest build() {
            return new UpdateTableReplicaAutoScalingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTableReplicaAutoScalingRequest> {
        public Builder globalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexAutoScalingUpdate> var1);

        public Builder globalSecondaryIndexUpdates(GlobalSecondaryIndexAutoScalingUpdate ... var1);

        public Builder globalSecondaryIndexUpdates(Consumer<GlobalSecondaryIndexAutoScalingUpdate.Builder> ... var1);

        public Builder tableName(String var1);

        public Builder provisionedWriteCapacityAutoScalingUpdate(AutoScalingSettingsUpdate var1);

        default public Builder provisionedWriteCapacityAutoScalingUpdate(Consumer<AutoScalingSettingsUpdate.Builder> provisionedWriteCapacityAutoScalingUpdate) {
            return this.provisionedWriteCapacityAutoScalingUpdate((AutoScalingSettingsUpdate)((AutoScalingSettingsUpdate.Builder)AutoScalingSettingsUpdate.builder().applyMutation(provisionedWriteCapacityAutoScalingUpdate)).build());
        }

        public Builder replicaUpdates(Collection<ReplicaAutoScalingUpdate> var1);

        public Builder replicaUpdates(ReplicaAutoScalingUpdate ... var1);

        public Builder replicaUpdates(Consumer<ReplicaAutoScalingUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

