/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.greedyswitch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p3order.counting.CrossMinUtil;
import org.eclipse.elk.core.options.PortSide;

public final class BetweenLayerEdgeTwoNodeCrossingsCounter {
    private int upperLowerCrossings;
    private int lowerUpperCrossings;
    private AdjacencyList upperAdjacencies;
    private AdjacencyList lowerAdjacencies;
    private final LNode[][] currentNodeOrder;
    private final int freeLayerIndex;
    private final Map<LPort, Integer> portPositions = Maps.newHashMap();
    private final Map<LNode, AdjacencyList> easternAdjacencies = Maps.newHashMap();
    private final Map<LNode, AdjacencyList> westernAdjacencies = Maps.newHashMap();

    public BetweenLayerEdgeTwoNodeCrossingsCounter(LNode[][] currentNodeOrder, int freeLayerIndex) {
        this.currentNodeOrder = currentNodeOrder;
        this.freeLayerIndex = freeLayerIndex;
        this.setPortPositionsForNeighbouringLayers();
    }

    private void setPortPositionsForNeighbouringLayers() {
        if (this.freeLayerIsNotFirstLayer()) {
            this.setPortPositionsForLayer(this.freeLayerIndex - 1, PortSide.EAST);
        }
        if (this.freeLayerIsNotLastLayer()) {
            this.setPortPositionsForLayer(this.freeLayerIndex + 1, PortSide.WEST);
        }
    }

    private boolean freeLayerIsNotFirstLayer() {
        return this.freeLayerIndex > 0;
    }

    private boolean freeLayerIsNotLastLayer() {
        return this.freeLayerIndex < this.currentNodeOrder.length - 1;
    }

    private void setPortPositionsForLayer(int layerIndex, PortSide portSide) {
        int portId = 0;
        LNode[] lNodeArray = this.currentNodeOrder[layerIndex];
        int n = lNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            Iterable<LPort> ports = CrossMinUtil.inNorthSouthEastWestOrder(node, portSide);
            for (LPort port : ports) {
                this.portPositions.put(port, portId++);
            }
            ++n2;
        }
    }

    public void countEasternEdgeCrossings(LNode upperNode, LNode lowerNode) {
        this.resetCrossingCount();
        if (upperNode.equals(lowerNode)) {
            return;
        }
        this.addEasternCrossings(upperNode, lowerNode);
    }

    public void countWesternEdgeCrossings(LNode upperNode, LNode lowerNode) {
        this.resetCrossingCount();
        if (upperNode.equals(lowerNode)) {
            return;
        }
        this.addWesternCrossings(upperNode, lowerNode);
    }

    public void countBothSideCrossings(LNode upperNode, LNode lowerNode) {
        this.resetCrossingCount();
        if (upperNode.equals(lowerNode)) {
            return;
        }
        this.addWesternCrossings(upperNode, lowerNode);
        this.addEasternCrossings(upperNode, lowerNode);
    }

    private void resetCrossingCount() {
        this.upperLowerCrossings = 0;
        this.lowerUpperCrossings = 0;
    }

    private void addEasternCrossings(LNode upperNode, LNode lowerNode) {
        this.upperAdjacencies = this.getAdjacencyFor(upperNode, PortSide.EAST, this.easternAdjacencies);
        this.lowerAdjacencies = this.getAdjacencyFor(lowerNode, PortSide.EAST, this.easternAdjacencies);
        if (this.upperAdjacencies.size() == 0 || this.lowerAdjacencies.size() == 0) {
            return;
        }
        this.countCrossingsByMergingAdjacencyLists();
    }

    private AdjacencyList getAdjacencyFor(LNode node, PortSide side, Map<LNode, AdjacencyList> adjacencies) {
        if (adjacencies.isEmpty()) {
            LNode[] lNodeArray = this.currentNodeOrder[this.freeLayerIndex];
            int n = lNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LNode n3 = lNodeArray[n2];
                adjacencies.put(n3, new AdjacencyList(n3, side));
                ++n2;
            }
        }
        AdjacencyList aL = adjacencies.get(node);
        aL.reset();
        return aL;
    }

    private void addWesternCrossings(LNode upperNode, LNode lowerNode) {
        this.upperAdjacencies = this.getAdjacencyFor(upperNode, PortSide.WEST, this.westernAdjacencies);
        this.lowerAdjacencies = this.getAdjacencyFor(lowerNode, PortSide.WEST, this.westernAdjacencies);
        if (this.upperAdjacencies.size() == 0 || this.lowerAdjacencies.size() == 0) {
            return;
        }
        this.countCrossingsByMergingAdjacencyLists();
    }

    private void countCrossingsByMergingAdjacencyLists() {
        while (!this.upperAdjacencies.isEmpty() && !this.lowerAdjacencies.isEmpty()) {
            if (this.isBelow(this.upperAdjacencies.first(), this.lowerAdjacencies.first())) {
                this.upperLowerCrossings += this.upperAdjacencies.size();
                this.lowerAdjacencies.removeFirst();
                continue;
            }
            if (this.isBelow(this.lowerAdjacencies.first(), this.upperAdjacencies.first())) {
                this.lowerUpperCrossings += this.lowerAdjacencies.size();
                this.upperAdjacencies.removeFirst();
                continue;
            }
            this.upperLowerCrossings += this.upperAdjacencies.countAdjacenciesBelowNodeOfFirstPort();
            this.lowerUpperCrossings += this.lowerAdjacencies.countAdjacenciesBelowNodeOfFirstPort();
            this.upperAdjacencies.removeFirst();
            this.lowerAdjacencies.removeFirst();
        }
    }

    private boolean isBelow(int firstPort, int secondPort) {
        return firstPort > secondPort;
    }

    public int getUpperLowerCrossings() {
        return this.upperLowerCrossings;
    }

    public int getLowerUpperCrossings() {
        return this.lowerUpperCrossings;
    }

    private class AdjacencyList {
        private final LNode node;
        private final List<Adjacency> adjacencyList;
        private final PortSide side;
        private int size;
        private int currentSize;
        private int currentIndex;

        AdjacencyList(LNode node, PortSide side) {
            this.node = node;
            this.side = side;
            this.adjacencyList = Lists.newArrayList();
            this.getAdjacenciesSortedByPosition();
        }

        private void getAdjacenciesSortedByPosition() {
            this.iterateTroughEdgesCollectingAdjacencies();
            Collections.sort(this.adjacencyList);
        }

        private void iterateTroughEdgesCollectingAdjacencies() {
            Iterable<LPort> ports = CrossMinUtil.inNorthSouthEastWestOrder(this.node, this.side);
            for (LPort port : ports) {
                List<LEdge> edges = this.getEdgesConnectedTo(port);
                for (LEdge edge : edges) {
                    if (edge.isSelfLoop() || !this.isNotInLayer(edge)) continue;
                    this.addAdjacencyOf(edge);
                    ++this.size;
                    ++this.currentSize;
                }
            }
        }

        private List<LEdge> getEdgesConnectedTo(LPort port) {
            return this.side == PortSide.WEST ? port.getIncomingEdges() : port.getOutgoingEdges();
        }

        private boolean isNotInLayer(LEdge edge) {
            return edge.getSource().getNode().getLayer() != edge.getTarget().getNode().getLayer();
        }

        private void addAdjacencyOf(LEdge edge) {
            LPort adjacentPort = this.adjacentPortOf(edge, this.side);
            int adjacentPortPosition = BetweenLayerEdgeTwoNodeCrossingsCounter.this.portPositions.get(adjacentPort);
            int lastIndex = this.adjacencyList.size() - 1;
            if (!this.adjacencyList.isEmpty() && this.adjacencyList.get((int)lastIndex).position == adjacentPortPosition) {
                ++this.adjacencyList.get((int)lastIndex).cardinality;
                ++this.adjacencyList.get((int)lastIndex).currentCardinality;
            } else {
                this.adjacencyList.add(new Adjacency(adjacentPortPosition, adjacentPort));
            }
        }

        private LPort adjacentPortOf(LEdge e, PortSide s) {
            return s == PortSide.WEST ? e.getSource() : e.getTarget();
        }

        public void reset() {
            this.currentIndex = 0;
            this.currentSize = this.size;
            if (!this.isEmpty()) {
                this.currentAdjacency().reset();
            }
        }

        public int countAdjacenciesBelowNodeOfFirstPort() {
            return this.currentSize - this.currentAdjacency().currentCardinality;
        }

        public void removeFirst() {
            if (this.isEmpty()) {
                return;
            }
            Adjacency currentEntry = this.currentAdjacency();
            if (currentEntry.currentCardinality == 1) {
                this.incrementCurrentIndex();
            } else {
                --currentEntry.currentCardinality;
            }
            --this.currentSize;
        }

        private void incrementCurrentIndex() {
            ++this.currentIndex;
            if (this.currentIndex < this.adjacencyList.size()) {
                this.currentAdjacency().reset();
            }
        }

        public boolean isEmpty() {
            return this.currentSize == 0;
        }

        public int first() {
            return this.currentAdjacency().position;
        }

        public int size() {
            return this.currentSize;
        }

        private Adjacency currentAdjacency() {
            return this.adjacencyList.get(this.currentIndex);
        }

        public String toString() {
            return "AdjacencyList [node=" + String.valueOf(this.node) + ", adjacencies= " + String.valueOf(this.adjacencyList) + "]";
        }

        private class Adjacency
        implements Comparable<Adjacency> {
            private final int position;
            private int cardinality;
            private int currentCardinality;

            Adjacency(int adjacentPortPosition, LPort port) {
                this.position = adjacentPortPosition;
                this.cardinality = 1;
                this.currentCardinality = 1;
            }

            public void reset() {
                this.currentCardinality = this.cardinality;
            }

            @Override
            public int compareTo(Adjacency o) {
                return this.position < o.position ? -1 : (this.position == o.position ? 0 : 1);
            }

            public String toString() {
                return "Adjacency [position=" + this.position + ", cardinality=" + this.cardinality + ", currentCardinality=" + this.currentCardinality + "]";
            }
        }
    }
}

