/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p2layers;

import java.util.List;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LongestPathLayerer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> BASELINE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER).addBefore(LayeredPhases.P2_LAYERING, IntermediateProcessorStrategy.LAYER_CONSTRAINT_PREPROCESSOR).addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.LAYER_CONSTRAINT_POSTPROCESSOR);
    private LGraph layeredGraph;
    private int[] nodeHeights;

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return BASELINE_PROCESSING_CONFIGURATION;
    }

    @Override
    public void process(LGraph thelayeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Longest path layering", 1.0f);
        this.layeredGraph = thelayeredGraph;
        List<LNode> nodes = this.layeredGraph.getLayerlessNodes();
        this.nodeHeights = new int[nodes.size()];
        int index = 0;
        for (LNode node : nodes) {
            node.id = index;
            this.nodeHeights[index] = -1;
            ++index;
        }
        for (LNode node : nodes) {
            this.visit(node);
        }
        nodes.clear();
        this.layeredGraph = null;
        this.nodeHeights = null;
        monitor.done();
    }

    private int visit(LNode node) {
        int height = this.nodeHeights[node.id];
        if (height >= 0) {
            return height;
        }
        int maxHeight = 1;
        for (LPort port : node.getPorts()) {
            for (LEdge edge : port.getOutgoingEdges()) {
                LNode targetNode = edge.getTarget().getNode();
                if (node == targetNode) continue;
                int targetHeight = this.visit(targetNode);
                maxHeight = Math.max(maxHeight, targetHeight + 1);
            }
        }
        this.putNode(node, maxHeight);
        return maxHeight;
    }

    private void putNode(LNode node, int height) {
        List<Layer> layers = this.layeredGraph.getLayers();
        int i = layers.size();
        while (i < height) {
            layers.add(0, new Layer(this.layeredGraph));
            ++i;
        }
        node.setLayer(layers.get(layers.size() - height));
        this.nodeHeights[node.id] = height;
    }
}

