# Scheduler
<span class="source-link">[[Source]](src/runtime_info/scheduler.md#L-0-7)</span>

Provides functions that expose information about runtime schedulers.


```pony
primitive val Scheduler
```

## Constructors

### create
<span class="source-link">[[Source]](src/runtime_info/scheduler.md#L-0-7)</span>


```pony
new val create()
: Scheduler val^
```

#### Returns

* [Scheduler](runtime_info-Scheduler.md) val^

---

## Public Functions

### schedulers
<span class="source-link">[[Source]](src/runtime_info/scheduler.md#L-0-12)</span>


Returns the maximum number of schedulers available to run actors.


```pony
fun box schedulers(
  auth: SchedulerInfoAuth val)
: U32 val
```
#### Parameters

*   auth: [SchedulerInfoAuth](runtime_info-SchedulerInfoAuth.md) val

#### Returns

* [U32](builtin-U32.md) val

---

### active_schedulers
<span class="source-link">[[Source]](src/runtime_info/scheduler.md#L-0-18)</span>


Returns the number of schedulers currently available to run actors.


```pony
fun box active_schedulers(
  auth: SchedulerInfoAuth val)
: U32 val
```
#### Parameters

*   auth: [SchedulerInfoAuth](runtime_info-SchedulerInfoAuth.md) val

#### Returns

* [U32](builtin-U32.md) val

---

### minimum_schedulers
<span class="source-link">[[Source]](src/runtime_info/scheduler.md#L-0-24)</span>


Returns the minimum number of schedulers. The active number of schedulers is
guaranteed to never drop below this number.


```pony
fun box minimum_schedulers(
  auth: SchedulerInfoAuth val)
: U32 val
```
#### Parameters

*   auth: [SchedulerInfoAuth](runtime_info-SchedulerInfoAuth.md) val

#### Returns

* [U32](builtin-U32.md) val

---

### sleeping_schedulers
<span class="source-link">[[Source]](src/runtime_info/scheduler.md#L-0-31)</span>


Returns the number of schedulers that are currently sleeping and not
available run actors. Schedulers are put to sleep if there isn't enough
work to keep all of the possible schedulers busy.


```pony
fun box sleeping_schedulers(
  auth: SchedulerInfoAuth val)
: U32 val
```
#### Parameters

*   auth: [SchedulerInfoAuth](runtime_info-SchedulerInfoAuth.md) val

#### Returns

* [U32](builtin-U32.md) val

---

### scaling_is_active
<span class="source-link">[[Source]](src/runtime_info/scheduler.md#L-0-39)</span>


Returns true is scheduler scaling is on and the number of active schedulers
can change while the program is running based on load.


```pony
fun box scaling_is_active(
  auth: SchedulerInfoAuth val)
: Bool val
```
#### Parameters

*   auth: [SchedulerInfoAuth](runtime_info-SchedulerInfoAuth.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### will_yield_cpu
<span class="source-link">[[Source]](src/runtime_info/scheduler.md#L-0-46)</span>


Returns true if schedulers without work will yield the CPU allowing other
processes to have access.


```pony
fun box will_yield_cpu(
  auth: SchedulerInfoAuth val)
: Bool val
```
#### Parameters

*   auth: [SchedulerInfoAuth](runtime_info-SchedulerInfoAuth.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### scheduler_index
<span class="source-link">[[Source]](src/runtime_info/scheduler.md#L-0-53)</span>


Returns the index of the current scheduler thread


```pony
fun box scheduler_index(
  auth: SchedulerInfoAuth val)
: I32 val
```
#### Parameters

*   auth: [SchedulerInfoAuth](runtime_info-SchedulerInfoAuth.md) val

#### Returns

* [I32](builtin-I32.md) val

---

### eq
<span class="source-link">[[Source]](src/runtime_info/scheduler.md#L-0-12)</span>


```pony
fun box eq(
  that: Scheduler val)
: Bool val
```
#### Parameters

*   that: [Scheduler](runtime_info-Scheduler.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/runtime_info/scheduler.md#L-0-12)</span>


```pony
fun box ne(
  that: Scheduler val)
: Bool val
```
#### Parameters

*   that: [Scheduler](runtime_info-Scheduler.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

