/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class SimpleType
extends AstType {
    public SimpleType(String identifier) {
        this(identifier, EMPTY_TYPES);
    }

    public SimpleType(Identifier identifier) {
        this.setIdentifierToken(identifier);
    }

    public SimpleType(String identifier, TextLocation location) {
        this.setChildByRole(Roles.IDENTIFIER, Identifier.create(identifier, location));
    }

    public SimpleType(String identifier, Iterable<AstType> typeArguments) {
        this.setIdentifier(identifier);
        if (typeArguments != null) {
            for (AstType typeArgument : typeArguments) {
                this.addChild(typeArgument, Roles.TYPE_ARGUMENT);
            }
        }
    }

    public SimpleType(String identifier, AstType ... typeArguments) {
        this.setIdentifier(identifier);
        if (typeArguments != null) {
            for (AstType typeArgument : typeArguments) {
                this.addChild(typeArgument, Roles.TYPE_ARGUMENT);
            }
        }
    }

    public final String getIdentifier() {
        return this.getChildByRole(Roles.IDENTIFIER).getName();
    }

    public final void setIdentifier(String value) {
        this.setChildByRole(Roles.IDENTIFIER, Identifier.create(value));
    }

    public final Identifier getIdentifierToken() {
        return this.getChildByRole(Roles.IDENTIFIER);
    }

    public final void setIdentifierToken(Identifier value) {
        this.setChildByRole(Roles.IDENTIFIER, value);
    }

    public final AstNodeCollection<AstType> getTypeArguments() {
        return this.getChildrenByRole(Roles.TYPE_ARGUMENT);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitSimpleType(this, data);
    }

    @Override
    public String toString() {
        AstNodeCollection<AstType> typeArguments = this.getTypeArguments();
        if (typeArguments.isEmpty()) {
            return this.getIdentifier();
        }
        StringBuilder sb = new StringBuilder(this.getIdentifier()).append('<');
        boolean first = true;
        for (AstType typeArgument : typeArguments) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(typeArgument);
        }
        return sb.append('>').toString();
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof SimpleType) {
            SimpleType otherType = (SimpleType)other;
            return !other.isNull() && SimpleType.matchString(this.getIdentifier(), otherType.getIdentifier()) && this.getTypeArguments().matches(otherType.getTypeArguments(), match);
        }
        return false;
    }
}

