\name{InverseDisplacementFieldImageFilter}
\alias{InverseDisplacementFieldImageFilter}
\title{InverseDisplacementFieldImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes the inverse of a displacement field.
InverseDisplacementFieldImageFilter}
\details{
InverseDisplacementFieldImageFilter takes a displacement field as input and computes the displacement
field that is its inverse. If the input displacement field was mapping
coordinates from a space A into a space B, the output of this filter
will map coordinates from the space B into the space A.
Given that both the input and output displacement field are
represented as discrete images with pixel type vector, the inverse
will be only an estimation and will probably not correspond to a
perfect inverse. The precision of the inverse can be improved at the
price of increasing the computation time and memory consumption in
this filter.
The method used for computing the inverse displacement field is to
subsample the input field using a regular grid and create Kerned-Base
Spline in which the reference landmarks are the coordinates of the
deformed point and the target landmarks are the negative of the
displacement vectors. The kernel-base spline is then used for
regularly sampling the output space and recover vector values for
every single pixel.
The subsampling factor used for the regular grid of the input field
will determine the number of landmarks in the KernelBased spline and
therefore it will have a dramatic effect on both the precision of
output displacement field and the computational time required for the
filter to complete the estimation. A large subsampling factor will
result in few landmarks in the KernelBased spline, therefore on fast
computation and low precision. A small subsampling factor will result
in a large number of landmarks in the KernelBased spline, therefore a
large memory consumption, long computation time and high precision for
the inverse estimation.
This filter expects both the input and output images to be of pixel
type Vector .
See:
InverseDisplacementField for the procedural interface
itk::InverseDisplacementFieldImageFilter for the Doxygen on the original ITK class.
InverseDisplacementFieldImageFilter}
%C++ includes: sitkInverseDisplacementFieldImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< double > GetOutputOrigin() const:}{
Get the output image origin.
}
\item{std::vector< double > GetOutputSpacing() const:}{
Get the output image spacing.
}
\item{std::vector< uint32_t > GetSize() const:}{
Get the size of the output image.
}
\item{unsigned int GetSubsamplingFactor() const:}{
Set/Get the factor used for subsampling the input displacement field.
A large value in this factor will produce a fast computation of the
inverse field but with low precision. A small value of this factor
will produce a precise computation of the inverse field at the price
of large memory consumption and long computational time.
}
\item{ InverseDisplacementFieldImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetOutputOrigin(std::vector< double > OutputOrigin):}{
Set the output image origin.
}
\item{Self SetOutputSpacing(std::vector< double > OutputSpacing):}{
Set the output image spacing.
}
\item{void SetReferenceImage(const Image &refImage):}{
This methods sets the output size, origin, and direction to that of
the provided image
}
\item{Self SetSize(std::vector< uint32_t > Size):}{
Set the size of the output image.
}
\item{Self SetSubsamplingFactor(unsigned int SubsamplingFactor):}{
Set/Get the factor used for subsampling the input displacement field.
A large value in this factor will produce a fast computation of the
inverse field but with low precision. A small value of this factor
will produce a precise computation of the inverse field at the price
of large memory consumption and long computational time.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~InverseDisplacementFieldImageFilter():}{
Destructor
}
}
}
