
# 11 "plugins/ltac/coretactics.mlg"
 

open Util
open Locus
open Tactypes
open Genredexpr
open Stdarg
open Extraargs
open Tacarg
open Names
open Logic


# 17 "plugins/ltac/coretactics.ml"

let _ = Mltop.add_known_module "rocq-runtime.plugins.ltac"
let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "reflexivity" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("reflexivity", Tacentries.TyNil), 
           (fun ist -> 
# 30 "plugins/ltac/coretactics.mlg"
                         Tactics.intros_reflexivity 
# 25 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "exact" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("exact", Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_uconstr), 
                                                         Tacentries.TyNil)), 
           (fun c ist -> 
# 34 "plugins/ltac/coretactics.mlg"
                              Internals.exact ist c 
# 35 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "assumption" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("assumption", Tacentries.TyNil), 
           (fun ist -> 
# 38 "plugins/ltac/coretactics.mlg"
                        Tactics.assumption 
# 43 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "etransitivity" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("etransitivity", Tacentries.TyNil), 
           (fun ist -> 
# 42 "plugins/ltac/coretactics.mlg"
                           Tactics.intros_transitivity None 
# 51 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "cut" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("cut", Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                       Tacentries.TyNil)), 
           (fun c ist -> 
# 46 "plugins/ltac/coretactics.mlg"
                           Tactics.cut c 
# 61 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "exact_no_check" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("exact_no_check", Tacentries.TyArg (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                  Tacentries.TyNil)), 
           (fun c ist -> 
# 50 "plugins/ltac/coretactics.mlg"
                                      Tactics.exact_no_check c 
# 71 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "vm_cast_no_check" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("vm_cast_no_check", Tacentries.TyArg (
                                                                    Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                    Tacentries.TyNil)), 
           (fun c ist -> 
# 54 "plugins/ltac/coretactics.mlg"
                                        Tactics.vm_cast_no_check c 
# 81 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "native_cast_no_check" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("native_cast_no_check", 
                            Tacentries.TyArg (Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                            Tacentries.TyNil)), (fun c ist -> 
# 58 "plugins/ltac/coretactics.mlg"
                                            Tactics.native_cast_no_check c 
# 90 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "exfalso" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("exfalso", Tacentries.TyNil), 
           (fun ist -> 
# 62 "plugins/ltac/coretactics.mlg"
                     Tactics.exfalso 
# 98 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "lapply" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("lapply", Tacentries.TyArg (
                                                          Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                          Tacentries.TyNil)), 
           (fun c ist -> 
# 66 "plugins/ltac/coretactics.mlg"
                              Tactics.cut_and_apply c 
# 108 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "transitivity" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("transitivity", Tacentries.TyArg (
                                                                Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                                Tacentries.TyNil)), 
           (fun c ist -> 
# 70 "plugins/ltac/coretactics.mlg"
                                    Tactics.intros_transitivity (Some c) 
# 118 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "left" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("left", Tacentries.TyNil), 
           (fun ist -> 
# 76 "plugins/ltac/coretactics.mlg"
                  Tactics.left_with_bindings false NoBindings 
# 126 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "eleft" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("eleft", Tacentries.TyNil), 
           (fun ist -> 
# 80 "plugins/ltac/coretactics.mlg"
                   Tactics.left_with_bindings true NoBindings 
# 134 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "left_with" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("left", Tacentries.TyIdent ("with", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_bindings), 
                                                        Tacentries.TyNil))), 
           (fun bl ist -> 
# 84 "plugins/ltac/coretactics.mlg"
                                     
    Tacticals.tclDELAYEDWITHHOLES false bl (fun bl -> Tactics.left_with_bindings false bl)
  
# 147 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "eleft_with" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("eleft", Tacentries.TyIdent ("with", 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_bindings), 
                                                         Tacentries.TyNil))), 
           (fun bl ist -> 
# 90 "plugins/ltac/coretactics.mlg"
                                      
    Tacticals.tclDELAYEDWITHHOLES true bl (fun bl -> Tactics.left_with_bindings true bl)
  
# 160 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "right" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("right", Tacentries.TyNil), 
           (fun ist -> 
# 98 "plugins/ltac/coretactics.mlg"
                   Tactics.right_with_bindings false NoBindings 
# 168 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "eright" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("eright", Tacentries.TyNil), 
           (fun ist -> 
# 102 "plugins/ltac/coretactics.mlg"
                    Tactics.right_with_bindings true NoBindings 
# 176 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "right_with" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("right", Tacentries.TyIdent ("with", 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_bindings), 
                                                         Tacentries.TyNil))), 
           (fun bl ist -> 
# 106 "plugins/ltac/coretactics.mlg"
                                      
    Tacticals.tclDELAYEDWITHHOLES false bl (fun bl -> Tactics.right_with_bindings false bl)
  
# 189 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "eright_with" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("eright", Tacentries.TyIdent ("with", 
                                                          Tacentries.TyArg (
                                                          Extend.TUentry (Genarg.get_arg_tag wit_bindings), 
                                                          Tacentries.TyNil))), 
           (fun bl ist -> 
# 112 "plugins/ltac/coretactics.mlg"
                                       
    Tacticals.tclDELAYEDWITHHOLES true bl (fun bl -> Tactics.right_with_bindings true bl)
  
# 202 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "constructor" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("constructor", Tacentries.TyNil), 
           (fun ist -> 
# 120 "plugins/ltac/coretactics.mlg"
                         Tactics.any_constructor false None 
# 210 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("constructor", Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var), 
                                                              Tacentries.TyNil)), 
          (fun i ist -> 
# 121 "plugins/ltac/coretactics.mlg"
                                      
    Tactics.constructor_tac false None i NoBindings
  
# 220 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("constructor", Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var), 
                                                              Tacentries.TyIdent ("with", 
                                                              Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_bindings), 
                                                              Tacentries.TyNil)))), 
          (fun i bl ist -> 
# 124 "plugins/ltac/coretactics.mlg"
                                                          
    let tac bl = Tactics.constructor_tac false None i bl in
    Tacticals.tclDELAYEDWITHHOLES false bl tac
  
# 234 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "econstructor" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("econstructor", Tacentries.TyNil), 
           (fun ist -> 
# 131 "plugins/ltac/coretactics.mlg"
                          Tactics.any_constructor true None 
# 242 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("econstructor", Tacentries.TyArg (
                                                               Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var), 
                                                               Tacentries.TyNil)), 
          (fun i ist -> 
# 132 "plugins/ltac/coretactics.mlg"
                                       
    Tactics.constructor_tac true None i NoBindings
  
# 252 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("econstructor", Tacentries.TyArg (
                                                               Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var), 
                                                               Tacentries.TyIdent ("with", 
                                                               Tacentries.TyArg (
                                                               Extend.TUentry (Genarg.get_arg_tag wit_bindings), 
                                                               Tacentries.TyNil)))), 
          (fun i bl ist -> 
# 135 "plugins/ltac/coretactics.mlg"
                                                           
    let tac bl = Tactics.constructor_tac true None i bl in
    Tacticals.tclDELAYEDWITHHOLES true bl tac
  
# 266 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "specialize" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("specialize", Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_constr_with_bindings), 
                                                              Tacentries.TyNil)), 
           (fun c ist -> 
# 144 "plugins/ltac/coretactics.mlg"
                                               
    Tacticals.tclDELAYEDWITHHOLES false c (fun c -> Tactics.specialize c None)
  
# 278 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("specialize", Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_constr_with_bindings), 
                                                             Tacentries.TyIdent ("as", 
                                                             Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_simple_intropattern), 
                                                             Tacentries.TyNil)))), 
          (fun c ipat ist -> 
# 147 "plugins/ltac/coretactics.mlg"
                                                                              
    Tacticals.tclDELAYEDWITHHOLES false c (fun c -> Tactics.specialize c (Some ipat))
  
# 291 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "symmetry" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("symmetry", Tacentries.TyNil), 
           (fun ist -> 
# 153 "plugins/ltac/coretactics.mlg"
                      Tactics.intros_symmetry {onhyps=Some[];concl_occs=AllOccurrences} 
# 299 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "symmetry_in" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("symmetry", Tacentries.TyIdent ("in", 
                                                            Tacentries.TyArg (
                                                            Extend.TUentry (Genarg.get_arg_tag wit_in_clause), 
                                                            Tacentries.TyNil))), 
           (fun cl ist -> 
# 157 "plugins/ltac/coretactics.mlg"
                                         Tactics.intros_symmetry cl 
# 310 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "split" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("split", Tacentries.TyNil), 
           (fun ist -> 
# 163 "plugins/ltac/coretactics.mlg"
                   Tactics.split_with_bindings false [NoBindings] 
# 318 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "esplit" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("esplit", Tacentries.TyNil), 
           (fun ist -> 
# 167 "plugins/ltac/coretactics.mlg"
                    Tactics.split_with_bindings true [NoBindings] 
# 326 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "split_with" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("split", Tacentries.TyIdent ("with", 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_bindings), 
                                                         Tacentries.TyNil))), 
           (fun bl ist -> 
# 171 "plugins/ltac/coretactics.mlg"
                                      
    Tacticals.tclDELAYEDWITHHOLES false bl (fun bl -> Tactics.split_with_bindings false [bl])
  
# 339 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "esplit_with" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("esplit", Tacentries.TyIdent ("with", 
                                                          Tacentries.TyArg (
                                                          Extend.TUentry (Genarg.get_arg_tag wit_bindings), 
                                                          Tacentries.TyNil))), 
           (fun bl ist -> 
# 177 "plugins/ltac/coretactics.mlg"
                                       
    Tacticals.tclDELAYEDWITHHOLES true bl (fun bl -> Tactics.split_with_bindings true [bl])
  
# 352 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "exists" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("exists", Tacentries.TyNil), 
           (fun ist -> 
# 183 "plugins/ltac/coretactics.mlg"
                    Tactics.split_with_bindings false [NoBindings] 
# 360 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("exists", Tacentries.TyArg (
                                                         Extend.TUlist1sep (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_bindings), ","), 
                                                         Tacentries.TyNil)), 
          (fun bll ist -> 
# 184 "plugins/ltac/coretactics.mlg"
                                                   Tactics.split_with_delayed_bindings false bll 
# 369 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "eexists" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("eexists", Tacentries.TyNil), 
           (fun ist -> 
# 188 "plugins/ltac/coretactics.mlg"
                     Tactics.split_with_bindings true [NoBindings] 
# 377 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("eexists", Tacentries.TyArg (
                                                          Extend.TUlist1sep (
                                                          Extend.TUentry (Genarg.get_arg_tag wit_bindings), ","), 
                                                          Tacentries.TyNil)), 
          (fun bll ist -> 
# 189 "plugins/ltac/coretactics.mlg"
                                                    Tactics.split_with_delayed_bindings true bll 
# 386 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "intros_until" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("intros", Tacentries.TyIdent ("until", 
                                                          Tacentries.TyArg (
                                                          Extend.TUentry (Genarg.get_arg_tag wit_quantified_hypothesis), 
                                                          Tacentries.TyNil))), 
           (fun h ist -> 
# 195 "plugins/ltac/coretactics.mlg"
                                                     Tactics.intros_until h 
# 397 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "intro" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("intro", Tacentries.TyNil), 
           (fun ist -> 
# 199 "plugins/ltac/coretactics.mlg"
                   Tactics.intro_move None MoveLast 
# 405 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("intro", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ident), 
                                                        Tacentries.TyNil)), 
          (fun id ist -> 
# 200 "plugins/ltac/coretactics.mlg"
                             Tactics.intro_move (Some id) MoveLast 
# 413 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("intro", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ident), 
                                                        Tacentries.TyIdent ("at", 
                                                        Tacentries.TyIdent ("top", 
                                                        Tacentries.TyNil)))), 
          (fun id ist -> 
# 201 "plugins/ltac/coretactics.mlg"
                                        Tactics.intro_move (Some id) MoveFirst 
# 423 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("intro", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ident), 
                                                        Tacentries.TyIdent ("at", 
                                                        Tacentries.TyIdent ("bottom", 
                                                        Tacentries.TyNil)))), 
          (fun id ist -> 
# 202 "plugins/ltac/coretactics.mlg"
                                           Tactics.intro_move (Some id) MoveLast 
# 433 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("intro", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ident), 
                                                        Tacentries.TyIdent ("after", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                        Tacentries.TyNil)))), 
          (fun id h ist -> 
# 203 "plugins/ltac/coretactics.mlg"
                                            Tactics.intro_move (Some id) (MoveAfter h) 
# 444 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("intro", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ident), 
                                                        Tacentries.TyIdent ("before", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                        Tacentries.TyNil)))), 
          (fun id h ist -> 
# 204 "plugins/ltac/coretactics.mlg"
                                             Tactics.intro_move (Some id) (MoveBefore h) 
# 455 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("intro", Tacentries.TyIdent ("at", 
                                                        Tacentries.TyIdent ("top", 
                                                        Tacentries.TyNil))), 
          (fun ist -> 
# 205 "plugins/ltac/coretactics.mlg"
                              Tactics.intro_move None MoveFirst 
# 463 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("intro", Tacentries.TyIdent ("at", 
                                                        Tacentries.TyIdent ("bottom", 
                                                        Tacentries.TyNil))), 
          (fun ist -> 
# 206 "plugins/ltac/coretactics.mlg"
                                 Tactics.intro_move None MoveLast 
# 471 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("intro", Tacentries.TyIdent ("after", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                        Tacentries.TyNil))), 
          (fun h ist -> 
# 207 "plugins/ltac/coretactics.mlg"
                                  Tactics.intro_move None (MoveAfter h) 
# 480 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("intro", Tacentries.TyIdent ("before", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                        Tacentries.TyNil))), 
          (fun h ist -> 
# 208 "plugins/ltac/coretactics.mlg"
                                   Tactics.intro_move None (MoveBefore h) 
# 489 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "move" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("move", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                        Tacentries.TyIdent ("at", 
                                                        Tacentries.TyIdent ("top", 
                                                        Tacentries.TyNil)))), 
           (fun id ist -> 
# 214 "plugins/ltac/coretactics.mlg"
                                     Tactics.move_hyp id MoveFirst 
# 501 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("move", Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                       Tacentries.TyIdent ("at", 
                                                       Tacentries.TyIdent ("bottom", 
                                                       Tacentries.TyNil)))), 
          (fun id ist -> 
# 215 "plugins/ltac/coretactics.mlg"
                                        Tactics.move_hyp id MoveLast 
# 511 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("move", Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                       Tacentries.TyIdent ("after", 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                       Tacentries.TyNil)))), 
          (fun id h ist -> 
# 216 "plugins/ltac/coretactics.mlg"
                                         Tactics.move_hyp id (MoveAfter h) 
# 522 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("move", Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                       Tacentries.TyIdent ("before", 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                       Tacentries.TyNil)))), 
          (fun id h ist -> 
# 217 "plugins/ltac/coretactics.mlg"
                                          Tactics.move_hyp id (MoveBefore h) 
# 533 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "rename" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("rename", Tacentries.TyArg (
                                                          Extend.TUlist1sep (
                                                          Extend.TUentry (Genarg.get_arg_tag wit_rename), ","), 
                                                          Tacentries.TyNil)), 
           (fun ids ist -> 
# 223 "plugins/ltac/coretactics.mlg"
                                                 Tactics.rename_hyp ids 
# 544 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "revert" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("revert", Tacentries.TyArg (
                                                          Extend.TUlist1 (
                                                          Extend.TUentry (Genarg.get_arg_tag wit_hyp)), 
                                                          Tacentries.TyNil)), 
           (fun hl ist -> 
# 229 "plugins/ltac/coretactics.mlg"
                                    Generalize.revert hl 
# 555 "plugins/ltac/coretactics.ml"
)))]


# 234 "plugins/ltac/coretactics.mlg"
 

let simple_induct h =
  Tacticals.tclTHEN (Tactics.intros_until h)
    (Tacticals.onLastHyp Tactics.simplest_elim)


# 567 "plugins/ltac/coretactics.ml"

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "simple_induction" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("simple", Tacentries.TyIdent ("induction", 
                                                          Tacentries.TyArg (
                                                          Extend.TUentry (Genarg.get_arg_tag wit_quantified_hypothesis), 
                                                          Tacentries.TyNil))), 
           (fun h ist -> 
# 243 "plugins/ltac/coretactics.mlg"
                                                         simple_induct h 
# 577 "plugins/ltac/coretactics.ml"
)))]


# 246 "plugins/ltac/coretactics.mlg"
 

let simple_destruct h =
  Tacticals.tclTHEN (Tactics.intros_until h)
    (Tacticals.onLastHyp Tactics.simplest_case)


# 589 "plugins/ltac/coretactics.ml"

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "simple_destruct" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("simple", Tacentries.TyIdent ("destruct", 
                                                          Tacentries.TyArg (
                                                          Extend.TUentry (Genarg.get_arg_tag wit_quantified_hypothesis), 
                                                          Tacentries.TyNil))), 
           (fun h ist -> 
# 255 "plugins/ltac/coretactics.mlg"
                                                        simple_destruct h 
# 599 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "admit" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("admit", Tacentries.TyNil), 
           (fun ist -> 
# 261 "plugins/ltac/coretactics.mlg"
                  Proofview.give_up 
# 607 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "fix" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("fix", Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ident), 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_natural), 
                                                       Tacentries.TyNil))), 
           (fun id n ist -> 
# 267 "plugins/ltac/coretactics.mlg"
                                      Tactics.fix id n 
# 619 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "cofix" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("cofix", Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_ident), 
                                                         Tacentries.TyNil)), 
           (fun id ist -> 
# 273 "plugins/ltac/coretactics.mlg"
                             Tactics.cofix id 
# 629 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "clear" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("clear", Tacentries.TyArg (
                                                         Extend.TUlist0 (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_hyp)), 
                                                         Tacentries.TyNil)), 
           (fun ids ist -> 
# 279 "plugins/ltac/coretactics.mlg"
                                
    if List.is_empty ids then Tactics.keep []
    else Tactics.clear ids
  
# 643 "plugins/ltac/coretactics.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("clear", Tacentries.TyIdent ("-", 
                                                        Tacentries.TyArg (
                                                        Extend.TUlist1 (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_hyp)), 
                                                        Tacentries.TyNil))), 
          (fun ids ist -> 
# 283 "plugins/ltac/coretactics.mlg"
                                        Tactics.keep ids 
# 653 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "clearbody" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("clearbody", Tacentries.TyArg (
                                                             Extend.TUlist1 (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_hyp)), 
                                                             Tacentries.TyNil)), 
           (fun ids ist -> 
# 289 "plugins/ltac/coretactics.mlg"
                                        Tactics.clear_body ids 
# 664 "plugins/ltac/coretactics.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "generalize_dependent" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("generalize", Tacentries.TyIdent ("dependent", 
                                                              Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                              Tacentries.TyNil))), 
           (fun c ist -> 
# 295 "plugins/ltac/coretactics.mlg"
                                              Generalize.generalize_dep c 
# 675 "plugins/ltac/coretactics.ml"
)))]


# 300 "plugins/ltac/coretactics.mlg"
 

open Tacexpr

let initial_atomic () =
  let nocl = {onhyps=Some[];concl_occs=AllOccurrences} in
  let iter (s, t) =
    let body = CAst.make (TacAtom t) in
    Tacenv.register_ltac false false (Names.Id.of_string s) body
  in
  let () = List.iter iter
      [ "red", TacReduce (Red, nocl);
        "hnf", TacReduce(Hnf,nocl);
        "simpl", TacReduce(Simpl (Redops.all_flags,None),nocl);
        "compute", TacReduce(Cbv Redops.all_flags,nocl);
        "intros", TacIntroPattern (false,[]);
      ]
  in
  let iter (s, t) = Tacenv.register_ltac false false (Names.Id.of_string s) t in
  List.iter iter
      [ "idtac", CAst.make (TacId []);
        "fail", CAst.make (TacFail (TacLocal,ArgArg 0,[]));
        "fresh", CAst.make @@ TacArg(TacFreshId [])
      ]

let () = Mltop.declare_cache_obj initial_atomic "rocq-runtime.plugins.ltac"

(* First-class Ltac access to primitive blocks *)

let initial_name s = { mltac_plugin = "rocq-runtime.plugins.ltac"; mltac_tactic = s; }
let initial_entry s = { mltac_name = initial_name s; mltac_index = 0; }

let register_list_tactical name f =
  let tac args ist = match args with
  | [v] ->
    begin match Tacinterp.Value.to_list v with
    | None -> Tacticals.tclZEROMSG (Pp.str "Expected a list")
    | Some tacs ->
      let tacs = List.map (fun tac -> Tacinterp.tactic_of_value ist tac) tacs in
      f tacs
    end
  | _ -> assert false
  in
  Tacenv.register_ml_tactic (initial_name name) [|tac|]

let () = register_list_tactical "first" Tacticals.tclFIRST
let () = register_list_tactical "solve" Tacticals.tclSOLVE

let initial_tacticals () =
  let idn n = Id.of_string (Printf.sprintf "_%i" n) in
  let varn n = Reference (ArgVar (CAst.make (idn n))) in
  let iter (s, t) = Tacenv.register_ltac false false (Id.of_string s) t in
  List.iter iter [
    "first", CAst.make (TacFun
        ([Name (idn 0)], CAst.make (TacML (initial_entry "first", [varn 0]))));
    "solve", CAst.make (TacFun
        ([Name (idn 0)], CAst.make (TacML (initial_entry "solve", [varn 0]))));
  ]

let () = Mltop.declare_cache_obj initial_tacticals "rocq-runtime.plugins.ltac"


# 742 "plugins/ltac/coretactics.ml"

