/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.repository;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.ManagerFactory;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroup;
import com.ibm.db2.cmx.runtime.internal.repository.api.RuntimeGroupManager;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.PureQueryUtility;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import com.ibm.db2.cmx.tools.internal.repository.DefaultActionProcessor;
import com.ibm.db2.cmx.tools.internal.repository.ManageRepositoryUtility;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.List;

public class ListActionProcessor
extends DefaultActionProcessor {
    @Override
    public PureQueryUtility.UtilityResult processAction(PossibleArgs possibleArgs, ArtifactOptionsSet artifactOptionsSet, Connection connection, String string, RepositoryVersion repositoryVersion, PrintWriter printWriter) throws MetadataException {
        PureQueryUtility.UtilityResult utilityResult = null;
        utilityResult = this.listRuntimeGroupVersions(artifactOptionsSet, connection, string, printWriter);
        return utilityResult;
    }

    private PureQueryUtility.UtilityResult listRuntimeGroupVersions(ArtifactOptionsSet artifactOptionsSet, Connection connection, String string, PrintWriter printWriter) throws MetadataException {
        String string2 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_ID);
        RuntimeGroupManager runtimeGroupManager = ManagerFactory.getRuntimeGroupManager(connection, string);
        List<RuntimeGroup> list = runtimeGroupManager.list();
        if (string2 == null) {
            for (RuntimeGroup runtimeGroup : list) {
                if (runtimeGroup.isActive()) {
                    printWriter.println(runtimeGroup.getName() + "  " + runtimeGroup.getVersion() + " " + Messages.getText("MSG_RUNTIME_GROUP_ACTIVE", new Object[0]));
                    continue;
                }
                printWriter.println(runtimeGroup.getName() + "  " + runtimeGroup.getVersion());
            }
        } else if (ManageRepositoryUtility.runtimeGroupExists(string2, runtimeGroupManager)) {
            List<String> list2 = ManageRepositoryUtility.getRuntimeGroupVersions(string2, runtimeGroupManager, printWriter);
            for (String string3 : list2) {
                printWriter.println(string2 + "  " + string3);
            }
        } else {
            PureQueryUtility.UtilityResult utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.FAILURE);
            utilityResult.reason = Messages.getText("MSG_ERROR_RUNTIMEGROUP_NOT_FOUND", string2);
            return utilityResult;
        }
        return new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS);
    }
}

