# This file was automatically generated by running:
#
#   scripts/generate_grapheme_properties.cr
#
# DO NOT EDIT

struct String::Grapheme
  # :nodoc:
  #
  # The Grapheme Cluster Break Property values
  # http://www.unicode.org/reports/tr29/#Grapheme_Cluster_Break_Property_Values
  enum Property
    Start
    Any
    Prepend
    CR
    LF
    Control
    Extend
    RegionalIndicator
    SpacingMark
    L
    V
    T
    LV
    LVT
    ZWJ
    ExtendedPictographic

    ExtendedPlusZeroWidth

    # returns the Unicode property value (see `Codepoints` constants below)
    # of the given code point
    def self.from(char : Char)
      r = char.ord
      # run a binary search
      f = 0
      t = Grapheme.codepoints.size
      while t > f
        mid = (f + t) // 2
        cp = Grapheme.codepoints[mid]
        if r < cp[0]
          t = mid
          next
        end
        if r > cp[1]
          f = mid + 1
          next
        end
        return cp[2]
      end
      Property::Any
    end
  end

  # Maps code point ranges to their properties. In the context of this package,
  # any code point that is not contained may map to `Property::Any`. The code point
  # ranges in this slice are numerically sorted.
  #
  # These ranges were taken from
  # http://www.unicode.org/Public/17.0.0/ucd/auxiliary/GraphemeBreakProperty.txt
  # as well as
  # http://www.unicode.org/Public/17.0.0/ucd/emoji/emoji-data.txt
  # ("Extended_Pictographic" only). See
  # https://www.unicode.org/license.html for the Unicode license agreement.
  @@codepoints : Array(Tuple(Int32, Int32, Property))?

  # :nodoc:
  protected def self.codepoints
    @@codepoints ||= begin
      data = Array(Tuple(Int32, Int32, Property)).new(1540)
      put(data, 0x0000, 0x0009, Property::Control)
      put(data, 0x000A, 0x000A, Property::LF)
      put(data, 0x000B, 0x000C, Property::Control)
      put(data, 0x000D, 0x000D, Property::CR)
      put(data, 0x000E, 0x001F, Property::Control)
      put(data, 0x007F, 0x009F, Property::Control)
      put(data, 0x00AD, 0x00AD, Property::Control)
      put(data, 0x0300, 0x036F, Property::Extend)
      put(data, 0x0483, 0x0489, Property::Extend)
      put(data, 0x0591, 0x05BD, Property::Extend)
      put(data, 0x05BF, 0x05BF, Property::Extend)
      put(data, 0x05C1, 0x05C2, Property::Extend)
      put(data, 0x05C4, 0x05C5, Property::Extend)
      put(data, 0x05C7, 0x05C7, Property::Extend)
      put(data, 0x0600, 0x0605, Property::Prepend)
      put(data, 0x0610, 0x061A, Property::Extend)
      put(data, 0x061C, 0x061C, Property::Control)
      put(data, 0x064B, 0x065F, Property::Extend)
      put(data, 0x0670, 0x0670, Property::Extend)
      put(data, 0x06D6, 0x06DC, Property::Extend)
      put(data, 0x06DD, 0x06DD, Property::Prepend)
      put(data, 0x06DF, 0x06E4, Property::Extend)
      put(data, 0x06E7, 0x06E8, Property::Extend)
      put(data, 0x06EA, 0x06ED, Property::Extend)
      put(data, 0x070F, 0x070F, Property::Prepend)
      put(data, 0x0711, 0x0711, Property::Extend)
      put(data, 0x0730, 0x074A, Property::Extend)
      put(data, 0x07A6, 0x07B0, Property::Extend)
      put(data, 0x07EB, 0x07F3, Property::Extend)
      put(data, 0x07FD, 0x07FD, Property::Extend)
      put(data, 0x0816, 0x0819, Property::Extend)
      put(data, 0x081B, 0x0823, Property::Extend)
      put(data, 0x0825, 0x0827, Property::Extend)
      put(data, 0x0829, 0x082D, Property::Extend)
      put(data, 0x0859, 0x085B, Property::Extend)
      put(data, 0x0890, 0x0891, Property::Prepend)
      put(data, 0x0897, 0x089F, Property::Extend)
      put(data, 0x08CA, 0x08E1, Property::Extend)
      put(data, 0x08E2, 0x08E2, Property::Prepend)
      put(data, 0x08E3, 0x0902, Property::Extend)
      put(data, 0x0903, 0x0903, Property::SpacingMark)
      put(data, 0x093A, 0x093A, Property::Extend)
      put(data, 0x093B, 0x093B, Property::SpacingMark)
      put(data, 0x093C, 0x093C, Property::Extend)
      put(data, 0x093E, 0x0940, Property::SpacingMark)
      put(data, 0x0941, 0x0948, Property::Extend)
      put(data, 0x0949, 0x094C, Property::SpacingMark)
      put(data, 0x094D, 0x094D, Property::Extend)
      put(data, 0x094E, 0x094F, Property::SpacingMark)
      put(data, 0x0951, 0x0957, Property::Extend)
      put(data, 0x0962, 0x0963, Property::Extend)
      put(data, 0x0981, 0x0981, Property::Extend)
      put(data, 0x0982, 0x0983, Property::SpacingMark)
      put(data, 0x09BC, 0x09BC, Property::Extend)
      put(data, 0x09BE, 0x09BE, Property::Extend)
      put(data, 0x09BF, 0x09C0, Property::SpacingMark)
      put(data, 0x09C1, 0x09C4, Property::Extend)
      put(data, 0x09C7, 0x09C8, Property::SpacingMark)
      put(data, 0x09CB, 0x09CC, Property::SpacingMark)
      put(data, 0x09CD, 0x09CD, Property::Extend)
      put(data, 0x09D7, 0x09D7, Property::Extend)
      put(data, 0x09E2, 0x09E3, Property::Extend)
      put(data, 0x09FE, 0x09FE, Property::Extend)
      put(data, 0x0A01, 0x0A02, Property::Extend)
      put(data, 0x0A03, 0x0A03, Property::SpacingMark)
      put(data, 0x0A3C, 0x0A3C, Property::Extend)
      put(data, 0x0A3E, 0x0A40, Property::SpacingMark)
      put(data, 0x0A41, 0x0A42, Property::Extend)
      put(data, 0x0A47, 0x0A48, Property::Extend)
      put(data, 0x0A4B, 0x0A4D, Property::Extend)
      put(data, 0x0A51, 0x0A51, Property::Extend)
      put(data, 0x0A70, 0x0A71, Property::Extend)
      put(data, 0x0A75, 0x0A75, Property::Extend)
      put(data, 0x0A81, 0x0A82, Property::Extend)
      put(data, 0x0A83, 0x0A83, Property::SpacingMark)
      put(data, 0x0ABC, 0x0ABC, Property::Extend)
      put(data, 0x0ABE, 0x0AC0, Property::SpacingMark)
      put(data, 0x0AC1, 0x0AC5, Property::Extend)
      put(data, 0x0AC7, 0x0AC8, Property::Extend)
      put(data, 0x0AC9, 0x0AC9, Property::SpacingMark)
      put(data, 0x0ACB, 0x0ACC, Property::SpacingMark)
      put(data, 0x0ACD, 0x0ACD, Property::Extend)
      put(data, 0x0AE2, 0x0AE3, Property::Extend)
      put(data, 0x0AFA, 0x0AFF, Property::Extend)
      put(data, 0x0B01, 0x0B01, Property::Extend)
      put(data, 0x0B02, 0x0B03, Property::SpacingMark)
      put(data, 0x0B3C, 0x0B3C, Property::Extend)
      put(data, 0x0B3E, 0x0B3F, Property::Extend)
      put(data, 0x0B40, 0x0B40, Property::SpacingMark)
      put(data, 0x0B41, 0x0B44, Property::Extend)
      put(data, 0x0B47, 0x0B48, Property::SpacingMark)
      put(data, 0x0B4B, 0x0B4C, Property::SpacingMark)
      put(data, 0x0B4D, 0x0B4D, Property::Extend)
      put(data, 0x0B55, 0x0B57, Property::Extend)
      put(data, 0x0B62, 0x0B63, Property::Extend)
      put(data, 0x0B82, 0x0B82, Property::Extend)
      put(data, 0x0BBE, 0x0BBE, Property::Extend)
      put(data, 0x0BBF, 0x0BBF, Property::SpacingMark)
      put(data, 0x0BC0, 0x0BC0, Property::Extend)
      put(data, 0x0BC1, 0x0BC2, Property::SpacingMark)
      put(data, 0x0BC6, 0x0BC8, Property::SpacingMark)
      put(data, 0x0BCA, 0x0BCC, Property::SpacingMark)
      put(data, 0x0BCD, 0x0BCD, Property::Extend)
      put(data, 0x0BD7, 0x0BD7, Property::Extend)
      put(data, 0x0C00, 0x0C00, Property::Extend)
      put(data, 0x0C01, 0x0C03, Property::SpacingMark)
      put(data, 0x0C04, 0x0C04, Property::Extend)
      put(data, 0x0C3C, 0x0C3C, Property::Extend)
      put(data, 0x0C3E, 0x0C40, Property::Extend)
      put(data, 0x0C41, 0x0C44, Property::SpacingMark)
      put(data, 0x0C46, 0x0C48, Property::Extend)
      put(data, 0x0C4A, 0x0C4D, Property::Extend)
      put(data, 0x0C55, 0x0C56, Property::Extend)
      put(data, 0x0C62, 0x0C63, Property::Extend)
      put(data, 0x0C81, 0x0C81, Property::Extend)
      put(data, 0x0C82, 0x0C83, Property::SpacingMark)
      put(data, 0x0CBC, 0x0CBC, Property::Extend)
      put(data, 0x0CBE, 0x0CBE, Property::SpacingMark)
      put(data, 0x0CBF, 0x0CC0, Property::Extend)
      put(data, 0x0CC1, 0x0CC1, Property::SpacingMark)
      put(data, 0x0CC2, 0x0CC2, Property::Extend)
      put(data, 0x0CC3, 0x0CC4, Property::SpacingMark)
      put(data, 0x0CC6, 0x0CC8, Property::Extend)
      put(data, 0x0CCA, 0x0CCD, Property::Extend)
      put(data, 0x0CD5, 0x0CD6, Property::Extend)
      put(data, 0x0CE2, 0x0CE3, Property::Extend)
      put(data, 0x0CF3, 0x0CF3, Property::SpacingMark)
      put(data, 0x0D00, 0x0D01, Property::Extend)
      put(data, 0x0D02, 0x0D03, Property::SpacingMark)
      put(data, 0x0D3B, 0x0D3C, Property::Extend)
      put(data, 0x0D3E, 0x0D3E, Property::Extend)
      put(data, 0x0D3F, 0x0D40, Property::SpacingMark)
      put(data, 0x0D41, 0x0D44, Property::Extend)
      put(data, 0x0D46, 0x0D48, Property::SpacingMark)
      put(data, 0x0D4A, 0x0D4C, Property::SpacingMark)
      put(data, 0x0D4D, 0x0D4D, Property::Extend)
      put(data, 0x0D4E, 0x0D4E, Property::Prepend)
      put(data, 0x0D57, 0x0D57, Property::Extend)
      put(data, 0x0D62, 0x0D63, Property::Extend)
      put(data, 0x0D81, 0x0D81, Property::Extend)
      put(data, 0x0D82, 0x0D83, Property::SpacingMark)
      put(data, 0x0DCA, 0x0DCA, Property::Extend)
      put(data, 0x0DCF, 0x0DCF, Property::Extend)
      put(data, 0x0DD0, 0x0DD1, Property::SpacingMark)
      put(data, 0x0DD2, 0x0DD4, Property::Extend)
      put(data, 0x0DD6, 0x0DD6, Property::Extend)
      put(data, 0x0DD8, 0x0DDE, Property::SpacingMark)
      put(data, 0x0DDF, 0x0DDF, Property::Extend)
      put(data, 0x0DF2, 0x0DF3, Property::SpacingMark)
      put(data, 0x0E31, 0x0E31, Property::Extend)
      put(data, 0x0E33, 0x0E33, Property::SpacingMark)
      put(data, 0x0E34, 0x0E3A, Property::Extend)
      put(data, 0x0E47, 0x0E4E, Property::Extend)
      put(data, 0x0EB1, 0x0EB1, Property::Extend)
      put(data, 0x0EB3, 0x0EB3, Property::SpacingMark)
      put(data, 0x0EB4, 0x0EBC, Property::Extend)
      put(data, 0x0EC8, 0x0ECE, Property::Extend)
      put(data, 0x0F18, 0x0F19, Property::Extend)
      put(data, 0x0F35, 0x0F35, Property::Extend)
      put(data, 0x0F37, 0x0F37, Property::Extend)
      put(data, 0x0F39, 0x0F39, Property::Extend)
      put(data, 0x0F3E, 0x0F3F, Property::SpacingMark)
      put(data, 0x0F71, 0x0F7E, Property::Extend)
      put(data, 0x0F7F, 0x0F7F, Property::SpacingMark)
      put(data, 0x0F80, 0x0F84, Property::Extend)
      put(data, 0x0F86, 0x0F87, Property::Extend)
      put(data, 0x0F8D, 0x0F97, Property::Extend)
      put(data, 0x0F99, 0x0FBC, Property::Extend)
      put(data, 0x0FC6, 0x0FC6, Property::Extend)
      put(data, 0x102D, 0x1030, Property::Extend)
      put(data, 0x1031, 0x1031, Property::SpacingMark)
      put(data, 0x1032, 0x1037, Property::Extend)
      put(data, 0x1039, 0x103A, Property::Extend)
      put(data, 0x103B, 0x103C, Property::SpacingMark)
      put(data, 0x103D, 0x103E, Property::Extend)
      put(data, 0x1056, 0x1057, Property::SpacingMark)
      put(data, 0x1058, 0x1059, Property::Extend)
      put(data, 0x105E, 0x1060, Property::Extend)
      put(data, 0x1071, 0x1074, Property::Extend)
      put(data, 0x1082, 0x1082, Property::Extend)
      put(data, 0x1084, 0x1084, Property::SpacingMark)
      put(data, 0x1085, 0x1086, Property::Extend)
      put(data, 0x108D, 0x108D, Property::Extend)
      put(data, 0x109D, 0x109D, Property::Extend)
      put(data, 0x1100, 0x115F, Property::L)
      put(data, 0x1160, 0x11A7, Property::V)
      put(data, 0x11A8, 0x11FF, Property::T)
      put(data, 0x135D, 0x135F, Property::Extend)
      put(data, 0x1712, 0x1715, Property::Extend)
      put(data, 0x1732, 0x1734, Property::Extend)
      put(data, 0x1752, 0x1753, Property::Extend)
      put(data, 0x1772, 0x1773, Property::Extend)
      put(data, 0x17B4, 0x17B5, Property::Extend)
      put(data, 0x17B6, 0x17B6, Property::SpacingMark)
      put(data, 0x17B7, 0x17BD, Property::Extend)
      put(data, 0x17BE, 0x17C5, Property::SpacingMark)
      put(data, 0x17C6, 0x17C6, Property::Extend)
      put(data, 0x17C7, 0x17C8, Property::SpacingMark)
      put(data, 0x17C9, 0x17D3, Property::Extend)
      put(data, 0x17DD, 0x17DD, Property::Extend)
      put(data, 0x180B, 0x180D, Property::Extend)
      put(data, 0x180E, 0x180E, Property::Control)
      put(data, 0x180F, 0x180F, Property::Extend)
      put(data, 0x1885, 0x1886, Property::Extend)
      put(data, 0x18A9, 0x18A9, Property::Extend)
      put(data, 0x1920, 0x1922, Property::Extend)
      put(data, 0x1923, 0x1926, Property::SpacingMark)
      put(data, 0x1927, 0x1928, Property::Extend)
      put(data, 0x1929, 0x192B, Property::SpacingMark)
      put(data, 0x1930, 0x1931, Property::SpacingMark)
      put(data, 0x1932, 0x1932, Property::Extend)
      put(data, 0x1933, 0x1938, Property::SpacingMark)
      put(data, 0x1939, 0x193B, Property::Extend)
      put(data, 0x1A17, 0x1A18, Property::Extend)
      put(data, 0x1A19, 0x1A1A, Property::SpacingMark)
      put(data, 0x1A1B, 0x1A1B, Property::Extend)
      put(data, 0x1A55, 0x1A55, Property::SpacingMark)
      put(data, 0x1A56, 0x1A56, Property::Extend)
      put(data, 0x1A57, 0x1A57, Property::SpacingMark)
      put(data, 0x1A58, 0x1A5E, Property::Extend)
      put(data, 0x1A60, 0x1A60, Property::Extend)
      put(data, 0x1A62, 0x1A62, Property::Extend)
      put(data, 0x1A65, 0x1A6C, Property::Extend)
      put(data, 0x1A6D, 0x1A72, Property::SpacingMark)
      put(data, 0x1A73, 0x1A7C, Property::Extend)
      put(data, 0x1A7F, 0x1A7F, Property::Extend)
      put(data, 0x1AB0, 0x1ADD, Property::Extend)
      put(data, 0x1AE0, 0x1AEB, Property::Extend)
      put(data, 0x1B00, 0x1B03, Property::Extend)
      put(data, 0x1B04, 0x1B04, Property::SpacingMark)
      put(data, 0x1B34, 0x1B3D, Property::Extend)
      put(data, 0x1B3E, 0x1B41, Property::SpacingMark)
      put(data, 0x1B42, 0x1B44, Property::Extend)
      put(data, 0x1B6B, 0x1B73, Property::Extend)
      put(data, 0x1B80, 0x1B81, Property::Extend)
      put(data, 0x1B82, 0x1B82, Property::SpacingMark)
      put(data, 0x1BA1, 0x1BA1, Property::SpacingMark)
      put(data, 0x1BA2, 0x1BA5, Property::Extend)
      put(data, 0x1BA6, 0x1BA7, Property::SpacingMark)
      put(data, 0x1BA8, 0x1BAD, Property::Extend)
      put(data, 0x1BE6, 0x1BE6, Property::Extend)
      put(data, 0x1BE7, 0x1BE7, Property::SpacingMark)
      put(data, 0x1BE8, 0x1BE9, Property::Extend)
      put(data, 0x1BEA, 0x1BEC, Property::SpacingMark)
      put(data, 0x1BED, 0x1BED, Property::Extend)
      put(data, 0x1BEE, 0x1BEE, Property::SpacingMark)
      put(data, 0x1BEF, 0x1BF3, Property::Extend)
      put(data, 0x1C24, 0x1C2B, Property::SpacingMark)
      put(data, 0x1C2C, 0x1C33, Property::Extend)
      put(data, 0x1C34, 0x1C35, Property::SpacingMark)
      put(data, 0x1C36, 0x1C37, Property::Extend)
      put(data, 0x1CD0, 0x1CD2, Property::Extend)
      put(data, 0x1CD4, 0x1CE0, Property::Extend)
      put(data, 0x1CE1, 0x1CE1, Property::SpacingMark)
      put(data, 0x1CE2, 0x1CE8, Property::Extend)
      put(data, 0x1CED, 0x1CED, Property::Extend)
      put(data, 0x1CF4, 0x1CF4, Property::Extend)
      put(data, 0x1CF7, 0x1CF7, Property::SpacingMark)
      put(data, 0x1CF8, 0x1CF9, Property::Extend)
      put(data, 0x1DC0, 0x1DFF, Property::Extend)
      put(data, 0x200B, 0x200B, Property::Control)
      put(data, 0x200C, 0x200C, Property::Extend)
      put(data, 0x200D, 0x200D, Property::ZWJ)
      put(data, 0x200E, 0x200F, Property::Control)
      put(data, 0x2028, 0x202E, Property::Control)
      put(data, 0x203C, 0x203C, Property::ExtendedPictographic)
      put(data, 0x2049, 0x2049, Property::ExtendedPictographic)
      put(data, 0x2060, 0x206F, Property::Control)
      put(data, 0x20D0, 0x20F0, Property::Extend)
      put(data, 0x2122, 0x2122, Property::ExtendedPictographic)
      put(data, 0x2139, 0x2139, Property::ExtendedPictographic)
      put(data, 0x2194, 0x2199, Property::ExtendedPictographic)
      put(data, 0x21A9, 0x21AA, Property::ExtendedPictographic)
      put(data, 0x231A, 0x231B, Property::ExtendedPictographic)
      put(data, 0x2328, 0x2328, Property::ExtendedPictographic)
      put(data, 0x23CF, 0x23CF, Property::ExtendedPictographic)
      put(data, 0x23E9, 0x23F3, Property::ExtendedPictographic)
      put(data, 0x23F8, 0x23FA, Property::ExtendedPictographic)
      put(data, 0x24C2, 0x24C2, Property::ExtendedPictographic)
      put(data, 0x25AA, 0x25AB, Property::ExtendedPictographic)
      put(data, 0x25B6, 0x25B6, Property::ExtendedPictographic)
      put(data, 0x25C0, 0x25C0, Property::ExtendedPictographic)
      put(data, 0x25FB, 0x25FE, Property::ExtendedPictographic)
      put(data, 0x2600, 0x2604, Property::ExtendedPictographic)
      put(data, 0x260E, 0x260E, Property::ExtendedPictographic)
      put(data, 0x2611, 0x2611, Property::ExtendedPictographic)
      put(data, 0x2614, 0x2615, Property::ExtendedPictographic)
      put(data, 0x2618, 0x2618, Property::ExtendedPictographic)
      put(data, 0x261D, 0x261D, Property::ExtendedPictographic)
      put(data, 0x2620, 0x2620, Property::ExtendedPictographic)
      put(data, 0x2622, 0x2623, Property::ExtendedPictographic)
      put(data, 0x2626, 0x2626, Property::ExtendedPictographic)
      put(data, 0x262A, 0x262A, Property::ExtendedPictographic)
      put(data, 0x262E, 0x262F, Property::ExtendedPictographic)
      put(data, 0x2638, 0x263A, Property::ExtendedPictographic)
      put(data, 0x2640, 0x2640, Property::ExtendedPictographic)
      put(data, 0x2642, 0x2642, Property::ExtendedPictographic)
      put(data, 0x2648, 0x2653, Property::ExtendedPictographic)
      put(data, 0x265F, 0x2660, Property::ExtendedPictographic)
      put(data, 0x2663, 0x2663, Property::ExtendedPictographic)
      put(data, 0x2665, 0x2666, Property::ExtendedPictographic)
      put(data, 0x2668, 0x2668, Property::ExtendedPictographic)
      put(data, 0x267B, 0x267B, Property::ExtendedPictographic)
      put(data, 0x267E, 0x267F, Property::ExtendedPictographic)
      put(data, 0x2692, 0x2697, Property::ExtendedPictographic)
      put(data, 0x2699, 0x2699, Property::ExtendedPictographic)
      put(data, 0x269B, 0x269C, Property::ExtendedPictographic)
      put(data, 0x26A0, 0x26A1, Property::ExtendedPictographic)
      put(data, 0x26A7, 0x26A7, Property::ExtendedPictographic)
      put(data, 0x26AA, 0x26AB, Property::ExtendedPictographic)
      put(data, 0x26B0, 0x26B1, Property::ExtendedPictographic)
      put(data, 0x26BD, 0x26BE, Property::ExtendedPictographic)
      put(data, 0x26C4, 0x26C5, Property::ExtendedPictographic)
      put(data, 0x26C8, 0x26C8, Property::ExtendedPictographic)
      put(data, 0x26CE, 0x26CF, Property::ExtendedPictographic)
      put(data, 0x26D1, 0x26D1, Property::ExtendedPictographic)
      put(data, 0x26D3, 0x26D4, Property::ExtendedPictographic)
      put(data, 0x26E9, 0x26EA, Property::ExtendedPictographic)
      put(data, 0x26F0, 0x26F5, Property::ExtendedPictographic)
      put(data, 0x26F7, 0x26FA, Property::ExtendedPictographic)
      put(data, 0x26FD, 0x26FD, Property::ExtendedPictographic)
      put(data, 0x2702, 0x2702, Property::ExtendedPictographic)
      put(data, 0x2705, 0x2705, Property::ExtendedPictographic)
      put(data, 0x2708, 0x270D, Property::ExtendedPictographic)
      put(data, 0x270F, 0x270F, Property::ExtendedPictographic)
      put(data, 0x2712, 0x2712, Property::ExtendedPictographic)
      put(data, 0x2714, 0x2714, Property::ExtendedPictographic)
      put(data, 0x2716, 0x2716, Property::ExtendedPictographic)
      put(data, 0x271D, 0x271D, Property::ExtendedPictographic)
      put(data, 0x2721, 0x2721, Property::ExtendedPictographic)
      put(data, 0x2728, 0x2728, Property::ExtendedPictographic)
      put(data, 0x2733, 0x2734, Property::ExtendedPictographic)
      put(data, 0x2744, 0x2744, Property::ExtendedPictographic)
      put(data, 0x2747, 0x2747, Property::ExtendedPictographic)
      put(data, 0x274C, 0x274C, Property::ExtendedPictographic)
      put(data, 0x274E, 0x274E, Property::ExtendedPictographic)
      put(data, 0x2753, 0x2755, Property::ExtendedPictographic)
      put(data, 0x2757, 0x2757, Property::ExtendedPictographic)
      put(data, 0x2763, 0x2764, Property::ExtendedPictographic)
      put(data, 0x2795, 0x2797, Property::ExtendedPictographic)
      put(data, 0x27A1, 0x27A1, Property::ExtendedPictographic)
      put(data, 0x27B0, 0x27B0, Property::ExtendedPictographic)
      put(data, 0x27BF, 0x27BF, Property::ExtendedPictographic)
      put(data, 0x2934, 0x2935, Property::ExtendedPictographic)
      put(data, 0x2B05, 0x2B07, Property::ExtendedPictographic)
      put(data, 0x2B1B, 0x2B1C, Property::ExtendedPictographic)
      put(data, 0x2B50, 0x2B50, Property::ExtendedPictographic)
      put(data, 0x2B55, 0x2B55, Property::ExtendedPictographic)
      put(data, 0x2CEF, 0x2CF1, Property::Extend)
      put(data, 0x2D7F, 0x2D7F, Property::Extend)
      put(data, 0x2DE0, 0x2DFF, Property::Extend)
      put(data, 0x302A, 0x302F, Property::Extend)
      put(data, 0x3030, 0x3030, Property::ExtendedPictographic)
      put(data, 0x303D, 0x303D, Property::ExtendedPictographic)
      put(data, 0x3099, 0x309A, Property::Extend)
      put(data, 0x3297, 0x3297, Property::ExtendedPictographic)
      put(data, 0x3299, 0x3299, Property::ExtendedPictographic)
      put(data, 0xA66F, 0xA672, Property::Extend)
      put(data, 0xA674, 0xA67D, Property::Extend)
      put(data, 0xA69E, 0xA69F, Property::Extend)
      put(data, 0xA6F0, 0xA6F1, Property::Extend)
      put(data, 0xA802, 0xA802, Property::Extend)
      put(data, 0xA806, 0xA806, Property::Extend)
      put(data, 0xA80B, 0xA80B, Property::Extend)
      put(data, 0xA823, 0xA824, Property::SpacingMark)
      put(data, 0xA825, 0xA826, Property::Extend)
      put(data, 0xA827, 0xA827, Property::SpacingMark)
      put(data, 0xA82C, 0xA82C, Property::Extend)
      put(data, 0xA880, 0xA881, Property::SpacingMark)
      put(data, 0xA8B4, 0xA8C3, Property::SpacingMark)
      put(data, 0xA8C4, 0xA8C5, Property::Extend)
      put(data, 0xA8E0, 0xA8F1, Property::Extend)
      put(data, 0xA8FF, 0xA8FF, Property::Extend)
      put(data, 0xA926, 0xA92D, Property::Extend)
      put(data, 0xA947, 0xA951, Property::Extend)
      put(data, 0xA952, 0xA952, Property::SpacingMark)
      put(data, 0xA953, 0xA953, Property::Extend)
      put(data, 0xA960, 0xA97C, Property::L)
      put(data, 0xA980, 0xA982, Property::Extend)
      put(data, 0xA983, 0xA983, Property::SpacingMark)
      put(data, 0xA9B3, 0xA9B3, Property::Extend)
      put(data, 0xA9B4, 0xA9B5, Property::SpacingMark)
      put(data, 0xA9B6, 0xA9B9, Property::Extend)
      put(data, 0xA9BA, 0xA9BB, Property::SpacingMark)
      put(data, 0xA9BC, 0xA9BD, Property::Extend)
      put(data, 0xA9BE, 0xA9BF, Property::SpacingMark)
      put(data, 0xA9C0, 0xA9C0, Property::Extend)
      put(data, 0xA9E5, 0xA9E5, Property::Extend)
      put(data, 0xAA29, 0xAA2E, Property::Extend)
      put(data, 0xAA2F, 0xAA30, Property::SpacingMark)
      put(data, 0xAA31, 0xAA32, Property::Extend)
      put(data, 0xAA33, 0xAA34, Property::SpacingMark)
      put(data, 0xAA35, 0xAA36, Property::Extend)
      put(data, 0xAA43, 0xAA43, Property::Extend)
      put(data, 0xAA4C, 0xAA4C, Property::Extend)
      put(data, 0xAA4D, 0xAA4D, Property::SpacingMark)
      put(data, 0xAA7C, 0xAA7C, Property::Extend)
      put(data, 0xAAB0, 0xAAB0, Property::Extend)
      put(data, 0xAAB2, 0xAAB4, Property::Extend)
      put(data, 0xAAB7, 0xAAB8, Property::Extend)
      put(data, 0xAABE, 0xAABF, Property::Extend)
      put(data, 0xAAC1, 0xAAC1, Property::Extend)
      put(data, 0xAAEB, 0xAAEB, Property::SpacingMark)
      put(data, 0xAAEC, 0xAAED, Property::Extend)
      put(data, 0xAAEE, 0xAAEF, Property::SpacingMark)
      put(data, 0xAAF5, 0xAAF5, Property::SpacingMark)
      put(data, 0xAAF6, 0xAAF6, Property::Extend)
      put(data, 0xABE3, 0xABE4, Property::SpacingMark)
      put(data, 0xABE5, 0xABE5, Property::Extend)
      put(data, 0xABE6, 0xABE7, Property::SpacingMark)
      put(data, 0xABE8, 0xABE8, Property::Extend)
      put(data, 0xABE9, 0xABEA, Property::SpacingMark)
      put(data, 0xABEC, 0xABEC, Property::SpacingMark)
      put(data, 0xABED, 0xABED, Property::Extend)
      put(data, 0xAC00, 0xAC00, Property::LV)
      put(data, 0xAC01, 0xAC1B, Property::LVT)
      put(data, 0xAC1C, 0xAC1C, Property::LV)
      put(data, 0xAC1D, 0xAC37, Property::LVT)
      put(data, 0xAC38, 0xAC38, Property::LV)
      put(data, 0xAC39, 0xAC53, Property::LVT)
      put(data, 0xAC54, 0xAC54, Property::LV)
      put(data, 0xAC55, 0xAC6F, Property::LVT)
      put(data, 0xAC70, 0xAC70, Property::LV)
      put(data, 0xAC71, 0xAC8B, Property::LVT)
      put(data, 0xAC8C, 0xAC8C, Property::LV)
      put(data, 0xAC8D, 0xACA7, Property::LVT)
      put(data, 0xACA8, 0xACA8, Property::LV)
      put(data, 0xACA9, 0xACC3, Property::LVT)
      put(data, 0xACC4, 0xACC4, Property::LV)
      put(data, 0xACC5, 0xACDF, Property::LVT)
      put(data, 0xACE0, 0xACE0, Property::LV)
      put(data, 0xACE1, 0xACFB, Property::LVT)
      put(data, 0xACFC, 0xACFC, Property::LV)
      put(data, 0xACFD, 0xAD17, Property::LVT)
      put(data, 0xAD18, 0xAD18, Property::LV)
      put(data, 0xAD19, 0xAD33, Property::LVT)
      put(data, 0xAD34, 0xAD34, Property::LV)
      put(data, 0xAD35, 0xAD4F, Property::LVT)
      put(data, 0xAD50, 0xAD50, Property::LV)
      put(data, 0xAD51, 0xAD6B, Property::LVT)
      put(data, 0xAD6C, 0xAD6C, Property::LV)
      put(data, 0xAD6D, 0xAD87, Property::LVT)
      put(data, 0xAD88, 0xAD88, Property::LV)
      put(data, 0xAD89, 0xADA3, Property::LVT)
      put(data, 0xADA4, 0xADA4, Property::LV)
      put(data, 0xADA5, 0xADBF, Property::LVT)
      put(data, 0xADC0, 0xADC0, Property::LV)
      put(data, 0xADC1, 0xADDB, Property::LVT)
      put(data, 0xADDC, 0xADDC, Property::LV)
      put(data, 0xADDD, 0xADF7, Property::LVT)
      put(data, 0xADF8, 0xADF8, Property::LV)
      put(data, 0xADF9, 0xAE13, Property::LVT)
      put(data, 0xAE14, 0xAE14, Property::LV)
      put(data, 0xAE15, 0xAE2F, Property::LVT)
      put(data, 0xAE30, 0xAE30, Property::LV)
      put(data, 0xAE31, 0xAE4B, Property::LVT)
      put(data, 0xAE4C, 0xAE4C, Property::LV)
      put(data, 0xAE4D, 0xAE67, Property::LVT)
      put(data, 0xAE68, 0xAE68, Property::LV)
      put(data, 0xAE69, 0xAE83, Property::LVT)
      put(data, 0xAE84, 0xAE84, Property::LV)
      put(data, 0xAE85, 0xAE9F, Property::LVT)
      put(data, 0xAEA0, 0xAEA0, Property::LV)
      put(data, 0xAEA1, 0xAEBB, Property::LVT)
      put(data, 0xAEBC, 0xAEBC, Property::LV)
      put(data, 0xAEBD, 0xAED7, Property::LVT)
      put(data, 0xAED8, 0xAED8, Property::LV)
      put(data, 0xAED9, 0xAEF3, Property::LVT)
      put(data, 0xAEF4, 0xAEF4, Property::LV)
      put(data, 0xAEF5, 0xAF0F, Property::LVT)
      put(data, 0xAF10, 0xAF10, Property::LV)
      put(data, 0xAF11, 0xAF2B, Property::LVT)
      put(data, 0xAF2C, 0xAF2C, Property::LV)
      put(data, 0xAF2D, 0xAF47, Property::LVT)
      put(data, 0xAF48, 0xAF48, Property::LV)
      put(data, 0xAF49, 0xAF63, Property::LVT)
      put(data, 0xAF64, 0xAF64, Property::LV)
      put(data, 0xAF65, 0xAF7F, Property::LVT)
      put(data, 0xAF80, 0xAF80, Property::LV)
      put(data, 0xAF81, 0xAF9B, Property::LVT)
      put(data, 0xAF9C, 0xAF9C, Property::LV)
      put(data, 0xAF9D, 0xAFB7, Property::LVT)
      put(data, 0xAFB8, 0xAFB8, Property::LV)
      put(data, 0xAFB9, 0xAFD3, Property::LVT)
      put(data, 0xAFD4, 0xAFD4, Property::LV)
      put(data, 0xAFD5, 0xAFEF, Property::LVT)
      put(data, 0xAFF0, 0xAFF0, Property::LV)
      put(data, 0xAFF1, 0xB00B, Property::LVT)
      put(data, 0xB00C, 0xB00C, Property::LV)
      put(data, 0xB00D, 0xB027, Property::LVT)
      put(data, 0xB028, 0xB028, Property::LV)
      put(data, 0xB029, 0xB043, Property::LVT)
      put(data, 0xB044, 0xB044, Property::LV)
      put(data, 0xB045, 0xB05F, Property::LVT)
      put(data, 0xB060, 0xB060, Property::LV)
      put(data, 0xB061, 0xB07B, Property::LVT)
      put(data, 0xB07C, 0xB07C, Property::LV)
      put(data, 0xB07D, 0xB097, Property::LVT)
      put(data, 0xB098, 0xB098, Property::LV)
      put(data, 0xB099, 0xB0B3, Property::LVT)
      put(data, 0xB0B4, 0xB0B4, Property::LV)
      put(data, 0xB0B5, 0xB0CF, Property::LVT)
      put(data, 0xB0D0, 0xB0D0, Property::LV)
      put(data, 0xB0D1, 0xB0EB, Property::LVT)
      put(data, 0xB0EC, 0xB0EC, Property::LV)
      put(data, 0xB0ED, 0xB107, Property::LVT)
      put(data, 0xB108, 0xB108, Property::LV)
      put(data, 0xB109, 0xB123, Property::LVT)
      put(data, 0xB124, 0xB124, Property::LV)
      put(data, 0xB125, 0xB13F, Property::LVT)
      put(data, 0xB140, 0xB140, Property::LV)
      put(data, 0xB141, 0xB15B, Property::LVT)
      put(data, 0xB15C, 0xB15C, Property::LV)
      put(data, 0xB15D, 0xB177, Property::LVT)
      put(data, 0xB178, 0xB178, Property::LV)
      put(data, 0xB179, 0xB193, Property::LVT)
      put(data, 0xB194, 0xB194, Property::LV)
      put(data, 0xB195, 0xB1AF, Property::LVT)
      put(data, 0xB1B0, 0xB1B0, Property::LV)
      put(data, 0xB1B1, 0xB1CB, Property::LVT)
      put(data, 0xB1CC, 0xB1CC, Property::LV)
      put(data, 0xB1CD, 0xB1E7, Property::LVT)
      put(data, 0xB1E8, 0xB1E8, Property::LV)
      put(data, 0xB1E9, 0xB203, Property::LVT)
      put(data, 0xB204, 0xB204, Property::LV)
      put(data, 0xB205, 0xB21F, Property::LVT)
      put(data, 0xB220, 0xB220, Property::LV)
      put(data, 0xB221, 0xB23B, Property::LVT)
      put(data, 0xB23C, 0xB23C, Property::LV)
      put(data, 0xB23D, 0xB257, Property::LVT)
      put(data, 0xB258, 0xB258, Property::LV)
      put(data, 0xB259, 0xB273, Property::LVT)
      put(data, 0xB274, 0xB274, Property::LV)
      put(data, 0xB275, 0xB28F, Property::LVT)
      put(data, 0xB290, 0xB290, Property::LV)
      put(data, 0xB291, 0xB2AB, Property::LVT)
      put(data, 0xB2AC, 0xB2AC, Property::LV)
      put(data, 0xB2AD, 0xB2C7, Property::LVT)
      put(data, 0xB2C8, 0xB2C8, Property::LV)
      put(data, 0xB2C9, 0xB2E3, Property::LVT)
      put(data, 0xB2E4, 0xB2E4, Property::LV)
      put(data, 0xB2E5, 0xB2FF, Property::LVT)
      put(data, 0xB300, 0xB300, Property::LV)
      put(data, 0xB301, 0xB31B, Property::LVT)
      put(data, 0xB31C, 0xB31C, Property::LV)
      put(data, 0xB31D, 0xB337, Property::LVT)
      put(data, 0xB338, 0xB338, Property::LV)
      put(data, 0xB339, 0xB353, Property::LVT)
      put(data, 0xB354, 0xB354, Property::LV)
      put(data, 0xB355, 0xB36F, Property::LVT)
      put(data, 0xB370, 0xB370, Property::LV)
      put(data, 0xB371, 0xB38B, Property::LVT)
      put(data, 0xB38C, 0xB38C, Property::LV)
      put(data, 0xB38D, 0xB3A7, Property::LVT)
      put(data, 0xB3A8, 0xB3A8, Property::LV)
      put(data, 0xB3A9, 0xB3C3, Property::LVT)
      put(data, 0xB3C4, 0xB3C4, Property::LV)
      put(data, 0xB3C5, 0xB3DF, Property::LVT)
      put(data, 0xB3E0, 0xB3E0, Property::LV)
      put(data, 0xB3E1, 0xB3FB, Property::LVT)
      put(data, 0xB3FC, 0xB3FC, Property::LV)
      put(data, 0xB3FD, 0xB417, Property::LVT)
      put(data, 0xB418, 0xB418, Property::LV)
      put(data, 0xB419, 0xB433, Property::LVT)
      put(data, 0xB434, 0xB434, Property::LV)
      put(data, 0xB435, 0xB44F, Property::LVT)
      put(data, 0xB450, 0xB450, Property::LV)
      put(data, 0xB451, 0xB46B, Property::LVT)
      put(data, 0xB46C, 0xB46C, Property::LV)
      put(data, 0xB46D, 0xB487, Property::LVT)
      put(data, 0xB488, 0xB488, Property::LV)
      put(data, 0xB489, 0xB4A3, Property::LVT)
      put(data, 0xB4A4, 0xB4A4, Property::LV)
      put(data, 0xB4A5, 0xB4BF, Property::LVT)
      put(data, 0xB4C0, 0xB4C0, Property::LV)
      put(data, 0xB4C1, 0xB4DB, Property::LVT)
      put(data, 0xB4DC, 0xB4DC, Property::LV)
      put(data, 0xB4DD, 0xB4F7, Property::LVT)
      put(data, 0xB4F8, 0xB4F8, Property::LV)
      put(data, 0xB4F9, 0xB513, Property::LVT)
      put(data, 0xB514, 0xB514, Property::LV)
      put(data, 0xB515, 0xB52F, Property::LVT)
      put(data, 0xB530, 0xB530, Property::LV)
      put(data, 0xB531, 0xB54B, Property::LVT)
      put(data, 0xB54C, 0xB54C, Property::LV)
      put(data, 0xB54D, 0xB567, Property::LVT)
      put(data, 0xB568, 0xB568, Property::LV)
      put(data, 0xB569, 0xB583, Property::LVT)
      put(data, 0xB584, 0xB584, Property::LV)
      put(data, 0xB585, 0xB59F, Property::LVT)
      put(data, 0xB5A0, 0xB5A0, Property::LV)
      put(data, 0xB5A1, 0xB5BB, Property::LVT)
      put(data, 0xB5BC, 0xB5BC, Property::LV)
      put(data, 0xB5BD, 0xB5D7, Property::LVT)
      put(data, 0xB5D8, 0xB5D8, Property::LV)
      put(data, 0xB5D9, 0xB5F3, Property::LVT)
      put(data, 0xB5F4, 0xB5F4, Property::LV)
      put(data, 0xB5F5, 0xB60F, Property::LVT)
      put(data, 0xB610, 0xB610, Property::LV)
      put(data, 0xB611, 0xB62B, Property::LVT)
      put(data, 0xB62C, 0xB62C, Property::LV)
      put(data, 0xB62D, 0xB647, Property::LVT)
      put(data, 0xB648, 0xB648, Property::LV)
      put(data, 0xB649, 0xB663, Property::LVT)
      put(data, 0xB664, 0xB664, Property::LV)
      put(data, 0xB665, 0xB67F, Property::LVT)
      put(data, 0xB680, 0xB680, Property::LV)
      put(data, 0xB681, 0xB69B, Property::LVT)
      put(data, 0xB69C, 0xB69C, Property::LV)
      put(data, 0xB69D, 0xB6B7, Property::LVT)
      put(data, 0xB6B8, 0xB6B8, Property::LV)
      put(data, 0xB6B9, 0xB6D3, Property::LVT)
      put(data, 0xB6D4, 0xB6D4, Property::LV)
      put(data, 0xB6D5, 0xB6EF, Property::LVT)
      put(data, 0xB6F0, 0xB6F0, Property::LV)
      put(data, 0xB6F1, 0xB70B, Property::LVT)
      put(data, 0xB70C, 0xB70C, Property::LV)
      put(data, 0xB70D, 0xB727, Property::LVT)
      put(data, 0xB728, 0xB728, Property::LV)
      put(data, 0xB729, 0xB743, Property::LVT)
      put(data, 0xB744, 0xB744, Property::LV)
      put(data, 0xB745, 0xB75F, Property::LVT)
      put(data, 0xB760, 0xB760, Property::LV)
      put(data, 0xB761, 0xB77B, Property::LVT)
      put(data, 0xB77C, 0xB77C, Property::LV)
      put(data, 0xB77D, 0xB797, Property::LVT)
      put(data, 0xB798, 0xB798, Property::LV)
      put(data, 0xB799, 0xB7B3, Property::LVT)
      put(data, 0xB7B4, 0xB7B4, Property::LV)
      put(data, 0xB7B5, 0xB7CF, Property::LVT)
      put(data, 0xB7D0, 0xB7D0, Property::LV)
      put(data, 0xB7D1, 0xB7EB, Property::LVT)
      put(data, 0xB7EC, 0xB7EC, Property::LV)
      put(data, 0xB7ED, 0xB807, Property::LVT)
      put(data, 0xB808, 0xB808, Property::LV)
      put(data, 0xB809, 0xB823, Property::LVT)
      put(data, 0xB824, 0xB824, Property::LV)
      put(data, 0xB825, 0xB83F, Property::LVT)
      put(data, 0xB840, 0xB840, Property::LV)
      put(data, 0xB841, 0xB85B, Property::LVT)
      put(data, 0xB85C, 0xB85C, Property::LV)
      put(data, 0xB85D, 0xB877, Property::LVT)
      put(data, 0xB878, 0xB878, Property::LV)
      put(data, 0xB879, 0xB893, Property::LVT)
      put(data, 0xB894, 0xB894, Property::LV)
      put(data, 0xB895, 0xB8AF, Property::LVT)
      put(data, 0xB8B0, 0xB8B0, Property::LV)
      put(data, 0xB8B1, 0xB8CB, Property::LVT)
      put(data, 0xB8CC, 0xB8CC, Property::LV)
      put(data, 0xB8CD, 0xB8E7, Property::LVT)
      put(data, 0xB8E8, 0xB8E8, Property::LV)
      put(data, 0xB8E9, 0xB903, Property::LVT)
      put(data, 0xB904, 0xB904, Property::LV)
      put(data, 0xB905, 0xB91F, Property::LVT)
      put(data, 0xB920, 0xB920, Property::LV)
      put(data, 0xB921, 0xB93B, Property::LVT)
      put(data, 0xB93C, 0xB93C, Property::LV)
      put(data, 0xB93D, 0xB957, Property::LVT)
      put(data, 0xB958, 0xB958, Property::LV)
      put(data, 0xB959, 0xB973, Property::LVT)
      put(data, 0xB974, 0xB974, Property::LV)
      put(data, 0xB975, 0xB98F, Property::LVT)
      put(data, 0xB990, 0xB990, Property::LV)
      put(data, 0xB991, 0xB9AB, Property::LVT)
      put(data, 0xB9AC, 0xB9AC, Property::LV)
      put(data, 0xB9AD, 0xB9C7, Property::LVT)
      put(data, 0xB9C8, 0xB9C8, Property::LV)
      put(data, 0xB9C9, 0xB9E3, Property::LVT)
      put(data, 0xB9E4, 0xB9E4, Property::LV)
      put(data, 0xB9E5, 0xB9FF, Property::LVT)
      put(data, 0xBA00, 0xBA00, Property::LV)
      put(data, 0xBA01, 0xBA1B, Property::LVT)
      put(data, 0xBA1C, 0xBA1C, Property::LV)
      put(data, 0xBA1D, 0xBA37, Property::LVT)
      put(data, 0xBA38, 0xBA38, Property::LV)
      put(data, 0xBA39, 0xBA53, Property::LVT)
      put(data, 0xBA54, 0xBA54, Property::LV)
      put(data, 0xBA55, 0xBA6F, Property::LVT)
      put(data, 0xBA70, 0xBA70, Property::LV)
      put(data, 0xBA71, 0xBA8B, Property::LVT)
      put(data, 0xBA8C, 0xBA8C, Property::LV)
      put(data, 0xBA8D, 0xBAA7, Property::LVT)
      put(data, 0xBAA8, 0xBAA8, Property::LV)
      put(data, 0xBAA9, 0xBAC3, Property::LVT)
      put(data, 0xBAC4, 0xBAC4, Property::LV)
      put(data, 0xBAC5, 0xBADF, Property::LVT)
      put(data, 0xBAE0, 0xBAE0, Property::LV)
      put(data, 0xBAE1, 0xBAFB, Property::LVT)
      put(data, 0xBAFC, 0xBAFC, Property::LV)
      put(data, 0xBAFD, 0xBB17, Property::LVT)
      put(data, 0xBB18, 0xBB18, Property::LV)
      put(data, 0xBB19, 0xBB33, Property::LVT)
      put(data, 0xBB34, 0xBB34, Property::LV)
      put(data, 0xBB35, 0xBB4F, Property::LVT)
      put(data, 0xBB50, 0xBB50, Property::LV)
      put(data, 0xBB51, 0xBB6B, Property::LVT)
      put(data, 0xBB6C, 0xBB6C, Property::LV)
      put(data, 0xBB6D, 0xBB87, Property::LVT)
      put(data, 0xBB88, 0xBB88, Property::LV)
      put(data, 0xBB89, 0xBBA3, Property::LVT)
      put(data, 0xBBA4, 0xBBA4, Property::LV)
      put(data, 0xBBA5, 0xBBBF, Property::LVT)
      put(data, 0xBBC0, 0xBBC0, Property::LV)
      put(data, 0xBBC1, 0xBBDB, Property::LVT)
      put(data, 0xBBDC, 0xBBDC, Property::LV)
      put(data, 0xBBDD, 0xBBF7, Property::LVT)
      put(data, 0xBBF8, 0xBBF8, Property::LV)
      put(data, 0xBBF9, 0xBC13, Property::LVT)
      put(data, 0xBC14, 0xBC14, Property::LV)
      put(data, 0xBC15, 0xBC2F, Property::LVT)
      put(data, 0xBC30, 0xBC30, Property::LV)
      put(data, 0xBC31, 0xBC4B, Property::LVT)
      put(data, 0xBC4C, 0xBC4C, Property::LV)
      put(data, 0xBC4D, 0xBC67, Property::LVT)
      put(data, 0xBC68, 0xBC68, Property::LV)
      put(data, 0xBC69, 0xBC83, Property::LVT)
      put(data, 0xBC84, 0xBC84, Property::LV)
      put(data, 0xBC85, 0xBC9F, Property::LVT)
      put(data, 0xBCA0, 0xBCA0, Property::LV)
      put(data, 0xBCA1, 0xBCBB, Property::LVT)
      put(data, 0xBCBC, 0xBCBC, Property::LV)
      put(data, 0xBCBD, 0xBCD7, Property::LVT)
      put(data, 0xBCD8, 0xBCD8, Property::LV)
      put(data, 0xBCD9, 0xBCF3, Property::LVT)
      put(data, 0xBCF4, 0xBCF4, Property::LV)
      put(data, 0xBCF5, 0xBD0F, Property::LVT)
      put(data, 0xBD10, 0xBD10, Property::LV)
      put(data, 0xBD11, 0xBD2B, Property::LVT)
      put(data, 0xBD2C, 0xBD2C, Property::LV)
      put(data, 0xBD2D, 0xBD47, Property::LVT)
      put(data, 0xBD48, 0xBD48, Property::LV)
      put(data, 0xBD49, 0xBD63, Property::LVT)
      put(data, 0xBD64, 0xBD64, Property::LV)
      put(data, 0xBD65, 0xBD7F, Property::LVT)
      put(data, 0xBD80, 0xBD80, Property::LV)
      put(data, 0xBD81, 0xBD9B, Property::LVT)
      put(data, 0xBD9C, 0xBD9C, Property::LV)
      put(data, 0xBD9D, 0xBDB7, Property::LVT)
      put(data, 0xBDB8, 0xBDB8, Property::LV)
      put(data, 0xBDB9, 0xBDD3, Property::LVT)
      put(data, 0xBDD4, 0xBDD4, Property::LV)
      put(data, 0xBDD5, 0xBDEF, Property::LVT)
      put(data, 0xBDF0, 0xBDF0, Property::LV)
      put(data, 0xBDF1, 0xBE0B, Property::LVT)
      put(data, 0xBE0C, 0xBE0C, Property::LV)
      put(data, 0xBE0D, 0xBE27, Property::LVT)
      put(data, 0xBE28, 0xBE28, Property::LV)
      put(data, 0xBE29, 0xBE43, Property::LVT)
      put(data, 0xBE44, 0xBE44, Property::LV)
      put(data, 0xBE45, 0xBE5F, Property::LVT)
      put(data, 0xBE60, 0xBE60, Property::LV)
      put(data, 0xBE61, 0xBE7B, Property::LVT)
      put(data, 0xBE7C, 0xBE7C, Property::LV)
      put(data, 0xBE7D, 0xBE97, Property::LVT)
      put(data, 0xBE98, 0xBE98, Property::LV)
      put(data, 0xBE99, 0xBEB3, Property::LVT)
      put(data, 0xBEB4, 0xBEB4, Property::LV)
      put(data, 0xBEB5, 0xBECF, Property::LVT)
      put(data, 0xBED0, 0xBED0, Property::LV)
      put(data, 0xBED1, 0xBEEB, Property::LVT)
      put(data, 0xBEEC, 0xBEEC, Property::LV)
      put(data, 0xBEED, 0xBF07, Property::LVT)
      put(data, 0xBF08, 0xBF08, Property::LV)
      put(data, 0xBF09, 0xBF23, Property::LVT)
      put(data, 0xBF24, 0xBF24, Property::LV)
      put(data, 0xBF25, 0xBF3F, Property::LVT)
      put(data, 0xBF40, 0xBF40, Property::LV)
      put(data, 0xBF41, 0xBF5B, Property::LVT)
      put(data, 0xBF5C, 0xBF5C, Property::LV)
      put(data, 0xBF5D, 0xBF77, Property::LVT)
      put(data, 0xBF78, 0xBF78, Property::LV)
      put(data, 0xBF79, 0xBF93, Property::LVT)
      put(data, 0xBF94, 0xBF94, Property::LV)
      put(data, 0xBF95, 0xBFAF, Property::LVT)
      put(data, 0xBFB0, 0xBFB0, Property::LV)
      put(data, 0xBFB1, 0xBFCB, Property::LVT)
      put(data, 0xBFCC, 0xBFCC, Property::LV)
      put(data, 0xBFCD, 0xBFE7, Property::LVT)
      put(data, 0xBFE8, 0xBFE8, Property::LV)
      put(data, 0xBFE9, 0xC003, Property::LVT)
      put(data, 0xC004, 0xC004, Property::LV)
      put(data, 0xC005, 0xC01F, Property::LVT)
      put(data, 0xC020, 0xC020, Property::LV)
      put(data, 0xC021, 0xC03B, Property::LVT)
      put(data, 0xC03C, 0xC03C, Property::LV)
      put(data, 0xC03D, 0xC057, Property::LVT)
      put(data, 0xC058, 0xC058, Property::LV)
      put(data, 0xC059, 0xC073, Property::LVT)
      put(data, 0xC074, 0xC074, Property::LV)
      put(data, 0xC075, 0xC08F, Property::LVT)
      put(data, 0xC090, 0xC090, Property::LV)
      put(data, 0xC091, 0xC0AB, Property::LVT)
      put(data, 0xC0AC, 0xC0AC, Property::LV)
      put(data, 0xC0AD, 0xC0C7, Property::LVT)
      put(data, 0xC0C8, 0xC0C8, Property::LV)
      put(data, 0xC0C9, 0xC0E3, Property::LVT)
      put(data, 0xC0E4, 0xC0E4, Property::LV)
      put(data, 0xC0E5, 0xC0FF, Property::LVT)
      put(data, 0xC100, 0xC100, Property::LV)
      put(data, 0xC101, 0xC11B, Property::LVT)
      put(data, 0xC11C, 0xC11C, Property::LV)
      put(data, 0xC11D, 0xC137, Property::LVT)
      put(data, 0xC138, 0xC138, Property::LV)
      put(data, 0xC139, 0xC153, Property::LVT)
      put(data, 0xC154, 0xC154, Property::LV)
      put(data, 0xC155, 0xC16F, Property::LVT)
      put(data, 0xC170, 0xC170, Property::LV)
      put(data, 0xC171, 0xC18B, Property::LVT)
      put(data, 0xC18C, 0xC18C, Property::LV)
      put(data, 0xC18D, 0xC1A7, Property::LVT)
      put(data, 0xC1A8, 0xC1A8, Property::LV)
      put(data, 0xC1A9, 0xC1C3, Property::LVT)
      put(data, 0xC1C4, 0xC1C4, Property::LV)
      put(data, 0xC1C5, 0xC1DF, Property::LVT)
      put(data, 0xC1E0, 0xC1E0, Property::LV)
      put(data, 0xC1E1, 0xC1FB, Property::LVT)
      put(data, 0xC1FC, 0xC1FC, Property::LV)
      put(data, 0xC1FD, 0xC217, Property::LVT)
      put(data, 0xC218, 0xC218, Property::LV)
      put(data, 0xC219, 0xC233, Property::LVT)
      put(data, 0xC234, 0xC234, Property::LV)
      put(data, 0xC235, 0xC24F, Property::LVT)
      put(data, 0xC250, 0xC250, Property::LV)
      put(data, 0xC251, 0xC26B, Property::LVT)
      put(data, 0xC26C, 0xC26C, Property::LV)
      put(data, 0xC26D, 0xC287, Property::LVT)
      put(data, 0xC288, 0xC288, Property::LV)
      put(data, 0xC289, 0xC2A3, Property::LVT)
      put(data, 0xC2A4, 0xC2A4, Property::LV)
      put(data, 0xC2A5, 0xC2BF, Property::LVT)
      put(data, 0xC2C0, 0xC2C0, Property::LV)
      put(data, 0xC2C1, 0xC2DB, Property::LVT)
      put(data, 0xC2DC, 0xC2DC, Property::LV)
      put(data, 0xC2DD, 0xC2F7, Property::LVT)
      put(data, 0xC2F8, 0xC2F8, Property::LV)
      put(data, 0xC2F9, 0xC313, Property::LVT)
      put(data, 0xC314, 0xC314, Property::LV)
      put(data, 0xC315, 0xC32F, Property::LVT)
      put(data, 0xC330, 0xC330, Property::LV)
      put(data, 0xC331, 0xC34B, Property::LVT)
      put(data, 0xC34C, 0xC34C, Property::LV)
      put(data, 0xC34D, 0xC367, Property::LVT)
      put(data, 0xC368, 0xC368, Property::LV)
      put(data, 0xC369, 0xC383, Property::LVT)
      put(data, 0xC384, 0xC384, Property::LV)
      put(data, 0xC385, 0xC39F, Property::LVT)
      put(data, 0xC3A0, 0xC3A0, Property::LV)
      put(data, 0xC3A1, 0xC3BB, Property::LVT)
      put(data, 0xC3BC, 0xC3BC, Property::LV)
      put(data, 0xC3BD, 0xC3D7, Property::LVT)
      put(data, 0xC3D8, 0xC3D8, Property::LV)
      put(data, 0xC3D9, 0xC3F3, Property::LVT)
      put(data, 0xC3F4, 0xC3F4, Property::LV)
      put(data, 0xC3F5, 0xC40F, Property::LVT)
      put(data, 0xC410, 0xC410, Property::LV)
      put(data, 0xC411, 0xC42B, Property::LVT)
      put(data, 0xC42C, 0xC42C, Property::LV)
      put(data, 0xC42D, 0xC447, Property::LVT)
      put(data, 0xC448, 0xC448, Property::LV)
      put(data, 0xC449, 0xC463, Property::LVT)
      put(data, 0xC464, 0xC464, Property::LV)
      put(data, 0xC465, 0xC47F, Property::LVT)
      put(data, 0xC480, 0xC480, Property::LV)
      put(data, 0xC481, 0xC49B, Property::LVT)
      put(data, 0xC49C, 0xC49C, Property::LV)
      put(data, 0xC49D, 0xC4B7, Property::LVT)
      put(data, 0xC4B8, 0xC4B8, Property::LV)
      put(data, 0xC4B9, 0xC4D3, Property::LVT)
      put(data, 0xC4D4, 0xC4D4, Property::LV)
      put(data, 0xC4D5, 0xC4EF, Property::LVT)
      put(data, 0xC4F0, 0xC4F0, Property::LV)
      put(data, 0xC4F1, 0xC50B, Property::LVT)
      put(data, 0xC50C, 0xC50C, Property::LV)
      put(data, 0xC50D, 0xC527, Property::LVT)
      put(data, 0xC528, 0xC528, Property::LV)
      put(data, 0xC529, 0xC543, Property::LVT)
      put(data, 0xC544, 0xC544, Property::LV)
      put(data, 0xC545, 0xC55F, Property::LVT)
      put(data, 0xC560, 0xC560, Property::LV)
      put(data, 0xC561, 0xC57B, Property::LVT)
      put(data, 0xC57C, 0xC57C, Property::LV)
      put(data, 0xC57D, 0xC597, Property::LVT)
      put(data, 0xC598, 0xC598, Property::LV)
      put(data, 0xC599, 0xC5B3, Property::LVT)
      put(data, 0xC5B4, 0xC5B4, Property::LV)
      put(data, 0xC5B5, 0xC5CF, Property::LVT)
      put(data, 0xC5D0, 0xC5D0, Property::LV)
      put(data, 0xC5D1, 0xC5EB, Property::LVT)
      put(data, 0xC5EC, 0xC5EC, Property::LV)
      put(data, 0xC5ED, 0xC607, Property::LVT)
      put(data, 0xC608, 0xC608, Property::LV)
      put(data, 0xC609, 0xC623, Property::LVT)
      put(data, 0xC624, 0xC624, Property::LV)
      put(data, 0xC625, 0xC63F, Property::LVT)
      put(data, 0xC640, 0xC640, Property::LV)
      put(data, 0xC641, 0xC65B, Property::LVT)
      put(data, 0xC65C, 0xC65C, Property::LV)
      put(data, 0xC65D, 0xC677, Property::LVT)
      put(data, 0xC678, 0xC678, Property::LV)
      put(data, 0xC679, 0xC693, Property::LVT)
      put(data, 0xC694, 0xC694, Property::LV)
      put(data, 0xC695, 0xC6AF, Property::LVT)
      put(data, 0xC6B0, 0xC6B0, Property::LV)
      put(data, 0xC6B1, 0xC6CB, Property::LVT)
      put(data, 0xC6CC, 0xC6CC, Property::LV)
      put(data, 0xC6CD, 0xC6E7, Property::LVT)
      put(data, 0xC6E8, 0xC6E8, Property::LV)
      put(data, 0xC6E9, 0xC703, Property::LVT)
      put(data, 0xC704, 0xC704, Property::LV)
      put(data, 0xC705, 0xC71F, Property::LVT)
      put(data, 0xC720, 0xC720, Property::LV)
      put(data, 0xC721, 0xC73B, Property::LVT)
      put(data, 0xC73C, 0xC73C, Property::LV)
      put(data, 0xC73D, 0xC757, Property::LVT)
      put(data, 0xC758, 0xC758, Property::LV)
      put(data, 0xC759, 0xC773, Property::LVT)
      put(data, 0xC774, 0xC774, Property::LV)
      put(data, 0xC775, 0xC78F, Property::LVT)
      put(data, 0xC790, 0xC790, Property::LV)
      put(data, 0xC791, 0xC7AB, Property::LVT)
      put(data, 0xC7AC, 0xC7AC, Property::LV)
      put(data, 0xC7AD, 0xC7C7, Property::LVT)
      put(data, 0xC7C8, 0xC7C8, Property::LV)
      put(data, 0xC7C9, 0xC7E3, Property::LVT)
      put(data, 0xC7E4, 0xC7E4, Property::LV)
      put(data, 0xC7E5, 0xC7FF, Property::LVT)
      put(data, 0xC800, 0xC800, Property::LV)
      put(data, 0xC801, 0xC81B, Property::LVT)
      put(data, 0xC81C, 0xC81C, Property::LV)
      put(data, 0xC81D, 0xC837, Property::LVT)
      put(data, 0xC838, 0xC838, Property::LV)
      put(data, 0xC839, 0xC853, Property::LVT)
      put(data, 0xC854, 0xC854, Property::LV)
      put(data, 0xC855, 0xC86F, Property::LVT)
      put(data, 0xC870, 0xC870, Property::LV)
      put(data, 0xC871, 0xC88B, Property::LVT)
      put(data, 0xC88C, 0xC88C, Property::LV)
      put(data, 0xC88D, 0xC8A7, Property::LVT)
      put(data, 0xC8A8, 0xC8A8, Property::LV)
      put(data, 0xC8A9, 0xC8C3, Property::LVT)
      put(data, 0xC8C4, 0xC8C4, Property::LV)
      put(data, 0xC8C5, 0xC8DF, Property::LVT)
      put(data, 0xC8E0, 0xC8E0, Property::LV)
      put(data, 0xC8E1, 0xC8FB, Property::LVT)
      put(data, 0xC8FC, 0xC8FC, Property::LV)
      put(data, 0xC8FD, 0xC917, Property::LVT)
      put(data, 0xC918, 0xC918, Property::LV)
      put(data, 0xC919, 0xC933, Property::LVT)
      put(data, 0xC934, 0xC934, Property::LV)
      put(data, 0xC935, 0xC94F, Property::LVT)
      put(data, 0xC950, 0xC950, Property::LV)
      put(data, 0xC951, 0xC96B, Property::LVT)
      put(data, 0xC96C, 0xC96C, Property::LV)
      put(data, 0xC96D, 0xC987, Property::LVT)
      put(data, 0xC988, 0xC988, Property::LV)
      put(data, 0xC989, 0xC9A3, Property::LVT)
      put(data, 0xC9A4, 0xC9A4, Property::LV)
      put(data, 0xC9A5, 0xC9BF, Property::LVT)
      put(data, 0xC9C0, 0xC9C0, Property::LV)
      put(data, 0xC9C1, 0xC9DB, Property::LVT)
      put(data, 0xC9DC, 0xC9DC, Property::LV)
      put(data, 0xC9DD, 0xC9F7, Property::LVT)
      put(data, 0xC9F8, 0xC9F8, Property::LV)
      put(data, 0xC9F9, 0xCA13, Property::LVT)
      put(data, 0xCA14, 0xCA14, Property::LV)
      put(data, 0xCA15, 0xCA2F, Property::LVT)
      put(data, 0xCA30, 0xCA30, Property::LV)
      put(data, 0xCA31, 0xCA4B, Property::LVT)
      put(data, 0xCA4C, 0xCA4C, Property::LV)
      put(data, 0xCA4D, 0xCA67, Property::LVT)
      put(data, 0xCA68, 0xCA68, Property::LV)
      put(data, 0xCA69, 0xCA83, Property::LVT)
      put(data, 0xCA84, 0xCA84, Property::LV)
      put(data, 0xCA85, 0xCA9F, Property::LVT)
      put(data, 0xCAA0, 0xCAA0, Property::LV)
      put(data, 0xCAA1, 0xCABB, Property::LVT)
      put(data, 0xCABC, 0xCABC, Property::LV)
      put(data, 0xCABD, 0xCAD7, Property::LVT)
      put(data, 0xCAD8, 0xCAD8, Property::LV)
      put(data, 0xCAD9, 0xCAF3, Property::LVT)
      put(data, 0xCAF4, 0xCAF4, Property::LV)
      put(data, 0xCAF5, 0xCB0F, Property::LVT)
      put(data, 0xCB10, 0xCB10, Property::LV)
      put(data, 0xCB11, 0xCB2B, Property::LVT)
      put(data, 0xCB2C, 0xCB2C, Property::LV)
      put(data, 0xCB2D, 0xCB47, Property::LVT)
      put(data, 0xCB48, 0xCB48, Property::LV)
      put(data, 0xCB49, 0xCB63, Property::LVT)
      put(data, 0xCB64, 0xCB64, Property::LV)
      put(data, 0xCB65, 0xCB7F, Property::LVT)
      put(data, 0xCB80, 0xCB80, Property::LV)
      put(data, 0xCB81, 0xCB9B, Property::LVT)
      put(data, 0xCB9C, 0xCB9C, Property::LV)
      put(data, 0xCB9D, 0xCBB7, Property::LVT)
      put(data, 0xCBB8, 0xCBB8, Property::LV)
      put(data, 0xCBB9, 0xCBD3, Property::LVT)
      put(data, 0xCBD4, 0xCBD4, Property::LV)
      put(data, 0xCBD5, 0xCBEF, Property::LVT)
      put(data, 0xCBF0, 0xCBF0, Property::LV)
      put(data, 0xCBF1, 0xCC0B, Property::LVT)
      put(data, 0xCC0C, 0xCC0C, Property::LV)
      put(data, 0xCC0D, 0xCC27, Property::LVT)
      put(data, 0xCC28, 0xCC28, Property::LV)
      put(data, 0xCC29, 0xCC43, Property::LVT)
      put(data, 0xCC44, 0xCC44, Property::LV)
      put(data, 0xCC45, 0xCC5F, Property::LVT)
      put(data, 0xCC60, 0xCC60, Property::LV)
      put(data, 0xCC61, 0xCC7B, Property::LVT)
      put(data, 0xCC7C, 0xCC7C, Property::LV)
      put(data, 0xCC7D, 0xCC97, Property::LVT)
      put(data, 0xCC98, 0xCC98, Property::LV)
      put(data, 0xCC99, 0xCCB3, Property::LVT)
      put(data, 0xCCB4, 0xCCB4, Property::LV)
      put(data, 0xCCB5, 0xCCCF, Property::LVT)
      put(data, 0xCCD0, 0xCCD0, Property::LV)
      put(data, 0xCCD1, 0xCCEB, Property::LVT)
      put(data, 0xCCEC, 0xCCEC, Property::LV)
      put(data, 0xCCED, 0xCD07, Property::LVT)
      put(data, 0xCD08, 0xCD08, Property::LV)
      put(data, 0xCD09, 0xCD23, Property::LVT)
      put(data, 0xCD24, 0xCD24, Property::LV)
      put(data, 0xCD25, 0xCD3F, Property::LVT)
      put(data, 0xCD40, 0xCD40, Property::LV)
      put(data, 0xCD41, 0xCD5B, Property::LVT)
      put(data, 0xCD5C, 0xCD5C, Property::LV)
      put(data, 0xCD5D, 0xCD77, Property::LVT)
      put(data, 0xCD78, 0xCD78, Property::LV)
      put(data, 0xCD79, 0xCD93, Property::LVT)
      put(data, 0xCD94, 0xCD94, Property::LV)
      put(data, 0xCD95, 0xCDAF, Property::LVT)
      put(data, 0xCDB0, 0xCDB0, Property::LV)
      put(data, 0xCDB1, 0xCDCB, Property::LVT)
      put(data, 0xCDCC, 0xCDCC, Property::LV)
      put(data, 0xCDCD, 0xCDE7, Property::LVT)
      put(data, 0xCDE8, 0xCDE8, Property::LV)
      put(data, 0xCDE9, 0xCE03, Property::LVT)
      put(data, 0xCE04, 0xCE04, Property::LV)
      put(data, 0xCE05, 0xCE1F, Property::LVT)
      put(data, 0xCE20, 0xCE20, Property::LV)
      put(data, 0xCE21, 0xCE3B, Property::LVT)
      put(data, 0xCE3C, 0xCE3C, Property::LV)
      put(data, 0xCE3D, 0xCE57, Property::LVT)
      put(data, 0xCE58, 0xCE58, Property::LV)
      put(data, 0xCE59, 0xCE73, Property::LVT)
      put(data, 0xCE74, 0xCE74, Property::LV)
      put(data, 0xCE75, 0xCE8F, Property::LVT)
      put(data, 0xCE90, 0xCE90, Property::LV)
      put(data, 0xCE91, 0xCEAB, Property::LVT)
      put(data, 0xCEAC, 0xCEAC, Property::LV)
      put(data, 0xCEAD, 0xCEC7, Property::LVT)
      put(data, 0xCEC8, 0xCEC8, Property::LV)
      put(data, 0xCEC9, 0xCEE3, Property::LVT)
      put(data, 0xCEE4, 0xCEE4, Property::LV)
      put(data, 0xCEE5, 0xCEFF, Property::LVT)
      put(data, 0xCF00, 0xCF00, Property::LV)
      put(data, 0xCF01, 0xCF1B, Property::LVT)
      put(data, 0xCF1C, 0xCF1C, Property::LV)
      put(data, 0xCF1D, 0xCF37, Property::LVT)
      put(data, 0xCF38, 0xCF38, Property::LV)
      put(data, 0xCF39, 0xCF53, Property::LVT)
      put(data, 0xCF54, 0xCF54, Property::LV)
      put(data, 0xCF55, 0xCF6F, Property::LVT)
      put(data, 0xCF70, 0xCF70, Property::LV)
      put(data, 0xCF71, 0xCF8B, Property::LVT)
      put(data, 0xCF8C, 0xCF8C, Property::LV)
      put(data, 0xCF8D, 0xCFA7, Property::LVT)
      put(data, 0xCFA8, 0xCFA8, Property::LV)
      put(data, 0xCFA9, 0xCFC3, Property::LVT)
      put(data, 0xCFC4, 0xCFC4, Property::LV)
      put(data, 0xCFC5, 0xCFDF, Property::LVT)
      put(data, 0xCFE0, 0xCFE0, Property::LV)
      put(data, 0xCFE1, 0xCFFB, Property::LVT)
      put(data, 0xCFFC, 0xCFFC, Property::LV)
      put(data, 0xCFFD, 0xD017, Property::LVT)
      put(data, 0xD018, 0xD018, Property::LV)
      put(data, 0xD019, 0xD033, Property::LVT)
      put(data, 0xD034, 0xD034, Property::LV)
      put(data, 0xD035, 0xD04F, Property::LVT)
      put(data, 0xD050, 0xD050, Property::LV)
      put(data, 0xD051, 0xD06B, Property::LVT)
      put(data, 0xD06C, 0xD06C, Property::LV)
      put(data, 0xD06D, 0xD087, Property::LVT)
      put(data, 0xD088, 0xD088, Property::LV)
      put(data, 0xD089, 0xD0A3, Property::LVT)
      put(data, 0xD0A4, 0xD0A4, Property::LV)
      put(data, 0xD0A5, 0xD0BF, Property::LVT)
      put(data, 0xD0C0, 0xD0C0, Property::LV)
      put(data, 0xD0C1, 0xD0DB, Property::LVT)
      put(data, 0xD0DC, 0xD0DC, Property::LV)
      put(data, 0xD0DD, 0xD0F7, Property::LVT)
      put(data, 0xD0F8, 0xD0F8, Property::LV)
      put(data, 0xD0F9, 0xD113, Property::LVT)
      put(data, 0xD114, 0xD114, Property::LV)
      put(data, 0xD115, 0xD12F, Property::LVT)
      put(data, 0xD130, 0xD130, Property::LV)
      put(data, 0xD131, 0xD14B, Property::LVT)
      put(data, 0xD14C, 0xD14C, Property::LV)
      put(data, 0xD14D, 0xD167, Property::LVT)
      put(data, 0xD168, 0xD168, Property::LV)
      put(data, 0xD169, 0xD183, Property::LVT)
      put(data, 0xD184, 0xD184, Property::LV)
      put(data, 0xD185, 0xD19F, Property::LVT)
      put(data, 0xD1A0, 0xD1A0, Property::LV)
      put(data, 0xD1A1, 0xD1BB, Property::LVT)
      put(data, 0xD1BC, 0xD1BC, Property::LV)
      put(data, 0xD1BD, 0xD1D7, Property::LVT)
      put(data, 0xD1D8, 0xD1D8, Property::LV)
      put(data, 0xD1D9, 0xD1F3, Property::LVT)
      put(data, 0xD1F4, 0xD1F4, Property::LV)
      put(data, 0xD1F5, 0xD20F, Property::LVT)
      put(data, 0xD210, 0xD210, Property::LV)
      put(data, 0xD211, 0xD22B, Property::LVT)
      put(data, 0xD22C, 0xD22C, Property::LV)
      put(data, 0xD22D, 0xD247, Property::LVT)
      put(data, 0xD248, 0xD248, Property::LV)
      put(data, 0xD249, 0xD263, Property::LVT)
      put(data, 0xD264, 0xD264, Property::LV)
      put(data, 0xD265, 0xD27F, Property::LVT)
      put(data, 0xD280, 0xD280, Property::LV)
      put(data, 0xD281, 0xD29B, Property::LVT)
      put(data, 0xD29C, 0xD29C, Property::LV)
      put(data, 0xD29D, 0xD2B7, Property::LVT)
      put(data, 0xD2B8, 0xD2B8, Property::LV)
      put(data, 0xD2B9, 0xD2D3, Property::LVT)
      put(data, 0xD2D4, 0xD2D4, Property::LV)
      put(data, 0xD2D5, 0xD2EF, Property::LVT)
      put(data, 0xD2F0, 0xD2F0, Property::LV)
      put(data, 0xD2F1, 0xD30B, Property::LVT)
      put(data, 0xD30C, 0xD30C, Property::LV)
      put(data, 0xD30D, 0xD327, Property::LVT)
      put(data, 0xD328, 0xD328, Property::LV)
      put(data, 0xD329, 0xD343, Property::LVT)
      put(data, 0xD344, 0xD344, Property::LV)
      put(data, 0xD345, 0xD35F, Property::LVT)
      put(data, 0xD360, 0xD360, Property::LV)
      put(data, 0xD361, 0xD37B, Property::LVT)
      put(data, 0xD37C, 0xD37C, Property::LV)
      put(data, 0xD37D, 0xD397, Property::LVT)
      put(data, 0xD398, 0xD398, Property::LV)
      put(data, 0xD399, 0xD3B3, Property::LVT)
      put(data, 0xD3B4, 0xD3B4, Property::LV)
      put(data, 0xD3B5, 0xD3CF, Property::LVT)
      put(data, 0xD3D0, 0xD3D0, Property::LV)
      put(data, 0xD3D1, 0xD3EB, Property::LVT)
      put(data, 0xD3EC, 0xD3EC, Property::LV)
      put(data, 0xD3ED, 0xD407, Property::LVT)
      put(data, 0xD408, 0xD408, Property::LV)
      put(data, 0xD409, 0xD423, Property::LVT)
      put(data, 0xD424, 0xD424, Property::LV)
      put(data, 0xD425, 0xD43F, Property::LVT)
      put(data, 0xD440, 0xD440, Property::LV)
      put(data, 0xD441, 0xD45B, Property::LVT)
      put(data, 0xD45C, 0xD45C, Property::LV)
      put(data, 0xD45D, 0xD477, Property::LVT)
      put(data, 0xD478, 0xD478, Property::LV)
      put(data, 0xD479, 0xD493, Property::LVT)
      put(data, 0xD494, 0xD494, Property::LV)
      put(data, 0xD495, 0xD4AF, Property::LVT)
      put(data, 0xD4B0, 0xD4B0, Property::LV)
      put(data, 0xD4B1, 0xD4CB, Property::LVT)
      put(data, 0xD4CC, 0xD4CC, Property::LV)
      put(data, 0xD4CD, 0xD4E7, Property::LVT)
      put(data, 0xD4E8, 0xD4E8, Property::LV)
      put(data, 0xD4E9, 0xD503, Property::LVT)
      put(data, 0xD504, 0xD504, Property::LV)
      put(data, 0xD505, 0xD51F, Property::LVT)
      put(data, 0xD520, 0xD520, Property::LV)
      put(data, 0xD521, 0xD53B, Property::LVT)
      put(data, 0xD53C, 0xD53C, Property::LV)
      put(data, 0xD53D, 0xD557, Property::LVT)
      put(data, 0xD558, 0xD558, Property::LV)
      put(data, 0xD559, 0xD573, Property::LVT)
      put(data, 0xD574, 0xD574, Property::LV)
      put(data, 0xD575, 0xD58F, Property::LVT)
      put(data, 0xD590, 0xD590, Property::LV)
      put(data, 0xD591, 0xD5AB, Property::LVT)
      put(data, 0xD5AC, 0xD5AC, Property::LV)
      put(data, 0xD5AD, 0xD5C7, Property::LVT)
      put(data, 0xD5C8, 0xD5C8, Property::LV)
      put(data, 0xD5C9, 0xD5E3, Property::LVT)
      put(data, 0xD5E4, 0xD5E4, Property::LV)
      put(data, 0xD5E5, 0xD5FF, Property::LVT)
      put(data, 0xD600, 0xD600, Property::LV)
      put(data, 0xD601, 0xD61B, Property::LVT)
      put(data, 0xD61C, 0xD61C, Property::LV)
      put(data, 0xD61D, 0xD637, Property::LVT)
      put(data, 0xD638, 0xD638, Property::LV)
      put(data, 0xD639, 0xD653, Property::LVT)
      put(data, 0xD654, 0xD654, Property::LV)
      put(data, 0xD655, 0xD66F, Property::LVT)
      put(data, 0xD670, 0xD670, Property::LV)
      put(data, 0xD671, 0xD68B, Property::LVT)
      put(data, 0xD68C, 0xD68C, Property::LV)
      put(data, 0xD68D, 0xD6A7, Property::LVT)
      put(data, 0xD6A8, 0xD6A8, Property::LV)
      put(data, 0xD6A9, 0xD6C3, Property::LVT)
      put(data, 0xD6C4, 0xD6C4, Property::LV)
      put(data, 0xD6C5, 0xD6DF, Property::LVT)
      put(data, 0xD6E0, 0xD6E0, Property::LV)
      put(data, 0xD6E1, 0xD6FB, Property::LVT)
      put(data, 0xD6FC, 0xD6FC, Property::LV)
      put(data, 0xD6FD, 0xD717, Property::LVT)
      put(data, 0xD718, 0xD718, Property::LV)
      put(data, 0xD719, 0xD733, Property::LVT)
      put(data, 0xD734, 0xD734, Property::LV)
      put(data, 0xD735, 0xD74F, Property::LVT)
      put(data, 0xD750, 0xD750, Property::LV)
      put(data, 0xD751, 0xD76B, Property::LVT)
      put(data, 0xD76C, 0xD76C, Property::LV)
      put(data, 0xD76D, 0xD787, Property::LVT)
      put(data, 0xD788, 0xD788, Property::LV)
      put(data, 0xD789, 0xD7A3, Property::LVT)
      put(data, 0xD7B0, 0xD7C6, Property::V)
      put(data, 0xD7CB, 0xD7FB, Property::T)
      put(data, 0xFB1E, 0xFB1E, Property::Extend)
      put(data, 0xFE00, 0xFE0F, Property::Extend)
      put(data, 0xFE20, 0xFE2F, Property::Extend)
      put(data, 0xFEFF, 0xFEFF, Property::Control)
      put(data, 0xFF9E, 0xFF9F, Property::Extend)
      put(data, 0xFFF0, 0xFFFB, Property::Control)
      put(data, 0x101FD, 0x101FD, Property::Extend)
      put(data, 0x102E0, 0x102E0, Property::Extend)
      put(data, 0x10376, 0x1037A, Property::Extend)
      put(data, 0x10A01, 0x10A03, Property::Extend)
      put(data, 0x10A05, 0x10A06, Property::Extend)
      put(data, 0x10A0C, 0x10A0F, Property::Extend)
      put(data, 0x10A38, 0x10A3A, Property::Extend)
      put(data, 0x10A3F, 0x10A3F, Property::Extend)
      put(data, 0x10AE5, 0x10AE6, Property::Extend)
      put(data, 0x10D24, 0x10D27, Property::Extend)
      put(data, 0x10D69, 0x10D6D, Property::Extend)
      put(data, 0x10EAB, 0x10EAC, Property::Extend)
      put(data, 0x10EFA, 0x10EFF, Property::Extend)
      put(data, 0x10F46, 0x10F50, Property::Extend)
      put(data, 0x10F82, 0x10F85, Property::Extend)
      put(data, 0x11000, 0x11000, Property::SpacingMark)
      put(data, 0x11001, 0x11001, Property::Extend)
      put(data, 0x11002, 0x11002, Property::SpacingMark)
      put(data, 0x11038, 0x11046, Property::Extend)
      put(data, 0x11070, 0x11070, Property::Extend)
      put(data, 0x11073, 0x11074, Property::Extend)
      put(data, 0x1107F, 0x11081, Property::Extend)
      put(data, 0x11082, 0x11082, Property::SpacingMark)
      put(data, 0x110B0, 0x110B2, Property::SpacingMark)
      put(data, 0x110B3, 0x110B6, Property::Extend)
      put(data, 0x110B7, 0x110B8, Property::SpacingMark)
      put(data, 0x110B9, 0x110BA, Property::Extend)
      put(data, 0x110BD, 0x110BD, Property::Prepend)
      put(data, 0x110C2, 0x110C2, Property::Extend)
      put(data, 0x110CD, 0x110CD, Property::Prepend)
      put(data, 0x11100, 0x11102, Property::Extend)
      put(data, 0x11127, 0x1112B, Property::Extend)
      put(data, 0x1112C, 0x1112C, Property::SpacingMark)
      put(data, 0x1112D, 0x11134, Property::Extend)
      put(data, 0x11145, 0x11146, Property::SpacingMark)
      put(data, 0x11173, 0x11173, Property::Extend)
      put(data, 0x11180, 0x11181, Property::Extend)
      put(data, 0x11182, 0x11182, Property::SpacingMark)
      put(data, 0x111B3, 0x111B5, Property::SpacingMark)
      put(data, 0x111B6, 0x111BE, Property::Extend)
      put(data, 0x111BF, 0x111BF, Property::SpacingMark)
      put(data, 0x111C0, 0x111C0, Property::Extend)
      put(data, 0x111C2, 0x111C3, Property::Prepend)
      put(data, 0x111C9, 0x111CC, Property::Extend)
      put(data, 0x111CE, 0x111CE, Property::SpacingMark)
      put(data, 0x111CF, 0x111CF, Property::Extend)
      put(data, 0x1122C, 0x1122E, Property::SpacingMark)
      put(data, 0x1122F, 0x11231, Property::Extend)
      put(data, 0x11232, 0x11233, Property::SpacingMark)
      put(data, 0x11234, 0x11237, Property::Extend)
      put(data, 0x1123E, 0x1123E, Property::Extend)
      put(data, 0x11241, 0x11241, Property::Extend)
      put(data, 0x112DF, 0x112DF, Property::Extend)
      put(data, 0x112E0, 0x112E2, Property::SpacingMark)
      put(data, 0x112E3, 0x112EA, Property::Extend)
      put(data, 0x11300, 0x11301, Property::Extend)
      put(data, 0x11302, 0x11303, Property::SpacingMark)
      put(data, 0x1133B, 0x1133C, Property::Extend)
      put(data, 0x1133E, 0x1133E, Property::Extend)
      put(data, 0x1133F, 0x1133F, Property::SpacingMark)
      put(data, 0x11340, 0x11340, Property::Extend)
      put(data, 0x11341, 0x11344, Property::SpacingMark)
      put(data, 0x11347, 0x11348, Property::SpacingMark)
      put(data, 0x1134B, 0x1134C, Property::SpacingMark)
      put(data, 0x1134D, 0x1134D, Property::Extend)
      put(data, 0x11357, 0x11357, Property::Extend)
      put(data, 0x11362, 0x11363, Property::SpacingMark)
      put(data, 0x11366, 0x1136C, Property::Extend)
      put(data, 0x11370, 0x11374, Property::Extend)
      put(data, 0x113B8, 0x113B8, Property::Extend)
      put(data, 0x113B9, 0x113BA, Property::SpacingMark)
      put(data, 0x113BB, 0x113C0, Property::Extend)
      put(data, 0x113C2, 0x113C2, Property::Extend)
      put(data, 0x113C5, 0x113C5, Property::Extend)
      put(data, 0x113C7, 0x113C9, Property::Extend)
      put(data, 0x113CA, 0x113CA, Property::SpacingMark)
      put(data, 0x113CC, 0x113CD, Property::SpacingMark)
      put(data, 0x113CE, 0x113D0, Property::Extend)
      put(data, 0x113D1, 0x113D1, Property::Prepend)
      put(data, 0x113D2, 0x113D2, Property::Extend)
      put(data, 0x113E1, 0x113E2, Property::Extend)
      put(data, 0x11435, 0x11437, Property::SpacingMark)
      put(data, 0x11438, 0x1143F, Property::Extend)
      put(data, 0x11440, 0x11441, Property::SpacingMark)
      put(data, 0x11442, 0x11444, Property::Extend)
      put(data, 0x11445, 0x11445, Property::SpacingMark)
      put(data, 0x11446, 0x11446, Property::Extend)
      put(data, 0x1145E, 0x1145E, Property::Extend)
      put(data, 0x114B0, 0x114B0, Property::Extend)
      put(data, 0x114B1, 0x114B2, Property::SpacingMark)
      put(data, 0x114B3, 0x114B8, Property::Extend)
      put(data, 0x114B9, 0x114B9, Property::SpacingMark)
      put(data, 0x114BA, 0x114BA, Property::Extend)
      put(data, 0x114BB, 0x114BC, Property::SpacingMark)
      put(data, 0x114BD, 0x114BD, Property::Extend)
      put(data, 0x114BE, 0x114BE, Property::SpacingMark)
      put(data, 0x114BF, 0x114C0, Property::Extend)
      put(data, 0x114C1, 0x114C1, Property::SpacingMark)
      put(data, 0x114C2, 0x114C3, Property::Extend)
      put(data, 0x115AF, 0x115AF, Property::Extend)
      put(data, 0x115B0, 0x115B1, Property::SpacingMark)
      put(data, 0x115B2, 0x115B5, Property::Extend)
      put(data, 0x115B8, 0x115BB, Property::SpacingMark)
      put(data, 0x115BC, 0x115BD, Property::Extend)
      put(data, 0x115BE, 0x115BE, Property::SpacingMark)
      put(data, 0x115BF, 0x115C0, Property::Extend)
      put(data, 0x115DC, 0x115DD, Property::Extend)
      put(data, 0x11630, 0x11632, Property::SpacingMark)
      put(data, 0x11633, 0x1163A, Property::Extend)
      put(data, 0x1163B, 0x1163C, Property::SpacingMark)
      put(data, 0x1163D, 0x1163D, Property::Extend)
      put(data, 0x1163E, 0x1163E, Property::SpacingMark)
      put(data, 0x1163F, 0x11640, Property::Extend)
      put(data, 0x116AB, 0x116AB, Property::Extend)
      put(data, 0x116AC, 0x116AC, Property::SpacingMark)
      put(data, 0x116AD, 0x116AD, Property::Extend)
      put(data, 0x116AE, 0x116AF, Property::SpacingMark)
      put(data, 0x116B0, 0x116B7, Property::Extend)
      put(data, 0x1171D, 0x1171D, Property::Extend)
      put(data, 0x1171E, 0x1171E, Property::SpacingMark)
      put(data, 0x1171F, 0x1171F, Property::Extend)
      put(data, 0x11722, 0x11725, Property::Extend)
      put(data, 0x11726, 0x11726, Property::SpacingMark)
      put(data, 0x11727, 0x1172B, Property::Extend)
      put(data, 0x1182C, 0x1182E, Property::SpacingMark)
      put(data, 0x1182F, 0x11837, Property::Extend)
      put(data, 0x11838, 0x11838, Property::SpacingMark)
      put(data, 0x11839, 0x1183A, Property::Extend)
      put(data, 0x11930, 0x11930, Property::Extend)
      put(data, 0x11931, 0x11935, Property::SpacingMark)
      put(data, 0x11937, 0x11938, Property::SpacingMark)
      put(data, 0x1193B, 0x1193E, Property::Extend)
      put(data, 0x1193F, 0x1193F, Property::Prepend)
      put(data, 0x11940, 0x11940, Property::SpacingMark)
      put(data, 0x11941, 0x11941, Property::Prepend)
      put(data, 0x11942, 0x11942, Property::SpacingMark)
      put(data, 0x11943, 0x11943, Property::Extend)
      put(data, 0x119D1, 0x119D3, Property::SpacingMark)
      put(data, 0x119D4, 0x119D7, Property::Extend)
      put(data, 0x119DA, 0x119DB, Property::Extend)
      put(data, 0x119DC, 0x119DF, Property::SpacingMark)
      put(data, 0x119E0, 0x119E0, Property::Extend)
      put(data, 0x119E4, 0x119E4, Property::SpacingMark)
      put(data, 0x11A01, 0x11A0A, Property::Extend)
      put(data, 0x11A33, 0x11A38, Property::Extend)
      put(data, 0x11A39, 0x11A39, Property::SpacingMark)
      put(data, 0x11A3B, 0x11A3E, Property::Extend)
      put(data, 0x11A47, 0x11A47, Property::Extend)
      put(data, 0x11A51, 0x11A56, Property::Extend)
      put(data, 0x11A57, 0x11A58, Property::SpacingMark)
      put(data, 0x11A59, 0x11A5B, Property::Extend)
      put(data, 0x11A84, 0x11A89, Property::Prepend)
      put(data, 0x11A8A, 0x11A96, Property::Extend)
      put(data, 0x11A97, 0x11A97, Property::SpacingMark)
      put(data, 0x11A98, 0x11A99, Property::Extend)
      put(data, 0x11B60, 0x11B60, Property::Extend)
      put(data, 0x11B61, 0x11B61, Property::SpacingMark)
      put(data, 0x11B62, 0x11B64, Property::Extend)
      put(data, 0x11B65, 0x11B65, Property::SpacingMark)
      put(data, 0x11B66, 0x11B66, Property::Extend)
      put(data, 0x11B67, 0x11B67, Property::SpacingMark)
      put(data, 0x11C2F, 0x11C2F, Property::SpacingMark)
      put(data, 0x11C30, 0x11C36, Property::Extend)
      put(data, 0x11C38, 0x11C3D, Property::Extend)
      put(data, 0x11C3E, 0x11C3E, Property::SpacingMark)
      put(data, 0x11C3F, 0x11C3F, Property::Extend)
      put(data, 0x11C92, 0x11CA7, Property::Extend)
      put(data, 0x11CA9, 0x11CA9, Property::SpacingMark)
      put(data, 0x11CAA, 0x11CB0, Property::Extend)
      put(data, 0x11CB1, 0x11CB1, Property::SpacingMark)
      put(data, 0x11CB2, 0x11CB3, Property::Extend)
      put(data, 0x11CB4, 0x11CB4, Property::SpacingMark)
      put(data, 0x11CB5, 0x11CB6, Property::Extend)
      put(data, 0x11D31, 0x11D36, Property::Extend)
      put(data, 0x11D3A, 0x11D3A, Property::Extend)
      put(data, 0x11D3C, 0x11D3D, Property::Extend)
      put(data, 0x11D3F, 0x11D45, Property::Extend)
      put(data, 0x11D46, 0x11D46, Property::Prepend)
      put(data, 0x11D47, 0x11D47, Property::Extend)
      put(data, 0x11D8A, 0x11D8E, Property::SpacingMark)
      put(data, 0x11D90, 0x11D91, Property::Extend)
      put(data, 0x11D93, 0x11D94, Property::SpacingMark)
      put(data, 0x11D95, 0x11D95, Property::Extend)
      put(data, 0x11D96, 0x11D96, Property::SpacingMark)
      put(data, 0x11D97, 0x11D97, Property::Extend)
      put(data, 0x11EF3, 0x11EF4, Property::Extend)
      put(data, 0x11EF5, 0x11EF6, Property::SpacingMark)
      put(data, 0x11F00, 0x11F01, Property::Extend)
      put(data, 0x11F02, 0x11F02, Property::Prepend)
      put(data, 0x11F03, 0x11F03, Property::SpacingMark)
      put(data, 0x11F34, 0x11F35, Property::SpacingMark)
      put(data, 0x11F36, 0x11F3A, Property::Extend)
      put(data, 0x11F3E, 0x11F3F, Property::SpacingMark)
      put(data, 0x11F40, 0x11F42, Property::Extend)
      put(data, 0x11F5A, 0x11F5A, Property::Extend)
      put(data, 0x13430, 0x1343F, Property::Control)
      put(data, 0x13440, 0x13440, Property::Extend)
      put(data, 0x13447, 0x13455, Property::Extend)
      put(data, 0x1611E, 0x16129, Property::Extend)
      put(data, 0x1612A, 0x1612C, Property::SpacingMark)
      put(data, 0x1612D, 0x1612F, Property::Extend)
      put(data, 0x16AF0, 0x16AF4, Property::Extend)
      put(data, 0x16B30, 0x16B36, Property::Extend)
      put(data, 0x16D63, 0x16D63, Property::V)
      put(data, 0x16D67, 0x16D6A, Property::V)
      put(data, 0x16F4F, 0x16F4F, Property::Extend)
      put(data, 0x16F51, 0x16F87, Property::SpacingMark)
      put(data, 0x16F8F, 0x16F92, Property::Extend)
      put(data, 0x16FE4, 0x16FE4, Property::Extend)
      put(data, 0x16FF0, 0x16FF1, Property::Extend)
      put(data, 0x1BC9D, 0x1BC9E, Property::Extend)
      put(data, 0x1BCA0, 0x1BCA3, Property::Control)
      put(data, 0x1CF00, 0x1CF2D, Property::Extend)
      put(data, 0x1CF30, 0x1CF46, Property::Extend)
      put(data, 0x1D165, 0x1D169, Property::Extend)
      put(data, 0x1D16D, 0x1D172, Property::Extend)
      put(data, 0x1D173, 0x1D17A, Property::Control)
      put(data, 0x1D17B, 0x1D182, Property::Extend)
      put(data, 0x1D185, 0x1D18B, Property::Extend)
      put(data, 0x1D1AA, 0x1D1AD, Property::Extend)
      put(data, 0x1D242, 0x1D244, Property::Extend)
      put(data, 0x1DA00, 0x1DA36, Property::Extend)
      put(data, 0x1DA3B, 0x1DA6C, Property::Extend)
      put(data, 0x1DA75, 0x1DA75, Property::Extend)
      put(data, 0x1DA84, 0x1DA84, Property::Extend)
      put(data, 0x1DA9B, 0x1DA9F, Property::Extend)
      put(data, 0x1DAA1, 0x1DAAF, Property::Extend)
      put(data, 0x1E000, 0x1E006, Property::Extend)
      put(data, 0x1E008, 0x1E018, Property::Extend)
      put(data, 0x1E01B, 0x1E021, Property::Extend)
      put(data, 0x1E023, 0x1E024, Property::Extend)
      put(data, 0x1E026, 0x1E02A, Property::Extend)
      put(data, 0x1E08F, 0x1E08F, Property::Extend)
      put(data, 0x1E130, 0x1E136, Property::Extend)
      put(data, 0x1E2AE, 0x1E2AE, Property::Extend)
      put(data, 0x1E2EC, 0x1E2EF, Property::Extend)
      put(data, 0x1E4EC, 0x1E4EF, Property::Extend)
      put(data, 0x1E5EE, 0x1E5EF, Property::Extend)
      put(data, 0x1E6E3, 0x1E6E3, Property::Extend)
      put(data, 0x1E6E6, 0x1E6E6, Property::Extend)
      put(data, 0x1E6EE, 0x1E6EF, Property::Extend)
      put(data, 0x1E6F5, 0x1E6F5, Property::Extend)
      put(data, 0x1E8D0, 0x1E8D6, Property::Extend)
      put(data, 0x1E944, 0x1E94A, Property::Extend)
      put(data, 0x1F004, 0x1F004, Property::ExtendedPictographic)
      put(data, 0x1F02C, 0x1F02F, Property::ExtendedPictographic)
      put(data, 0x1F094, 0x1F09F, Property::ExtendedPictographic)
      put(data, 0x1F0AF, 0x1F0B0, Property::ExtendedPictographic)
      put(data, 0x1F0C0, 0x1F0C0, Property::ExtendedPictographic)
      put(data, 0x1F0CF, 0x1F0D0, Property::ExtendedPictographic)
      put(data, 0x1F0F6, 0x1F0FF, Property::ExtendedPictographic)
      put(data, 0x1F170, 0x1F171, Property::ExtendedPictographic)
      put(data, 0x1F17E, 0x1F17F, Property::ExtendedPictographic)
      put(data, 0x1F18E, 0x1F18E, Property::ExtendedPictographic)
      put(data, 0x1F191, 0x1F19A, Property::ExtendedPictographic)
      put(data, 0x1F1AE, 0x1F1E5, Property::ExtendedPictographic)
      put(data, 0x1F1E6, 0x1F1FF, Property::RegionalIndicator)
      put(data, 0x1F201, 0x1F20F, Property::ExtendedPictographic)
      put(data, 0x1F21A, 0x1F21A, Property::ExtendedPictographic)
      put(data, 0x1F22F, 0x1F22F, Property::ExtendedPictographic)
      put(data, 0x1F232, 0x1F23A, Property::ExtendedPictographic)
      put(data, 0x1F23C, 0x1F23F, Property::ExtendedPictographic)
      put(data, 0x1F249, 0x1F25F, Property::ExtendedPictographic)
      put(data, 0x1F266, 0x1F321, Property::ExtendedPictographic)
      put(data, 0x1F324, 0x1F393, Property::ExtendedPictographic)
      put(data, 0x1F396, 0x1F397, Property::ExtendedPictographic)
      put(data, 0x1F399, 0x1F39B, Property::ExtendedPictographic)
      put(data, 0x1F39E, 0x1F3F0, Property::ExtendedPictographic)
      put(data, 0x1F3F3, 0x1F3F5, Property::ExtendedPictographic)
      put(data, 0x1F3F7, 0x1F3FA, Property::ExtendedPictographic)
      put(data, 0x1F3FB, 0x1F3FF, Property::Extend)
      put(data, 0x1F400, 0x1F4FD, Property::ExtendedPictographic)
      put(data, 0x1F4FF, 0x1F53D, Property::ExtendedPictographic)
      put(data, 0x1F549, 0x1F54E, Property::ExtendedPictographic)
      put(data, 0x1F550, 0x1F567, Property::ExtendedPictographic)
      put(data, 0x1F56F, 0x1F570, Property::ExtendedPictographic)
      put(data, 0x1F573, 0x1F57A, Property::ExtendedPictographic)
      put(data, 0x1F587, 0x1F587, Property::ExtendedPictographic)
      put(data, 0x1F58A, 0x1F58D, Property::ExtendedPictographic)
      put(data, 0x1F590, 0x1F590, Property::ExtendedPictographic)
      put(data, 0x1F595, 0x1F596, Property::ExtendedPictographic)
      put(data, 0x1F5A4, 0x1F5A5, Property::ExtendedPictographic)
      put(data, 0x1F5A8, 0x1F5A8, Property::ExtendedPictographic)
      put(data, 0x1F5B1, 0x1F5B2, Property::ExtendedPictographic)
      put(data, 0x1F5BC, 0x1F5BC, Property::ExtendedPictographic)
      put(data, 0x1F5C2, 0x1F5C4, Property::ExtendedPictographic)
      put(data, 0x1F5D1, 0x1F5D3, Property::ExtendedPictographic)
      put(data, 0x1F5DC, 0x1F5DE, Property::ExtendedPictographic)
      put(data, 0x1F5E1, 0x1F5E1, Property::ExtendedPictographic)
      put(data, 0x1F5E3, 0x1F5E3, Property::ExtendedPictographic)
      put(data, 0x1F5E8, 0x1F5E8, Property::ExtendedPictographic)
      put(data, 0x1F5EF, 0x1F5EF, Property::ExtendedPictographic)
      put(data, 0x1F5F3, 0x1F5F3, Property::ExtendedPictographic)
      put(data, 0x1F5FA, 0x1F64F, Property::ExtendedPictographic)
      put(data, 0x1F680, 0x1F6C5, Property::ExtendedPictographic)
      put(data, 0x1F6CB, 0x1F6D2, Property::ExtendedPictographic)
      put(data, 0x1F6D5, 0x1F6E5, Property::ExtendedPictographic)
      put(data, 0x1F6E9, 0x1F6E9, Property::ExtendedPictographic)
      put(data, 0x1F6EB, 0x1F6F0, Property::ExtendedPictographic)
      put(data, 0x1F6F3, 0x1F6FF, Property::ExtendedPictographic)
      put(data, 0x1F7DA, 0x1F7FF, Property::ExtendedPictographic)
      put(data, 0x1F80C, 0x1F80F, Property::ExtendedPictographic)
      put(data, 0x1F848, 0x1F84F, Property::ExtendedPictographic)
      put(data, 0x1F85A, 0x1F85F, Property::ExtendedPictographic)
      put(data, 0x1F888, 0x1F88F, Property::ExtendedPictographic)
      put(data, 0x1F8AE, 0x1F8AF, Property::ExtendedPictographic)
      put(data, 0x1F8BC, 0x1F8BF, Property::ExtendedPictographic)
      put(data, 0x1F8C2, 0x1F8CF, Property::ExtendedPictographic)
      put(data, 0x1F8D9, 0x1F8FF, Property::ExtendedPictographic)
      put(data, 0x1F90C, 0x1F93A, Property::ExtendedPictographic)
      put(data, 0x1F93C, 0x1F945, Property::ExtendedPictographic)
      put(data, 0x1F947, 0x1F9FF, Property::ExtendedPictographic)
      put(data, 0x1FA58, 0x1FA5F, Property::ExtendedPictographic)
      put(data, 0x1FA6E, 0x1FAFF, Property::ExtendedPictographic)
      put(data, 0x1FC00, 0x1FFFD, Property::ExtendedPictographic)
      put(data, 0xE0000, 0xE001F, Property::Control)
      put(data, 0xE0020, 0xE007F, Property::Extend)
      put(data, 0xE0080, 0xE00FF, Property::Control)
      put(data, 0xE0100, 0xE01EF, Property::Extend)
      put(data, 0xE01F0, 0xE0FFF, Property::Control)
      data
    end
  end

  private def self.put(array : Array, *values) : Nil
    array << values
  end
end
