/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.echosvg.parser.CalcParseException;
import io.sf.carte.echosvg.parser.NumberParser;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.PointsHandler;
import java.io.IOException;
import org.w3c.css.om.unit.CSSUnit;

public class PointsParser
extends NumberParser {
    private PointsHandler pointsHandler;
    protected boolean eRead;
    private boolean processingY = false;
    private float lastX;

    public PointsParser(PointsHandler handler) {
        this.pointsHandler = handler;
    }

    public void setPointsHandler(PointsHandler handler) {
        this.pointsHandler = handler;
    }

    public PointsHandler getPointsHandler() {
        return this.pointsHandler;
    }

    @Override
    protected void doParse() throws ParseException, IOException {
        this.pointsHandler.startPoints();
        this.current = this.reader.read();
        this.skipSpaces();
        while (this.current != -1) {
            float y;
            float x;
            try {
                x = this.parseFloat();
            }
            catch (CalcParseException e) {
                this.processingY = false;
                this.cssParse();
                this.pointsHandler.endPoints();
                return;
            }
            this.skipCommaSpaces();
            try {
                y = this.parseFloat();
            }
            catch (CalcParseException e) {
                this.lastX = x;
                this.processingY = true;
                this.cssParse();
                this.pointsHandler.endPoints();
                return;
            }
            this.pointsHandler.point(x, y);
            this.skipCommaSpaces();
        }
        this.pointsHandler.endPoints();
    }

    @Override
    protected void handleNumber(short unitType, float floatValue) throws ParseException {
        if (unitType != 0) {
            throw new ParseException(this.createErrorMessage("dimension.not.number", new Object[]{CSSUnit.dimensionUnitString((short)unitType)}), -1, -1);
        }
        if (this.processingY) {
            this.pointsHandler.point(this.lastX, floatValue);
        } else {
            this.lastX = floatValue;
        }
        this.processingY = !this.processingY;
    }
}

