/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public abstract class AbstractBasePointerRelativeMsSymbol
extends AbstractMsSymbol {
    protected long offset;
    protected RecordNumber typeRecordNumber;
    protected String name;

    public AbstractBasePointerRelativeMsSymbol(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize, int offsetSize, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.offset = reader.parseVarSizedOffset(offsetSize);
        this.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.name = reader.parseString(pdb, strType);
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: [%08X], Type: %s, %s", this.getSymbolTypeName(), this.offset, this.pdb.getTypeRecord(this.typeRecordNumber), this.name));
    }
}

