/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pyghidra.interpreter;

import docking.action.DockingAction;
import ghidra.app.plugin.core.console.CodeCompletion;
import ghidra.app.plugin.core.interpreter.InterpreterConnection;
import ghidra.app.plugin.core.interpreter.InterpreterConsole;
import ghidra.app.plugin.core.interpreter.InterpreterPanelService;
import ghidra.pyghidra.PyGhidraPlugin;
import ghidra.pyghidra.interpreter.CancelAction;
import ghidra.pyghidra.interpreter.PyGhidraConsole;
import ghidra.pyghidra.interpreter.ResetAction;
import ghidra.util.Disposable;
import ghidra.util.exception.AssertException;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

public final class PyGhidraInterpreter
implements Disposable,
InterpreterConnection {
    private PyGhidraConsole pyghidraConsole = null;
    public final InterpreterConsole console;

    public PyGhidraInterpreter(PyGhidraPlugin plugin, boolean isPythonAvailable) {
        InterpreterPanelService service = (InterpreterPanelService)plugin.getTool().getService(InterpreterPanelService.class);
        this.console = service.createInterpreterPanel((InterpreterConnection)this, false);
        if (!isPythonAvailable) {
            this.console.addFirstActivationCallback(this::unavailableCallback);
        }
    }

    public void dispose() {
        if (this.pyghidraConsole != null) {
            this.pyghidraConsole.dispose();
        }
        this.console.dispose();
    }

    public Icon getIcon() {
        return ResourceManager.loadImage((String)"images/python.png");
    }

    public String getTitle() {
        return "PyGhidra";
    }

    public List<CodeCompletion> getCompletions(String cmd) {
        throw new AssertException("Unreachable, unimplemented and deprecated method");
    }

    public List<CodeCompletion> getCompletions(String cmd, int caretPos) {
        if (this.pyghidraConsole == null) {
            return List.of();
        }
        return this.pyghidraConsole.getCompletions(cmd, caretPos);
    }

    private void unavailableCallback() {
        this.console.setInputPermitted(false);
        PrintWriter out = this.console.getOutWriter();
        out.println("Ghidra was not started with PyGhidra. Python is not available.");
    }

    public void init(PyGhidraConsole pythonSideConsole) {
        if (this.pyghidraConsole != null) {
            throw new AssertException("the interpreter has already been initialized");
        }
        this.pyghidraConsole = pythonSideConsole;
        this.console.addFirstActivationCallback(this.pyghidraConsole::restart);
        this.console.addAction((DockingAction)new CancelAction(this.pyghidraConsole));
        this.console.addAction((DockingAction)new ResetAction(this.pyghidraConsole));
    }
}

