/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.EncodedAnnotation;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class AnnotationItem
implements StructConverter {
    private byte visibility;
    private EncodedAnnotation annotation;

    public AnnotationItem(BinaryReader reader) throws IOException {
        this.visibility = reader.readNextByte();
        this.annotation = new EncodedAnnotation(reader);
    }

    public byte getVisibility() {
        return this.visibility;
    }

    public EncodedAnnotation getAnnotation() {
        return this.annotation;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType annotationDataType = this.annotation.toDataType();
        StringBuilder builder = new StringBuilder();
        builder.append("annotation_item_");
        builder.append(this.visibility + "_");
        builder.append(annotationDataType.getName());
        StructureDataType structure = new StructureDataType(builder.toString(), 0);
        structure.add(BYTE, "visibility", null);
        structure.add(annotationDataType, "annotation", null);
        builder.append(structure.getLength() + "_");
        structure.setCategoryPath(new CategoryPath("/dex/annotation_item"));
        try {
            structure.setName(builder.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return structure;
    }
}

