/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tray.ahessian.server;

import com.caucho.hessian4.io.SerializerFactory;
import io.netty.channel.Channel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.handler.ipfilter.IpFilterRuleList;
import io.netty.util.internal.logging.InternalLogger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import org.rzo.netty.ahessian.application.jmx.remote.service.JmxSerializerFactory;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactoryBuilder;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactoryFactory;
import org.rzo.netty.ahessian.bootstrap.DefaultServer;
import org.rzo.netty.mcast.discovery.DiscoveryServer;

public class AHessianJmxServer {
    public AHessianJmxServer(MBeanServer mbeanServer, String ipFilter, String serviceDiscoveryName, int port, InternalLogger logger, int debug, InetAddress address) throws Exception {
        ChannelPipelineFactoryBuilder builder = new ChannelPipelineFactoryBuilder().serializerFactory((SerializerFactory)new JmxSerializerFactory()).rpcServiceInterface(MBeanServerConnection.class).rpcServerService((Object)mbeanServer).serviceThreads(10).ipFilter(ipFilter);
        if (debug > 2) {
            builder.debug();
        }
        HashSet<String> channelOptions = new HashSet<String>();
        channelOptions.add("TCP_NODELAY");
        int serverPort = port;
        DefaultServer server = new DefaultServer(OioServerSocketChannel.class, (ChannelPipelineFactoryFactory)builder, channelOptions, serverPort, address);
        server.start();
        Channel channel = server.getChannel();
        ExecutorService executor = Executors.newCachedThreadPool();
        if (serverPort == 0) {
            serverPort = ((InetSocketAddress)channel.localAddress()).getPort();
        }
        if (debug > 2 && logger != null) {
            logger.info("ahessian jmx service bound to port " + serverPort);
        }
        DiscoveryServer discovery = new DiscoveryServer();
        discovery.setDebug(debug > 2);
        discovery.setLogger(logger);
        discovery.setIpSet(new IpFilterRuleList("+n:localhost, -n:*"));
        discovery.setName(serviceDiscoveryName);
        discovery.setPort(serverPort);
        discovery.init();
    }

    public static void main(String[] args) throws Exception {
        MBeanServer _mbeanServer = MBeanServerFactory.createMBeanServer();
        AHessianJmxServer _ahessianServer = new AHessianJmxServer(_mbeanServer, "+n:localhost, -n:*", "test", 15009, null, 4, null);
    }
}

