/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.label;

import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.Demangler;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.MangledContext;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class DemanglerCmd
extends BackgroundCommand<Program> {
    private Address addr;
    private String mangled;
    private String result;
    private DemangledObject demangledObject;
    private static List<Demangler> demanglers;
    private DemanglerOptions options;

    public DemanglerCmd(Address addr, String mangled) {
        this(addr, mangled, new DemanglerOptions());
    }

    public DemanglerCmd(Address addr, String mangled, DemanglerOptions options) {
        super("Demangle Symbol", false, true, false);
        this.addr = addr;
        this.mangled = SymbolUtilities.getCleanSymbolName((String)mangled, (Address)addr);
        this.options = options;
    }

    public boolean applyTo(Program prog, TaskMonitor monitor) {
        for (Demangler demangler : DemanglerCmd.getDemanglers()) {
            if (!demangler.canDemangle(prog)) continue;
            if (!this.doDemangle(demangler, prog, monitor)) {
                return false;
            }
            if (this.result == null) continue;
            return true;
        }
        return false;
    }

    private boolean doDemangle(Demangler demangler, Program program, TaskMonitor monitor) {
        MangledContext mangledContext = demangler.createMangledContext(this.mangled, this.options, program, this.addr);
        try {
            this.demangledObject = demangler.demangle(mangledContext);
        }
        catch (DemangledException e) {
            if (e.isInvalidMangledName()) {
                this.setStatusMsg("Invalid mangled name");
                return true;
            }
            this.setStatusMsg("Unable to demangle symbol: " + this.mangled + " at " + String.valueOf(this.addr) + ".  Message: " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.setStatusMsg("Unable to demangle symbol: " + this.mangled + " at " + String.valueOf(this.addr) + ". Message: " + e.getMessage());
            return false;
        }
        if (this.demangledObject == null) {
            return true;
        }
        try {
            if (this.demangledObject.applyTo(program, this.addr, this.options, monitor)) {
                this.result = this.demangledObject.getSignature(true);
                return true;
            }
        }
        catch (Exception e) {
            this.updateStatusForUnexpectedException(e);
            return false;
        }
        this.setStatusMsg("Failed to apply mangled symbol at " + String.valueOf(this.addr) + "; name:  " + this.mangled + " (" + demangler.getClass().getName() + "/" + this.demangledObject.getClass().getName() + ")");
        return false;
    }

    private void updateStatusForUnexpectedException(Exception e) {
        String message = e.getMessage();
        if (message == null) {
            this.setStatusMsg("Unable to demangle symbol at " + this.addr.toString() + "; name: " + this.mangled + ".  Message: " + e.toString());
        } else {
            this.setStatusMsg("Unable to demangle symbol at " + this.addr.toString() + "; name: " + this.mangled + ".  Message: " + message);
        }
        Msg.error((Object)((Object)this), (Object)this.getStatusMsg(), (Throwable)e);
    }

    public String getResult() {
        return this.result;
    }

    public DemangledObject getDemangledObject() {
        return this.demangledObject;
    }

    private static List<Demangler> getDemanglers() {
        if (demanglers == null) {
            demanglers = ClassSearcher.getInstances(Demangler.class);
        }
        return demanglers;
    }
}

