/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.funcfixup;

import ghidra.app.util.bin.format.dwarf.DWARFFunction;
import ghidra.app.util.bin.format.dwarf.DWARFVariable;
import ghidra.app.util.bin.format.dwarf.funcfixup.DWARFFunctionFixup;
import ghidra.util.classfinder.ExtensionPointProperties;

@ExtensionPointProperties(priority=3000)
public class ThisCallingConventionDWARFFunctionFixup
implements DWARFFunctionFixup {
    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc) {
        if (dfunc.params.isEmpty() || dfunc.callingConventionName != null) {
            return;
        }
        DWARFVariable firstParam = dfunc.params.get(0);
        if (firstParam.isThis) {
            if (!firstParam.name.isAnon() && !"this".equals(firstParam.name.getOriginalName())) {
                dfunc.getProgram().logWarningAt(dfunc.address, dfunc.name.getName(), "Renamed parameter \"%s\" to %s".formatted(firstParam.name.getName(), "this"));
            }
            firstParam.name = firstParam.name.replaceName("this", "this");
            dfunc.callingConventionName = "__thiscall";
        }
    }
}

