/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.line;

public class DWARFLineProgramState {
    public long address;
    public int file = 1;
    public int line = 1;
    public int column;
    public boolean isStatement;
    public boolean isBasicBlock;
    public boolean isEndSequence;
    public boolean prologueEnd;
    public boolean epilogueBegin;
    public long isa;
    public long discriminator;

    public DWARFLineProgramState(boolean defaultIsStatement) {
        this.isStatement = defaultIsStatement;
    }

    public DWARFLineProgramState(DWARFLineProgramState other) {
        this.address = other.address;
        this.file = other.file;
        this.line = other.line;
        this.column = other.column;
        this.isStatement = other.isStatement;
        this.isBasicBlock = other.isBasicBlock;
        this.isEndSequence = other.isEndSequence;
        this.prologueEnd = other.prologueEnd;
        this.epilogueBegin = other.epilogueBegin;
        this.isa = other.isa;
        this.discriminator = other.discriminator;
    }

    public boolean isSameFileLine(DWARFLineProgramState other) {
        return this.file == other.file && this.line == other.line;
    }

    public String toString() {
        return String.format("DWARFLineProgramState [address=%s, file=%s, line=%s, column=%s, isStatement=%s, isBasicBlock=%s, isEndSequence=%s, prologueEnd=%s, epilogueBegin=%s, isa=%s, discriminator=%s]", this.address, this.file, this.line, this.column, this.isStatement, this.isBasicBlock, this.isEndSequence, this.prologueEnd, this.epilogueBegin, this.isa, this.discriminator);
    }
}

