/*
 * Decompiled with CFR 0.152.
 */
package generic.lsh.vector;

import generic.lsh.vector.HashEntry;
import generic.lsh.vector.LSHCosineVector;
import generic.lsh.vector.LSHVector;
import generic.lsh.vector.VectorCompare;
import java.util.TreeSet;

public class LSHCosineVectorAccum
extends LSHCosineVector {
    private TreeSet<Entry> treehash = new TreeSet();
    private boolean finalized = false;

    public void addHash(int h, double w) {
        if (this.finalized) {
            throw new RuntimeException("already finalized");
        }
        this.treehash.add(new Entry(h, w));
    }

    public void doFinalize() {
        if (this.finalized) {
            return;
        }
        HashEntry[] entries = new HashEntry[this.treehash.size()];
        int count = 0;
        for (Entry entry : this.treehash) {
            HashEntry h;
            entries[count] = h = new HashEntry(entry.hash, 1, entry.weight);
            ++count;
        }
        this.setHashEntries(entries);
        this.treehash = null;
        this.finalized = true;
    }

    @Override
    public double getLength() {
        this.doFinalize();
        return super.getLength();
    }

    @Override
    public double compare(LSHVector op2, VectorCompare data) {
        this.doFinalize();
        ((LSHCosineVectorAccum)op2).doFinalize();
        return super.compare(op2, data);
    }

    @Override
    public int numEntries() {
        return this.treehash.size();
    }

    public static class Entry
    implements Comparable<Entry> {
        public final int hash;
        public final double weight;

        public Entry(int hash, double weight) {
            this.hash = hash;
            this.weight = weight;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.hash;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return this.hash == other.hash;
        }

        @Override
        public int compareTo(Entry o) {
            if (this.hash < 0) {
                if (o.hash >= 0) {
                    return 1;
                }
            } else if (o.hash < 0) {
                return -1;
            }
            return this.hash - o.hash;
        }

        public String toString() {
            return this.hash + "(" + this.weight + ")";
        }
    }
}

