/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.resources.icons.NumberIcon;
import docking.widgets.dialogs.NumberInputDialog;
import docking.widgets.label.GLabel;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.support.GTreeSelectionEvent;
import docking.widgets.tree.support.GTreeSelectionListener;
import docking.widgets.tree.tasks.GTreeExpandAllTask;
import generic.theme.GIcon;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.slicetree.InSliceRootNode;
import ghidra.app.plugin.core.decompiler.taint.slicetree.OutSliceRootNode;
import ghidra.app.plugin.core.decompiler.taint.slicetree.SliceNode;
import ghidra.app.services.GoToService;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.preferences.Preferences;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import resources.Icons;

public class TaintSliceTreeProvider
extends ComponentProviderAdapter
implements DomainObjectListener {
    static final String EXPAND_ACTION_NAME = "Fully Expand Selected Nodes";
    static final String TITLE = "Taint Slice Tree";
    private static final Icon EMPTY_ICON = Icons.EMPTY_ICON;
    private static final Icon EXPAND_ICON = Icons.EXPAND_ALL_ICON;
    private static final Icon COLLAPSE_ICON = Icons.COLLAPSE_ALL_ICON;
    private static Icon REFRESH_ICON = new GIcon("icon.plugin.calltree.refresh");
    private static Icon REFRESH_NOT_NEEDED_ICON = new GIcon("icon.plugin.calltree.refresh.not.needed");
    public static Icon HIGH_VARIABLE_ICON = new GIcon("icon.debugger.provider.stack");
    public static Icon HIGH_FUNCTION_ICON = new GIcon("icon.plugin.navigation.function");
    public static Icon IN_TAINT_ICON = new GIcon("icon.up");
    public static Icon OUT_TAINT_ICON = new GIcon("icon.down");
    public static Icon TAINT_ICON = new GIcon("icon.version.tracking.package");
    private static final String RECURSE_DEPTH_PROPERTY_NAME = "call.tree.recurse.depth";
    private static final String DEFAULT_RECURSE_DEPTH = "5";
    private final TaintPlugin plugin;
    private JComponent component;
    private JSplitPane splitPane;
    private GTree inTree;
    private GTree outTree;
    private boolean isPrimary;
    private SwingUpdateManager reloadUpdateManager = new SwingUpdateManager(500, () -> this.doUpdate());
    private Program currentProgram;
    private Function currentFunction;
    private ToggleDockingAction filterDuplicates;
    private ToggleDockingAction navigationOutgoingAction;
    private ToggleDockingAction navigationIncomingAction;
    private DockingAction refreshAction;
    private boolean isFiringNavigationEvent;
    private AtomicInteger recurseDepth = new AtomicInteger();
    private NumberIcon recurseIcon;

    public TaintSliceTreeProvider(TaintPlugin plugin, boolean isPrimary) {
        super(plugin.getTool(), TITLE, plugin.getName());
        this.plugin = plugin;
        this.isPrimary = isPrimary;
        this.component = this.buildComponent();
        this.component.setPreferredSize(new Dimension(800, 400));
        this.setWindowMenuGroup(TITLE);
        this.setDefaultWindowPosition(WindowPosition.WINDOW);
        this.setIcon(TaintPlugin.PROVIDER_ICON);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Taint_Slice_Tree_Plugin"));
        this.addToTool();
        this.loadRecurseDepthPreference();
        this.createActions();
    }

    private void createActions() {
        String expandMenu = Integer.toString(1);
        String selectionMenuGroup = Integer.toString(2);
        String goToMenu = Integer.toString(3);
        String homeToolbarGroup = Integer.toString(1);
        String filterOptionsToolbarGroup = Integer.toString(2);
        String navigationOptionsToolbarGroup = Integer.toString(3);
        String ownerName = this.plugin.getName();
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(EXPAND_ACTION_NAME, ownerName).helpLocation(new HelpLocation(ownerName, "Call_Tree_Context_Action_Expand_Nodes"))).popupMenuIcon(EXPAND_ICON)).popupMenuPath(new String[]{"Expand Nodes to Depth Limit"})).popupMenuGroup(expandMenu)).popupWhen(c -> this.isValidContext((ActionContext)c, Condition.EITHER))).enabledWhen(c -> this.isValidContext((ActionContext)c, Condition.EITHER))).onAction(c -> this.expandToDepth((ActionContext)c))).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Collapse All", ownerName).helpLocation(new HelpLocation(ownerName, "Call_Tree_Context_Action_Collapse_Nodes"))).popupMenuIcon(COLLAPSE_ICON)).popupMenuPath(new String[]{"Collapse All Nodes"})).popupMenuGroup(expandMenu)).popupWhen(c -> this.getSelectedPaths((ActionContext)c) != null)).enabledWhen(c -> this.isValidContextSel((ActionContext)c, Condition.EITHER))).onAction(c -> this.collapseAll((ActionContext)c))).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Go To Destination", ownerName).helpLocation(new HelpLocation(ownerName, "Call_Tree_Context_Action_Goto_Destination"))).popupMenuPath(new String[]{"Go To Call Destination"})).popupMenuGroup(goToMenu)).popupWhen(c -> this.addToPopupNotRoot((ActionContext)c))).enabledWhen(c -> this.isValidContextSel((ActionContext)c, Condition.OUT))).onAction(c -> this.gotToDest((ActionContext)c))).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Go To Source", ownerName).helpLocation(new HelpLocation(ownerName, "Call_Tree_Context_Action_Goto_Source"))).popupMenuPath(new String[]{"Go To Call Source"})).popupMenuGroup(goToMenu)).popupWhen(c -> this.addToPopupNotRoot((ActionContext)c))).enabledWhen(c -> this.isValidContextSel((ActionContext)c, Condition.EITHER))).onAction(c -> this.gotToSrc((ActionContext)c))).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Recurse Depth", ownerName).description("<html>Recurse Depth<br><br>Limits the depth to which recursing tree operations<br> will go.  Example operations include <b>Expand All</b> and filtering")).helpLocation(new HelpLocation(ownerName, "Call_Tree_Action_Recurse_Depth"))).toolBarGroup(filterOptionsToolbarGroup, "2")).toolBarIcon((Icon)new NumberIcon(this.recurseDepth.get()))).onAction(c -> this.recurseDepth((ActionContext)c))).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Select Call Source", ownerName).helpLocation(new HelpLocation(ownerName, "Call_Tree_Context_Action_Select_Source"))).popupMenuIcon((Icon)new GIcon("icon.plugin.calltree.filter.select.source"))).popupMenuPath(new String[]{"Select Call Source"})).popupMenuGroup(selectionMenuGroup)).popupWhen(c -> this.addToPopupMult((ActionContext)c))).enabledWhen(c -> this.isValidContextMult((ActionContext)c, Condition.EITHER))).onAction(c -> this.makeSelectionFromPaths((ActionContext)c, true))).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Select Call Destination", ownerName).helpLocation(new HelpLocation(ownerName, "Call_Tree_Context_Action_Select_Destination"))).popupMenuIcon((Icon)new GIcon("icon.plugin.calltree.filter.select.source"))).popupMenuPath(new String[]{"Select Call Destination"})).popupMenuGroup(selectionMenuGroup)).popupWhen(c -> this.addToPopupMult((ActionContext)c))).enabledWhen(c -> this.isValidContextMult((ActionContext)c, Condition.OUT))).onAction(c -> this.makeSelectionFromPaths((ActionContext)c, false))).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Home", ownerName).helpLocation(new HelpLocation(ownerName, "Call_Tree_Action_Home"))).toolBarGroup(homeToolbarGroup)).toolBarIcon(Icons.HOME_ICON)).enabledWhen(c -> this.currentFunction != null)).onAction(c -> this.home((ActionContext)c))).buildAndInstallLocal((ComponentProvider)this);
        this.refreshAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Refresh", ownerName).description("<html>Push at any time to refresh the current trees.<br> This is highlighted when the data <i>may</i> be stale.<br>")).helpLocation(new HelpLocation(ownerName, "Call_Tree_Action_Refresh"))).toolBarGroup(homeToolbarGroup)).toolBarIcon(REFRESH_NOT_NEEDED_ICON)).enabledWhen(c -> true)).onAction(c -> this.reloadUpdateManager.updateNow())).buildAndInstallLocal((ComponentProvider)this);
        this.filterDuplicates = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Filter Duplicates", ownerName).description("<html>Push at any time to refresh the current trees.<br> This is highlighted when the data <i>may</i> be stale.<br>")).helpLocation(new HelpLocation(ownerName, "Call_Tree_Action_Filter"))).toolBarGroup(filterOptionsToolbarGroup, "1")).toolBarIcon((Icon)new GIcon("icon.plugin.calltree.filter.duplicates"))).selected(true).onAction(c -> this.doUpdate())).buildAndInstallLocal((ComponentProvider)this);
        this.navigationOutgoingAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Navigate Outgoing Nodes", ownerName).description("<html>Outgoing Navigation<br><br> Toggled <b>on</b> triggers node selections<br>in the tree to navigate the Listing to<br>the <b>source</b> location of the call")).helpLocation(new HelpLocation(ownerName, "Call_Tree_Action_Navigation"))).toolBarGroup(navigationOptionsToolbarGroup, "1")).toolBarIcon(Icons.NAVIGATE_ON_OUTGOING_EVENT_ICON)).selected(true).onAction(c -> {})).buildAndInstallLocal((ComponentProvider)this);
        this.navigationIncomingAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Navigate Incoming Location Changes", ownerName).description(HTMLUtilities.toHTML((String)"Incoming Navigation<br><br>Toggle <b>On</b>  - change the displayed function on Listing navigation events<br>Toggled <b>Off</b> - don't change the displayed function on Listing navigation events"))).helpLocation(new HelpLocation(ownerName, "Call_Tree_Action_Incoming_Navigation"))).toolBarGroup(navigationOptionsToolbarGroup, "2")).toolBarIcon(Icons.NAVIGATE_ON_INCOMING_EVENT_ICON)).selected(this.isPrimary).onAction(c -> {
            if (this.navigationIncomingAction.isSelected()) {
                this.setLocation(this.plugin.getCurrentLocation());
            }
        })).buildAndInstallLocal((ComponentProvider)this);
    }

    private boolean isValidSelection(ActionContext context) {
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        if (gTree.getSelectionPaths().length != 1) {
            return false;
        }
        TreePath path = gTree.getSelectionPath();
        if (path == null) {
            return false;
        }
        GTreeNode node = (GTreeNode)path.getLastPathComponent();
        return node instanceof SliceNode;
    }

    private boolean isValidContext(ActionContext context, Condition cond) {
        Object contextObject = context.getContextObject();
        if (!(contextObject instanceof GTree)) {
            return false;
        }
        if (contextObject == this.inTree && cond == Condition.OUT) {
            return false;
        }
        return contextObject != this.outTree || cond != Condition.IN;
    }

    private boolean isValidContextSel(ActionContext context, Condition cond) {
        return this.isValidContext(context, cond) && this.isValidSelection(context);
    }

    private boolean isValidContextMult(ActionContext context, Condition cond) {
        if (!this.isValidContext(context, cond)) {
            return false;
        }
        if (this.currentFunction == null) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        return selectionPaths.length > 0;
    }

    private TreePath[] getSelectedPaths(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (!(contextObject instanceof GTree)) {
            return null;
        }
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths.length == 0) {
            return null;
        }
        return selectionPaths;
    }

    private boolean addToPopupNotRoot(ActionContext context) {
        TreePath[] selectionPaths = this.getSelectedPaths(context);
        if (selectionPaths == null) {
            return false;
        }
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (!node.isRoot()) continue;
            return false;
        }
        return true;
    }

    private boolean addToPopupMult(ActionContext context) {
        if (!this.addToPopupNotRoot(context)) {
            return false;
        }
        return this.isValidContextMult(context, Condition.OUT);
    }

    private void expandToDepth(ActionContext context) {
        TreePath[] paths;
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        for (TreePath treePath : paths = gTree.getSelectionPaths()) {
            GTreeNode node = (GTreeNode)treePath.getLastPathComponent();
            gTree.runTask((GTreeTask)new ExpandToDepthTask(this, gTree, node, this.recurseDepth.get()));
        }
    }

    private void collapseAll(ActionContext context) {
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        GTreeNode rootNode = gTree.getViewRoot();
        List children = rootNode.getChildren();
        for (GTreeNode child : children) {
            gTree.collapseAll(child);
        }
    }

    private void gotToDest(ActionContext context) {
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        TreePath path = gTree.getSelectionPath();
        SliceNode node = (SliceNode)((Object)path.getLastPathComponent());
        this.goTo(node.getLocation());
    }

    private void gotToSrc(ActionContext context) {
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        TreePath path = gTree.getSelectionPath();
        SliceNode node = (SliceNode)((Object)path.getLastPathComponent());
        this.goTo(new ProgramLocation(this.currentProgram, node.getSourceAddress()));
    }

    private void recurseDepth(ActionContext context) {
        NumberInputDialog dialog = new NumberInputDialog("", "", Integer.valueOf(this.recurseDepth.get()), 0, Integer.MAX_VALUE, false);
        if (!dialog.show()) {
            return;
        }
        int newValue = dialog.getValue();
        this.setRecurseDepth(newValue);
    }

    private void home(ActionContext context) {
        FunctionSignatureFieldLocation location = new FunctionSignatureFieldLocation(this.currentProgram, this.currentFunction.getEntryPoint());
        this.goTo((ProgramLocation)location);
    }

    private void makeSelectionFromPaths(ActionContext context, boolean selectSource) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] paths = gTree.getSelectionPaths();
        AddressSet set = new AddressSet();
        for (TreePath path : paths) {
            SliceNode sliceNode = (SliceNode)((Object)path.getLastPathComponent());
            Address address = null;
            address = selectSource ? sliceNode.getSourceAddress() : sliceNode.getLocation().getAddress();
            set.addRange(address, address);
        }
        ProgramSelection selection = new ProgramSelection((AddressSetView)set);
        this.tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.plugin.getName(), selection, this.currentProgram));
    }

    private void goTo(ProgramLocation location) {
        this.isFiringNavigationEvent = true;
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        if (goToService != null) {
            goToService.goTo(location);
            this.isFiringNavigationEvent = false;
            return;
        }
        this.plugin.firePluginEvent((PluginEvent)new ProgramLocationPluginEvent(this.getName(), location, this.currentProgram));
        this.isFiringNavigationEvent = false;
    }

    public ActionContext getActionContext(MouseEvent e) {
        if (e == null) {
            return new DefaultActionContext((ComponentProvider)this, this.getActiveComponent());
        }
        Object source = e.getSource();
        if (source instanceof JTree) {
            JTree jTree = (JTree)source;
            GTree gTree = this.inTree;
            if (this.outTree.isMyJTree(jTree)) {
                gTree = this.outTree;
            }
            return new DefaultActionContext((ComponentProvider)this, (Component)gTree);
        }
        return null;
    }

    private Component getActiveComponent() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = manager.getFocusOwner();
        if (focusOwner == null) {
            return this.component;
        }
        if (SwingUtilities.isDescendingFrom(focusOwner, (Component)this.outTree)) {
            return this.outTree;
        }
        if (SwingUtilities.isDescendingFrom(focusOwner, (Component)this.inTree)) {
            return this.inTree;
        }
        return this.component;
    }

    private JComponent buildComponent() {
        JPanel container = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane(1);
        this.inTree = this.createTree();
        this.outTree = this.createTree();
        GTreeSelectionListener treeSelectionListener = e -> {
            if (e.getEventOrigin() != GTreeSelectionEvent.EventOrigin.USER_GENERATED) {
                return;
            }
            if (!this.navigationOutgoingAction.isSelected()) {
                return;
            }
            if (this.currentFunction == null) {
                return;
            }
            TreePath path = e.getPath();
            if (path == null) {
                return;
            }
            SliceNode node = (SliceNode)((Object)((Object)path.getLastPathComponent()));
            Address sourceAddress = node.getSourceAddress();
            this.goTo(new ProgramLocation(this.currentProgram, sourceAddress));
        };
        this.outTree.addGTreeSelectionListener(treeSelectionListener);
        this.inTree.addGTreeSelectionListener(treeSelectionListener);
        GTreeSelectionListener contextSelectionListener = e -> this.notifyContextChanged();
        this.inTree.addGTreeSelectionListener(contextSelectionListener);
        this.outTree.addGTreeSelectionListener(contextSelectionListener);
        this.splitPane.setLeftComponent(this.createTreePanel(true, this.inTree));
        this.splitPane.setRightComponent(this.createTreePanel(false, this.outTree));
        this.splitPane.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                long changeFlags = e.getChangeFlags();
                if (2L == (changeFlags & 2L) && TaintSliceTreeProvider.this.splitPane.isDisplayable()) {
                    SwingUtilities.invokeLater(() -> TaintSliceTreeProvider.this.splitPane.setDividerLocation(0.5));
                    TaintSliceTreeProvider.this.splitPane.removeHierarchyListener(this);
                }
            }
        });
        container.add((Component)this.splitPane, "Center");
        return container;
    }

    private JPanel createTreePanel(boolean isIncoming, GTree tree) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new GLabel(isIncoming ? "Backward Taint Tree (in nodes)" : "Forward Taint Tree (out nodes)"), "North");
        panel.add((Component)tree, "Center");
        return panel;
    }

    private GTree createTree() {
        GTree tree = new GTree((GTreeNode)new EmptyRootNode(this));
        tree.setPaintHandlesForLeafNodes(false);
        return tree;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void componentShown() {
        this.reload();
    }

    public void componentHidden() {
        if (!this.isPrimary) {
            this.plugin.removeProvider(this);
        }
    }

    public void reload() {
        this.setLocation(this.plugin.getCurrentLocation());
    }

    public void dispose() {
        this.reloadUpdateManager.dispose();
        this.inTree.dispose();
        this.outTree.dispose();
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
            this.currentProgram = null;
        }
        this.refreshAction.dispose();
        this.filterDuplicates.dispose();
        this.navigationOutgoingAction.dispose();
        this.navigationIncomingAction.dispose();
    }

    public void setLocation(ProgramLocation location) {
        if (this.isFiringNavigationEvent) {
            return;
        }
        if (!this.followLocationChanges()) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        this.doSetLocation(location);
    }

    private void doSetLocation(ProgramLocation location) {
        if (location == null) {
            this.setFunction(null);
            return;
        }
        if (this.currentProgram == null) {
            this.currentProgram = this.plugin.getCurrentProgram();
            this.currentProgram.addListener((DomainObjectListener)this);
        }
        Function function = this.plugin.getFunction(location);
        this.setFunction(function);
    }

    private void setFunction(Function function) {
        if (function != null && function.equals((Object)this.currentFunction)) {
            return;
        }
        this.doSetFunction(function);
    }

    private void doSetFunction(Function function) {
        this.currentFunction = function;
        this.notifyContextChanged();
        if (this.currentFunction == null) {
            this.clearTrees();
            return;
        }
        this.resetTrees();
        this.updateTitle();
        this.reloadUpdateManager.update();
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    private void clearTrees() {
        if (this.inTree.getModelRoot() instanceof EmptyRootNode) {
            return;
        }
        this.updateTitle();
        this.inTree.setRootNode((GTreeNode)new EmptyRootNode(this));
        this.outTree.setRootNode((GTreeNode)new EmptyRootNode(this));
    }

    private void resetTrees() {
        this.inTree.setRootNode((GTreeNode)new PendingRootNode(this));
        this.outTree.setRootNode((GTreeNode)new PendingRootNode(this));
    }

    private void doUpdate() {
        this.updateIncomingReferences(this.currentFunction);
        this.updateOutgoingReferences(this.currentFunction);
        this.setStale(false);
    }

    private void updateIncomingReferences(Function function) {
        Object rootNode = null;
        rootNode = function == null ? new EmptyRootNode(this) : new InSliceRootNode(this.currentProgram, function, function.getEntryPoint(), this.filterDuplicates.isSelected(), this.recurseDepth);
        this.inTree.setRootNode((GTreeNode)rootNode);
    }

    private void updateOutgoingReferences(Function function) {
        Object rootNode = null;
        rootNode = function == null ? new EmptyRootNode(this) : new OutSliceRootNode(this.currentProgram, function, function.getEntryPoint(), this.filterDuplicates.isSelected(), this.recurseDepth);
        this.outTree.setRootNode((GTreeNode)rootNode);
    }

    private void updateTitle() {
        Object title = TITLE;
        Object subTitle = "<No Function>";
        if (this.currentFunction != null) {
            String programName = this.currentProgram != null ? this.currentProgram.getDomainFile().getName() : "";
            title = "Taint Slice Tree: " + this.currentFunction.getName();
            subTitle = " (" + programName + ")";
        }
        this.setTitle((String)title);
        this.setSubTitle((String)subTitle);
    }

    public void initialize(Program program, ProgramLocation location) {
        if (program == null) {
            this.setLocation(null);
            return;
        }
        this.currentProgram = program;
        this.currentProgram.addListener((DomainObjectListener)this);
        this.doSetLocation(location);
    }

    public void programActivated(Program program) {
        if (!this.followLocationChanges() && this.currentProgram != null) {
            return;
        }
        this.currentProgram = program;
        this.currentProgram.addListener((DomainObjectListener)this);
        this.setLocation(this.plugin.getCurrentLocation());
    }

    public void programDeactivated(Program program) {
        if (!this.followLocationChanges()) {
            return;
        }
        this.clearState();
    }

    public void programClosed(Program program) {
        if (program != this.currentProgram) {
            return;
        }
        program.removeListener((DomainObjectListener)this);
        this.clearState();
        this.currentProgram = null;
    }

    private void clearState() {
        this.inTree.cancelWork();
        this.outTree.cancelWork();
        this.currentFunction = null;
        this.reloadUpdateManager.update();
    }

    public boolean isShowingLocation(ProgramLocation location) {
        if (this.currentFunction == null) {
            return false;
        }
        AddressSetView body = this.currentFunction.getBody();
        return body.contains(location.getAddress());
    }

    private boolean followLocationChanges() {
        return this.navigationIncomingAction.isSelected();
    }

    public void domainObjectChanged(DomainObjectChangedEvent event) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isEmpty()) {
            return;
        }
        if (event.contains((EventType)DomainObjectEvent.RESTORED)) {
            this.setStale(true);
            return;
        }
        block4: for (int i = 0; i < event.numRecords(); ++i) {
            DomainObjectChangeRecord domainObjectRecord = event.getChangeRecord(i);
            ProgramEvent eventType = (ProgramEvent)domainObjectRecord.getEventType();
            switch (eventType) {
                case MEMORY_BLOCK_MOVED: 
                case MEMORY_BLOCK_REMOVED: 
                case SYMBOL_ADDED: 
                case SYMBOL_REMOVED: 
                case REFERENCE_ADDED: 
                case REFERENCE_REMOVED: {
                    this.setStale(true);
                    continue block4;
                }
                case SYMBOL_RENAMED: {
                    Symbol symbol = (Symbol)((ProgramChangeRecord)domainObjectRecord).getObject();
                    if (!(symbol instanceof FunctionSymbol)) continue block4;
                    FunctionSymbol functionSymbol = (FunctionSymbol)symbol;
                    Function function = (Function)functionSymbol.getObject();
                    if (this.updateRootNodes(function)) {
                        return;
                    }
                    this.inTree.runTask((GTreeTask)new UpdateFunctionNodeTask(this, this.inTree, function));
                    this.outTree.runTask((GTreeTask)new UpdateFunctionNodeTask(this, this.outTree, function));
                    continue block4;
                }
            }
        }
    }

    private boolean isEmpty() {
        GTreeNode rootNode = this.inTree.getModelRoot();
        return rootNode instanceof EmptyRootNode;
    }

    private boolean updateRootNodes(Function function) {
        SliceNode sliceNode;
        Function nodeFunction;
        GTreeNode root = this.inTree.getModelRoot();
        if (root instanceof SliceNode && (nodeFunction = (sliceNode = (SliceNode)root).getRemoteFunction()).equals((Object)function)) {
            this.reloadUpdateManager.update();
            return true;
        }
        return false;
    }

    private void setStale(boolean stale) {
        if (stale) {
            this.refreshAction.getToolBarData().setIcon(REFRESH_ICON);
        } else {
            this.refreshAction.getToolBarData().setIcon(REFRESH_NOT_NEEDED_ICON);
        }
    }

    public void setRecurseDepth(int depth) {
        if (depth < 1) {
            return;
        }
        if (this.recurseDepth.get() == depth) {
            return;
        }
        this.recurseDepth.set(depth);
        this.recurseIcon.setNumber(depth);
        this.removeFilterCache();
        this.inTree.refilterLater();
        this.outTree.refilterLater();
        this.saveRecurseDepth();
    }

    private void removeFilterCache() {
        GTreeNode rootNode = this.inTree.getModelRoot();
        rootNode.removeAll();
        rootNode = this.outTree.getModelRoot();
        rootNode.removeAll();
    }

    private void saveRecurseDepth() {
        Preferences.setProperty((String)RECURSE_DEPTH_PROPERTY_NAME, (String)Integer.toString(this.recurseDepth.get()));
        Preferences.store();
    }

    private void loadRecurseDepthPreference() {
        int intValue;
        String value = Preferences.getProperty((String)RECURSE_DEPTH_PROPERTY_NAME, (String)DEFAULT_RECURSE_DEPTH);
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            intValue = Integer.parseInt(DEFAULT_RECURSE_DEPTH);
        }
        this.recurseDepth.set(intValue);
    }

    public int getRecurseDepth() {
        return this.recurseDepth.get();
    }

    public void setIncomingFilter(String text) {
        this.inTree.setFilterText(text);
    }

    public void setOutgoingFilter(String text) {
        this.outTree.setFilterText(text);
    }

    private static enum Condition {
        IN,
        OUT,
        EITHER;

    }

    private class ExpandToDepthTask
    extends GTreeExpandAllTask {
        private int maxDepth;

        public ExpandToDepthTask(TaintSliceTreeProvider taintSliceTreeProvider, GTree tree, GTreeNode node, int maxDepth) {
            super(tree, node);
            TreePath treePath = node.getTreePath();
            int startDepth = treePath.getPathCount();
            this.maxDepth = maxDepth + startDepth - 1;
        }

        protected void expandNode(GTreeNode node, boolean force, TaskMonitor monitor) throws CancelledException {
            TreePath treePath = node.getTreePath();
            Object[] path = treePath.getPath();
            if (path.length > this.maxDepth) {
                return;
            }
            if (!force && !node.isAutoExpandPermitted()) {
                return;
            }
            SliceNode sliceNode = (SliceNode)node;
            if (sliceNode.functionIsInPath()) {
                return;
            }
            super.expandNode(node, false, monitor);
        }
    }

    private class EmptyRootNode
    extends GTreeNode {
        private EmptyRootNode(TaintSliceTreeProvider taintSliceTreeProvider) {
        }

        public Icon getIcon(boolean expanded) {
            return EMPTY_ICON;
        }

        public String getName() {
            return "No Function";
        }

        public String getToolTip() {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    }

    private class PendingRootNode
    extends GTreeNode {
        private PendingRootNode(TaintSliceTreeProvider taintSliceTreeProvider) {
        }

        public Icon getIcon(boolean expanded) {
            return TaintPlugin.FUNCTION_ICON;
        }

        public String getName() {
            return "Pending...";
        }

        public String getToolTip() {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    }

    private class UpdateFunctionNodeTask
    extends GTreeTask {
        private Function function;

        protected UpdateFunctionNodeTask(TaintSliceTreeProvider taintSliceTreeProvider, GTree tree, Function function) {
            super(tree);
            this.function = function;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            SliceNode rootNode = (SliceNode)this.tree.getModelRoot();
            List children = rootNode.getChildren();
            for (GTreeNode node : children) {
                this.updateFunction((SliceNode)node);
            }
        }

        private void updateFunction(SliceNode node) {
            if (!node.isLoaded()) {
                return;
            }
            if (this.function.equals((Object)node.getRemoteFunction())) {
                GTreeNode parent = node.getParent();
                parent.removeNode((GTreeNode)node);
                parent.addNode((GTreeNode)node.recreate());
                return;
            }
            List children = node.getChildren();
            for (GTreeNode child : children) {
                this.updateFunction((SliceNode)child);
            }
        }
    }
}

