/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.comments;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.decompiler.DecompilerLocation;
import ghidra.app.plugin.core.comments.CommentsActionFactory;
import ghidra.app.plugin.core.comments.CommentsDialog;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CommentType;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.CommentTypeUtils;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;

public class DecompilerCommentsActionFactory
extends CommentsActionFactory {
    protected DockingAction doGetEditCommentsAction(CommentsDialog dialog, String name) {
        return new DecompilerEditCommentsAction(dialog, name);
    }

    protected DockingAction doGetSetCommentsAction(CommentsDialog dialog, String name, String actionName, CommentType commentType) {
        return new DecompilerSetCommentsAction(dialog, name, actionName, commentType);
    }

    protected boolean doIsCommentSupported(ProgramLocation loc) {
        if (loc == null || loc.getAddress() == null) {
            return false;
        }
        return loc instanceof CodeUnitLocation || loc instanceof DecompilerLocation || loc instanceof FunctionLocation && !(loc instanceof VariableLocation);
    }

    private static class DecompilerEditCommentsAction
    extends DecompilerSetCommentsAction {
        private static final String[] EDIT_MENUPATH = new String[]{"Comments", "Set..."};

        DecompilerEditCommentsAction(CommentsDialog dialog, String name) {
            super(dialog, name, "Edit Comments", null);
            this.setPopupMenuData(new MenuData(EDIT_MENUPATH, "comments"));
            this.setKeyBindingData(new KeyBindingData(59, 0));
        }

        @Override
        protected CommentType getEditCommentType(ActionContext context) {
            if (context instanceof DecompilerActionContext) {
                DecompilerActionContext decompContext = (DecompilerActionContext)context;
                Address addr = decompContext.getAddress();
                if (addr.equals((Object)decompContext.getFunctionEntryPoint())) {
                    return CommentType.PLATE;
                }
                return CommentType.PRE;
            }
            CodeUnit cu = this.getCodeUnit(context);
            return CommentTypeUtils.getCommentType((CodeUnit)cu, (ProgramLocation)this.getLocationForContext(context), null);
        }
    }

    private static class DecompilerSetCommentsAction
    extends DockingAction {
        private final CommentsDialog dialog;
        private final CommentType commentType;

        DecompilerSetCommentsAction(CommentsDialog dialog, String name, String actionName, CommentType commentType) {
            super(actionName, name);
            this.dialog = dialog;
            this.commentType = commentType;
            this.setPopupMenuData(new MenuData(new String[]{"Comments", actionName + "..."}, "comments"));
            this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionComments"));
        }

        protected CommentType getEditCommentType(ActionContext context) {
            return this.commentType;
        }

        public void actionPerformed(ActionContext context) {
            CodeUnit cu = this.getCodeUnit(context);
            CommentType type = this.getEditCommentType(context);
            this.dialog.showDialog(cu, type);
        }

        public boolean isEnabledForContext(ActionContext actionContext) {
            ProgramLocation loc = this.getLocationForContext(actionContext);
            if (!CommentsActionFactory.isCommentSupported((ProgramLocation)loc)) {
                return false;
            }
            return CommentTypeUtils.isCommentAllowed((CodeUnit)this.getCodeUnit(actionContext), (ProgramLocation)loc);
        }

        public boolean isValidContext(ActionContext context) {
            return context instanceof ListingActionContext || context instanceof DecompilerActionContext;
        }

        protected CodeUnit getCodeUnit(ActionContext actionContext) {
            ProgramLocationActionContext context = (ProgramLocationActionContext)actionContext;
            return context.getCodeUnit();
        }

        protected ProgramLocation getLocationForContext(ActionContext actionContext) {
            if (actionContext instanceof DecompilerActionContext && this.commentType != CommentType.PRE && this.commentType != CommentType.PLATE && this.commentType != null) {
                return null;
            }
            if (!(actionContext instanceof ProgramLocationActionContext)) {
                return null;
            }
            ProgramLocationActionContext context = (ProgramLocationActionContext)actionContext;
            return context.getLocation();
        }
    }
}

