/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.SparcAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class SparcEarlyAddressAnalyzer
extends SparcAnalyzer {
    public SparcEarlyAddressAnalyzer() {
        this.setPriority(AnalysisPriority.DISASSEMBLY);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        if (!this.o7CallReturnAnalysis) {
            return true;
        }
        AddressSet unanalyzedSet = new AddressSet(set);
        Register linkReg = program.getLanguage().getRegister("o7");
        InstructionIterator instructions = program.getListing().getInstructions((AddressSetView)unanalyzedSet, true);
        block0: for (Instruction instr : instructions) {
            PcodeOp[] pcode;
            if (!instr.getFlowType().isCall() || !instr.hasFallthrough()) continue;
            for (PcodeOp pcodeOp : pcode = instr.getPcode()) {
                Varnode input;
                Varnode output = pcodeOp.getOutput();
                if (output == null || !output.getAddress().equals((Object)linkReg.getAddress()) || (input = pcodeOp.getInput(0)).isConstant()) continue;
                instr.setFlowOverride(FlowOverride.CALL_RETURN);
                continue block0;
            }
        }
        return true;
    }
}

