/*
 * Decompiled with CFR 0.152.
 */
package help.validator.links;

import help.validator.links.InvalidLink;
import help.validator.location.HelpModuleCollection;
import help.validator.model.TOCItemReference;
import java.nio.file.Path;

public class MissingTOCDefinitionInvalidLink
implements InvalidLink {
    private final TOCItemReference reference;
    private final HelpModuleCollection help;

    public MissingTOCDefinitionInvalidLink(HelpModuleCollection help, TOCItemReference reference) {
        this.help = help;
        this.reference = reference;
        if (Boolean.parseBoolean(System.getProperty("ghidra.help.failfast"))) {
            throw new RuntimeException(this.toString());
        }
    }

    @Override
    public int identityHashCode() {
        return System.identityHashCode(this.reference);
    }

    @Override
    public Path getSourceFile() {
        return this.reference.getSourceFile();
    }

    @Override
    public int getLineNumber() {
        return this.reference.getLineNumber();
    }

    @Override
    public int compareTo(InvalidLink other) {
        if (other == null) {
            return 1;
        }
        if (!(other instanceof MissingTOCDefinitionInvalidLink)) {
            return -1;
        }
        MissingTOCDefinitionInvalidLink otherLink = (MissingTOCDefinitionInvalidLink)other;
        return this.reference.compareTo(otherLink.reference);
    }

    @Override
    public String toString() {
        return "Missing TOC definition (<tocdef>) for reference (<tocref>):\n\t" + String.valueOf(this.reference);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MissingTOCDefinitionInvalidLink other = (MissingTOCDefinitionInvalidLink)obj;
        return !(this.reference == null ? other.reference != null : !this.reference.equals(other.reference));
    }
}

