/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.query.client.IDSQLResolution;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.protocol.FilterAtom;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.List;

public abstract class DateBSimFilterType
extends BSimFilterType {
    public static final List<DateTimeFormatter> FORMATTERS = Arrays.asList(DateTimeFormatter.ofPattern("yyyy MM dd"), DateTimeFormatter.ofPattern("yyyy-MM-dd"), DateTimeFormatter.ofPattern("yyyy/MM/dd"), DateTimeFormatter.ofPattern("MMM dd, yyyy"), DateTimeFormatter.ofPattern("MMMM dd, yyyy"), DateTimeFormatter.ofPattern("MM dd yyyy"), DateTimeFormatter.ofPattern("MM-dd-yyyy"), DateTimeFormatter.ofPattern("MM/dd/yyyy"), DateTimeFormatter.ofPattern("yyyy"));

    public DateBSimFilterType(String label, String xmlval, String hint) {
        super(label, xmlval, hint);
    }

    public DateBSimFilterType() {
        super("default label", "", "");
    }

    @Override
    public boolean isValidValue(String value) {
        return this.formatDate(value) != null;
    }

    @Override
    public String normalizeValue(String value) {
        LocalDate date = this.formatDate(value);
        return date == null ? null : date.toString();
    }

    protected LocalDate formatDate(String value) {
        for (DateTimeFormatter formatter : FORMATTERS) {
            try {
                return LocalDate.parse(value, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    @Override
    public IDSQLResolution generateIDSQLResolution(FilterAtom atom) {
        return null;
    }

    @Override
    public boolean evaluate(ExecutableRecord rec, String value) {
        return false;
    }

    @Override
    public boolean isMultipleEntryAllowed() {
        return false;
    }
}

