/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.map;

import db.DBHandle;
import db.DBRecord;
import ghidra.framework.data.OpenMode;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceDelegatingManager;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.map.TraceAddressSnapRangePropertyMap;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.UnionAddressSetView;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.spatial.SpatialMap;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;

public class DBTraceAddressSnapRangePropertyMap<T, DR extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<T>>
extends AbstractDBTraceSpaceBasedManager<DBTraceAddressSnapRangePropertyMapSpace<T, DR>>
implements TraceAddressSnapRangePropertyMap<T>,
DBTraceDelegatingManager<DBTraceAddressSnapRangePropertyMapSpace<T, DR>> {
    protected final Class<DR> dataType;
    protected final DBTraceAddressSnapRangePropertyMapDataFactory<T, DR> dataFactory;

    public DBTraceAddressSnapRangePropertyMap(String name, DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager, Class<DR> dataType, DBTraceAddressSnapRangePropertyMapDataFactory<T, DR> dataFactory) throws IOException, VersionException {
        super(name, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager);
        this.dataType = dataType;
        this.dataFactory = dataFactory;
        this.loadSpaces();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected DBTraceAddressSnapRangePropertyMapSpace<T, DR> createSpace(AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceAddressSnapRangePropertyMapSpace<T, DR>(this.tableName(space, ent.getThreadKey(), ent.getFrameLevel()), this.trace.getStoreFactory(), this.lock, space, null, ent.getFrameLevel(), this.dataType, this.dataFactory);
    }

    @Override
    protected DBTraceAddressSnapRangePropertyMapSpace<T, DR> createRegisterSpace(AddressSpace space, TraceThread thread, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceAddressSnapRangePropertyMapSpace<T, DR>(this.tableName(space, ent.getThreadKey(), ent.getFrameLevel()), this.trace.getStoreFactory(), this.lock, space, thread, ent.getFrameLevel(), this.dataType, this.dataFactory);
    }

    public DBTraceAddressSnapRangePropertyMapSpace<T, DR> getRegisterSpace(TraceThread thread, boolean createIfAbsent) {
        return (DBTraceAddressSnapRangePropertyMapSpace)this.getForRegisterSpace(thread, 0, createIfAbsent);
    }

    public DBTraceAddressSnapRangePropertyMapSpace<T, DR> getRegisterSpace(TraceStackFrame frame, boolean createIfAbsent) {
        return (DBTraceAddressSnapRangePropertyMapSpace)this.getForRegisterSpace(frame, createIfAbsent);
    }

    @Override
    public DBTraceAddressSnapRangePropertyMapSpace<T, DR> getForSpace(AddressSpace space, boolean createIfAbsent) {
        return (DBTraceAddressSnapRangePropertyMapSpace)super.getForSpace(space, createIfAbsent);
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }

    @Override
    public void deleteValue(T value) {
        if (!(value instanceof DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)) {
            throw new IllegalArgumentException("Can only directly delete values for maps where the entry is the value");
        }
        this.deleteData((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)value);
    }

    public void deleteData(DR data) {
        AddressSpace space = ((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)data).range.getAddressSpace();
        this.delegateDeleteV(space, m -> m.deleteData(data));
    }

    public T put(TraceAddressSnapRange shape, T value) {
        return (T)this.delegateWrite(shape.getRange().getAddressSpace(), m -> m.put(shape, value));
    }

    public boolean remove(TraceAddressSnapRange shape, T value) {
        return this.delegateDeleteB(shape.getRange().getAddressSpace(), m -> m.remove(shape, value), false);
    }

    public boolean remove(Map.Entry<TraceAddressSnapRange, T> entry) {
        return this.delegateDeleteB(entry.getKey().getRange().getAddressSpace(), m -> m.remove(entry), false);
    }

    public int size() {
        int count = 0;
        for (DBTraceAddressSnapRangePropertyMapSpace space : this.getActiveMemorySpaces()) {
            count += space.size();
        }
        return count;
    }

    public boolean isEmpty() {
        return !this.delegateAny(this.memSpacesView, m -> !m.isEmpty());
    }

    public Collection<Map.Entry<TraceAddressSnapRange, T>> entries() {
        return this.delegateCollection(this.memSpacesView, m -> m.entries());
    }

    public Collection<Map.Entry<TraceAddressSnapRange, T>> orderedEntries() {
        return this.delegateCollection(this.memSpacesView, m -> m.orderedEntries());
    }

    public Collection<TraceAddressSnapRange> keys() {
        return this.delegateCollection(this.memSpacesView, m -> m.keys());
    }

    public Collection<TraceAddressSnapRange> orderedKeys() {
        return this.delegateCollection(this.memSpacesView, m -> m.orderedKeys());
    }

    public Collection<T> values() {
        return this.delegateCollection(this.memSpacesView, m -> m.values());
    }

    public Collection<T> orderedValues() {
        return this.delegateCollection(this.memSpacesView, m -> m.orderedValues());
    }

    public SpatialMap<TraceAddressSnapRange, T, DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery> reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery query) {
        return (SpatialMap)this.delegateRead(query.getAddressSpace(), m -> m.reduce(query), SpatialMap.emptyMap());
    }

    public Map.Entry<TraceAddressSnapRange, T> firstEntry() {
        return (Map.Entry)this.delegateFirst(this.memSpacesView, m -> m.firstEntry());
    }

    public TraceAddressSnapRange firstKey() {
        return (TraceAddressSnapRange)this.delegateFirst(this.memSpacesView, m -> m.firstKey());
    }

    public T firstValue() {
        return (T)this.delegateFirst(this.memSpacesView, m -> m.firstValue());
    }

    public void clear() {
        for (DBTraceAddressSnapRangePropertyMapSpace space : this.memSpacesView) {
            space.clear();
        }
    }

    @Override
    public AddressSetView getAddressSetView(Lifespan span, Predicate<T> predicate) {
        return new UnionAddressSetView(this.memSpaces.values().stream().map(m -> m.getAddressSetView(span, predicate)).toList());
    }

    @Override
    public AddressSetView getAddressSetView(Lifespan span) {
        return this.getAddressSetView(span, t -> true);
    }

    public static interface DBTraceAddressSnapRangePropertyMapDataFactory<T, DR extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<T>> {
        public DR create(DBTraceAddressSnapRangePropertyMapTree<T, DR> var1, DBCachedObjectStore<DR> var2, DBRecord var3);
    }
}

