/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

import ghidra.pcode.emu.PcodeThread;
import ghidra.trace.model.time.schedule.AbstractStep;
import ghidra.trace.model.time.schedule.Step;
import ghidra.trace.model.time.schedule.Stepper;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class TickStep
extends AbstractStep {
    public static TickStep parse(long threadKey, String stepSpec, TraceSchedule.TimeRadix radix) {
        try {
            return new TickStep(threadKey, radix.decode(stepSpec));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse tick step: '" + stepSpec + "'");
        }
    }

    public TickStep(long threadKey, long tickCount) {
        super(threadKey, tickCount);
    }

    @Override
    public Step.StepType getType() {
        return Step.StepType.TICK;
    }

    @Override
    public long getSkipCount() {
        return 0L;
    }

    @Override
    protected String toStringStepPart(TraceSchedule.TimeRadix radix) {
        return radix.format(this.tickCount);
    }

    @Override
    public TickStep clone() {
        return new TickStep(this.threadKey, this.tickCount);
    }

    @Override
    public Step subtract(Step step) {
        assert (this.isCompatible(step));
        TickStep that = (TickStep)step;
        return new TickStep(this.threadKey, this.tickCount - that.tickCount);
    }

    @Override
    public void execute(PcodeThread<?> emuThread, Stepper stepper, TaskMonitor monitor) throws CancelledException {
        int i = 0;
        while ((long)i < this.tickCount) {
            monitor.incrementProgress(1L);
            monitor.checkCancelled();
            stepper.tick(emuThread);
            ++i;
        }
    }
}

