/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slgh_compile;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.opcodes.OpCode;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.OpTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.sleigh.grammar.Location;

public class ExprTree {
    public final Location location;
    VectorSTL<OpTpl> ops;
    VarnodeTpl outvn;

    public ExprTree(Location location) {
        this.location = location;
        this.ops = null;
        this.outvn = null;
    }

    public ExprTree(Location location, VarnodeTpl vn) {
        this.location = location;
        this.outvn = vn;
        this.ops = new VectorSTL();
    }

    public ExprTree(Location location, OpTpl op) {
        this.location = location;
        this.ops = new VectorSTL();
        this.ops.push_back((Object)op);
        this.outvn = op.getOut() != null ? new VarnodeTpl(location, op.getOut()) : null;
    }

    public void setOutput(Location newLocation, VarnodeTpl newout) {
        if (this.outvn == null) {
            throw new SleighError("Expression has no output", newLocation);
        }
        if (this.outvn.isUnnamed()) {
            OpTpl op = (OpTpl)this.ops.back();
            op.clearOutput();
            op.setOutput(newout);
        } else {
            OpTpl op = new OpTpl(newLocation, OpCode.CPUI_COPY);
            op.addInput(this.outvn);
            op.setOutput(newout);
            this.ops.push_back((Object)op);
        }
        this.outvn = new VarnodeTpl(newLocation, newout);
    }

    ConstTpl getSize() {
        return this.outvn.getSize();
    }

    static VectorSTL<OpTpl> appendParams(OpTpl op, VectorSTL<ExprTree> param) {
        VectorSTL res = new VectorSTL();
        for (int i = 0; i < param.size(); ++i) {
            res.appendAll(((ExprTree)param.get((int)i)).ops);
            ((ExprTree)param.get((int)i)).ops.clear();
            op.addInput(((ExprTree)param.get((int)i)).outvn);
            ((ExprTree)param.get((int)i)).outvn = null;
        }
        res.push_back((Object)op);
        return res;
    }

    public static VectorSTL<OpTpl> toVector(ExprTree expr) {
        VectorSTL<OpTpl> res = expr.ops;
        expr.ops = null;
        return res;
    }
}

