/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LEI;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.model.Point;

public class ArticulatedEdge<V, E>
extends LEI<V, E> {
    protected LE<V, E> se;
    protected final List<LV<V>> intermediateVertices = new ArrayList<LV<V>>();
    protected final List<Point> intermediatePoints = new ArrayList<Point>();

    public static <V, E> ArticulatedEdge of(LE<V, E> edge, LV<V> source, LV<V> target) {
        return new ArticulatedEdge<V, E>(edge, source, target);
    }

    protected ArticulatedEdge(LE<V, E> edge, LV<V> source, LV<V> target) {
        super(edge.getEdge(), source, target);
        this.se = edge;
    }

    public List<Point> getIntermediatePoints() {
        return this.intermediatePoints;
    }

    public void addIntermediateVertex(LV<V> v) {
        this.intermediateVertices.add(v);
    }

    public void addIntermediatePoint(Point p) {
        this.intermediatePoints.add(p);
    }

    public List<LV<V>> getIntermediateVertices() {
        return Collections.unmodifiableList(this.intermediateVertices);
    }

    public ArticulatedEdge<V, E> reversed() {
        ArticulatedEdge reversed = ArticulatedEdge.of(this, this.target, this.source);
        this.intermediateVertices.forEach(v -> reversed.intermediateVertices.add(0, (LV)v));
        this.intermediatePoints.forEach(v -> reversed.intermediatePoints.add(0, (Point)v));
        return reversed;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        return "ArticulatedEdge{edge=" + this.getEdge() + ", source=" + this.source + ", intermediateVertices=" + this.intermediateVertices + ", target=" + this.target + "}";
    }
}

