/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DefaultFocusOwnerProvider;
import docking.DockingDialog;
import docking.DockingKeyBindingAction;
import docking.DockingWindowManager;
import docking.ExecutableAction;
import docking.FocusOwnerProvider;
import docking.KeyBindingPrecedence;
import docking.KeyEntryTextField;
import docking.actions.KeyBindingUtils;
import docking.menu.keys.MenuKeyProcessor;
import ghidra.util.bean.GGlassPane;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class KeyBindingOverrideKeyEventDispatcher
implements KeyEventDispatcher {
    private static KeyBindingOverrideKeyEventDispatcher instance = null;
    private ExecutableAction inProgressAction;
    private FocusOwnerProvider focusProvider = new DefaultFocusOwnerProvider();

    static void install() {
        if (instance == null) {
            instance = new KeyBindingOverrideKeyEventDispatcher();
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.addKeyEventDispatcher(instance);
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.blockKeyInput(event)) {
            return true;
        }
        if (this.actionInProgress(event)) {
            return true;
        }
        if (MenuKeyProcessor.processMenuKeyEvent(event)) {
            return true;
        }
        DockingKeyBindingAction action = this.getActionForEvent(event);
        if (action == null) {
            return false;
        }
        Component focusOwner = this.focusProvider.getFocusOwner();
        ExecutableAction executableAction = action.getExecutableAction(focusOwner);
        if (this.processSystemActionPrecedence(executableAction, event)) {
            return true;
        }
        if (this.willBeHandledByTextComponent(event)) {
            return false;
        }
        if (this.processComponentKeyListeners(event)) {
            return true;
        }
        if (this.hasJavaAction(event)) {
            return false;
        }
        if (!executableAction.isValid()) {
            return false;
        }
        if (!executableAction.isEnabled()) {
            executableAction.reportNotEnabled(focusOwner);
            return true;
        }
        return this.processActionAtPrecedence(KeyBindingPrecedence.KeyListenerLevel, executableAction, event) || this.processActionAtPrecedence(KeyBindingPrecedence.ActionMapLevel, executableAction, event) || this.processActionAtPrecedence(KeyBindingPrecedence.DefaultLevel, executableAction, event) || this.throwAssertException();
    }

    private boolean blockKeyInput(KeyEvent event) {
        Component component = event.getComponent();
        if (component == null) {
            return false;
        }
        JRootPane rootPane = SwingUtilities.getRootPane(component);
        if (rootPane == null) {
            return true;
        }
        Component glassPane = rootPane.getGlassPane();
        return glassPane instanceof GGlassPane && ((GGlassPane)glassPane).isBusy();
    }

    private boolean actionInProgress(KeyEvent event) {
        boolean wasInProgress;
        boolean bl = wasInProgress = this.inProgressAction != null;
        if (event.getID() == 402) {
            ExecutableAction action = this.inProgressAction;
            this.inProgressAction = null;
            if (action != null) {
                action.execute();
            }
        }
        return wasInProgress;
    }

    private boolean isSettingKeyBindings(KeyEvent event) {
        Component destination = event.getComponent();
        if (destination == null) {
            Component focusOwner;
            destination = focusOwner = this.focusProvider.getFocusOwner();
        }
        return destination instanceof KeyEntryTextField;
    }

    private boolean willBeHandledByTextComponent(KeyEvent event) {
        Component destination = event.getComponent();
        if (destination == null) {
            Component focusOwner;
            destination = focusOwner = this.focusProvider.getFocusOwner();
        }
        if (!(destination instanceof JTextComponent)) {
            return false;
        }
        JTextComponent textComponent = (JTextComponent)destination;
        int code = event.getKeyCode();
        if (code == 27) {
            return this.isCellEditing(textComponent);
        }
        if (!this.isModified(event)) {
            return true;
        }
        return this.hasRegisteredKeyBinding(textComponent, event);
    }

    private boolean isCellEditing(JTextComponent c) {
        for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof JTree) {
                JTree tree = (JTree)parent;
                return tree.isEditing();
            }
            if (!(parent instanceof JTable)) continue;
            JTable table = (JTable)parent;
            return table.isEditing();
        }
        return false;
    }

    private boolean isModified(KeyEvent e) {
        return e.isAltDown() || e.isAltGraphDown() || e.isMetaDown() || e.isControlDown();
    }

    private boolean hasRegisteredKeyBinding(JComponent c, KeyEvent event) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(event);
        Action action = this.getJavaActionForComponent(c, keyStroke);
        return action != null;
    }

    private boolean throwAssertException() {
        throw new AssertException("New precedence added to KeyBindingPrecedence?");
    }

    private boolean processSystemActionPrecedence(ExecutableAction executableAction, KeyEvent event) {
        if (this.isSettingKeyBindings(event)) {
            return false;
        }
        KeyBindingPrecedence precedence = executableAction.getKeyBindingPrecedence();
        if (precedence != KeyBindingPrecedence.SystemActionsLevel) {
            return false;
        }
        this.inProgressAction = executableAction;
        return true;
    }

    private boolean processActionAtPrecedence(KeyBindingPrecedence keyBindingPrecedence, ExecutableAction action, KeyEvent event) {
        KeyBindingPrecedence actionPrecedence = action.getKeyBindingPrecedence();
        if (keyBindingPrecedence != actionPrecedence) {
            return false;
        }
        if (this.inProgressAction != null) {
            return true;
        }
        this.inProgressAction = action;
        event.consume();
        return true;
    }

    private boolean processComponentKeyListeners(KeyEvent keyEvent) {
        KeyListener[] keyListeners;
        Component focusOwner = this.focusProvider.getFocusOwner();
        if (focusOwner == null) {
            return false;
        }
        block5: for (KeyListener listener : keyListeners = focusOwner.getKeyListeners()) {
            int id = keyEvent.getID();
            switch (id) {
                case 400: {
                    listener.keyTyped(keyEvent);
                    continue block5;
                }
                case 401: {
                    listener.keyPressed(keyEvent);
                    continue block5;
                }
                case 402: {
                    listener.keyReleased(keyEvent);
                }
            }
        }
        return keyEvent.isConsumed();
    }

    private boolean hasJavaAction(KeyEvent event) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(event);
        Component focusOwner = this.focusProvider.getFocusOwner();
        if (focusOwner == null || !focusOwner.isEnabled() || !(focusOwner instanceof JComponent)) {
            return false;
        }
        JComponent jComponent = (JComponent)focusOwner;
        Action action = this.getJavaActionForComponent(jComponent, keyStroke);
        return action != null && action.isEnabled();
    }

    private Action getJavaActionForComponent(JComponent jComponent, KeyStroke keyStroke) {
        Action action = KeyBindingUtils.getAction(jComponent, keyStroke, 0);
        if (action != null) {
            return action;
        }
        action = KeyBindingUtils.getAction(jComponent, keyStroke, 1);
        return action;
    }

    private DockingKeyBindingAction getActionForEvent(KeyEvent event) {
        DockingWindowManager activeManager = this.getActiveDockingWindowManager();
        if (activeManager == null) {
            return null;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(event);
        DockingKeyBindingAction bindingAction = (DockingKeyBindingAction)activeManager.getActionForKeyStroke(keyStroke);
        return bindingAction;
    }

    private DockingWindowManager getActiveDockingWindowManager() {
        Window activeWindow = this.focusProvider.getActiveWindow();
        if (activeWindow == null) {
            return null;
        }
        DockingWindowManager activeManager = DockingWindowManager.getActiveInstance();
        if (activeManager == null) {
            return null;
        }
        DockingWindowManager managingInstance = KeyBindingOverrideKeyEventDispatcher.getDockingWindowManagerForWindow(activeWindow);
        if (managingInstance != null) {
            return managingInstance;
        }
        return activeManager;
    }

    private static DockingWindowManager getDockingWindowManagerForWindow(Window activeWindow) {
        DockingWindowManager manager = DockingWindowManager.getInstance(activeWindow);
        if (manager != null) {
            return manager;
        }
        if (activeWindow instanceof DockingDialog) {
            DockingDialog dockingDialog = (DockingDialog)activeWindow;
            return dockingDialog.getOwningWindowManager();
        }
        return null;
    }

    void setFocusOwnerProvider(FocusOwnerProvider focusProvider) {
        this.focusProvider = focusProvider;
    }
}

