/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.list;

import docking.widgets.AbstractGCellRenderer;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import java.awt.Color;
import java.awt.Component;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class GListCellRenderer<E>
extends AbstractGCellRenderer
implements ListCellRenderer<E> {
    private static final Color LIST_BACKGROUND_COLOR = new GColor("color.bg.list.row");

    public static <E> GListCellRenderer<E> createDefaultTextRenderer(final Function<E, String> cellToTextMappingFunction) {
        return new GListCellRenderer<E>(){

            @Override
            protected String getItemText(E value) {
                return (String)cellToTextMappingFunction.apply(value);
            }
        };
    }

    public GListCellRenderer() {
        this.setShouldAlternateRowBackgroundColors(false);
        this.noFocusBorder = this.getBorder("List.noFocusBorder");
        this.focusBorder = this.getBorder("List.focusCellHighlightBorder");
    }

    private Border getBorder(String id) {
        Border border = UIManager.getBorder(id);
        if (border == null) {
            border = BorderFactory.createEmptyBorder(2, 4, 2, 4);
        }
        return border;
    }

    @Override
    protected Color getDefaultBackgroundColor() {
        return LIST_BACKGROUND_COLOR;
    }

    protected String getItemText(E value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean hasFocus) {
        this.setText(this.getItemText(value));
        this.setHorizontalAlignment(value instanceof Number ? 4 : 2);
        ListModel<? extends E> model = list.getModel();
        this.configureFont(list, model, index);
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            boolean isDropRow;
            this.setForegroundColor(list, model, value);
            JList.DropLocation dropLocation = list.getDropLocation();
            boolean bl = isDropRow = dropLocation != null && dropLocation.isInsert() && dropLocation.getIndex() == index;
            if (isDropRow) {
                this.setBackground((Color)GThemeDefaults.Colors.Palette.CYAN);
            } else {
                this.setBackground(this.getAlternatingBackgroundColor(list, index));
            }
        }
        this.setBorder(hasFocus ? this.focusBorder : this.noFocusBorder);
        return this;
    }

    protected void setForegroundColor(JList<? extends E> list, ListModel<? extends E> model, Object value) {
        this.setForeground(list.getForeground());
    }

    protected void configureFont(JList<? extends E> list, ListModel<? extends E> model, int index) {
        this.setFont(this.defaultFont);
    }
}

